create table oik.oik_user_actions_log
(
    id         uuid               not null
        constraint oik_user_actions_log_pk_id
            primary key,
    importance smallint           not null,
    time       timestamp          not null,
    action     integer            not null,
    category   integer            not null,
    user_name  text               not null,
    text       text               not null,
    state      text               not null,
    ack_time   timestamp,
    ack_user   text,
    extra_id   uuid,
    extra_int  integer,
    extra_text text
)
WITH (OIDS = FALSE)
TABLESPACE pg_default;

alter table oik.oik_user_actions_log
    owner to postgres;

create index oik_user_actions_log_time_index
    on oik.oik_user_actions_log (time);

create index oik_user_actions_log_action_index
    on oik.oik_user_actions_log (action);

create index oik_user_actions_log_category_index
    on oik.oik_user_actions_log (category);
	
GRANT SELECT ON TABLE oik.oik_user_actions_log TO oik_group_super;
GRANT ALL ON TABLE oik.oik_user_actions_log TO postgres;

