DROP EXTENSION IF EXISTS oik_fdw CASCADE;

CREATE SCHEMA IF NOT EXISTS oik;

CREATE EXTENSION IF NOT EXISTS oik_fdw SCHEMA oik;

SET SCHEMA 'oik';

CREATE SERVER oik_server FOREIGN DATA WRAPPER oik_fdw;

/****************************************************************************/

create table oik.conforms
(
    fullpath char(100),
    fieldname char(20),
    rusname char(20),
    refname char(50),
    permissions text
);

create table oik.coretable
(
    recid integer,
    fullpath char(100),
    datecreate timestamp,
    date1 timestamp,
    date2 timestamp,
    object char(50),
    comment text,
    num integer,
    state integer
);

create table oik.equipment
(
    fullpath char(100),
    fulldescription char(100),
    description char(50),
    code char(50)
);

create table oik.history
(
    idx integer,
    recid integer,
    datecreate timestamp,
    uid integer,
    kind integer,
    comment text,
    reccontext text,
    signature text
);

create table oik.mags
(
    fullpath char(100),
    fulldescription char(150),
    description char(20),
    exttable char(8),
    sign bytea
);

create table oik.mobilesigns
(
    recnum serial not null
        constraint mobilesigns_pkey
            primary key,
    formid integer,
    signx integer,
    signy integer,
    signpagenum integer,
    jrecid integer,
    jid char(32)
);

create table oik.nextnums
(
    fullpath char(100),
    fieldname char(20),
    nextnum integer
);

create table oik.oik_doc_customization
(
    userid integer not null,
    factoryid text not null,
    overlays xml,
    customxml xml,
    constraint oik_doc_customization_pkey
        primary key (userid, factoryid)
);

create table oik.oik_itembyguid_withname
(
    id uuid not null
        constraint oik_named_data_pkey
            primary key,
    name text not null,
    ownerid integer not null,
    contenttype smallint not null,
    locked boolean default false not null,
    xmlcontent xml not null,
    orderix integer default 500 not null,
    json1 json
);

create table oik.oik_itembynumid
(
    id integer not null
        constraint oik_d2_pkey
            primary key,
    contenttype integer not null,
    ownerid integer,
    txt1 text,
    xml1 xml,
    bin1 bytea
);

create table oik.oik_map
(
    mapid integer not null
        constraint oik_map_pkey
            primary key,
    centerlatitude double precision,
    centerlongitude double precision,
    zoom integer,
    zoommin integer,
    zoommax integer,
    sourceid integer
);

create table oik.oik_map_item
(
    id uuid not null
        constraint oik_map_item_pkey
            primary key,
    entitytype smallint not null,
    xml1 xml,
    xml2 xml not null,
    geometry text,
    latitude double precision,
    longitude double precision,
    zoommin double precision,
    zoommax double precision,
    zindex integer,
    mapid integer,
    title text,
    extracontent text
);

create table oik.oik_mapsource
(
    sourceid integer not null
        constraint oik_mapsource_pkey
            primary key,
    tile_urlformat text
);

create table oik.oik_page
(
    id uuid not null
        constraint oik_page_pkey
            primary key,
    name text,
    ownerid integer not null,
    ispublic boolean default false not null,
    contentinfo text,
    xmlcontent xml not null,
    orderix integer default 0 not null
);

create table oik.oik_page_user
(
    id uuid not null,
    userid integer not null,
    orderix integer default 0 not null,
    constraint oik_page_user_pkey
        primary key (id, userid)
);

create table oik.oik_placards_active
(
    id uuid not null
        constraint oik_placards_active_pk
            primary key,
    type_id integer,
    created_time timestamp,
    operator varchar(80),
    comment text,
    position integer,
    tma integer,
    tob_scheme integer,
    tob_type integer,
    tob_object integer,
    scale real,
    index integer
);

create table oik.oik_placards_types
(
    id integer not null
        constraint oik_placards_types_pk
            primary key,
    name varchar(80),
    action integer,
    icon bytea,
    priority integer
);

create table oik.oik_sch_bindings
(
    tob_scheme integer not null,
    tob_type integer not null,
    tob_object integer not null,
    name varchar(80),
    tma integer not null,
    tma_type integer
);

create table oik.oik_uisettings
(
    ownerid integer not null,
    id text not null,
    xml1 xml,
    constraint oik_uisettings_pkey
        primary key (ownerid, id)
);

create table oik.oik_user
(
    userid integer not null
        constraint oik_user_pkey
            primary key,
    xmlcontent xml not null,
    xml2 xml,
    json1 json,
    json2 json,
    autoinfo text
);

create table oik.oik_user_item
(
    userid integer not null,
    itemid integer not null,
    xml1 xml,
    constraint oik_user_item_pkey
        primary key (userid, itemid)
);

create table oik.oikn_formsch
(
    recnum serial not null
        constraint oikn_formsch_pkey
            primary key,
    groupid integer not null,
    formid integer not null,
    nameex char(128) not null
);

create table oik.oikn_groupsch
(
    recnum serial not null
        constraint oikn_groupsch_pkey
            primary key,
    groupid integer not null,
    nameex char(128) not null
);

create table oik.oikn_schems
(
    recnum serial not null
        constraint oikn_schems_pkey
            primary key,
    formid integer not null,
    record text not null
);

create table oik.oikn_subgrsch
(
    recnum serial not null
        constraint oikn_subgrsch_pkey
            primary key,
    subgrid integer not null,
    nameex char(128) not null,
    groupid integer not null
);

create table oik.persons
(
    uid integer,
    gid integer,
    fio char(50),
    pwdhash text,
    publickey text
);

create table oik.refs
(
    name char(50),
    referencetable char(10)
);

create table oik.special_actions
(
    recnum serial not null
        constraint special_actions_pkey
            primary key,
    zoneid integer not null,
    actiontype integer not null,
    name char(32) not null,
    formid integer,
    data text
);

create table oik.special_drawings
(
    recnum serial not null
        constraint special_drawings_pkey
            primary key,
    formid integer not null,
    recordxsde xml,
    recordjson json
);

create table oik.special_zones
(
    recnum serial not null
        constraint special_zones_pkey
            primary key,
    formid integer not null,
    zoneid integer not null,
    name char(32)
);

create table oik.sqltokens
(
    sql92 char(20),
    currentv char(20)
);

create table oik.tm_dynamtii
(
    recnum serial not null
        constraint tm_dynamtii_pkey
            primary key,
    formid integer not null,
    tmadr integer not null
);

create table oik.tm_dynamtit
(
    recnum serial not null
        constraint tm_dynamtit_pkey
            primary key,
    formid integer not null,
    tmadr integer not null
);

create table oik.tm_dynamts
(
    recnum serial not null
        constraint tm_dynamts_pkey
            primary key,
    formid integer not null,
    tmadr integer not null
);

create table oik.userforms
(
    fullpath char(100),
    rtype integer,
    seqid integer,
    formname char(100),
    formblob text
);

/********************************************************************************************************/

create foreign table oik.oik_aan
    (
        el_type smallint options (field_id '601'),
        aa_flags bit(8) options (field_id '602'),
        step integer options (field_id '603'),
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        flags integer options (field_id '50'),
        update_time timestamp options (field_id '51'),
        v_val real options (field_id '301'),
        v_unit char(10) options (field_id '303'),
        v_format text options (field_id '304'),
        v_mult real options (field_id '305'),
        v_shift real options (field_id '306')
        )
    server oik_server
    options (table_id '7');

create foreign table oik.oik_alarms
    (
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        alarm_name text options (field_id '901'),
        alarm_id smallint options (field_id '902'),
        group_id smallint options (field_id '903'),
        val real options (field_id '904'),
        expr text options (field_id '905'),
        cmp_sign smallint options (field_id '906'),
        numseconds smallint options (field_id '907'),
        fill_type smallint options (field_id '908'),
        active boolean options (field_id '909'),
        in_use smallint options (field_id '910'),
        importance smallint options (field_id '911'),
        period integer options (field_id '912'),
        day_map bytea options (field_id '913'),
        week_map bit(8) options (field_id '914'),
        year_map bytea options (field_id '915'),
        indirect smallint options (field_id '916'),
        countdown integer options (field_id '917'),
        cur_val real options (field_id '918'),
        cmp_val real options (field_id '919'),
        param1 real options (field_id '920'),
        param2 real options (field_id '921'),
        param1_name text options (field_id '922'),
        param2_name text options (field_id '923')
        )
    server oik_server
    options (table_id '11');

create foreign table oik.oik_chn
    (
        name text options (field_id '1'),
        tma integer options (field_id '4'),
        ch smallint options (field_id '5')
        )
    server oik_server
    options (table_id '14');

create foreign table oik.oik_cur_ts
    (
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        flags integer options (field_id '50'),
        update_time timestamp options (field_id '51'),
        change_time timestamp options (field_id '101'),
        tm_time timestamp options (field_id '102'),
        ex_flags integer options (field_id '103'),
        flags2 smallint options (field_id '104'),
        provider text options (field_id '105'),
        v_code smallint options (field_id '201'),
        v_s2 smallint options (field_id '202'),
        v_importance smallint options (field_id '203'),
        v_state_text text options (field_id '204'),
        v_normalstate smallint options (field_id '205'),
        cl_name text options (field_id '250'),
        cl_gen_ack boolean options (field_id '251'),
        cl_unack0 boolean options (field_id '252'),
        cl_unack1 boolean options (field_id '253'),
        cl_text0 text options (field_id '254'),
        cl_text1 text options (field_id '255'),
        cl_break_text text options (field_id '256'),
        cl_malfun_text text options (field_id '257'),
        cl_fla_name text options (field_id '258'),
        cl_flb_name text options (field_id '259'),
        cl_flc_name text options (field_id '260'),
        cl_fld_name text options (field_id '261'),
        cl_fla_text0 text options (field_id '262'),
        cl_fla_text1 text options (field_id '263'),
        cl_flb_text0 text options (field_id '264'),
        cl_flb_text1 text options (field_id '265'),
        cl_flc_text0 text options (field_id '266'),
        cl_flc_text1 text options (field_id '267'),
        cl_fld_text0 text options (field_id '268'),
        cl_fld_text1 text options (field_id '269')
        )
    server oik_server
    options (table_id '1');

create foreign table oik.oik_cur_tt
    (
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        flags integer options (field_id '50'),
        update_time timestamp options (field_id '51'),
        change_time timestamp options (field_id '101'),
        tm_time timestamp options (field_id '102'),
        ex_flags integer options (field_id '103'),
        flags2 smallint options (field_id '104'),
        provider text options (field_id '105'),
        v_val real options (field_id '301'),
        v_code smallint options (field_id '302'),
        v_unit char(10) options (field_id '303'),
        v_format text options (field_id '304'),
        v_mult real options (field_id '305'),
        v_shift real options (field_id '306'),
        cl_name text options (field_id '350'),
        cl_val_min real options (field_id '351'),
        cl_val_max real options (field_id '352'),
        cl_aperture real options (field_id '353'),
        flags_b1 boolean options (field_id '50', bit_num '1')
        )
    server oik_server
    options (table_id '2');

create foreign table oik.oik_event_log
    (
        elix bytea options (field_id '706'),
        update_time timestamp options (field_id '51'),
        rec_type smallint options (field_id '701'),
        rec_type_name text options (field_id '702'),
        rec_state smallint options (field_id '703'),
        cmd_result smallint options (field_id '704'),
        rec_state_text text options (field_id '705'),
        fix_time timestamp options (field_id '707'),
        rec_text text options (field_id '708'),
        user_name text options (field_id '709'),
        ext_kind smallint options (field_id '710'),
        ext_source smallint options (field_id '711'),
        ext_binary bytea options (field_id '712'),
        ts_add_flags bit(8) options (field_id '713'),
        ack_time timestamp options (field_id '714'),
        ack_user text options (field_id '715'),
        importance smallint options (field_id '716'),
        flags integer options (field_id '50'),
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        v_code smallint options (field_id '201'),
        v_s2 smallint options (field_id '202'),
        v_val real options (field_id '301'),
        alarm_id smallint options (field_id '902'),
        alarm_active boolean options (field_id '909')
        )
    server oik_server
    options (table_id '8');

create foreign table oik.oik_event_log_elix
    (
        elix bytea options (field_id '706'),
        update_time timestamp options (field_id '51'),
        rec_type smallint options (field_id '701'),
        rec_type_name text options (field_id '702'),
        rec_state smallint options (field_id '703'),
        cmd_result smallint options (field_id '704'),
        rec_state_text text options (field_id '705'),
        fix_time timestamp options (field_id '707'),
        rec_text text options (field_id '708'),
        user_name text options (field_id '709'),
        ext_kind smallint options (field_id '710'),
        ext_source smallint options (field_id '711'),
        ext_binary bytea options (field_id '712'),
        ts_add_flags bit(8) options (field_id '713'),
        ack_time timestamp options (field_id '714'),
        ack_user text options (field_id '715'),
        importance smallint options (field_id '716'),
        flags integer options (field_id '50'),
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        v_code smallint options (field_id '201'),
        v_s2 smallint options (field_id '202'),
        v_val real options (field_id '301'),
        alarm_id smallint options (field_id '902'),
        alarm_active boolean options (field_id '909')
        )
    server oik_server
    options (table_id '9');

create foreign table oik.oik_event_log_rb
    (
        update_time timestamp options (field_id '51'),
        rec_type smallint options (field_id '701'),
        rec_type_name text options (field_id '702'),
        rec_state smallint options (field_id '703'),
        cmd_result smallint options (field_id '704'),
        rec_state_text text options (field_id '705'),
        fix_time timestamp options (field_id '707'),
        rec_text text options (field_id '708'),
        user_name text options (field_id '709'),
        ext_kind smallint options (field_id '710'),
        ext_source smallint options (field_id '711'),
        ext_binary bytea options (field_id '712'),
        ts_add_flags bit(8) options (field_id '713'),
        ack_time timestamp options (field_id '714'),
        ack_user text options (field_id '715'),
        importance smallint options (field_id '716'),
        flags integer options (field_id '50'),
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        v_code smallint options (field_id '201'),
        v_s2 smallint options (field_id '202'),
        v_val real options (field_id '301'),
        alarm_id smallint options (field_id '902'),
        alarm_active boolean options (field_id '909')
        )
    server oik_server
    options (table_id '12');

create foreign table oik.oik_retro
    (
        typ smallint options (field_id '801'),
        num integer options (field_id '807'),
        name text options (field_id '802'),
        descr text options (field_id '803'),
        avrg boolean options (field_id '804'),
        period integer options (field_id '805'),
        maxrec integer options (field_id '806'),
        start_time timestamp options (field_id '808'),
        end_time timestamp options (field_id '809'),
        megabytes integer options (field_id '810')
        )
    server oik_server
    options (table_id '10');

create foreign table oik.oik_retro_ts
    (
        retro_num smallint options (field_id '501'),
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        flags integer options (field_id '50'),
        update_time timestamp options (field_id '51'),
        change_time timestamp options (field_id '101'),
        tm_time timestamp options (field_id '102'),
        ex_flags integer options (field_id '103'),
        flags2 smallint options (field_id '104'),
        provider text options (field_id '105'),
        v_code smallint options (field_id '201'),
        v_s2 smallint options (field_id '202'),
        v_importance smallint options (field_id '203'),
        v_state_text text options (field_id '204'),
        v_normalstate smallint options (field_id '205'),
        cl_name text options (field_id '250'),
        cl_gen_ack boolean options (field_id '251'),
        cl_unack0 boolean options (field_id '252'),
        cl_unack1 boolean options (field_id '253'),
        cl_text0 text options (field_id '254'),
        cl_text1 text options (field_id '255'),
        cl_break_text text options (field_id '256'),
        cl_malfun_text text options (field_id '257'),
        cl_fla_name text options (field_id '258'),
        cl_flb_name text options (field_id '259'),
        cl_flc_name text options (field_id '260'),
        cl_fld_name text options (field_id '261'),
        cl_fla_text0 text options (field_id '262'),
        cl_fla_text1 text options (field_id '263'),
        cl_flb_text0 text options (field_id '264'),
        cl_flb_text1 text options (field_id '265'),
        cl_flc_text0 text options (field_id '266'),
        cl_flc_text1 text options (field_id '267'),
        cl_fld_text0 text options (field_id '268'),
        cl_fld_text1 text options (field_id '269')
        )
    server oik_server
    options (table_id '4');

create foreign table oik.oik_retro_tt
    (
        retro_num smallint options (field_id '501'),
        name text options (field_id '1'),
        tm_type smallint options (field_id '2'),
        tm_type_name text options (field_id '3'),
        tma integer options (field_id '4'),
        tma_str varchar(20) options (field_id '10001'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6'),
        point smallint options (field_id '7'),
        class_id smallint options (field_id '8'),
        group_id smallint options (field_id '9'),
        flags integer options (field_id '50'),
        update_time timestamp options (field_id '51'),
        change_time timestamp options (field_id '101'),
        tm_time timestamp options (field_id '102'),
        ex_flags integer options (field_id '103'),
        flags2 smallint options (field_id '104'),
        provider text options (field_id '105'),
        v_val real options (field_id '301'),
        v_code smallint options (field_id '302'),
        v_unit char(10) options (field_id '303'),
        v_format text options (field_id '304'),
        v_mult real options (field_id '305'),
        v_shift real options (field_id '306'),
        cl_name text options (field_id '350'),
        cl_val_min real options (field_id '351'),
        cl_val_max real options (field_id '352'),
        cl_aperture real options (field_id '353')
        )
    server oik_server
    options (table_id '5');

create foreign table oik.oik_rtu
    (
        name text options (field_id '1'),
        tma integer options (field_id '4'),
        ch smallint options (field_id '5'),
        rtu smallint options (field_id '6')
        )
    server oik_server
    options (table_id '13');

/***************************************************************************************/

create or replace view v_rtu as SELECT * FROM oik_rtu;
create or replace view v_chn as SELECT * FROM oik_chn;
create or replace view v_cur_tt as SELECT * FROM oik_cur_tt;
create or replace view v_retro as SELECT * FROM oik_retro;
create or replace view v_retro_tt as SELECT  * FROM oik_retro_tt;
create or replace view v_aan as SELECT * FROM oik_aan;
create or replace view v_event_log_elix as SELECT * FROM oik_event_log_elix;
create or replace view v_event_log_rb as SELECT * FROM oik_event_log_rb;
create or replace view v_alarms as SELECT * FROM oik_alarms;
create or replace view v_cur_ts as SELECT * FROM oik_cur_ts;
create or replace view v_retro_ts as SELECT * FROM oik_retro_ts;
create or replace view v_event_log as SELECT * FROM oik_event_log;

/***************************************************************************************/

CREATE ROLE oik_group_super;
GRANT ALL ON SCHEMA oik TO oik_group_super;
GRANT SELECT ON ALL TABLES IN SCHEMA oik TO oik_group_super;

CREATE ROLE oik_group_public;
GRANT USAGE ON SCHEMA oik TO oik_group_public;
GRANT SELECT ON v_retro TO oik_group_public;

/***************************************************************************************/

INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (1, 'Переносное Заземление', 1, decode('${plac1}', 'base64'), 100);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (2, 'Расшиновка', 2, decode('${plac2}', 'base64'), 100);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (3, 'Не включать - работа на линии', null, decode('${plac3}', 'base64'), 2);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (4, 'Не включать - работают люди', null, decode('${plac4}', 'base64'), 2);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (5, 'Заземлено', null, decode('${plac5}', 'base64'), 1);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (6, 'Работа под напряжением', null, decode('${plac6}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (7, 'Транзит разомкнут', null, decode('${plac7}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (8, 'Допуск к работе под напряжением', null, decode('${plac8}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (9, 'Допуск к работе на отключенном напряжении', null, decode('${plac9}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (10, 'Переносное заземление', null, decode('${plac10}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (11, 'Повреждение', null, decode('${plac11}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (12, 'РЗА', null, decode('${plac12}', 'base64'), 0);
INSERT INTO oik_placards_types (id, name, action, icon, priority) 
    VALUES (13, 'Комментарий', null, decode('${plac13}', 'base64'), 0);

/***************************************************************************************/

INSERT INTO oik_itembynumid (id, contenttype, ownerid, txt1, xml1, bin1) 
    VALUES (1, 1, null, 'no connection', null, decode('${noconnect}', 'base64'));
INSERT INTO oik_itembynumid (id, contenttype, ownerid, txt1, xml1, bin1) 
    VALUES (2, 1, null, 'bell', null, decode('${bell}', 'base64'));
INSERT INTO oik_itembynumid (id, contenttype, ownerid, txt1, xml1, bin1) 
    VALUES (10, 1, null, 'event0', null, decode('${event0}', 'base64'));
INSERT INTO oik_itembynumid (id, contenttype, ownerid, txt1, xml1, bin1) 
    VALUES (11, 1, null, 'event1', null, decode('${event1}', 'base64'));
INSERT INTO oik_itembynumid (id, contenttype, ownerid, txt1, xml1, bin1) 
    VALUES (12, 1, null, 'event2', null, decode('${event2}', 'base64'));
INSERT INTO oik_itembynumid (id, contenttype, ownerid, txt1, xml1, bin1)
    VALUES (13, 1, null, 'event3', null, decode('${event3}', 'base64'));