-- added: act_value

DROP FOREIGN TABLE IF EXISTS oik.oik_alerts CASCADE;

CREATE FOREIGN TABLE IF NOT EXISTS oik.oik_alerts(
  alert_id            bytea     OPTIONS(field_id '1001'),
  importance          smallint  OPTIONS(field_id '1002'),
  active              boolean   OPTIONS(field_id '1003'),
  unack               boolean   OPTIONS(field_id '1004'),
  on_time             timestamp OPTIONS(field_id '1005'),
  off_time            timestamp OPTIONS(field_id '1006'),
  type_name           text      OPTIONS(field_id '1007'),
  name                text      OPTIONS(field_id '1008'),
  value_text          text      OPTIONS(field_id '1009'),
  cur_time            timestamp OPTIONS(field_id '1010'),
  cur_value           real      OPTIONS(field_id '1011'),
  act_value           real      OPTIONS(field_id '1012'),

  tm_type             smallint  OPTIONS(field_id '2'),
  --tm_type_name        text      OPTIONS(field_id '3'),
  tma                 int       OPTIONS(field_id '4'),
  tma_str             varchar(20) OPTIONS(field_id '10001'),
  ch                  smallint  OPTIONS(field_id '5'),
  rtu                 smallint  OPTIONS(field_id '6'),
  point               smallint  OPTIONS(field_id '7'),
  class_id            smallint  OPTIONS(field_id '8'),
  group_id            smallint  OPTIONS(field_id '9')
)
    SERVER oik_server
    OPTIONS (table_id '15');


ALTER FOREIGN TABLE oik.oik_alerts OWNER TO postgres;

CREATE OR REPLACE VIEW v_alerts      AS SELECT * FROM oik.oik_alerts;
ALTER TABLE oik.v_alerts OWNER TO postgres;


GRANT ALL ON SCHEMA oik TO oik_group_super;
GRANT SELECT ON ALL TABLES IN SCHEMA oik TO oik_group_super;

GRANT USAGE ON SCHEMA oik TO oik_group_public;
GRANT SELECT ON oik_alerts TO oik_group_public;
GRANT SELECT ON v_alerts TO oik_group_public;
