-- FOREIGN TABLE: oik.oik_event_blocks
-- DROP FOREIGN TABLE oik.oik_event_blocks;

CREATE FOREIGN TABLE IF NOT EXISTS oik.oik_event_blocks(
  unblktime         timestamp OPTIONS(field_id '1121'),

  name                text      OPTIONS (field_id '1') NULL COLLATE pg_catalog."default",
  tm_type             smallint  OPTIONS(field_id '2'),
  tm_type_name        text      OPTIONS(field_id '3'),
  tma                 int       OPTIONS(field_id '4'),
  tma_str             varchar(20) OPTIONS(field_id '10001'),
  ch                  smallint  OPTIONS(field_id '5'),
  rtu                 smallint  OPTIONS(field_id '6'),
  point               smallint  OPTIONS(field_id '7'),
  class_id            smallint  OPTIONS(field_id '8'),
  group_id            smallint  OPTIONS(field_id '9')
)
    SERVER oik_server
    OPTIONS (table_id '17');

ALTER FOREIGN TABLE oik.oik_event_blocks
    OWNER TO postgres;



-- View: oik.v_event_blocks
-- DROP VIEW oik.v_event_blocks;

CREATE OR REPLACE VIEW v_event_blocks      AS SELECT * FROM oik.oik_event_blocks;

ALTER TABLE oik.v_event_blocks
    OWNER TO postgres;

GRANT ALL ON TABLE oik.v_event_blocks TO postgres;
GRANT SELECT ON TABLE oik.v_event_blocks TO oik_group_super;



---------------------------
-- GROUP oik_group_super --
---------------------------
GRANT ALL ON SCHEMA oik TO oik_group_super;
GRANT SELECT ON ALL TABLES IN SCHEMA oik TO oik_group_super;

---------------------------
-- GROUP oik_group_public --
---------------------------
GRANT USAGE ON SCHEMA oik TO oik_group_public;

