DROP FOREIGN TABLE IF EXISTS oik_cur_tt CASCADE;

CREATE FOREIGN TABLE IF NOT EXISTS oik.oik_cur_tt(
    name text OPTIONS (field_id '1') NULL COLLATE pg_catalog."default",
    tm_type smallint OPTIONS (field_id '2') NULL,
    tm_type_name text OPTIONS (field_id '3') NULL COLLATE pg_catalog."default",
    tma integer OPTIONS (field_id '4') NULL,
    tma_str character varying(20) OPTIONS (field_id '10001') NULL COLLATE pg_catalog."default",
    ch smallint OPTIONS (field_id '5') NULL,
    rtu smallint OPTIONS (field_id '6') NULL,
    point smallint OPTIONS (field_id '7') NULL,
    class_id smallint OPTIONS (field_id '8') NULL,
    group_id smallint OPTIONS (field_id '9') NULL,
    flags integer OPTIONS (field_id '50') NULL,
    update_time timestamp without time zone OPTIONS (field_id '51') NULL,
    change_time timestamp without time zone OPTIONS (field_id '101') NULL,
    tm_time timestamp without time zone OPTIONS (field_id '102') NULL,
    ex_flags integer OPTIONS (field_id '103') NULL,
    flags2 smallint OPTIONS (field_id '104') NULL,
    provider text OPTIONS (field_id '105') NULL COLLATE pg_catalog."default",
    v_val real OPTIONS (field_id '301') NULL,
    v_code smallint OPTIONS (field_id '302') NULL,
    v_unit character(10) OPTIONS (field_id '303') NULL COLLATE pg_catalog."default",
    v_format text OPTIONS (field_id '304') NULL COLLATE pg_catalog."default",
    v_mult real OPTIONS (field_id '305') NULL,
    v_shift real OPTIONS (field_id '306') NULL,
    cl_name text OPTIONS (field_id '350') NULL COLLATE pg_catalog."default",
    cl_val_min real OPTIONS (field_id '351') NULL,
    cl_val_max real OPTIONS (field_id '352') NULL,
    cl_aperture real OPTIONS (field_id '353') NULL,
    flags_b1 boolean OPTIONS (field_id '50', bit_num '1') NULL,

    ms_times timestamp[] OPTIONS (field_id '354') NULL,
    ms_sflags smallint[] OPTIONS (field_id '355') NULL,
    ms_values real[] OPTIONS (field_id '356') NULL,
    ms_intv smallint OPTIONS (field_id '357') NULL
)
    SERVER oik_server
    OPTIONS (table_id '2');


ALTER FOREIGN TABLE oik.oik_cur_tt OWNER TO postgres;

CREATE OR REPLACE VIEW v_cur_tt      AS SELECT * FROM oik.oik_cur_tt;

GRANT ALL ON SCHEMA oik TO oik_group_super;
GRANT SELECT ON ALL TABLES IN SCHEMA oik TO oik_group_super;

GRANT USAGE ON SCHEMA oik TO oik_group_public;
GRANT SELECT ON oik_cur_tt TO oik_group_public;
GRANT SELECT ON v_cur_tt TO oik_group_public;