---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_basevoltage
(
    id uuid NOT NULL,
    modus_key text COLLATE pg_catalog."default",
    nominalvoltage_id uuid,
    name text COLLATE pg_catalog."default",
    voltage_in_volts integer,
    color text COLLATE pg_catalog."default",
    CONSTRAINT oik_cim_basevoltage_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_basevoltage
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_basevoltage TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_basevoltage TO postgres;

---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_class
(
    id integer NOT NULL,
    name text COLLATE pg_catalog."default",
    category smallint NOT NULL DEFAULT 0,
    modus_type integer,
    is_switch boolean,
    description text COLLATE pg_catalog."default",
    CONSTRAINT oik_cim_class_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_class
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_class TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_class TO postgres;

---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_cn
(
    id uuid NOT NULL,
    container_id uuid,
    substation_id uuid,
    basevoltage_id uuid,
    scheme_id integer,
    terminals uuid[],
    equipments uuid[],
    is_interface boolean DEFAULT false,
    CONSTRAINT oik_cim_cn_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_cn
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_cn TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_cn TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_equipment
(
    id uuid NOT NULL,
    name text COLLATE pg_catalog."default",
    class_id integer,
    category smallint NOT NULL DEFAULT 0,
    basevoltage_id uuid,
    container_id uuid,
    substation_id uuid,
    voltagelevel_id uuid,
    bay_id uuid,
    voltage_in_volts integer,
    aux_terminal_id uuid,
    switch_normalopen boolean,
    scheme_id integer,
    scheme_item_type integer,
    scheme_item_id integer,
    scheme_item_subtype integer,
    bay_name text COLLATE pg_catalog."default",
    bus_name text COLLATE pg_catalog."default",
    terminals uuid[],
    cnodes uuid[],
    tmlink text COLLATE pg_catalog."default",
    CONSTRAINT oik_cim_equipment_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_equipment
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_equipment TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_equipment TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_gscheme
(
    scheme_id integer NOT NULL,
    name text COLLATE pg_catalog."default",
    model_timestamp timestamp without time zone,
    model_need_update boolean NOT NULL DEFAULT false,
    xml1 xml,
    CONSTRAINT oik_cim_gscheme_pkey PRIMARY KEY (scheme_id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_gscheme
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_gscheme TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_gscheme TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_modus_type
(
    modus_type integer NOT NULL,
    cim_class_id integer NOT NULL,
    description text COLLATE pg_catalog."default",
    CONSTRAINT oik_cim_modus_type_pkey PRIMARY KEY (modus_type)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_modus_type
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_modus_type TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_modus_type TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_resource
(
    id uuid NOT NULL,
    class_id integer,
    class_name text COLLATE pg_catalog."default",
    name text COLLATE pg_catalog."default",
    scheme_id integer,
    xml1 xml,
    CONSTRAINT oik_cim_resource_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_resource
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_resource TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_resource TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_substation
(
    id uuid NOT NULL,
    name text COLLATE pg_catalog."default",
    sort_ix integer,
    scheme_id integer,
    model_timestamp timestamp without time zone,
    model_need_update boolean NOT NULL DEFAULT false,
    CONSTRAINT oik_cim_substation_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_substation
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_substation TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_substation TO postgres;
-- Index: oik_cim_substation_scheme_id_index

-- DROP INDEX IF EXISTS oik.oik_cim_substation_scheme_id_index;

CREATE UNIQUE INDEX IF NOT EXISTS oik_cim_substation_scheme_id_index
    ON oik.oik_cim_substation USING btree
    (scheme_id ASC NULLS LAST)
    TABLESPACE pg_default;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_terminal
(
    id uuid NOT NULL,
    equipment_id uuid,
    sequence_number integer,
    basevoltage_id uuid,
    transformer_end uuid,
    cn_id uuid,
    scheme_id integer,
    scheme_item_id integer,
    aux_equipments uuid[],
    CONSTRAINT oik_cim_terminal_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_terminal
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_terminal TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_terminal TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_transformer_end
(
    id uuid NOT NULL,
    transformer_id uuid,
    terminal_id uuid,
    basevoltage_id uuid,
    scheme_id integer,
    scheme_item_id integer,
    CONSTRAINT oik_cim_transformer_end_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_transformer_end
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_transformer_end TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_transformer_end TO postgres;
---------------------------------------
CREATE TABLE IF NOT EXISTS oik.oik_cim_voltagelevel
(
    id uuid NOT NULL,
    name text COLLATE pg_catalog."default",
    substation_id uuid,
    scheme_id integer,
    basevoltage_id uuid,
    voltage_in_volts integer,
    CONSTRAINT oik_cim_voltagelevel_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_cim_voltagelevel
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_cim_voltagelevel TO oik_group_super;

GRANT ALL ON TABLE oik.oik_cim_voltagelevel TO postgres;
---------------------------------------
---------------------------------------
