-- ================================================
CREATE TABLE IF NOT EXISTS oik.oik_docv
(
    id uuid NOT NULL,
    doc_type smallint NOT NULL,
    name text COLLATE pg_catalog."default" NOT NULL,
    user_id integer,
    group_id integer,
    is_version_model boolean NOT NULL DEFAULT false,
    visible_in_testmode boolean NOT NULL DEFAULT false,
    visible_in_prodmode boolean NOT NULL DEFAULT false,
    test_timestamp timestamp without time zone,
    test_crc bigint,
    test_crc_approved bigint,
    prod_crc bigint,
    CONSTRAINT oik_docv_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_docv
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_docv TO oik_group_super;

GRANT ALL ON TABLE oik.oik_docv TO postgres;

-- ================================================
CREATE TABLE IF NOT EXISTS oik.oik_itembyint_withname
(
    contenttype smallint NOT NULL,
    id integer NOT NULL,
    name text COLLATE pg_catalog."default" NOT NULL,
    orderix integer NOT NULL DEFAULT 500,
    locked boolean NOT NULL DEFAULT false,
    CONSTRAINT oik_itembyint_withname_pkey PRIMARY KEY (contenttype, id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_itembyint_withname
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_itembyint_withname TO oik_group_super;

GRANT ALL ON TABLE oik.oik_itembyint_withname TO postgres;

-- ================================================
CREATE TABLE IF NOT EXISTS oik.oik_me_scheme
(
    id uuid NOT NULL,
    local_id integer NOT NULL,
    name text COLLATE pg_catalog."default",
    domain_id uuid,
    domain_type smallint,
    diagram_data xml,
    guid_store xml,
    save_timestamp timestamp without time zone,
    CONSTRAINT oik_me_scheme_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_me_scheme
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_me_scheme TO oik_group_super;

GRANT ALL ON TABLE oik.oik_me_scheme TO postgres;

CREATE INDEX IF NOT EXISTS oik_me_scheme_domain_index
    ON oik.oik_me_scheme USING btree
    (domain_id ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE UNIQUE INDEX IF NOT EXISTS oik_me_scheme_local_id_index
    ON oik.oik_me_scheme USING btree
    (local_id ASC NULLS LAST)
    TABLESPACE pg_default;

-- ================================================
CREATE TABLE IF NOT EXISTS oik.oik_me_basevoltage
(
    id uuid NOT NULL,
    modus_key text COLLATE pg_catalog."default",
    iface_key text COLLATE pg_catalog."default",
    name text COLLATE pg_catalog."default",
    voltage_in_volts integer,
    CONSTRAINT oik_me_basevoltage_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_me_basevoltage
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_me_basevoltage TO oik_group_super;

GRANT ALL ON TABLE oik.oik_me_basevoltage TO postgres;

-- ================================================
CREATE TABLE IF NOT EXISTS oik.oik_me_style
(
    style_key text COLLATE pg_catalog."default" NOT NULL,
    fallback_index integer NOT NULL DEFAULT 0,
    name text COLLATE pg_catalog."default",
    is_default boolean NOT NULL DEFAULT false,
    xml1 xml,
    json1 json,
    CONSTRAINT oik_me_style_pkey PRIMARY KEY (style_key)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS oik.oik_me_style
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_me_style TO oik_group_super;

GRANT ALL ON TABLE oik.oik_me_style TO postgres;


-- ================================================
INSERT INTO oik_itembyint_withname(contenttype, id, name, orderix) VALUES(1, 101, 'Пользовательский 1', 10) ON CONFLICT DO NOTHING;
INSERT INTO oik_itembyint_withname(contenttype, id, name, orderix) VALUES(1, 102, 'Пользовательский 2', 20) ON CONFLICT DO NOTHING;
INSERT INTO oik_itembyint_withname(contenttype, id, name, orderix) VALUES(1, 103, 'Пользовательский 3', 30) ON CONFLICT DO NOTHING;

INSERT INTO oik_itembyint_withname(contenttype, id, name, orderix) VALUES(2, 101, 'Пользовательский 1', 10) ON CONFLICT DO NOTHING;
INSERT INTO oik_itembyint_withname(contenttype, id, name, orderix) VALUES(2, 102, 'Пользовательский 2', 20) ON CONFLICT DO NOTHING;
INSERT INTO oik_itembyint_withname(contenttype, id, name, orderix) VALUES(2, 103, 'Пользовательский 3', 30) ON CONFLICT DO NOTHING;

-- ================================================
