/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class FileStream {
    public static byte[] read(String aInputFileName) {
        FileStream.log("Reading in binary file named : " + aInputFileName);
        File file = new File(aInputFileName);
        FileStream.log("File size: " + file.length());
        byte[] result = new byte[(int)file.length()];
        try {
            InputStream input = null;
            try {
                int totalBytesRead = 0;
                input = new BufferedInputStream(new FileInputStream(file));
                while (totalBytesRead < result.length) {
                    int bytesRemaining = result.length - totalBytesRead;
                    int bytesRead = input.read(result, totalBytesRead, bytesRemaining);
                    if (bytesRead <= 0) continue;
                    totalBytesRead += bytesRead;
                }
                FileStream.log("Num bytes read: " + totalBytesRead);
            }
            finally {
                FileStream.log("Closing input stream.");
                input.close();
            }
        }
        catch (FileNotFoundException ex) {
            FileStream.log("File not found.");
        }
        catch (IOException ex) {
            FileStream.log(ex);
        }
        return result;
    }

    public static void write(byte[] aInput, String aOutputFileName) {
        FileStream.log("Writing binary file...");
        try {
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(aOutputFileName));
                output.write(aInput);
            }
            finally {
                output.close();
            }
        }
        catch (FileNotFoundException ex) {
            FileStream.log("File not found.");
        }
        catch (IOException ex) {
            FileStream.log(ex);
        }
    }

    public static byte[] readAlternateImpl(String aInputFileName) {
        FileStream.log("Reading in binary file named : " + aInputFileName);
        File file = new File(aInputFileName);
        FileStream.log("File size: " + file.length());
        byte[] result = null;
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            result = FileStream.readAndClose(input);
        }
        catch (FileNotFoundException ex) {
            FileStream.log(ex);
        }
        return result;
    }

    public static byte[] readAndClose(InputStream aInput) {
        byte[] bucket = new byte[32768];
        ByteArrayOutputStream result = null;
        try {
            try {
                result = new ByteArrayOutputStream(bucket.length);
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = aInput.read(bucket);
                    if (bytesRead <= 0) continue;
                    result.write(bucket, 0, bytesRead);
                }
            }
            finally {
                aInput.close();
            }
        }
        catch (IOException ex) {
            FileStream.log(ex);
        }
        return result.toByteArray();
    }

    private static void log(Object aThing) {
    }

    public static String readFile(String path) throws IOException {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    public static String[] getFilesList(String path, String filter) {
        ArrayList<String> files = new ArrayList<String>();
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        String[] tokens = filter.split("\\|");
        File[] fileArray = listOfFiles;
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                String[] stringArray = tokens;
                int n3 = tokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String t = stringArray[n4];
                    if (t.length() > 0 && f.getName().endsWith(t)) {
                        files.add(f.getName());
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return files.toArray(new String[files.size()]);
    }

    public static void writeString(String path, String data) {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(path));
                writer.write(data);
            }
            catch (IOException iOException) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

