/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.utils.concurrency;

import com.teleofis.utils.concurrency.IResetEvent;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ManualResetEvent
implements IResetEvent {
    private volatile CountDownLatch event;
    private final Integer mutex = new Integer(-1);

    public ManualResetEvent(boolean signalled) {
        this.event = signalled ? new CountDownLatch(0) : new CountDownLatch(1);
    }

    @Override
    public void set() {
        this.event.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Integer n = this.mutex;
        synchronized (n) {
            if (this.event.getCount() == 0L) {
                this.event = new CountDownLatch(1);
            }
        }
    }

    @Override
    public void waitOne() throws InterruptedException {
        this.event.await();
    }

    @Override
    public boolean waitOne(int timeout, TimeUnit unit) throws InterruptedException {
        return this.event.await(timeout, unit);
    }

    @Override
    public boolean isSignalled() {
        return this.event.getCount() == 0L;
    }
}

