/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig;

import com.teleofis.wrxconfig.ConfigurationContentProvider;
import com.teleofis.wrxconfig.ConfigurationLabelProvider;
import com.teleofis.wrxconfig.EditDialog;
import com.teleofis.wrxconfig.Model;
import com.teleofis.wrxconfig.actions.AddAction;
import com.teleofis.wrxconfig.actions.ConnectAction;
import com.teleofis.wrxconfig.actions.DeleteAction;
import com.teleofis.wrxconfig.actions.DisconnectAction;
import com.teleofis.wrxconfig.actions.EditAction;
import com.teleofis.wrxconfig.actions.ExitAction;
import com.teleofis.wrxconfig.actions.FastUploadAction;
import com.teleofis.wrxconfig.actions.MoveDownAction;
import com.teleofis.wrxconfig.actions.MoveUpAction;
import com.teleofis.wrxconfig.actions.OpenAction;
import com.teleofis.wrxconfig.actions.SaveAction;
import com.teleofis.wrxconfig.actions.SaveAsAction;
import com.teleofis.wrxconfig.actions.SettingsAction;
import com.teleofis.wrxconfig.actions.StopScriptAction;
import com.teleofis.wrxconfig.actions.UploadAction;
import com.teleofis.wrxconfig.controller.Controller;
import com.teleofis.wrxconfig.model.Configuration;
import com.teleofis.wrxconfig.model.Parameter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MainWindow
extends ApplicationWindow
implements PropertyChangeListener {
    private Table tableConfiguration;
    private TableViewer tableViewer;
    SaveAction saveAction;
    SaveAsAction saveAsAction;
    OpenAction openAction;
    ExitAction exitAction;
    SettingsAction settingsAction;
    AddAction addAction;
    DeleteAction deleteAction;
    EditAction editAction;
    MoveUpAction moveUpAction;
    MoveDownAction moveDownAction;
    ConnectAction connectAction;
    DisconnectAction disconnectAction;
    UploadAction uploadAction;
    FastUploadAction fastUploadAction;
    StopScriptAction stopScriptAction;

    public MainWindow() {
        super(null);
        this.createActions();
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(container, 67586);
        this.tableConfiguration = this.tableViewer.getTable();
        this.tableConfiguration.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        TableColumn column = new TableColumn(this.tableConfiguration, 0);
        column.setWidth(400);
        column.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        column = new TableColumn(this.tableConfiguration, 0);
        column.setWidth(200);
        column.setText("\u0418\u043c\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
        column = new TableColumn(this.tableConfiguration, 0);
        column.setWidth(200);
        column.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
        Configuration model = Model.INSTANCE.getModel();
        this.tableViewer.setInput((Object)model);
        this.tableConfiguration.setLinesVisible(true);
        this.tableConfiguration.setHeaderVisible(true);
        boolean settings = false;
        try {
            settings = new File(Model.INSTANCE.getModel().getSettingsPath()).isFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (settings) {
            Controller.INSTANCE.openSettings(Model.INSTANCE.getModel().getSettingsPath());
        }
        this.createEventListeners();
        Model.INSTANCE.addPropertyChangeListener("configuration", this);
        Model.INSTANCE.notifyListeners(this, "configuration");
        Model.INSTANCE.notifyListeners(this, "connection");
        return container;
    }

    private void createEventListeners() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditDialog dialog;
                int code;
                Parameter parameter;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedObject = selection.getFirstElement();
                if (selectedObject instanceof Parameter && (parameter = (Parameter)selectedObject) != null && (code = (dialog = new EditDialog(MainWindow.this.getShell(), parameter)).open()) == 0) {
                    Model.INSTANCE.notifyListeners(this, "configuration");
                }
            }
        });
    }

    private void createActions() {
        this.saveAction = new SaveAction(this);
        this.saveAsAction = new SaveAsAction(this);
        this.openAction = new OpenAction(this);
        this.exitAction = new ExitAction(this);
        this.settingsAction = new SettingsAction(this);
        this.addAction = new AddAction(this);
        this.deleteAction = new DeleteAction(this);
        this.editAction = new EditAction(this);
        this.moveUpAction = new MoveUpAction(this);
        this.moveDownAction = new MoveDownAction(this);
        this.connectAction = new ConnectAction(this);
        this.disconnectAction = new DisconnectAction();
        this.uploadAction = new UploadAction(this);
        this.fastUploadAction = new FastUploadAction(this);
        this.stopScriptAction = new StopScriptAction(this);
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("menu");
        MenuManager fileMenu = new MenuManager("\u0424\u0430\u0439\u043b");
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IAction)this.saveAsAction);
        fileMenu.add((IAction)this.openAction);
        fileMenu.add((IAction)this.settingsAction);
        fileMenu.add((IAction)this.exitAction);
        MenuManager editMenu = new MenuManager("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editMenu.add((IAction)this.addAction);
        editMenu.add((IAction)this.deleteAction);
        editMenu.add((IAction)this.editAction);
        editMenu.add((IAction)this.moveUpAction);
        editMenu.add((IAction)this.moveDownAction);
        MenuManager commandMenu = new MenuManager("\u041a\u043e\u043c\u0430\u043d\u0434\u0430");
        commandMenu.add((IAction)this.connectAction);
        commandMenu.add((IAction)this.disconnectAction);
        commandMenu.add((IAction)this.uploadAction);
        commandMenu.add((IAction)this.fastUploadAction);
        menuManager.add((IContributionItem)fileMenu);
        menuManager.add((IContributionItem)editMenu);
        menuManager.add((IContributionItem)commandMenu);
        return menuManager;
    }

    protected CoolBarManager createCoolBarManager(int style) {
        CoolBarManager coolBarManager = new CoolBarManager(style);
        ToolBarManager toolBar = new ToolBarManager(524288);
        toolBar.add((IAction)this.saveAction);
        toolBar.add((IAction)this.saveAsAction);
        toolBar.add((IAction)this.openAction);
        toolBar.add((IAction)this.settingsAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.connectAction);
        toolBar.add((IAction)this.disconnectAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.addAction);
        toolBar.add((IAction)this.deleteAction);
        toolBar.add((IAction)this.editAction);
        toolBar.add((IAction)this.moveUpAction);
        toolBar.add((IAction)this.moveDownAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.uploadAction);
        toolBar.add((IAction)this.fastUploadAction);
        toolBar.add((IAction)this.stopScriptAction);
        coolBarManager.add((IToolBarManager)toolBar);
        return coolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        return statusLineManager;
    }

    public static void main(String[] args) {
        try {
            Model.INSTANCE.getModel().loadProgramSettings();
            MainWindow window = new MainWindow();
            window.setBlockOnOpen(true);
            window.open();
            Model.INSTANCE.getModel().saveProgramSettings();
            Controller.INSTANCE.terminate();
            Display.getCurrent().dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Python Configuration Tool (v2.0.3)");
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("configuration")) {
            this.tableViewer.setInput((Object)Model.INSTANCE.getModel());
            this.tableViewer.refresh();
        }
        if (evt.getPropertyName().equals("connection")) {
            boolean connected = Model.INSTANCE.getModel().isConnected();
            if (connected) {
                this.connectAction.setEnabled(false);
                this.disconnectAction.setEnabled(true);
                this.uploadAction.setEnabled(true);
                this.fastUploadAction.setEnabled(true);
                this.stopScriptAction.setEnabled(true);
            } else {
                this.connectAction.setEnabled(true);
                this.disconnectAction.setEnabled(false);
                this.uploadAction.setEnabled(false);
                this.fastUploadAction.setEnabled(false);
                this.stopScriptAction.setEnabled(false);
            }
        }
    }
}

