/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig;

import com.teleofis.wrxconfig.model.Report;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public enum ReportManager {
    INSTANCE;

    private Report report = new Report();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void notifyListeners(Object source, String propertyName) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, null, null);
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            listener.propertyChange(event);
            ++n2;
        }
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void saveReport(String path) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Report.class});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File f = new File(String.valueOf(path) + System.getProperty("file.separator") + this.report.getImei() + ".xml");
            f.getParentFile().mkdirs();
            f.createNewFile();
            m.marshal((Object)INSTANCE.getReport(), f);
        }
        catch (JAXBException e) {
            JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a!");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a.");
        }
    }
}

