/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig;

import com.teleofis.wrxconfig.IProgress;
import com.teleofis.wrxconfig.controller.Controller;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class UploadDialog
extends Dialog
implements IProgress {
    public static int MODE_UPLOAD_FAST = 0;
    public static int MODE_UPLOAD_COMPLITE = 1;
    public static int MODE_STOP_SCRIPT = 2;
    Button okButton;
    private Label label;
    private ProgressBar progressBar;
    private Label lblResult;
    private final int mode;
    private final String title;

    public UploadDialog(Shell parentShell, int mode, String title) {
        super(parentShell);
        this.mode = mode;
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.label = new Label(container, 0);
        this.label.setText(this.title);
        this.progressBar = new ProgressBar(container, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblResult = new Label(container, 131072);
        this.lblResult.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        if (this.mode == MODE_UPLOAD_FAST) {
            Controller.INSTANCE.startUploadCommand(this, this.mode);
        } else if (this.mode == MODE_UPLOAD_COMPLITE) {
            Controller.INSTANCE.startUploadCommand(this, this.mode);
        } else if (this.mode == MODE_STOP_SCRIPT) {
            Controller.INSTANCE.stopScriptCommand(this);
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(367, 169);
    }

    @Override
    public void setTotal(final int total) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UploadDialog.this.progressBar.setMaximum(total);
            }
        });
    }

    @Override
    public void setCompleted(final int completeValue) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UploadDialog.this.progressBar.setSelection(completeValue);
                if (completeValue == 100) {
                    UploadDialog.this.okButton.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void setError(final int errorCode) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (errorCode == 2) {
                    UploadDialog.this.lblResult.setText("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432");
                } else if (errorCode == 1) {
                    UploadDialog.this.lblResult.setText("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043c\u0430.");
                } else {
                    UploadDialog.this.lblResult.setText("\u0423\u0441\u043f\u0435\u0448\u043d\u043e.");
                }
            }
        });
    }

    @Override
    public void setMessage(final String msg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UploadDialog.this.lblResult.setText(msg);
            }
        });
    }
}

