/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig.model;

import com.teleofis.wrxconfig.Model;
import com.teleofis.wrxconfig.model.Parameter;
import com.teleofis.wrxconfig.model.ProgramParameters;
import com.teleofis.wrxconfig.transport.SerialParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Configuration {
    private ArrayList<Parameter> parameters = new ArrayList();
    private boolean connected = false;
    @XmlElement
    private SerialParameters serialParameters;
    @XmlElement
    private ProgramParameters programParameters;
    @XmlElement
    private String settingsPath = "";

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void deleteParameter(Parameter parameter) {
        this.parameters.remove(parameter);
    }

    public Object[] getParametersAsArray() {
        return this.parameters.toArray();
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public SerialParameters getSerialParameters() {
        return this.serialParameters;
    }

    public void setSerialParameters(SerialParameters serialParameters) {
        this.serialParameters = serialParameters;
    }

    public ProgramParameters getProgramParameters() {
        return this.programParameters;
    }

    public void setProgramParameters(ProgramParameters programParameters) {
        this.programParameters = programParameters;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public String getSettingsPath() {
        return this.settingsPath;
    }

    public void setSettingsPath(String settingsPath) {
        this.settingsPath = settingsPath;
    }

    private String getProgramSettingsFullpath() {
        return String.valueOf(System.getProperty("user.dir")) + File.separator + "programSettings.xml";
    }

    public void saveProgramSettings() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File f = new File(this.getProgramSettingsFullpath());
            f.getParentFile().mkdirs();
            f.createNewFile();
            m.marshal((Object)Model.INSTANCE.getModel(), f);
        }
        catch (JAXBException e) {
            JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a!");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a.");
        }
    }

    public void loadProgramSettings() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller um = jc.createUnmarshaller();
            String path = this.getProgramSettingsFullpath();
            Configuration model = (Configuration)um.unmarshal((Reader)new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            this.setSerialParameters(model.getSerialParameters());
            this.setProgramParameters(model.getProgramParameters());
            this.setSettingsPath(model.getSettingsPath());
        }
        catch (JAXBException jAXBException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

