/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig.controller;

import com.teleofis.wrxconfig.IProgress;
import com.teleofis.wrxconfig.Model;
import com.teleofis.wrxconfig.ReportManager;
import com.teleofis.wrxconfig.model.Parameter;
import com.teleofis.wrxconfig.model.Report;
import com.teleofis.wrxconfig.telit.TelitLoader;
import com.teleofis.wrxconfig.transport.SerialTransport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public enum Controller {
    INSTANCE;

    private final String FILENAME = "main.pyo";
    private SerialTransport transport;
    private TelitLoader telit;
    private TelitThread telitThread;
    private boolean terminated = false;
    private ArrayBlockingQueue<Command> CommandsQueue = new ArrayBlockingQueue(10);

    private Controller() {
        this.transport = new SerialTransport(13);
        this.telit = new TelitLoader(this.transport);
        this.telitThread = new TelitThread();
        this.telitThread.setName("Telit Thread");
        this.telitThread.start();
    }

    public boolean openSettings(String path) {
        boolean result = false;
        Model.INSTANCE.getModel().clearParameters();
        try {
            Scanner scanner = new Scanner((InputStream)new FileInputStream(path), "UTF-8");
            try {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] param = line.split("::");
                    if (param.length <= 2) continue;
                    Model.INSTANCE.getModel().addParameter(new Parameter(param[0], param[2], param[1]));
                }
                result = true;
            }
            finally {
                scanner.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public boolean dumpSettings(String path) {
        boolean result = false;
        String output = "";
        for (Parameter parameter : Model.INSTANCE.getModel().getParameters()) {
            output = String.valueOf(output) + parameter.toString() + "\r\n";
        }
        if (path == null) {
            path = Model.INSTANCE.getModel().getSettingsPath();
        }
        if (path.equals("")) {
            return result;
        }
        Writer out = null;
        try {
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
                out.write(output);
            }
            catch (IOException e) {
                System.out.println("File (" + path + ") save error.");
                boolean bl = result;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        result = true;
        return result;
    }

    public void terminate() {
        this.terminated = true;
        try {
            this.telitThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.transport.close();
    }

    public boolean open() {
        return this.transport.open(Model.INSTANCE.getModel().getSerialParameters());
    }

    public boolean close() {
        return this.transport.close();
    }

    public void startUploadCommand(IProgress progress, int uploadMode) {
        try {
            this.CommandsQueue.put(new Command(0, progress, uploadMode));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getImei() {
        return this.telit.execute("AT#CGSN", "\\d{15}", 400, 0);
    }

    public void stopScriptCommand(IProgress progress) {
        try {
            this.CommandsQueue.put(new Command(1, progress, 0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean stopScript(IProgress progressBar) {
        boolean result = true;
        try {
            progressBar.setTotal(100);
            progressBar.setCompleted(30);
            result = this.telit.stopScriptExecution(progressBar);
            if (result) {
                progressBar.setError(0);
            } else {
                progressBar.setError(1);
            }
        }
        finally {
            progressBar.setCompleted(100);
        }
        return result;
    }

    private boolean upload(IProgress progressBar, int uploadMode) {
        boolean result = true;
        try {
            String imei;
            progressBar.setTotal(100);
            progressBar.setCompleted(0);
            if (result) {
                result = this.dumpSettings(String.valueOf(Model.INSTANCE.getModel().getProgramParameters().getPythonScriptsPath()) + File.separator + "settings.ini");
            }
            if (!result) {
                progressBar.setError(2);
                return false;
            }
            if (result) {
                progressBar.setCompleted(10);
                result = this.telit.upload(String.valueOf(Model.INSTANCE.getModel().getProgramParameters().getPythonScriptsPath()) + File.separator, ".ini", progressBar, 10, 25, ReportManager.INSTANCE.getReport().getFiles());
                if (result && uploadMode == 1) {
                    progressBar.setCompleted(25);
                    String fullPath = String.valueOf(Model.INSTANCE.getModel().getProgramParameters().getPythonScriptsPath()) + File.separator;
                    String filter = Model.INSTANCE.getModel().getProgramParameters().getPythonScriptsExtentions();
                    result = this.telit.upload(fullPath, filter, progressBar, 25, 75, ReportManager.INSTANCE.getReport().getFiles());
                }
            }
            if (result) {
                result = this.telit.setMode(Model.INSTANCE.getModel().getProgramParameters().getScriptStartMode());
            }
            if (result) {
                progressBar.setCompleted(75);
                result = this.telit.enableFile("main.pyo");
            }
            if (result && Model.INSTANCE.getModel().getProgramParameters().isScriptAutoStart()) {
                result = this.telit.executeFile();
            }
            if ((imei = this.getImei()) == null || imei.equals("")) {
                result = false;
            }
            if (result) {
                ReportManager.INSTANCE.getReport().setImei(imei);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                Date date = new Date();
                ReportManager.INSTANCE.getReport().setDate(dateFormat.format(date));
                ReportManager.INSTANCE.getReport().setTime(timeFormat.format(date));
            }
            if (result) {
                progressBar.setError(0);
            } else {
                progressBar.setError(1);
            }
        }
        finally {
            progressBar.setCompleted(100);
        }
        return result;
    }

    class Command {
        public static final int UPLOAD = 0;
        public static final int STOP_SCRIPT = 1;
        private final int command;
        private final int parameter;
        private final IProgress progress;

        public Command(int command, IProgress progress, int parameter) {
            this.command = command;
            this.progress = progress;
            this.parameter = parameter;
        }

        public int getCommand() {
            return this.command;
        }

        public int getParameter() {
            return this.parameter;
        }

        public IProgress getProgress() {
            return this.progress;
        }
    }

    class TelitThread
    extends Thread {
        TelitThread() {
        }

        @Override
        public void run() {
            block6: while (!Controller.this.terminated) {
                try {
                    Command cmd = (Command)Controller.this.CommandsQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (cmd == null) continue;
                    switch (cmd.getCommand()) {
                        case 0: {
                            ReportManager.INSTANCE.setReport(new Report());
                            if (!Controller.this.upload(cmd.getProgress(), cmd.getParameter())) continue block6;
                            ReportManager.INSTANCE.saveReport(Model.INSTANCE.getModel().getProgramParameters().getReportDirectory());
                            break;
                        }
                        case 1: {
                            Controller.this.stopScript(cmd.getProgress());
                        }
                    }
                }
                catch (InterruptedException e) {
                    Controller.this.terminated = true;
                }
            }
        }
    }
}

