/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig.telit;

import com.teleofis.utils.FileStream;
import com.teleofis.wrxconfig.IProgress;
import com.teleofis.wrxconfig.model.FileListElement;
import com.teleofis.wrxconfig.transport.SerialTransport;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelitLoader {
    private final SerialTransport transport;

    public TelitLoader(SerialTransport transport) {
        this.transport = transport;
    }

    private boolean sendCommand(String command, String response, int timeout) {
        command = command.concat("\r");
        System.out.println("OUT: " + command);
        return this.sendCommand(command.getBytes(), response, timeout);
    }

    private boolean sendCommand(byte[] command, String response, int timeout) {
        boolean result = this.transport.sendBytes(command);
        if (result) {
            String received = "";
            long endTime = System.currentTimeMillis() + (long)timeout;
            while (System.currentTimeMillis() < endTime) {
                byte[] rcvBytes = this.transport.receiveBytes();
                if (rcvBytes != null) {
                    if ((received = received.concat(new String(rcvBytes))).indexOf(response) != -1) {
                        System.out.println("IN: " + received);
                        return true;
                    }
                    if (received.indexOf("ERROR") == -1) continue;
                    System.out.println("IN: " + received);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public String execute(String command, String responsePartten, int timeout, int groupNumber) {
        command = String.valueOf(command) + "\r\n";
        return this.execute(command.getBytes(), responsePartten, timeout, groupNumber);
    }

    public String execute(byte[] command, String responsePartten, int timeout, int goupNumber) {
        boolean result = this.transport.sendBytes(command);
        if (result) {
            String received = "";
            Pattern pattern = Pattern.compile(responsePartten);
            long endTime = System.currentTimeMillis() + (long)timeout;
            while (System.currentTimeMillis() < endTime) {
                byte[] rcvBytes = this.transport.receiveBytes();
                if (rcvBytes != null) {
                    Matcher matcher = pattern.matcher(received = String.valueOf(received) + new String(rcvBytes));
                    if (!matcher.find()) continue;
                    return matcher.group(goupNumber);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private boolean checkConnection() {
        boolean result = false;
        int i = 0;
        while (i++ < 3 && !result) {
            result = this.sendCommand("AT", "OK", 2000);
        }
        return result;
    }

    public boolean stopScriptExecution(IProgress progressBar) {
        boolean result;
        block12: {
            block13: {
                result = false;
                if (this.sendCommand("AT#ESCRIPT?", "#ESCRIPT: \"\"", 200)) {
                    return true;
                }
                progressBar.setMessage("\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435");
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                result = this.sendCommand("AT#ESCRIPT=\"\"", "OK", 1000);
                if (!result) break block13;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long endTime = System.currentTimeMillis() + 30000L;
                progressBar.setMessage("\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043f\u0438\u0442\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043c\u0430");
                while (System.currentTimeMillis() < endTime) {
                    if (this.sendCommand("AT", "OK", 500)) {
                        continue;
                    }
                    break block12;
                }
                break block12;
            }
            progressBar.setMessage("\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0438 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043f\u0438\u0442\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043c\u0430");
            long endTime = System.currentTimeMillis() + 30000L;
            boolean done = false;
            while (System.currentTimeMillis() < endTime) {
                this.sendCommand("AT#ESCRIPT?", "OK", 500);
                result = this.sendCommand("AT#ESCRIPT=\"\"", "OK", 500);
                if (!result) continue;
                progressBar.setMessage("\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                done = true;
                break;
            }
            if (!done) break block12;
            endTime = System.currentTimeMillis() + 30000L;
            progressBar.setMessage("\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043f\u0438\u0442\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043c\u0430");
            while (System.currentTimeMillis() < endTime) {
                if (this.sendCommand("AT", "OK", 500)) {
                    continue;
                }
                break;
            }
        }
        return result;
    }

    private boolean deleteFile(String file) {
        boolean result = this.sendCommand("AT#DSCRIPT=\"" + file + "\"", "OK", 3000);
        return result;
    }

    private boolean writeFile(String path, String file) {
        boolean result = false;
        byte[] data = FileStream.read(String.valueOf(path) + file);
        result = this.sendCommand("AT#WSCRIPT=\"" + file + "\"," + Integer.toString(data.length), ">>>", 3000);
        if (result) {
            result = this.sendCommand(data, "OK", 30000);
        }
        return result;
    }

    private boolean listFiles() {
        boolean result = this.sendCommand("AT#LSCRIPT", "OK", 3000);
        return result;
    }

    public boolean enableFile(String file) {
        boolean result = this.sendCommand("AT#ESCRIPT=\"" + file + "\"", "OK", 3000);
        return result;
    }

    public boolean executeFile() {
        boolean result = this.sendCommand("AT#EXECSCR", "OK", 3000);
        return result;
    }

    public boolean setMode(int mode) {
        boolean result = false;
        if (mode >= 0 && mode <= 2) {
            result = this.sendCommand("AT#STARTMODESCR=" + String.valueOf(mode), "OK", 3000);
        }
        return result;
    }

    public boolean upload(String path, String filter) {
        return this.upload(path, filter, null, 0, 100, null);
    }

    public boolean upload(String path, String filter, IProgress progressBar, int startPB, int endPB, List<FileListElement> reportList) {
        boolean result = false;
        String[] files = FileStream.getFilesList(path, filter);
        if (files.length == 0) {
            return false;
        }
        result = this.checkConnection();
        int i = 0;
        if (result) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                this.deleteFile(file);
                result = this.writeFile(path, file);
                if (!result) break;
                if (progressBar != null) {
                    progressBar.setCompleted(i * (endPB - startPB) / files.length + startPB);
                    ++i;
                }
                if (reportList != null) {
                    byte[] data = FileStream.read(String.valueOf(path) + file);
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        byte[] digest = md.digest(data);
                        BigInteger bigInt = new BigInteger(1, digest);
                        String hashtext = bigInt.toString(16);
                        while (hashtext.length() < 32) {
                            hashtext = "0" + hashtext;
                        }
                        FileListElement el = new FileListElement();
                        el.setMd5hash(hashtext);
                        el.setName(String.valueOf(path) + file);
                        reportList.add(el);
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

