/*
 * Decompiled with CFR 0.152.
 */
package com.teleofis.wrxconfig.transport;

import com.teleofis.wrxconfig.transport.ByteMessage;
import com.teleofis.wrxconfig.transport.SerialParameters;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;

public class SerialTransport {
    private SerialPort serialPort;
    private byte messageSeparator;
    private ByteMessage message;
    private LinkedBlockingQueue<ByteMessage> rxQueue;

    public SerialTransport(byte messageSeparator) {
        this.messageSeparator = messageSeparator;
        this.message = new ByteMessage();
        this.rxQueue = new LinkedBlockingQueue();
    }

    public boolean close() {
        if (this.serialPort != null && this.serialPort.isOpened()) {
            try {
                this.serialPort.closePort();
                this.serialPort = null;
            }
            catch (SerialPortException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean open(SerialParameters serialParameters) {
        if (!this.close()) {
            return false;
        }
        this.serialPort = new SerialPort(serialParameters.getName());
        try {
            this.serialPort.openPort();
            this.serialPort.setParams(serialParameters.getBaudrate(), serialParameters.getDatabits(), serialParameters.getStopbits(), serialParameters.getParity());
            if (serialParameters.isCtsControl()) {
                this.serialPort.setFlowControlMode(3);
            }
        }
        catch (SerialPortException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean sendBytes(byte[] data) {
        try {
            this.serialPort.writeBytes(data);
        }
        catch (SerialPortException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public byte[] receiveBytes() {
        try {
            return this.serialPort.readBytes();
        }
        catch (SerialPortException serialPortException) {
            return null;
        }
    }

    public boolean sendString(String data) {
        try {
            this.serialPort.writeString(data);
        }
        catch (SerialPortException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void clearReceiveQueue() {
        this.rxQueue.clear();
    }

    public ByteMessage receive() {
        ByteMessage message = null;
        try {
            message = this.rxQueue.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return message;
    }

    private void process(byte[] data) {
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == this.messageSeparator) {
                if (this.message.getBytes().size() > 0) {
                    this.rxQueue.add(this.message);
                    this.message = new ByteMessage();
                }
            } else {
                this.message.addByte(b);
            }
            ++n2;
        }
    }

    class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR()) {
                try {
                    int size = event.getEventValue();
                    byte[] buffer = SerialTransport.this.serialPort.readBytes(size);
                    SerialTransport.this.process(buffer);
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

