unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, tmaccess, tma_defs, Grids, Buttons, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    btnInit: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    Timer1: TTimer;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    b_tmAnalogByList: TBitBtn;
    StringGrid2: TStringGrid;
    BitBtn2: TBitBtn;
    StringGrid1: TStringGrid;
    Button1: TButton;
    Memo1: TMemo;
    edtDateTime: TEdit;
    Label2: TLabel;
    b_tmStatusFull: TBitBtn;
    lblStatusFull: TLabel;
    b_tmAnalogFull: TBitBtn;
    lblAnalogFull: TLabel;
    Label3: TLabel;
    edtCh: TLabeledEdit;
    edtRTU: TLabeledEdit;
    edtPoint: TLabeledEdit;
    edtStep: TLabeledEdit;
    b_tmStatusByList: TBitBtn;
    Label4: TLabel;
    StringGrid3: TStringGrid;
    procedure btnInitClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure b_tmAnalogByListClick(Sender: TObject);
    procedure b_tmStatusFullClick(Sender: TObject);
    procedure b_tmAnalogFullClick(Sender: TObject);
    procedure b_tmStatusByListClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  LastPos: Integer;
implementation

{$R *.dfm}

procedure TForm1.btnInitClick(Sender: TObject);
var Event: TEvent;
begin
if tmInit(PChar(Edit1.TExt), 'xxx') <> SUCCESS then
    begin
    ShowMessage('     ');
    end
  else
    begin
    ShowMessage('    ');
    tmEventLog( 'N/A','N/A', $FFFF, @Event, 1, LastPos);
    end;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var values: array[0..9] of Single;
    flags: array[0..9] of SmallInt;
    i: Integer;
    dt: TDateTime;
begin
dt := StrToDateTime(edtDateTime.Text);
tmTakeRetroTit(StrToInt(edtCh.Text),
               StrToInt(edtRTU.Text),
               StrToInt(edtPoint.Text),
               PChar(edtDateTime.Text),
               StrToInt(edtStep.Text),
               10,
               0,
               @values[0],
               @flags[0]);
for i := 0 to 9 do
    begin
    StringGrid1.Cells[0, i+1] := FormatDateTime('hh:nn:ss',dt);
    StringGrid1.Cells[1, i+1] := Format('%f', [values[i]]);
    dt := dt + EncodeTime(0,0,30,0);
    end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
tmClose;
end;

procedure TForm1.Button1Click(Sender: TObject);
var Events: array[0..9] of TEvent;
    Cnt1, evRead: Integer;
begin
while true do
    begin
    evRead := tmEventLog( '01.01.1970 00:00',
                          '01.01.2030 00:00',
            $FFFF, @Events[0], 10, LastPos);
    if evRead > 0 then
        begin
        for Cnt1 := 0 to Pred(evRead) do
            begin
            Memo1.Lines.Add(Format('%s %d:%d:%d',
                             [StrPas(Events[Cnt1].DateTime),
                              Events[Cnt1].Ch,
                              Events[Cnt1].RTU,
                              Events[Cnt1].Point]));
            end;
        end;
    if evRead < 10 then
        break;
    end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var datagram: array[0..100] of char;
begin
if tmCheckForDatagram(datagram, sizeof(datagram)-1, 0) <> 0 then
    Button1Click(Sender);
end;

procedure TForm1.b_tmStatusFullClick(Sender: TObject);
var SP: TStatusPoint;
    ADR: TADRtm;
    name: array[0..100] of Char;
begin
ADR.Ch    := StrToInt(edtCh.Text);
ADR.RTU   := StrToInt(edtRTU.Text);
ADR.Point := StrToInt(edtPoint.Text);

if tmStatusFull(ADR.Ch, ADR.RTU, ADR.Point, @SP) = SUCCESS then
    begin
    ZeroMemory(@name[0], sizeof(name));
    tmGetObjectName(TM_STATUS,
                    ADR.Ch,
                    ADR.RTU,
                    ADR.Point,
                    @name[0],
                    sizeof(name)-1);
    lblStatusFull.Caption := Format(': %s : %d : %04X', [name, SP.Status, SP.Flags]);
    end
  else
    ShowMessage('   ');
end;

procedure TForm1.b_tmAnalogFullClick(Sender: TObject);
var AP: TAnalogPoint;
    ADR: TADRtm;
    name: array[0..100] of Char;
begin
ADR.Ch    := StrToInt(edtCh.Text);
ADR.RTU   := StrToInt(edtRTU.Text);
ADR.Point := StrToInt(edtPoint.Text);

if tmAnalogFull(ADR.Ch, ADR.RTU, ADR.Point, @AP, 'N/A', 0) = SUCCESS then
    begin
    ZeroMemory(@name[0], sizeof(name));
    tmGetObjectName(TM_ANALOG,
                    ADR.Ch,
                    ADR.RTU,
                    ADR.Point,
                    @name[0],
                    sizeof(name)-1);
    lblAnalogFull.Caption := Format(': %s : %f %s (%d  ) : %04X',
        [name, AP.asFloat, AP.Units, AP.asCode, AP.Flags]);
    end
  else
    ShowMessage('   ');
end;

procedure TForm1.b_tmAnalogByListClick(Sender: TObject);
var APs: array[0..2] of TAnalogPoint;
    ADRs: array[0..2] of TADRtm;
    name: array[0..100] of Char;
    i: Integer;
begin
ZeroMemory(@APs, sizeof(APs));
ADRs[0].Ch    := StrToInt(edtCh.Text);
ADRs[0].RTU   := StrToInt(edtRTU.Text);
ADRs[0].Point := StrToInt(edtPoint.Text);
for i := 1 to 2 do
    begin
    ADRs[i].Ch    := ADRs[0].Ch;
    ADRs[i].RTU   := ADRs[0].RTU;
    ADRs[i].Point := ADRs[0].Point + i;
    end;
tmAnalogByList(3, @ADRs[0], @APs[0], 'N/A', 0);
for i := 0 to 2 do
    begin
    ZeroMemory(@name[0], sizeof(name));
    tmGetObjectName(TM_ANALOG,
                    ADRs[i].Ch,
                    ADRs[i].RTU,
                    ADRs[i].Point,
                    @name[0],
                    sizeof(name)-1);
    StringGrid2.Cells[0,i+1] := StrPas(name);
    StringGrid2.Cells[1,i+1] := Format('%f', [APs[i].asFloat]);
    end;
end;

procedure TForm1.b_tmStatusByListClick(Sender: TObject);
var SPs: array[0..2] of TStatusPoint;
    ADRs: array[0..2] of TADRtm;
    name: array[0..100] of Char;
    i: Integer;
begin
ZeroMemory(@SPs, sizeof(SPs));
ADRs[0].Ch    := StrToInt(edtCh.Text);
ADRs[0].RTU   := StrToInt(edtRTU.Text);
ADRs[0].Point := StrToInt(edtPoint.Text);
for i := 1 to 2 do
    begin
    ADRs[i].Ch    := ADRs[0].Ch;
    ADRs[i].RTU   := ADRs[0].RTU;
    ADRs[i].Point := ADRs[0].Point + i;
    end;
tmStatusByList(3, @ADRs[0], @SPs[0]);
for i := 0 to 2 do
    begin
    ZeroMemory(@name[0], sizeof(name));
    tmGetObjectName(TM_STATUS,
                    ADRs[i].Ch,
                    ADRs[i].RTU,
                    ADRs[i].Point,
                    @name[0],
                    sizeof(name)-1);
    StringGrid3.Cells[0,i+1] := StrPas(name);
    StringGrid3.Cells[1,i+1] := IntToStr(SPs[i].Status);
    end;
end;

end.
