﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication
{
  class Program
  {
    static void Main(string[] args)
    {
      AppDomain currentDomain = AppDomain.CurrentDomain;
      currentDomain.UnhandledException += new UnhandledExceptionEventHandler(currentDomain_UnhandledException);

      using (var shell = new Shell())
      {
        shell.Run();
        Console.WriteLine("Press any key for exit");
        Console.ReadKey();
      }
    }

    static void currentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs args)
    {
      Exception e = (Exception)args.ExceptionObject;
      Console.WriteLine("UnhandledException : " + e.Message);
      Console.WriteLine("Press any key for exit");
      Console.ReadKey();
      Environment.Exit(0);
    }

  }
}
