﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml;
using SSH.CP.TmsClient;
using SSH.CP.Utils.Xml;

namespace ConsoleApplication
{
  public class Shell : IDisposable
  {
    private string _tmcServerName;
    private string _tmcPipeName;
    private TmsConnection _tmsConnection;

    public void Run()
    {
      var pathFileName = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "_Conf.xml");
      var stream = File.OpenRead(pathFileName);

      if (stream == null)
        throw new Exception("_Conf.xml not found");

      var doc = new XmlDocument();
      doc.Load(stream);
      stream.Dispose();

      LoadConf(doc);

      _tmsConnection = new TmsConnection();
      _tmsConnection.Server = _tmcServerName;
      _tmsConnection.Pipe = _tmcPipeName;
      _tmsConnection.User = "MyApp";
      try
      {
        _tmsConnection.EnsureConnected();
        DoJob();
      }
      finally
      {
        _tmsConnection.Close();
      }
    }

    private void LoadConf(XmlDocument pDoc)
    {
      var rootNode = pDoc.SelectSingleNode("/root");

      // Tm Server

      var xmlNode = pDoc.SelectSingleNode("/root/tmServer");
      if (xmlNode != null)
      {
        var configId = XmlFns.ReadAttribute<int>(xmlNode, "configId");
        var configList = xmlNode.SelectNodes("config");
        if(configList != null)
        {
          XmlNode configNode = null;
          foreach (XmlNode node in configList)
          {
            var id = XmlFns.ReadAttribute<int>(node, "id");
            if (id == configId)
            {
              configNode = node;
              break;
            }
          }
          if (configNode != null)
          {
            _tmcServerName = XmlFns.ReadAttribute(configNode, "server");
            _tmcPipeName = XmlFns.ReadAttribute(configNode, "pipe");
          }
        }
      }

      if (_tmcServerName == null)
        throw new Exception("_Conf.xml Error");

    }

    private void DoJob()
    {
			List<FullTagId> list;
      TmUtils.GetTagIds(_tmsConnection.Cid, out list);
      if (list != null)
      {
        foreach (var fullTagId in list)
        {
          Console.WriteLine(fullTagId);
        }
      }
    }

    public void Dispose()
    {
    }
  }
}
