﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using SampleApp.Model;
using SSH.CP.TmsClient;
using SSH.CP.TmsClient.Wraps;
using SSH.CP.Utils.Xml;

namespace SampleApp
{
  public partial class Form1 : Form
  {
    #region Fields
    private string _tmcServerName;
    private string _tmcPipeName;
    private TmsConnection _tmsConnection;
    private List<ShortTagId> _titList = new List<ShortTagId>();
    private List<ShortTagId> _tsList = new List<ShortTagId>();
    #endregion

    #region Ctor, Load
    public Form1()
    {
			InitializeComponent();
			//-----------
			//Size = new Size(600, 640);
		}

		protected override void OnLoad(EventArgs e)
		{
		  base.OnLoad(e);
      //-----------
		  LoadConf();
		}

    private void LoadConf()
    {
      var pathFileName = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "_Conf.xml");
      var stream = File.OpenRead(pathFileName);

      if (stream == null)
        throw new Exception("_Conf.xml not found");

      var doc = new XmlDocument();
      doc.Load(stream);
      stream.Dispose();

      LoadConf(doc);
    }

    private void LoadConf(XmlDocument pDoc)
    {
      var rootNode = pDoc.SelectSingleNode("/root");

      // Tm Server

      var xmlNode = rootNode.SelectSingleNode("tmServer");
      if (xmlNode != null)
      {
        var configId = XmlFns.ReadAttribute<int>(xmlNode, "configId");
        var configList = xmlNode.SelectNodes("config");
        if (configList != null)
        {
          XmlNode configNode = null;
          foreach (XmlNode node in configList)
          {
            var id = XmlFns.ReadAttribute<int>(node, "id");
            if (id == configId)
            {
              configNode = node;
              break;
            }
          }
          if (configNode != null)
          {
            _tmcServerName = XmlFns.ReadAttribute(configNode, "server");
            _tmcPipeName = XmlFns.ReadAttribute(configNode, "pipe");
          }
        }
      }

      if (_tmcServerName == null)
        throw new Exception("_Conf.xml Error");

      // TIT List

      var titNodeList = rootNode.SelectNodes("titCollection/item");
      if(titNodeList != null)
      {
        foreach (XmlNode itemNode in titNodeList)
        {
          ShortTagId tagId;
          if (ShortTagId.TryParse(XmlFns.ReadAttribute(itemNode, "address"), out tagId))
            _titList.Add(tagId);
        }
      }

      // TS List

      var tsNodeList = rootNode.SelectNodes("tsCollection/item");
      if (tsNodeList != null)
      {
        foreach (XmlNode itemNode in tsNodeList)
        {
          ShortTagId tagId;
          if (ShortTagId.TryParse(XmlFns.ReadAttribute(itemNode, "address"), out tagId))
            _tsList.Add(tagId);
        }
      }
    }
    #endregion

    #region Services
    private void EnsureConnect()
    {
      if (_tmsConnection == null)
      {
        _tmsConnection = new TmsConnection();
        _tmsConnection.Server = _tmcServerName;
        _tmsConnection.Pipe = _tmcPipeName;
        _tmsConnection.User = "MyApp";
      }
      _tmsConnection.EnsureConnected();
    }
    #endregion

    #region Dispose, Close

    protected override void OnClosed(EventArgs e)
    {
      if (_tmsConnection != null)
        _tmsConnection.Close();
      //-------
      base.OnClosed(e);
    }
    #endregion

    private void connectButton_Click(object sender, EventArgs e)
    {
      EnsureConnect();
      listBox.Items.Add("Connected");
      ScrollListBoxToEnd();
    }

    private void getTitListToolStripMenuItem_Click(object sender, EventArgs e)
    {
      var tagCount = _titList.Count;
      if (tagCount == 0) return;
      EnsureConnect();

      listBox.Items.Clear();

      UInt32 unixTime = 0;
      var adrArray = new TAdrTm[tagCount];
      var resultArray = TAnalogPoint.CreateArray(tagCount);

      for (int i = 0; i < tagCount; i++)
      {
        var tagId = _titList[i];
        TAdrTm.Set(ref adrArray[i], (Int16)tagId.Part1, (Int16)tagId.Part2, (Int16)tagId.Part3);
        //TAnalogPoint.Reset(ref resultArray[i]);
      }
      //------------------------------------------------
      Tmconn.tmcAnalogByList(_tmsConnection.Cid, (Int16)tagCount, adrArray, resultArray, unixTime, 0);
      //------------------------------------------------
      for (int i = 0; i < tagCount; i++)
      {
        var tagId = _titList[i];
        //-----------
        var tagName = TmUtils.GetTitName(_tmsConnection.Cid, tagId);
        //-----------
        var tagResult = resultArray[i];
  			var measure = (new string(tagResult.Unit, 0, 6)).Trim();
        var item = new TitResult() { TagId = tagId, Value = tagResult.asFloat, TagFlags = (TagFlags)tagResult.Flags, TagName = tagName, Measure = measure };

        listBox.Items.Add(item.ToString());
      }

      ScrollListBoxToEnd();
    }

    private void getTsListToolStripMenuItem_Click(object sender, EventArgs e)
    {
      var tagCount = _tsList.Count;
      if(tagCount == 0) return;
      EnsureConnect();

      listBox.Items.Clear();
      
      UInt32 unixTime = 0;
      var adrArray = new TAdrTm[tagCount];
      var resultArray = new TStatusPoint[tagCount];

      for (int i = 0; i < tagCount; i++)
      {
        var tagId = _tsList[i];
        TAdrTm.Set(ref adrArray[i], (Int16)tagId.Part1, (Int16)tagId.Part2, (Int16)tagId.Part3);
        //TStatusPoint.Reset(ref resultArray[i]);
      }
      //------------------------------------------------
      Tmconn.StatusByList(_tmsConnection.Cid, adrArray, resultArray, unixTime);
      //------------------------------------------------
      for (int i = 0; i < tagCount; i++)
      {
        var tagId = _tsList[i];
        //-----------
        var tagName = TmUtils.GetTsName(_tmsConnection.Cid, tagId);
        //-----------
        var tagResult = resultArray[i];
        var item = new TsResult() { TagId = tagId, Value = tagResult.Status, TagFlags = (TagFlags)tagResult.Flags, TagName = tagName };

        listBox.Items.Add(item.ToString());
      }

      ScrollListBoxToEnd();
    }

    private void getTitList2ToolStripMenuItem_Click(object sender, EventArgs e)
    {
      var tagCount = _titList.Count;
      if (tagCount == 0) return;
      EnsureConnect();

      listBox.Items.Clear();

      for (int i = 0; i < tagCount; i++)
      {
        var tagId = _titList[i];
        double tagValue;
        string measure;
        var success = TmUtils.QueryTIT(_tmsConnection.Cid, tagId, null, out tagValue, out measure);
        var item = new TitResult() { TagId = tagId, Value = (float)tagValue, TagFlags = success ? 0 : TagFlags.NODATA, TagName = null, Measure = measure };
        listBox.Items.Add(item.ToString());
      }

      ScrollListBoxToEnd();
    }

    private void ScrollListBoxToEnd()
    {
      int itemsPerPage = (int)(listBox.Height / listBox.ItemHeight);
      listBox.TopIndex = listBox.Items.Count - itemsPerPage;
    }

  }
}
