﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using SSH.CP.Utils;
using SSH.CP.WinForms;

namespace SampleApp
{
  static class Program
  {
    /// <summary>
    /// The main entry point for the application.
    /// </summary>
    [STAThread]
    static void Main()
    {
      Application.ThreadException += Application_ThreadException;
      Application.SetUnhandledExceptionMode(UnhandledExceptionMode.CatchException);
      AppDomain.CurrentDomain.UnhandledException += CurrentDomain_UnhandledException;
      try
      {
        Application.EnableVisualStyles();
        Application.SetCompatibleTextRenderingDefault(false);
        //----
        Application.Run(new Form1());
      }
      catch (AbortException e)
      {
      }
    }

    static void Application_ThreadException(object sender, System.Threading.ThreadExceptionEventArgs e)
    {
      ExceptionForm.ProcessException(e.Exception, true, true);
    }

    static void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs ea)
    {
      Exception e = ea.ExceptionObject as Exception;
      if (e != null)
      {
        ExceptionForm.ProcessException(e, true, true);
        Application.Exit();
      }
    }
  }
}
