 /* Server */

#ifndef _CFSHARE_H
#define _CFSHARE_H

#define PRINTF_ERROR			0
#define PRINTF_MESSAGE			1
#define PRINTF_DEBUG			2
#define ERROR_SAME_FILETIME		0x80ffffff

#define ERROR_BAD_DATA_RECEIVED 21200
#define ERROR_CFS_INTERNAL		21201
#define ERROR_LOCAL_EXCEPTION	21202
#define ERROR_NOT_INITIALIZED	21203
#define ERROR_SERVER_INTERNAL	21204
#define ERROR_LOCAL_UNKNOWN		21205
#define ERROR_STRUCTURE_FORMAT	21206

#define EXIT_CODE_RESTART		21300

//  
#define CFS_FEATCODE_WEB_CLIENT		19
#define CFS_FEAT_OK					1
#define CFS_FEAT_NO					0
#define CFS_FEAT_WAIT				-1
#define CFS_FEAT_ERR				-2
//  

#define CFSUMSG_MESSAGE			'M'
#define CFSUMSG_ERROR			'E'
#define CFSUMSG_DEBUG			'D'

#define CFS_USER_PIPE 			1
#define CFS_USER_LOCAL  		2
#define CFS_USER_WINSOCK		3

#define IFCFG_TYPE_DEFAULT		0
#define IFCFG_TYPE_ARIS			1

#ifdef _calltype_
#undef _calltype_
#endif
#define _calltype_ __stdcall

#ifdef IMPEX
#undef IMPEX
#endif

#ifdef CFSHARE_DLL
#define IMPEX __declspec(dllexport)	
#else
#define IMPEX __declspec(dllimport) 
#endif

#ifndef OPTIM
#define OPTIM
#endif

#define CFS_ENUM_DONE  (0xffffffff)
#define CFS_LEVEL_0  (0xffffffff)

#ifdef __cplusplus
extern "C" {
#endif
typedef VOID (__cdecl * cfsProgressFn)(DWORD count,DWORD total,LPVOID param);
typedef void (__cdecl* __printf_handler)(DWORD type,LPSTR string);
IMPEX BOOL _calltype_ cfsInstall(LPSTR BinPath);
IMPEX BOOL _calltype_ cfsRemove();
IMPEX BOOL _calltype_ cfsServer();			//returns FALSE if error
IMPEX DWORD _calltype_ cfsServerGetState();	//returns STILL_ACTIVE if ok, error_code otherwise
IMPEX BOOL _calltype_ cfsServerStop();
typedef struct {
	DWORD signature; // (DWORD)'CFSH'
	DWORD version;
	DWORD reserved[32];
}CFS_INIT_DATA;
/* Client */

IMPEX CFS_INIT_DATA* _calltype_ cfsInitApp();

IMPEX DWORD _calltype_ cfsGetVersion();

IMPEX BOOL _calltype_ cfsIsService();

#define CFS_TLS_TMCONN	0
#define CFS_TLS_SRV		1

IMPEX BOOL _calltype_ cfsGetTls(DWORD idx,PDWORD pval);

IMPEX BOOL _calltype_ cfsSetTls(DWORD idx,DWORD val);

IMPEX DWORD _calltype_ cfsRandom();

IMPEX BOOL _calltype_ cfsIsInteractive(LPSTR serviceName);

IMPEX DWORD _calltype_ cfsConnect(LPSTR serverName /* NTMachine name,NULL or "." if local*/,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns 0 if error, conn. id otherwise

IMPEX DWORD _calltype_ cfsGetConnectionType(DWORD connid);

IMPEX LPSTR _calltype_ cfsGetConnectionImage(DWORD connid);

IMPEX VOID _calltype_ cfsSetUser(LPSTR name,LPSTR pwd); // to set these parameters globally for the process

IMPEX VOID _calltype_ cfsGetUser(LPSTR name,DWORD namelen,LPSTR pwd,DWORD pwdlen);

IMPEX BOOL _calltype_ cfsLogon(DWORD connid,LPSTR name,LPSTR pwd,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs); // Fails only if no connection

IMPEX BOOL _calltype_ cfsIsReadOnly(DWORD connid, // perr[0]!=ERROR_SUCCESS if Error
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX VOID _calltype_ cfsDisconnect(DWORD connid);

IMPEX PVOID _calltype_ cfsAllocMemory(DWORD bytes);

IMPEX VOID _calltype_ cfsFreeMemory(PVOID pmem);

IMPEX BOOL _calltype_ cfsTest(DWORD connid,PBYTE pData,DWORD cbData,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsGetBasePath(DWORD connid,LPSTR path,DWORD cbPath,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileLock(DWORD connid,LPSTR fname/* remote*/,DWORD timeout/* msec*/,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileUnlock(DWORD connid,LPSTR fname,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileSetSize(DWORD connid,LPSTR fname,DWORD file_size,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX LONG _calltype_ cfsFileGetSize(DWORD connid,LPSTR fname,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//return value <0 if error

IMPEX BOOL _calltype_ cfsFileGetTime(DWORD connid,LPSTR fname,PFILETIME pft,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

typedef struct {
	FILETIME CreationTime;
	FILETIME ModificationTime;
	DWORD Attributes;
	DWORD Checksum;
	DWORD Reserved[12];
}CFS_FILE_PROPERTIES;
IMPEX BOOL _calltype_ cfsFileGetPropreties(DWORD connid,LPSTR fname,
	CFS_FILE_PROPERTIES* pprops,LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsFileCopy(DWORD connid,LPSTR existing_fname/*remote*/,LPSTR new_fname/*remote*/,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileMove(DWORD connid,LPSTR existing_fname/*remote*/,LPSTR new_fname/*remote*/,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileDelete(DWORD connid,LPSTR fname,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX LONG _calltype_ cfsFileRead(DWORD connid,LPSTR fname,LPVOID buf,DWORD offset,DWORD count,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns bytes read, <0 if error

IMPEX LONG _calltype_ cfsFileWrite(DWORD connid,LPSTR fname,LPVOID buf,DWORD offset,DWORD count,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns written read, <0 if error

IMPEX BOOL _calltype_ cfsDirEnum(DWORD connid,LPSTR dirname,PVOID buf,DWORD len, //buf -double zero terminated list of directories
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

typedef struct {
	DWORD	error_code;
	DWORD	bflags;
	CHAR	fname_or_error[1024];
}TCfsServerBackupData;
IMPEX BOOL _calltype_ cfsExternalBackupServer(
	DWORD connid,LPSTR dllname,LPSTR servname,DWORD bflags,
	TCfsServerBackupData* pbd,LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsExternalRestoreServer(
	DWORD connid,LPSTR dllname,LPSTR servname,LPSTR filename,PDWORD pbflags,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX VOID _calltype_ cfsGetStatistics(PDWORD	pBytesRecv,PDWORD	pBytesSent,
	PDWORD	pBytesRecvEncoded,PDWORD	pBytesSentEncoded);

/* High level client functions */
#define FAIL_IF_NO_CONNECT 0x80000000
IMPEX BOOL _calltype_ cfsFileGet(DWORD connid,LPSTR remote_fname,LPSTR local_fname,
	DWORD timeout,PFILETIME pft/* optional if not null*/,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileGetEx(DWORD connid,LPSTR remote_fname,LPSTR local_fname,
	DWORD timeout,PFILETIME pft/* optional if not null*/,
	cfsProgressFn pfn,LPVOID pfn_parm,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFileReplicate(DWORD connid,LPSTR fname,DWORD timeout,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
	
IMPEX BOOL _calltype_ cfsFilePut(DWORD connid,LPSTR remote_fname,LPSTR local_fname,DWORD timeout,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error

IMPEX BOOL _calltype_ cfsFilePutEx(
	DWORD connid,LPSTR remote_fname,LPSTR local_fname,DWORD timeout,
	cfsProgressFn pfn,LPVOID pfn_parm,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//returns FALSE if error


IMPEX BOOL _calltype_ cfsPrepNewConfig(DWORD connid,LPSTR remote_fname,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsOpenService(DWORD connid,SC_HANDLE hSvcMgr,LPSTR ServiceName,LPSC_HANDLE phService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsCloseService(DWORD connid,SC_HANDLE hService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsInstallService(
	DWORD connid,SC_HANDLE hSvcMgr,DWORD ServiceType,DWORD ServiceStartType,
	LPSTR ServiceName,LPSTR ServiceDisplayName,LPSTR ServiceDependencies,
	LPSTR ServiceBinaryPath,LPSC_HANDLE phService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsInstallServiceEx(
	DWORD connid,SC_HANDLE hSvcMgr,DWORD ServiceType,DWORD ServiceStartType,
	LPSTR ServiceName,LPSTR ServiceDisplayName,LPSTR ServiceDependencies,
	LPSTR ServiceBinaryPath,LPSTR ServiceAccount,LPSTR AccountPassword,
	LPSC_HANDLE phService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);


IMPEX BOOL _calltype_ cfsRemoveService(DWORD connid,SC_HANDLE hService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsRunService(DWORD connid,SC_HANDLE hService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsStopService(DWORD connid,SC_HANDLE hService,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsQueryService(DWORD connid,SC_HANDLE hService,PDWORD p_remerr,LPSERVICE_STATUS pStat,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsQueryServiceStartType(DWORD connid,SC_HANDLE hService,PDWORD p_remerr,PDWORD pStartType,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsSetServiceStartType(
	DWORD connid,SC_HANDLE hService,DWORD pStartType,
	LPSTR ServiceDisplayName,PDWORD p_remerr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);


IMPEX PVOID _calltype_ cfsPmonLocalDispatchProcess(int argc,char** argv,
	DWORD dwParId,PDWORD pPid);

IMPEX PVOID _calltype_ cfsPmonLocalDispatchProcessEx(int argc,char** argv,
	PVOID parent,PDWORD pPid,BOOL fLatent);

typedef struct {
	PVOID	Parent;
	DWORD	dwParId;
	DWORD	Pid;
	BOOL	Latent;
	DWORD	Timeout;
	BYTE	Restart;
	BYTE	bReserved[3];
	PVOID	LinkedProcess;
	DWORD	Reserved[6];
}LDISPP_PARMS;

IMPEX PVOID _calltype_ cfsPmonLocalDispatchProcessEx2(int argc,char** argv,LDISPP_PARMS* Parms);

IMPEX LPSTR _calltype_ cfsPmonLocalGetProcCmdLine(PVOID pd);

IMPEX VOID _calltype_ cfsPmonLocalUndispatchProcess(PVOID pd);

IMPEX VOID _calltype_ cfsPmonLocalRegisterProcess(int argc,char** argv,
	PHANDLE phStartEvt,PHANDLE phStopEvt);

IMPEX CHAR** _calltype_ cfsPmonLocalTokenizeString(LPSTR s,PINT pargc);

IMPEX BOOL _calltype_ cfsPmonEnumProcesses(DWORD connid,LPSTR prefix,LPSTR* pResult,BOOL fRunning,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsPmonEnumProcessRegisteredChildren(LPSTR arguments,BOOL fToStart);

IMPEX BOOL _calltype_ cfsPmonRestartProcess(DWORD connid,LPSTR process_name_args,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsPmonStopProcess(DWORD connid,LPSTR process_name_args,
	PDWORD pnumfound,LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsPmonStopProcessEx(DWORD connid,LPSTR process_name_args,DWORD fKill,PDWORD pnumfound,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsPmonCheckProcess(DWORD connid,LPSTR process_name_args,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsGetSecurityLevel(DWORD connid,PDWORD p_level,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsSetSecurityLevel(DWORD connid,DWORD level,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL 	_calltype_ cftNPropSet(DWORD id,LPSTR szName,LPSTR szText);
IMPEX BOOL 	_calltype_ cftNPropRemove(DWORD id,LPSTR szName);
IMPEX LPSTR _calltype_ cftNPropGetText(DWORD id,LPSTR name,LPSTR buf,DWORD count);
IMPEX LPSTR _calltype_ cftNPropEnum(DWORD id,DWORD idx,LPSTR buf,DWORD count);

IMPEX BOOL 	_calltype_ cftNodeMove(DWORD id,DWORD destid,BOOL fCheck);
IMPEX DWORD _calltype_ cftNodeInsertAfter(DWORD id,LPSTR szText);
IMPEX DWORD _calltype_ cftNodeInsertDown(DWORD id,LPSTR szText);
IMPEX DWORD _calltype_ cftNodeFindSubNode(DWORD id,LPSTR name);

IMPEX VOID 	_calltype_ cftNodeRemove(DWORD id);
IMPEX VOID 	_calltype_ cftNodeFreeTree(DWORD id);
IMPEX LPSTR _calltype_ cftNodeGetName(DWORD id,LPSTR buf,DWORD count);
IMPEX DWORD _calltype_ cftNodeEnum(DWORD id,DWORD idx);
IMPEX DWORD _calltype_ cftNodeGetNext(DWORD id);

IMPEX DWORD _calltype_ cftNodeFind(DWORD id,LPSTR name);
IMPEX DWORD _calltype_ cftNodeEnumAll(DWORD id,DWORD idx);
IMPEX VOID 	_calltype_ cftNodeMarkDirty(DWORD id);
IMPEX VOID 	_calltype_ cftNodeMarkClean(DWORD id);
IMPEX BOOL 	_calltype_ cftNodeIsDirty(DWORD id);
IMPEX DWORD _calltype_ cftNodeGetChangeCount(DWORD id);
IMPEX DWORD _calltype_ cftNodeGetParent(DWORD id);


IMPEX BOOL  _calltype_ cftNodeIsEnabled(DWORD id);
IMPEX VOID  _calltype_ cftNodeEnable(DWORD id,BOOL fEnable);
IMPEX BOOL _calltype_ cftNodeInsertNodeAfter(DWORD id,DWORD nid);
IMPEX BOOL _calltype_ cftNodeInsertNodeDown(DWORD id,DWORD nid);



IMPEX DWORD _calltype_ cftNodeNewTree();

IMPEX DWORD _calltype_ cfsConfFileOpen(LPSTR serverName,LPSTR fname,DWORD timeout,PFILETIME p_ft,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsConfFileSaveAs(DWORD tree_id,LPSTR serverName,LPSTR fname,DWORD timeout,PFILETIME pft,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL  _calltype_ cfsConfFileSaveLocal(DWORD tree_id,LPSTR fname,LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsNodeFileLoad(LPSTR fname,LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsNodeFileSave(DWORD tree_id,LPSTR fname,LPDWORD perr,LPSTR err_string,DWORD maxerrs);


IMPEX BOOL _calltype_ cfsSaveMachineConfig(BOOL fFull,LPSTR RemoteMasterMachine,LPSTR FileName,LPSTR errs,DWORD cb_errs);

typedef VOID (CALLBACK* CFSFNOTIFY)(LPSTR fname);
IMPEX HANDLE _calltype_ cfsStartWatchFile(LPSTR cname,LPSTR fname,PFILETIME p_ft,CFSFNOTIFY func,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);	//Returns handle of auto-reset event or null

IMPEX VOID _calltype_ cfsStopWatchFile(HANDLE hEvt);

//////////////////////////////////// remote pipes
IMPEX HANDLE _calltype_ cfsPipeOpen(DWORD connid,LPSTR pipe,DWORD flags,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsPipeClose(DWORD connid,HANDLE hPipe,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsPipeWait(DWORD connid,LPSTR pipe,DWORD dwTime,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsPipeSetMode(	DWORD connid,HANDLE hPipe,DWORD mode,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsPipeRead( DWORD connid,HANDLE hPipe,LPVOID inbuf,DWORD cb_inbuf,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs); // 0xffffffff if error

IMPEX DWORD _calltype_ cfsPipeWrite(	DWORD connid,HANDLE hPipe,LPVOID outbuf,DWORD cb_outbuf,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsPipeTransact(	DWORD connid,HANDLE hPipe,
	LPVOID outbuf,DWORD cb_outbuf,LPVOID inbuf,DWORD cb_inbuf,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsDevIoCtl(DWORD connid,HANDLE hDev,DWORD control_code,
	LPVOID OutBuf,DWORD cbOutBufSize,LPVOID InBuf,PDWORD pcbInBuf,PDWORD pdwErr,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
// returns FALSE on communication error
// PDWORD pdwErr[0]!=ERROR_SUCCESS on DeviceIoControl error

IMPEX LPSTR _calltype_ cfsEnumIepdDevices(
	DWORD connid,LPDWORD perr,LPSTR err_string,DWORD maxerrs
);
// returns NULL on error
// else returned ptr should be freed by cfsFreeMemory()

//////////////////////////////////// trace and log file funcs
#define STR_SRV_SIG 0x3fd5a759
#define STR_USR_SIG 0x83a3b266
typedef unsigned __int64 u64;

#define MAX_TI_TEXT 64

#pragma pack(1)

typedef struct {
	LPSTR fname;
	DWORD fattrs;
}FFindInfo;
typedef struct {
	DWORD count;
	FFindInfo files[1];
}FFindResults;
typedef struct {
	DWORD signature;
	DWORD unique;
	DWORD pid;
	DWORD ppid;
	DWORD flags;
	DWORD dbg_cnt;
	DWORD loud_cnt;
	CHAR name[MAX_TI_TEXT];
	CHAR comment[MAX_TI_TEXT];
	u64 bytes_in;
	u64 bytes_out;
	DWORD state;
	LONG creation_time;
}IfaceServer;

typedef struct {
	IfaceServer s;
	CHAR		cmdl[256];
}IfaceServerEx;

typedef struct {
	DWORD signature;
	DWORD unique;
	DWORD thid;
	DWORD pid;
	DWORD flags;
	DWORD dbg_cnt;
	DWORD loud_cnt;
	CHAR name[MAX_TI_TEXT];
	CHAR comment[MAX_TI_TEXT];
	u64 bytes_in;
	u64 bytes_out;
	HANDLE handle;
	LONG creation_time;
}IfaceUser;

typedef struct {
	HANDLE	hMap;
	PVOID	pData;
}TRACE_ITEM_STORAGE;

typedef struct {
	LPSTR	pAlias;
	LPSTR	pProtocol;
	LPSTR	pAddress;
}WS_ALIAS_INFO;

#pragma pack()

DWORD 	__stdcall lf_Open(LPSTR fname);
VOID 	__stdcall lf_Close(DWORD lfd_d);
VOID 	__stdcall lf_CloseSnapshot(DWORD lfd_d);
BOOL 	__stdcall lf_TakeSnapshot(DWORD lfd_d);
BOOL 	__stdcall lf_SnapGetRecord(DWORD lfd_d,char* buf,DWORD cBufSize);
BOOL 	__stdcall lf_SnapGetRecordFirst(DWORD lfd_d,char* buf,DWORD cBufSize);
BOOL 	__stdcall lf_Clear(DWORD lfd_d);
BOOL 	__stdcall lf_WriteSZ(DWORD lfd_d,char* sz);
BOOL 	__stdcall lf_StartServer(LPSTR errs); 
VOID 	__stdcall lf_StopServer();
BOOL	__stdcall lf_ParseTime(char* buf,u64* pV);
VOID 	__stdcall lf_FormatTime(u64* pV,char* buf,BOOL fExact);
INT		__stdcall lf_CompareTime(u64* pV1,u64* pV2);
LPSTR 	__stdcall lf_ParseMessage(LPSTR s,LPSTR sTime,LPSTR sDate,LPSTR sName,LPSTR sType,
	LPSTR sMsgType,LPSTR sThid);
DWORD	__stdcall lf_Copy(LPSTR fname,LPSTR fullname, LPSTR errs);

#define 	TRS_SRV_STARTING 	0
#define 	TRS_SRV_RUNNING		1
#define 	TRS_SRV_STOPPING	2
BOOL 	__stdcall strac_AllocServer(TRACE_ITEM_STORAGE* tis,DWORD pid,DWORD ppid,LPSTR name,LPSTR comment);
BOOL 	__stdcall strac_AllocUser(TRACE_ITEM_STORAGE* tis,DWORD thid,DWORD pid,LPSTR name,LPSTR comment);
VOID 	__stdcall strac_FreeServer(TRACE_ITEM_STORAGE* tis);
VOID 	__stdcall strac_FreeUser(TRACE_ITEM_STORAGE* tis);
VOID 	__stdcall strac_AddBytesIn(TRACE_ITEM_STORAGE* tis,DWORD bytes);
VOID 	__stdcall strac_AddBytesOut(TRACE_ITEM_STORAGE* tis,DWORD bytes);
VOID	__stdcall strac_SetServerState(TRACE_ITEM_STORAGE* tis,DWORD state);
VOID	__stdcall strac_SetUserHandle(TRACE_ITEM_STORAGE* tis,HANDLE handle);
VOID	__stdcall strac_AbortUser(TRACE_ITEM_STORAGE* tis);
DWORD	__stdcall strac_EnumServers(DWORD idx,LPSTR buf,DWORD len);
DWORD	__stdcall strac_EnumUsers(DWORD idx,LPSTR buf,DWORD len);

BOOL 	__stdcall strac_GetServerData(LPSTR buf,IfaceServer* is);
BOOL 	__stdcall strac_GetUserData(LPSTR buf,IfaceUser* iu);
BOOL	__stdcall strac_IsCurrentThreadTraced(BOOL fDebug);
VOID	__stdcall strac_SetConsoleDebug(BOOL fDebug);

IMPEX	PSECURITY_DESCRIPTOR	_calltype_	cfs_s_s_LoadSecurityDescriptor(LPSTR name,DWORD DefMask);
IMPEX	VOID					_calltype_	cfs_s_s_FreeSecurityDescriptor(PSECURITY_DESCRIPTOR psd);
IMPEX	VOID					_calltype_	cfs_s_s_GetSecurityDescriptorTime(LPSTR name,PFILETIME pft);
IMPEX	DWORD					_calltype_	cfs_s_s_GetAccess(PSECURITY_DESCRIPTOR psd,HANDLE hToken,PGENERIC_MAPPING pGenMapping);
IMPEX	DWORD					_calltype_	cfs_s_s_SetSecurityDescriptor(LPSTR name,PSECURITY_DESCRIPTOR psd,DWORD DefMask,DWORD ChangeType);
IMPEX	DWORD					_calltype_	cfs_s_s_GetSecurityLevel(PDWORD p_level);
IMPEX	BOOL					_calltype_	cfs_s_s_AdminsMask(HANDLE hToken,PDWORD pdwMask);

/*
IMPEX void *	__cdecl cfsa_malloc (size_t sz);
IMPEX void *	__cdecl cfsa_calloc (size_t nelem, size_t elsize);
IMPEX void 		__cdecl cfsa_free (void * ptr);
IMPEX void *	__cdecl cfsa_realloc (void * ptr, size_t sz);
*/

#ifndef NO__PRINTF
VOID __cdecl e_printf(LPCSTR format, ...);
VOID __cdecl m_printf(LPCSTR format, ...);
VOID __cdecl d_printf(LPCSTR format, ...);
VOID __cdecl set_printf_handler(__printf_handler);
#endif

IMPEX INT _calltype_ cfs_stricmp(OPTIM LPSTR s1,OPTIM LPSTR s2);
IMPEX INT _calltype_ cfs_strnicmp(OPTIM LPSTR s1,OPTIM LPSTR s2,INT count);

IMPEX LPSTR _calltype_ cfsTraceEnumServers(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
			// returns NULL on error
			// pointer to string otherwise ("suid1\0suid2\0suid3\0\0")

IMPEX LPSTR _calltype_ cfsTraceEnumUsers(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
			// should free pointer by cfsFreeMemory()

IMPEX BOOL _calltype_ cfsTraceGetServerData(DWORD connid,LPSTR suid,IfaceServer* is,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsTraceGetUserData(DWORD connid,LPSTR suid,IfaceUser* iu,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsTraceTreeWaitForChange(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsTraceTreeCheckForChange(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsTraceBeginTrace(DWORD connid,DWORD pid,DWORD thid,BOOL fDebug,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsTraceBeginTraceEx(DWORD connid,DWORD pid,DWORD thid,BOOL fDebug,DWORD pause,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsTraceEndTrace(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsTraceGetMessage(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
			// should free pointer by cfsFreeMemory()

IMPEX BOOL	_calltype_ cfsTraceStopProcess(DWORD connid,DWORD pid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL	_calltype_ cfsTraceRestartProcess(DWORD connid,DWORD pid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsLogOpen(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsLogOpenEx(DWORD connid,LPSTR fname,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);


IMPEX BOOL _calltype_ cfsLogClose(DWORD connid, 	
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsLogGetRecord(DWORD connid,BOOL fFirst,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
			// should free pointer by cfsFreeMemory()

IMPEX BOOL _calltype_ cfsLogClear(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsLogCopy(DWORD connid, 	LPSTR name,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsGetSysdataFile(DWORD connid, 	LPSTR name,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsFFIndDrives(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);
			// should free pointer by cfsFreeMemory()

IMPEX FFindResults* _calltype_ cfsFFindItems(DWORD connid,LPSTR fname,
			// should free pointer by cfsFreeMemory()
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsGetIniString(DWORD connid,LPSTR path,LPSTR section,LPSTR key,LPSTR def,LPSTR value,PDWORD pcb_value,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsSetIniString(DWORD connid,LPSTR path,LPSTR section,LPSTR key,LPSTR value,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX LPSTR _calltype_ cfsEditGrab(LPSTR MachineName,BOOL bGrab,LPSTR fname,LPSTR username,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsUserMessage(DWORD connid,CHAR message_type,LPSTR text);

IMPEX BOOL _calltype_ cfsIsReserveWorking(
	DWORD connid,	DWORD IpAddr, 
	WORD IpBCPort,	WORD IpPort,	DWORD SType,
	PBOOL pWorking, LPSTR SName, /*64*/
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);


IMPEX DWORD _calltype_ cfsWinsockGetAliases(WS_ALIAS_INFO** ppAI);
			// should free pointer by cfsFreeMemory()

IMPEX BOOL _calltype_ cfsWinsockSaveAliases(DWORD count,WS_ALIAS_INFO* pAI);

IMPEX LPSTR _calltype_ cfsWinsockEnumProtocols();
			// should free pointer by cfsFreeMemory()

IMPEX LPCSTR _calltype_ cfsWsGetErrorText(int error);

IMPEX DWORD _calltype_ cfsWsRemoteGetAliases(DWORD connid,LPDWORD perr,LPSTR err_string,DWORD maxerrs,
	WS_ALIAS_INFO** ppAI);
			// should free pointer by cfsFreeMemory()

IMPEX BOOL _calltype_ cfsWsRemoteSaveAliases(DWORD connid,LPDWORD perr,LPSTR err_string,DWORD maxerrs,
	DWORD count,WS_ALIAS_INFO* pAI);

IMPEX LPSTR _calltype_ cfsWsRemoteEnumProtocols(DWORD connid,LPDWORD perr,LPSTR err_string,DWORD maxerrs);
			// should free pointer by cfsFreeMemory()

IMPEX INT	_calltype_ cfsQueryAppKey();

IMPEX VOID	_calltype_ cfsWriteAppKey(INT ComNum);

IMPEX DWORD _calltype_ cfsGetConfDword(LPSTR name,DWORD def);

IMPEX DWORD _calltype_ cfsGetConfDwordEx(LPSTR fname,LPSTR secname,LPSTR keyname,DWORD def);

IMPEX BOOL _calltype_ cfsSetConfDword(LPSTR name,DWORD val);

IMPEX BOOL _calltype_ cfsSetConfDwordEx(LPSTR fname,LPSTR secname,LPSTR keyname,DWORD val);


IMPEX LPSTR _calltype_ cfsGetConfStringEx(LPSTR fname,LPSTR secname,LPSTR keyname,LPSTR def);

IMPEX BOOL	_calltype_ cfsSetConfStringEx(LPSTR fname,LPSTR secname,LPSTR keyname,LPSTR str);


IMPEX VOID	_calltype_ cfsInterMove(PBYTE dest,PBYTE src,DWORD cnt);


#define CFSHARE_ACCESS_READ			1
#define CFSHARE_ACCESS_WRITE		2
#define CFSHARE_ACCESS_GLOBAL		4
#define CFSHARE_ACCESS_OP_PIPE		8
#define CFSHARE_ACCESS_TRACE		0x10


#define CFSHARE_ACCESS_READ_R_STR		L" "
#define CFSHARE_ACCESS_WRITE_R_STR		L""
#define CFSHARE_ACCESS_GLOBAL_R_STR		L"   "
#define CFSHARE_ACCESS_OP_PIPE_R_STR	L"  "
#define CFSHARE_ACCESS_TRACE_R_STR		L""

#define CFSHARE_ACCESS_READ_E_STR		L"Read config"
#define CFSHARE_ACCESS_WRITE_E_STR		L"Modify"
#define CFSHARE_ACCESS_GLOBAL_E_STR		L"Global directory access"
#define CFSHARE_ACCESS_OP_PIPE_E_STR	L"Access servers"
#define CFSHARE_ACCESS_TRACE_E_STR		L"Trace"

#define CFS_SD_MAIN		0x80000000
#define CFS_SD_SERVER	0x80000001
typedef struct {
	DWORD ResourceType;
	struct {
		DWORD mask;
		CHAR eng[128];
		CHAR rus[128];
	}bit[32];
	struct {
		DWORD mask;
		CHAR eng[128];
		CHAR rus[128];
	}cplx[32];
	struct {
		DWORD mask;
		CHAR eng[128];
		CHAR rus[128];
	}audit[32];
	struct {
		CHAR eng[128];
		CHAR rus[128];
	}deflt;
	struct {
		CHAR eng[128];
		CHAR rus[128];
	}objtypename;
	GENERIC_MAPPING GenericMapping;
	CHAR name_prefix[128];
}CFS_ACCESS_DESCRIPTOR;
typedef struct {
	DWORD PrimaryDomainError;
	WCHAR PrimaryDomainName[100];
	BYTE  PrimaryDomainSid[100];
	DWORD AccountDomainError;
	WCHAR AccountDomainName[100];
	BYTE  AccountDomainSid[100];
}DOMAIN_INFO_S;

#define NTPT_NOTDEF				0
#define NTPT_WORKSTATION		1	
#define NTPT_DOMAIN_CONTROLLER	2
#define NTPT_SERVER				3

#pragma pack(1)
typedef struct {
	DWORD				Len;
	CHAR				ComputerName[64];
	DWORD				NtVerMaj;
	DWORD				NtVerMin;
	DWORD				NtBuild;
	DWORD				Acp;
	unsigned __int64	Uptime;
	BYTE				UptimeAbs;
	BYTE				NtProductType;
	BYTE				Win64;
	BYTE				_bres1;
	BYTE				LOctet[8];
	DWORD				_reserved[3];
	DWORD				CfsVerMaj;
	DWORD				CfsVerMin;
	DOMAIN_INFO_S		DomInfo;
	CHAR				UserName[64];
	CHAR				_res2[64];
	CHAR				UserAddr[64];
	CHAR				_res3[32];
	DWORD				IpAddrs[8];
	DWORD				AccessMask;
}COMPUTER_INFO_S;
#pragma pack()

IMPEX BOOL _calltype_ cfsGetDomainInfo(
	DWORD connid,DOMAIN_INFO_S* dis,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX BOOL _calltype_ cfsGetComputerInfo(
	DWORD connid,COMPUTER_INFO_S* dis,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX DWORD _calltype_ cfsGetLocalDomainInfo(
	DOMAIN_INFO_S* dis);

IMPEX BOOL _calltype_ cfsGetOsUptime(DWORD connid,unsigned __int64* p_uptime,PBOOL p_absolute);

IMPEX PSECURITY_DESCRIPTOR _calltype_ cfsQrySecurityDescriptor(
	DWORD connid,DWORD type,LPSTR name,PDWORD pdwDescLen,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);// should free with cfsFreeMemory

#define CFS_SD_CHANGE_SACL	1
#define CFS_SD_CHANGE_DACL	2
#define CFS_SD_CHANGE_OWNER	4
#define CFS_SD_CHANGE_GROUP	8



IMPEX BOOL _calltype_ cfsSetSecurityDescriptor(
	DWORD connid,DWORD type,LPSTR name,DWORD dwDescLen,PSECURITY_DESCRIPTOR pSD,DWORD ChangeType,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs);

IMPEX CFS_ACCESS_DESCRIPTOR* _calltype_ cfsGetAccessDescriptor(LPSTR ini,LPSTR section);

IMPEX PSECURITY_DESCRIPTOR _calltype_ cfsEditDacl(
	HWND hWnd,	LPWSTR systemname,
	LPSTR name,	PSECURITY_DESCRIPTOR initial,
	CFS_ACCESS_DESCRIPTOR* ad,	LPSTR errs,	PDWORD perr );

IMPEX PSECURITY_DESCRIPTOR _calltype_ cfsEditSacl(
	HWND hWnd,	LPWSTR systemname,
	LPSTR name,	PSECURITY_DESCRIPTOR initial,
	CFS_ACCESS_DESCRIPTOR* ad,	LPSTR errs,	PDWORD perr );

IMPEX PSECURITY_DESCRIPTOR _calltype_ cfsTakeOwnership(
	HWND hWnd,	LPWSTR systemname,
	LPSTR name,	PSECURITY_DESCRIPTOR initial,
	CFS_ACCESS_DESCRIPTOR* ad,	LPSTR errs,	PDWORD perr );

#ifdef CFSHARE_SECURED
#include "cfshare_sec.h"
#endif 

IMPEX HANDLE _calltype_ cfsBeginThread(
	void *security, 
	unsigned stack_size, 
	unsigned ( __stdcall *start_address )( void * ), 
	void *arglist, 
	unsigned initflag, 
	unsigned *thrdaddr,
	char* name
);
IMPEX VOID _calltype_ cfsSetThreadName(LPSTR name);

IMPEX LPSTR _calltype_ cfsLocalEnumThreads();	// should be freed

IMPEX LPSTR _calltype_ cfsEnumThreads(DWORD connid,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs); // should be freed

IMPEX LPSTR _calltype_ cfsEnumDomains();	// should be freed
IMPEX PVOID _calltype_ cfsGetUserSid(LPSTR Domain,LPSTR User); // should be freed	
IMPEX LPSTR _calltype_ cfsGetUserNameFromSid(PVOID Sid,LPSTR Domain); // should be freed
IMPEX LPSTR _calltype_ cfsPrintUserSid(PVOID Sid);	// should be freed
IMPEX PVOID _calltype_ cfsGetBinarySid(LPSTR TextSid); // should be freed

IMPEX LPSTR _calltype_ cfsEnumDomainUsers(LPSTR domain);	// should be freed

#pragma pack(1)
typedef struct {
	CHAR	Domain	[MAX_PATH];
	CHAR	User	[MAX_PATH];
	DWORD	level;
	DWORD	cb_data;
}RNG_USER_DATA;
#pragma pack()


#define CFS_RNG_SUPPORTED						0
#define CFS_RNG_ENUM_DOMAINS					1
#define CFS_RNG_ENUM_DOMAIN_USERS				2
#define CFS_RNG_ENUM_DOMAIN_MACHINES			3
#define CFS_RNG_ENUM_DOMAIN_GROUPS				4
#define CFS_RNG_GET_USER_SID					5
#define CFS_RNG_GET_USER_NAME					6
#define CFS_RNG_GET_SNU							7
#define CFS_RNG_ENUM_LOCAL_GROUPS				8
#define CFS_RNG_USER_ENUM_GROUPS				9


#define CFS_RNG_USER_ADD						0x100
#define CFS_RNG_USER_SET						0x101
#define CFS_RNG_USER_SETG						0x102
#define CFS_RNG_USER_SETLG						0x103


IMPEX PBYTE _calltype_ cfsRemoteNet(
	DWORD connid,
	DWORD function,
	PBYTE InData,
	DWORD cbInData,
	PDWORD pcbOutData,
	LPDWORD perr,LPSTR err_string,DWORD maxerrs
);	//result should be freed, NULL on error

IMPEX PBYTE _calltype_ cfsLocalNet(
	DWORD function,
	PVOID InData,
	DWORD cbInData,
	PDWORD pcbOutData
);

IMPEX PSECURITY_ATTRIBUTES _calltype_ cfsSAEO();
IMPEX PSECURITY_DESCRIPTOR _calltype_ cfsSDEO();

#define CFS_RESERVE_NONE	0
#define CFS_RESERVE_SRC		1
#define CFS_RESERVE_TARGET	2
#define CFS_RESERVE_NOTACT	3
typedef struct {
	DWORD	StructSize;
	DWORD	ReserveType;
	DWORD	InetAddr;
	WORD	Port;
	DWORD	AbortTimeout;
	DWORD	RetakeTimeout;
	DWORD	BindAddr;
	BOOL	CopyConfig;
	WORD	BroadcastPort;
	BOOL	StopInactive;
}CFS_RESERVE_PARAMETERS;

IMPEX CFS_RESERVE_PARAMETERS* _calltype_ cfsGetReserveParameters(); //should be freed
IMPEX BOOL _calltype_ cfsSetReserveParameters(CFS_RESERVE_PARAMETERS* parms);

IMPEX DWORD _calltype_ cfsGetTickCount();


#define CFS_SECURITY_LEVEL_DEFAULT	0
#define CFS_SECURITY_LEVEL_ACCESS	1

IMPEX DWORD _calltype_ cfs_s_s_GetSecurityLevel(PDWORD p_level);
/*
#pragma pack(1)

#define _STATS_PRG_CFSHARED	'h'
#define _STATS_PRG_SERVER	's'
#define _STATS_PRG_SRVRB	'r'
#define _STATS_PRG_SRVTM	't'
#define _STATS_PRG_DELTA	'd'
#define _STATS_PRG_CALC		'c'

typedef struct {

	DWORD			ut;
	WORD			ms;
	WORD			prg;	//8

	CHAR			name[16];	//24

	WORD			el_type;	//26
	union {
		BYTE				data[38];
		struct {
			DWORD			addr[8];	//58
			DWORD			parm1;		//62
			WORD			parm2;		//64
		}delta;
		struct {
			CHAR			name[38];
		}server_login;
		struct {
			WORD			chn;
			WORD			rtu;
			WORD			pt;
			DWORD			parm1;
			DWORD			parm2;
		}server_prm;
	};

}STATS_EL;
#pragma pack()
*/

IMPEX __int64	__stdcall cfsInterlockedRead64(volatile __int64 *target);
IMPEX __int64	__stdcall cfsInterlockedExchange64(volatile __int64 *target,__int64 value);
IMPEX __int64	__stdcall cfsInterlockedExchangeAdd64(volatile __int64 *target,__int64 addend);
IMPEX LONG		__stdcall cfsInterlockedCompareExchange32(LONG volatile *Destination, LONG Exchange, LONG Comparand);


#include <time.h>
IMPEX time_t	__cdecl old_uxtime();
IMPEX time_t	__cdecl uxgmtime();
IMPEX time_t	__cdecl uxtime();
IMPEX time_t	__cdecl uxtime_h(PBYTE pHund);
IMPEX time_t	__cdecl uxgmtime_h(PBYTE pHund);
IMPEX time_t	__cdecl uxtime_ms(PWORD pMS);
IMPEX time_t	__cdecl uxgmtime_ms(PWORD pMS);


IMPEX time_t	__cdecl mk_uxtime(DWORD Year,DWORD Month,DWORD Day, DWORD Hour,DWORD Minute,DWORD Second);
IMPEX BOOL		__cdecl parse_uxtime(time_t t, PDWORD Year, PDWORD  Month, PDWORD Day, PDWORD Hour, PDWORD Minute, PDWORD Second);
IMPEX DWORD		__cdecl dow_uxtime(time_t t);

IMPEX time_t	__cdecl uxgmtime2uxtime(	time_t t);
IMPEX time_t	__cdecl uxtime2uxgmtime(	time_t t);
IMPEX time_t	__cdecl uxgmt2tzuxt(	time_t t,TIME_ZONE_INFORMATION* ptzi);
IMPEX time_t	__cdecl tzuxtime2uxgmt(	time_t t,TIME_ZONE_INFORMATION* ptzi);
IMPEX time_t	__cdecl uxgmt_tz_dls_bias(	time_t t,TIME_ZONE_INFORMATION* ptzi);
IMPEX INT		__cdecl sprint_uxtime(time_t ut,LPSTR buf);

IMPEX BOOL		__cdecl cfsGetExactSystemTime(SYSTEMTIME* pst);






IMPEX DWORD		_calltype_	tscGetTickCount();
IMPEX BOOL		_calltype_	tscUse();
IMPEX VOID		_calltype_	tscGetPF(unsigned __int64 *ppf);
IMPEX VOID		_calltype_	tscGetPC(unsigned __int64 *ppc);



IMPEX PVOID	_calltype_ rwlAlloc	();
IMPEX VOID	_calltype_ rwlFree	(PVOID p);
IMPEX BOOL	_calltype_ rwlEnter	(PVOID p,BOOL fExclusive,DWORD Timeout);
IMPEX BOOL	_calltype_ rwlLeave	(PVOID p,BOOL fExclusive);


IMPEX	PVOID	_calltype_ ini_Open(LPSTR name);
IMPEX	VOID	_calltype_ ini_Close(PVOID pf);
IMPEX	VOID	_calltype_ ini_Flush(PVOID pf);
IMPEX	DWORD	_calltype_ ini_ReadString(PVOID pf,LPSTR sec,LPSTR key,LPSTR Default,LPSTR Dest,DWORD cbDest);
IMPEX	INT		_calltype_ ini_ReadInteger(PVOID pf,LPSTR sec,LPSTR key,INT Default);
IMPEX	DWORD	_calltype_ ini_ReadStruct(PVOID pf,LPSTR sec,LPSTR key,PVOID Dest,DWORD cbDest);
IMPEX	DWORD	_calltype_ ini_ReadSection(PVOID pf,LPSTR sec,LPSTR Dest,DWORD cbDest);
IMPEX	DWORD	_calltype_ ini_EnumSections(PVOID pf,LPSTR Dest,DWORD cbDest);
IMPEX	BOOL	_calltype_ ini_WriteString(PVOID pf,LPSTR sec,LPSTR str,LPSTR value);
IMPEX	BOOL	_calltype_ ini_WriteInteger(PVOID pf,LPSTR sec,LPSTR str,INT value);
IMPEX	BOOL	_calltype_ ini_WriteStruct(PVOID pf,LPSTR sec,LPSTR str,PVOID Struct,DWORD cbStruct);
IMPEX	VOID	_calltype_ ini_EraseSection(PVOID pf,LPSTR sec);

IMPEX	BOOL	_calltype_ pkfPack(LPSTR pkfname,LPSTR fnames,LPSTR errs,DWORD errlen);
IMPEX	BOOL	_calltype_ pkfPackAdd(LPSTR pkfname,LPSTR fnames,LPSTR errs,DWORD errlen);
IMPEX	LPSTR	_calltype_ pkfUnPack(LPSTR pkfname,LPSTR dirname,LPSTR errs,DWORD errlen);
IMPEX	LPSTR	_calltype_ pkfEnumPackedFiles(LPSTR pkfname,LPSTR errs,DWORD errlen);
IMPEX	BOOL	_calltype_ pkfExtractFile(LPSTR pkfname,LPSTR fname, LPSTR dirname,LPSTR errs,DWORD errlen);


#define CFSSELD_DRIVE_UNKNOWN		0x01
#define CFSSELD_DRIVE_UNFORM		0x02
#define CFSSELD_DRIVE_REMOVABLE		0x04
#define CFSSELD_DRIVE_FIXED			0x08
#define CFSSELD_DRIVE_NETWORK		0x10
#define CFSSELD_DRIVE_CDROM			0x20
#define CFSSELD_DRIVE_RAM			0x40

IMPEX	BOOL _calltype_ cfsSelectDirectory(
	HWND hParent,
	DWORD flags,
	LPSTR dir,
	LPSTR caption,
	LPSTR explanation
);
IMPEX	DWORD _calltype_ cfsEnumProcessChildren(DWORD pid,PDWORD chids,DWORD cnt);


IMPEX	VOID _calltype_ cfsAnsiToUTF8(LPSTR text,LPSTR buf,DWORD cb_buf);
IMPEX	VOID _calltype_ cfsUTF8ToAnsi(LPSTR utext,LPSTR buf,DWORD cb_buf);

#define cfslzCMem(x) ((x)+((x)/4)+512)

IMPEX	INT	 _calltype_ cfslzCompress(PVOID InBuf,DWORD InLen,PVOID OutBuf,PDWORD pOutLen);
IMPEX	INT	 _calltype_ cfslzDecompress(PVOID InBuf,DWORD InLen,PVOID OutBuf,PDWORD pOutLen);

#pragma pack(1)
typedef struct _CFS_CFIM_PARMS{
	DWORD	Ut;
	DWORD	Wku[4];
	DWORD	rbsBFlags;
	DWORD	tmsBFlags;
	DWORD	res[12];
}CFS_CFIM_PARMS;
#pragma pack()

IMPEX	BOOL	_calltype_ cfsMountCheckConfigImageFile(LPSTR fn,CFS_CFIM_PARMS* impr);
IMPEX	VOID	_calltype_ cfsMountCheckChangedImages(LPSTR* ppFree, LPSTR* ppEdited,LPSTR *ppUnchanged);
IMPEX	VOID	_calltype_ cfsMountGetImageTime(LPSTR imgname,PDWORD p_img_t,PDWORD p_mount_t);
IMPEX	BOOL	_calltype_ cfsMountUpdateImage(LPSTR imgname,LPSTR errs,DWORD cb_errs);
IMPEX	BOOL	_calltype_ cfsMountIsCfImage(DWORD connid);

IMPEX	BOOL	_calltype_ cfsUnpackNewConfig();


IMPEX	BOOL _calltype_ cfsSaveCfImage(
	BOOL fFull,
	DWORD tmsBFlags,
	DWORD rbsBFlags,
	LPSTR RemoteMasterMachine,
	LPSTR FileName,
	LPSTR errs,
	DWORD cb_errs
);


IMPEX DWORD _calltype_	cfsCrc32(PBYTE p_buf,DWORD cb_buf);
IMPEX VOID	_calltype_	cfsCrc32Start(PDWORD p_crc);
IMPEX VOID	_calltype_	cfsCrc32End(PDWORD p_crc);
IMPEX VOID	_calltype_	cfsCrc32Append(PDWORD p_crc,PBYTE p_buf,DWORD cb_buf);
IMPEX WORD	_calltype_	cfsCrc16(WORD crc, PBYTE p_buf,DWORD cb_buf);

#ifndef CFSHARE_OWN
IMPEX DWORD cfsIF_LANG;
#endif


#ifdef __cplusplus
}	// extern "C"
#endif

#endif //_CFSHARE_H


 

 



















