#ifndef _TMCONN_H
#define _TMCONN_H

#ifndef  IF_PORTCORE

typedef unsigned __int64 u64;
#define _STDCALL    __stdcall
#define _CDECL      __cdecl

#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
#ifndef __TIME_H
#include <time.h>
#endif
*/

#define ERROR_TM_NOT_CONNECTED 0xc0001
#define TM_KERNEL_SIGNATURE 0x0830

#ifndef INVALID
#define INVALID 0xffffffff
#endif



#define SUCCESS 1                 //   
#define FAILURE 0                 //    

/*-------------    -----------------*/

#define TMS_ACCESS_TM_READ			0x00000001
#define TMS_ACCESS_STATUS_CHANGE	0x00000002
#define TMS_ACCESS_ANALOG_CHANGE	0x00000004
#define TMS_ACCESS_ACCUM_CHANGE		0x00000008
#define TMS_ACCESS_TELECONTROL		0x00000010
#define TMS_ACCESS_RETRO_VIEW		0x00000020
#define TMS_ACCESS_LOG_VIEW			0x00000040
#define TMS_ACCESS_ALARM_CHANGE		0x00000080
#define TMS_ACCESS_TM_SOURCE		0x00000100
#define TMS_ACCESS_TMSRC_DIALOG		0x00000200


#define DNT_ACCESS_READ				0x00000001
#define DNT_ACCESS_TRACE			0x00000002
#define DNT_ACCESS_CMD				0x00000004

#define	DNT_GENERIC_READ	DNT_ACCESS_READ
#define	DNT_GENERIC_WRITE   DNT_ACCESS_READ
#define	DNT_GENERIC_EXECUTE DNT_GENERIC_READ
#define	DNT_GENERIC_ALL (DNT_ACCESS_READ|DNT_ACCESS_TRACE|DNT_ACCESS_CMD)

/*-------------    -----------------*/
#define UNRELIABLE_HDW     0x0001   //  
#define UNRELIABLE_MANU    0x0002   //   
#define REQUESTED          0x0004   //  
#define MANUALLY_SET       0x0008   //  
#define LEVEL_A            0x0010   //    
#define LEVEL_B            0x0020   // ------- " -------  
#define LEVEL_C            0x0040   // ------- " -------  
#define LEVEL_D            0x0080   // ------- " -------  
#define INVERTED           0x0100   //    
#define RESCHANNEL         0x0200	//     
#define TMCTRL_PRESENT     0x0400	//   - volatile []
#define HAS_ALARM          0x0400	//   - volatile []

#define STATUS_CLASS_APS   0x0800	//  []
#define TMSTREAMING        0x1000	//   
#define F_ABNORMAL         0x2000   //   
#define F_UNACKED          0x4000   //  
#define F_IV               0x8000   // 101 IV

#define F_INTERIM          0x02000000   //  


#define SF_INIT				 0x80000000


// S2
#define S2_BREAK			 0x0001		// ?
#define	S2_MALFUNCTION		 0x0002		//  ?
#define	S2_INTERIM			 0x4000

// S2	 
#define S2_FLAGSONLY		 0x8000




/*------------------------   ---------------------------*/
#define evSTATUS_CHANGE      0x0001   // 
#define evALARM              0x0002   //  
#define evCONTROL            0x0004   // 
#define evMANUAL_CONTROL     0x0008   //   
#define evMANUAL_STATUS_SET  0x0010   //   
#define evMANUAL_ANALOG_SET  0x0020   //   
#define evRES1               0x0040
#define evRES2               0x0080

#define evEXT_LNK			 0x2000	  //   -  !
#define evEXT_FILE_LNK		 0x4000	  //   -  !
#define evEXTENDED			 0x8000	  //  

#define EXTEVL_KIND_STRBIN		0x100

#define EXTEVL_SOURCE_SERVER			0
#define EXTEVL_SOURCE_COMTRADE			1
#define EXTEVL_SOURCE_OMP				2
#define EXTEVL_SOURCE_I850				50
#define EXTEVL_SOURCE_BLACK_BOX			90
#define EXTEVL_SOURCE_IEC101_MESSAGE	101
#define EXTEVL_SOURCE_AURA_FILE			102
#define EXTEVL_SOURCE_IEC103_MESSAGE	103
#define EXTEVL_SOURCE_SPA_MESSAGE		105
#define EXTEVL_SOURCE_MODBUS			106
#define EXTEVL_SOURCE_DNP3				107

#ifndef	FLAGS_IGNORE
#define FLAGS_IGNORE			0x00
#define FLAGS_SET				0x01
#define FLAGS_CLEAR				0x02
#define FLAGS_COPY				0x03
#define FLAGS_RESET				0x10
#define	CHANGE_ALWAYS			0x80
#endif

//////////////////////// SERVER CAPABILITIES
#define TMS_CAPS_SEQST				0
#define TMS_CAPS_ALRNEW				1
#define TMS_CAPS_COMTRADE			2
#define TMS_CAPS_EVLARCH			3
#define TMS_CAPS_SFBIEX				4
#define TMS_CAPS_FBFLAGS			5
#define TMS_CAPS_USERS				6

#define TMS_CAPS_CFGT				120
#define TMS_CAPS_CNT				127

//////////////////////// TM-DATA TYPES
#define TM_STATUS			((WORD)0x8000)
#define TM_ANALOG			((WORD)0x8001)
#define TM_ACCUM			((WORD)0x8002)
#define TM_CONTROL			((WORD)0x8003)

#define TM_CHANNEL 			((WORD)0x9000)
#define TM_RTU 				((WORD)0x9001)

#define TM_RETRO_STATUS		((WORD)0x9010)
#define TM_RETRO_ANALOG		((WORD)0x9011)
#define TM_RETRO_ACCUM 		((WORD)0x9012)

#define TM_TAGGED_INFO		((WORD)0xff00)

#define TAGINF_SIMPLE		0


#define MAP_COMMAND_SUPPORTED		0
#define MAP_COMMAND_ACKNOWLEDGE		1
#define MAP_COMMAND_SET_BRIGHTNESS	2
#define MAP_COMMAND_ON_MODE			3
#define MAP_COMMAND_OFF_MODE		4
#define MAP_COMMAND_NORMAL_MODE		5
#define MAP_COMMAND_SET_BLINK_RATE	6
#define MAP_COMMAND_SHOW_UNDEFINED  7
#define MAP_COMMAND_DARK_MODE		8
#define MAP_COMMAND_STNORM_MODE		9
#define MAP_COMMAND_IND_ADDRESS		10

#define DGM_DATASOURCE 	0x00000001
#define DGM_TRACEALL	0x00000002
#define DGM_TRACEDEF	0x00000004
#define DGM_TMNOTIFY	0x00000008
#define	EXTS_SHOW_S2	0x00000100
#define	DGM_TOB_CHANGE	0x00000200

#define USER_DGM_FLAGS			(EXTS_SHOW_S2|DGM_TOB_CHANGE)


#define DNTT_DRIVER		'0'
#define DNTT_ADAPTER	'1'
#define DNTT_PORT		'2'
#define DNTT_RTU		'3'
#define DNTT_ARRAY		'4'
#define DNTT_BLOCK		'5'
#define DNTT_INFO		'6'

#define DNTERR_OK			0
#define DNTERR_THREAD		1
#define DNTERR_RESOURCE		2
#define DNTERR_MEMORY		3
#define DNTERR_UNKNOWN		100

////////////	Delta trace flags
#define DNT_TRACE_ERROR		0
#define DNT_TRACE_MSG		1
#define DNT_TRACE_DEBUG		2
#define DNT_TRACE_TM_IN		3
#define DNT_TRACE_TM_OUT	4
#define DNT_TRACE_S_IN		5
#define DNT_TRACE_S_OUT		6
#define DNT_TRACE_LOG		0x4000
#define DNT_TRACE_DRV		0x8000

////////////	TMS trace flags
#define TMS_TR_ERROR		0x0001
#define TMS_TR_MSG			0x0002
#define TMS_TR_DEBUG		0x0004
#define TMS_TR_TM_IN		0x0008
#define TMS_TR_TM_OUT		0x0010
////////////////////////////////

#define DNT_DRIVER_ETHERNET	1
#define DNT_DRIVER_COM		2

#ifndef TMS_BACKUP_
#define TMS_BACKUP_
#define TMS_BACKUP_CONFIG	1
#define TMS_BACKUP_ARRAY	2
#define TMS_BACKUP_EVLOG	4
#define TMS_BACKUP_ALARMS	8
#define TMS_BACKUP_RETRO	0x10
#define TMS_BACKUP_SECURITY	0x20
#endif

#define TMV_MAX_CLASSES		256

#ifndef RBS_BACKUP_
#define RBS_BACKUP_
#define RBS_BACKUP_BASES	1
#define RBS_BACKUP_SECURITY 2
#endif




/*-------------------------------- * ------------------------------*/
#pragma pack(1)
typedef struct
	{
    short Ch;
    short RTU;
    short Point;
    } TADRtm;

typedef struct
	{
	short Status;            //  
	short Flags;             // 
	} TStatusPoint;			//  

typedef struct
	{
	float asFloat;           //   
	short asCode;            //  ,   
	short Flags;             // 
	char  Unit[8];           //  
	} TAnalogPoint;  //  

typedef struct {
	float Value;
	short Flags;
}TAnalogPointShort;

typedef struct {
	DWORD fix_time;
	DWORD tm_time;
	WORD  chn;
	WORD  rtu;
	WORD  point;
	WORD  asCode;
	float asFloat;
	WORD  flags;
}TAnalogQueueRecord;

typedef struct {
	WORD level;
	WORD a[4];
	LPSTR name;
}TBaseObjectInfo;

typedef struct {
	TADRtm	a;
	unsigned char type;
//	possible bits

#define VF_TYPE_STATUS				0x10
#define VF_TYPE_ANALOG_CODE			0x20
#define VF_TYPE_ANALOG_FLOAT		0x30
#define VF_TYPE_ACCUM_VALUE			0x40
#define VF_TYPE_ACCUM_CODE			0x50
#define VF_TYPE_ACCUM_INCREMENT		0x60
#define VF_TYPE_TELECTRL			0x70
#define VF_TYPE_ACCUM_FLOAT			0x80
#define VF_TYPE_ACCUM_DIRECT		0x90
#define VF_TYPE_ACCUM_FLT_DIRECT	0xa0
#define VF_TYPE_TC_ACK				0xb0
#define VF_TYPE_ANALOG_FLOATCODE	0xc0

#define VF_FLG_IGNORE			0x00
#define VF_FLG_SET				0x01
#define VF_FLG_CLEAR			0x02
#define VF_FLG_COPY				0x03

#define VF_SIGNED				0x04
#define VF_ALWAYS_SET_VALUE		0x08

	BYTE					flags;
	BYTE					bits;

	union {
		BYTE				uchar;
		CHAR				schar;
		WORD				ushort;
		SHORT				sshort;
		DWORD           	ulong;
		INT	                slong;
		float				flt;
	};
}TValueAndFlags;

typedef struct {
	TValueAndFlags	vf;
	 WORD			s2;
} TVF_S2;

typedef struct {
	DWORD	sec;
	WORD	ms;
	WORD	flags;
#define TMXT_FLAG_GREENWICH		0x01
#define TMXT_FLAG_CURDATA		0x02
#define TMXT_FLAG_IV			0x04
#define TMXT_FLAG_ZIMP			0x08
#define TMXT_FLAG_USER			0x10
#define TMXT_FLAG_MANRTR		0x20
}TMXTime;

typedef struct {
	TValueAndFlags	vf;
	TMXTime			xt;
}TTimedValueAndFlags;

#define _TMSVX_TIMED	1
#define _TMSVX_S2		2
#define _TMSVX_ID		4
#define _TMSVX_EXF		8

typedef struct {
	unsigned short Ch;
	unsigned short RTU;
	unsigned short Point;		//6
	DWORD          Value;		//10
	DWORD          sec;			//14
	unsigned char  hund;		//15
    unsigned char  DataType;	//16
}TTimedAccum;
typedef struct {
	unsigned short Ch;
	unsigned short RTU;
	unsigned short Point;		//6
	DWORD          sec;			//10
	unsigned char  hund;		//11
	unsigned char  flags_type;	//12
    unsigned short DataType;	//14
	unsigned char  Data[16];	//30
}TTimedAccumEx;
typedef struct {
	unsigned short Ch;
	unsigned short RTU;
	unsigned short Point;		//6
	DWORD          sec;			//10
	unsigned char  hund;		//11
	unsigned char  flags_type;	//12
    unsigned short DataType;	//14
#define ACCFLG_INC		1
#define ACCFLG_DIRECT	2
	unsigned short AccFlags;	//16
	unsigned char  Data[16];	//32
}TAccumData;

typedef struct
    {
    unsigned short  Point;
    unsigned char   RTU;
    unsigned char   Ch;
	unsigned char 	GroupId;
	unsigned char 	AlarmId;
	float 			Value;
	unsigned short	Sign		:1;
	unsigned short	Sensibility	:7;
	unsigned short	Active		:2;
	unsigned short	InUse		:2;
	unsigned short	Importance	:4;
	unsigned short 	Period;
	unsigned char 	DayMap[6];
	unsigned char 	WeekMap;
	unsigned char 	YearMap[6];
	unsigned char 	InDirect;
	unsigned short 	CountDown;
	double 			Sum;
    } TAlarm;
#define ALARM_FILTER_DEFAULT	0
#define ALARM_FILTER_IIR_1		1
typedef struct
    {
    unsigned short  Point;
    unsigned char   RTU;
    unsigned char   Ch;
	unsigned char 	GroupId;
	unsigned char 	AlarmId;
	float 			Value;
	unsigned short	Sign		:1;
	unsigned short	Seconds		:3;
	unsigned short	FiltType	:4;
	unsigned short	Active		:2;	//modified by server
	unsigned short	InUse		:2;
	unsigned short	Importance	:4;
	unsigned short 	Period;
	unsigned char 	DayMap[6];
	unsigned char 	WeekMap;
	unsigned char 	YearMap[6];
	unsigned char 	InDirect;
	unsigned short 	CountDown;	//modified by server
	double 			Sum;		//modified by server

	unsigned char	cRes[16];
	float			Param[2];
	DWORD	        lRes[6];

    } TAlarmNew;

typedef struct {
	float			Param;
	char			ParamName[128];
	} TAlarmParam;

typedef struct {
	unsigned		short	bit_fields;
	float					cur_val;
	float					comp_val;

	} TAlarmState;

typedef struct
	{
	float Value;             //  
	float Load;              // 
	short Flags;             // 
	char Unit[8];            //  
	} TAccumPoint;   //  

typedef struct {
	LPSTR	name;
	BYTE	cp_flags;
#define TMCPF_NAME		0x01
#define TMCPF_ALLFLAGS	0x02
#define TMCPF_ST0		0x04
#define TMCPF_ST1		0x08
#define TMCPF_SKIPRES	0x10
	BYTE	res1;

	WORD	Type;
	WORD	Ch;
	WORD	RTU;
	WORD	Point;
	DWORD	TM_Flags;

	WORD	tm_s2;
	WORD	tm_flags2;

	DWORD	tm_change_ut;
	DWORD	tm_tm_ut;
	WORD	tm_change_ms;
	WORD	tm_tm_ms;
	union {
		TStatusPoint st;
		TAnalogPoint an;
		TAccumPoint	 ac;
		BYTE		 padding[32];
	};
}TCommonPoint;


#ifndef EXF_Present

#define EXF_NotTopical		0x00000001
#define EXF_Invalid			0x00000002
#define EXF_Overflow		0x00000004
#define EXF_OutofRange		0x00000008
#define EXF_BadReference	0x00000010
#define EXF_Oscillatory		0x00000020
#define EXF_Failure			0x00000040
#define EXF_OldData			0x00000080
#define EXF_Inconsistent	0x00000100
#define EXF_Inaccurate		0x00000200
#define EXF_Substituted		0x00000400
#define EXF_Test			0x00000800
#define EXF_OperatorBlocked	0x00001000

#define EXF_Present			0x80000000

#endif
typedef struct	{
	char DateTime[24];       //     .. ::.cc

	unsigned short Imp;      //  
	unsigned short ID;       //  

	union {
		struct {
			unsigned short Ch;       // 
			unsigned short RTU;      //    (c 1)
			unsigned short Point;    //     (c 1)
		}Common;
		struct {
			WORD Kind;
			WORD DataLen;
			WORD Reserved;
		}Extended;
	};

	char Data[22];
} TEvent;      // 


typedef struct
	{
	DWORD          Time;     //   .  01.01.1970
	unsigned char  Hund;     //   .

	unsigned char  Imp;      //  
	unsigned short ID;       //  
	union {
		struct {
			unsigned char  Ch;       // 
			unsigned char  RTU;      //    (c 1)
			unsigned short Point;    //     (c 1)
		}Common;
		struct {
			unsigned short Kind;
			unsigned short DataLen;
		}Extended;
	};

	union
		{
		char EndOfHeader;
		BYTE end_header;
		struct
			{
			char State;     //   
			char Class;     //   (.. - 0   - 1)
#ifdef		IF_PORTCORE
			DWORD		ExtSig;									//6
			BYTE		ResCh;									//7
			BYTE		ResRTU;									//8
			WORD		ResPoint;								//10
			DWORD		FixUT;									//14
			WORD		S2;										//16
			DWORD		Flags;									//20
			WORD		FixMS;									//22  -- no more fields!
#endif
			} Status;  //   
		struct
			{
			float Val;      //   
			short AlarmID;  //  
			char  State;    // 0 -  , 1 -  
			} Alarm;   //   
		struct
			{
			char  Ch;
			char  RTU;
			short Point;
			char  Cmd;     //  
			char  Result;  // == SUCCESS   ,  FAILURE
			char  UserName[16];  // ,  
			} Control; //   

		struct {
			BYTE data[1];
		} Extended;

		struct
			{
			DWORD index;
			} ExtendedLink;

		} Data;
} TTMSEvent;        //   

typedef struct _TEventEx{
#ifdef IF_PORTCORE
    PVOID   next;
#else
	struct _TEventEx* next;
#endif
	DWORD size;
	TEvent evt;
}TEventEx;

typedef struct {
	u64 r;
	u64 m;
}TTMSElix;

typedef struct {
	TTMSElix elix;
	TTMSEvent ev;
}TTMSEventElix;

typedef struct _TEventElix{
	struct _TEventElix* next;
	TTMSElix			elix;
	DWORD				ev_size;
	TEvent				evt;
}TEventElix;

typedef struct {
	DWORD	ItemsLimit;
	DWORD	MemoryLimit;
	HANDLE	hStop;
	BOOL	Interrupted;
	BOOL	EvlArch;
}TEventExCriteria;



typedef struct {
	WORD Source;
	BYTE Rtu;
	BYTE Chn;
	BYTE Str_And_Bin;
}EXTEVL_STRBIN;


typedef struct {
	CHAR	sig[2];	//'T','D'
	DWORD	id;
	DWORD	delta_addr[16];
	DWORD	value_idx;
	CHAR	name[296];
	CHAR	value[128];
}TAGGED_DATA_DG;

struct StatusData  //   
	{
	char State;    //   
	char Class;    //   (.. - 0   - 1)
	};
struct AlarmData   //   
	{
	float Val;     //   
	short AlarmID; //  
	char  State;   // 0 -  , 1 -  
	};
struct ControlData //   
	{
	char  Ch;
	char  RTU;
	short Point;
	char  Cmd;     //  
	char  Result;  // == SUCCESS   ,  FAILURE
	char  UserName[16];  // ,  
	};

////////////////////////	AAN

//	DON'T EVER CHANGE THE STRUCTURES!

typedef struct{
	WORD	ms;
	float	value;
	DWORD	flags;
}TMAAN_SR_DATA;

#define AANSR_LAST	0xffff

typedef struct {
	BYTE			legend;
	BYTE			mdflg;	//l=2
	float			v_min;	//l=6
	float			v_max;	//l=10
	float			v_last;	//l=14
	WORD			v_avg;	//l=16
	DWORD			v_tmflg;//l=20
	DWORD			series;	//l=24
}TMAAN_MIN_DATA;

#define AAMDF_OVF			1

#define AAMDL_NO_DATA		0
#define AAMDL_NOT_WR		0xff
#define AAMDL_OK			1


typedef struct {
	DWORD		ok;
	DWORD		last_mc_ms;
	DWORD		last_hc_ms;
	DWORD		last_dc_ms;
	DWORD		megabytes;
}TM_AAN_STATS;

#define AAV_MOM			0
#define AAV_AVG			1
#define AAV_MIN			2
#define AAV_MAX			3

#define AAVR_MOM			(1<<AAV_MOM)
#define AAVR_AVG			(1<<AAV_AVG)
#define AAVR_MIN			(1<<AAV_MIN)
#define AAVR_MAX			(1<<AAV_MAX)

#define AAVF_OVF			1

typedef struct {
	BYTE	tag;
	BYTE	aav_flg;
	DWORD	ut;
	WORD	ms;
	DWORD	flags;
	float	value;
}TMAAN_ARCH_VALUE;				//16 bytes

//////////////////////
typedef struct
    {
    unsigned short TII_RETRO_PERIOD;
    unsigned short TII_RETRO_DEPTH;
    unsigned short TIT_RETRO_PERIOD[3];
    unsigned short TIT_RETRO_DEPTH[3];
    char           TIT_RETRO_NAME[3][30];
    } TRetroInfo;

typedef struct {
	WORD	type;
	CHAR	name[128];
	CHAR	descr[30];
	DWORD	period;
	DWORD	capacity;
	DWORD	start;
	DWORD	stop;
	DWORD	rec_count;
	DWORD	reserved[16];
}TRetroInfoEx;
typedef struct {
	DWORD Id;
	CHAR  Name[64];
}TTelemetrySource;
#ifndef TServerInfo_DEEFINED
#define TServerInfo_DEEFINED
typedef struct {
	CHAR  Description[64];

	DWORD dwType;
	DWORD dwHeapUsage;
	DWORD dwWSMin;
	DWORD dwWSMax;

	DWORD HandleCount;
	DWORD StartTime;
	DWORD ConfChangeTime;
	DWORD ThreadCount;

	DWORD UserCount;
	DWORD LogonCount;

	DWORD PresenceFlags;
#define SIPF_UNIQ_USERS_COUNT	1
#define SIPF_TM_VALUE_COUNT		2
#define SIPF_RB_FILL			4
#define SIPF_RB_MAX_FILL		8

	DWORD UniqUserCount;
	DWORD TmValueCount;

	DWORD ReserveBufFill;
	DWORD ReserveBufMaxFill;
	DWORD TmTotValCnt;
	DWORD ReserveSentAsyncBytes;

	BYTE  reserverd[92];

} TServerInfo;
#endif //TServerInfo_DEEFINED
typedef struct {
	DWORD	Id;
	WORD	type;
	TADRtm	a;
} TRetransInfo;

typedef struct {
	BOOL	valid;

	CHAR	UserName		[0x10];
	CHAR	UserComment		[0x40];
	CHAR	NtUserName		[0x20];
	CHAR	NtUserDomain	[0x20];

	DWORD	DatagramMask;
	DWORD	AccessMask;
	DWORD	ConnectTime;

	BYTE	reserved		[0x60];

}TUserInfo;

#define TRETRANS_ITEMS_MAX 128

typedef struct {
	BYTE Ok;
#define TRIR_GROUP 1
#define TRIR_CLASS 2
	BYTE flags;
	WORD Group;
	WORD Class;
	WORD reserved2[3];
}TRetransInfoReply;

typedef struct {
	DWORD Id;
	WORD type;
	BYTE count;
	BYTE fbType;
	TADRtm a;
} TFeedbackInfo;
typedef struct {
	WORD Ch;
	WORD RTU;
	WORD Point;
	short Flags;
	short Status;
}TRetroStatusElement;
typedef struct {
	WORD Ch;
	WORD RTU;
	WORD Point;
	short Flags;
	float asFloat;
	short asCode;
}TRetroAnalogElement;
typedef struct {
	WORD Ch;
	WORD RTU;
	WORD Point;
	short Flags;
	float Value;
	float Load;
}TRetroAccumElement;

typedef struct {
	DWORD dwNumber;
	CHAR szName[32];
}TServerConfig;


typedef struct {
	BOOL	success;
	DWORD	bflags;
	CHAR	fname_or_error[1024];
}TServerBackupData;

typedef struct {
	DWORD	dwFreeSpace;
	DWORD	dwErr;
	DWORD	reserved[14];
	CHAR	errs[512];
}TPreRestoreServer;


#define TOF_WR_REPL		0
#define	TOF_WR_ADDT		1

typedef struct {
	BYTE	tob_flg;
	DWORD	scheme;
	WORD	type;
	DWORD	object;		//0xffffffff - not present
}TTechObj;

typedef struct {
	BYTE	tob_flg;
	DWORD	scheme;
	WORD	type;
	DWORD	object;
	LPSTR	props;		// "Prop1=aa\0Prop1=bbbb\0Prop2=ccc\0\0"
}TTechObjProps;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////	DELTA STRUCTURES

typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	BYTE value;
}DeltaStatus;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	BYTE value;
	BYTE hinum;
}DeltaStatus2;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	LONG value;
}DeltaAnalog;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	LONG value;
	BYTE hinum;
}DeltaAnalog2;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	float value;
}DeltaAnalogF;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	float value;
	BYTE hinum;
}DeltaAnalogF2;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	LONG value;
}DeltaAccum;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	LONG value;
	BYTE hinum;
}DeltaAccum2;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	float value;
}DeltaAccumF;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	float value;
	BYTE hinum;
}DeltaAccumF2;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	WORD ctrlBlock;
	WORD ctrlGroup;
	WORD ctrlPoint;
}DeltaControl;
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	WORD ctrlBlock;
	WORD ctrlGroup;
	WORD ctrlPoint;
	BYTE hinum;
}DeltaControl2;

typedef struct {
	BYTE type;
	BYTE length;
	LONG current;
}DeltaSliceTime;

typedef struct {
	BYTE type;
	BYTE length;
	CHAR text[1];
}DeltaDescription;


typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	CHAR s[1];

}DeltaStrval;

typedef struct {
	BYTE type;
	BYTE length;
}DeltaCommon;

/*subj to endian conversion in if_portcore*/

#define DELTA_ITEM_DESCRIPTION	0
#define DELTA_ITEM_TIME			1
#define	DELTA_ITEM_STATUS		2
#define DELTA_ITEM_ANALOG		3
#define DELTA_ITEM_ACCUM		4
#define DELTA_ITEM_CONTROL		5
#define DELTA_ITEM_ANALOGF		6
#define DELTA_ITEM_ACCUMF		7
#define DELTA_ITEM_STRVAL		8


#define DELTA_ITEMF_RELIABLE	1
#define DELTA_ITEMF_ZEROENUM    2
#define DELTA_ITEMF_DESTRELI	4
#define DELTA_ITEMF_DESTVAL		8
#define DELTA_ITEMF_HEX			0x10
#define DELTA_ITEMF_GROUP8		0x20
#define DELTA_ITEMF_N_PRSNT		0x40
#define DELTA_ITEMF_BINVAL		0x80
#define DELTA_ITEMF_WRITABLE	0x100
#define DELTA_ITEMF_CTLVALUE	0x200
#define DELTA_ITEMF_S2_BREAK	0x400
#define DELTA_ITEMF_S2_MALFN	0x800
#define DELTA_ITEMF_ANALONG		0x1000

#ifndef _BORLAND_TIME
#define _BORLAND_TIME
typedef struct {
		WORD year;
		BYTE day;
		BYTE month;
		BYTE min;
		BYTE hour;
		BYTE hund;
		BYTE sec;
}BorlandTime;
#endif

#pragma pack()



typedef struct {
	BYTE storage[0x100];
}ANALOG_QUEUE_FIND;
#ifdef _TMCONN_DLL
__declspec(dllexport) extern
#else
#ifndef IF_PORTCORE
__declspec(dllimport)
#endif // IF_PORTCORE
#endif
float huge_flt;

typedef VOID (_STDCALL * tmcDatagramFn)(DWORD count,LPBYTE buf,LPVOID param);
typedef VOID (_STDCALL * tmcProgressFn)(DWORD count,LPVOID str,LPVOID param);
typedef LONG (_STDCALL * tmcTelecontrolCallback)(DWORD cid,PVOID parm,LPSTR estr);
typedef VOID (_CDECL   * tcapRecvFunc)(DWORD count,LPBYTE buf,DWORD cid,BYTE proto);

#define TMTCCB_OK		1
#define TMTCCB_CANCEL	0
#define TMTCCB_NOKEY	-1
#ifdef _TMCONN_DLL
#define TMC_IMPEX	__declspec(dllexport)
#else
#ifndef IF_PORTCORE
#define TMC_IMPEX	__declspec(dllimport)
#else
#define TMC_IMPEX
#endif // IF_PORTCORE
#endif

#ifdef __cplusplus
#endif
/*-----------------------   --------------------------*/
//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID _STDCALL tmcFreeMemory(PVOID p);

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcConnect(
					LPSTR server,
					LPSTR pipe,
					LPSTR user,
					tmcDatagramFn cback,
					LPVOID cback_param);
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcConnectEx(
					LPSTR server,
					LPSTR pipe,
					LPSTR user,
					tmcDatagramFn cback,
					LPVOID cback_param,
					DWORD	cbProps,
					PDWORD	pProps,
					PDWORD	pPropValues	);
#define				TMC_MAX_CPROPS			8
#define				TMCCPROP_DGTYPE			1
//
//***************************************************************


//***************************************************************	IMPLEMENTED
#ifdef IF_PORTCORE
DWORD _STDCALL tmcConnectLocal(
					LPSTR pname,
					LPSTR user,
					tmcDatagramFn cback,
					LPVOID cback_param
);
#endif
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID _STDCALL tmcSetTelecontrolCallback(
				DWORD cid,
				tmcTelecontrolCallback cb,
				PVOID parm);
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR  _STDCALL tmcDecodeTcError(WORD status);
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID  _STDCALL tmcDisconnect( DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID  _STDCALL tmcUpdateConnection( DWORD cid );
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcIsConnected(	DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcGetServerCaps(DWORD cid,PBYTE pCaps);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcGetCfsHandle(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetConfigPath(DWORD cid,LPSTR path, DWORD cb_path);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcGetConfigType(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetCurrentServer(DWORD cid,LPSTR machine,DWORD cbMachine,LPSTR pipe,DWORD cbPipe);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcGetUrgentMessage(DWORD cid);
// returned pointer should be freed by tmcFreeMemory()
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetMapMode(DWORD cid, DWORD ModeType,PDWORD pMapMode);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcReconnectCount(	DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID  _STDCALL tmcReactError( DWORD cid, BOOL fReact );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX INT	_STDCALL tmcGetServerFeature(DWORD cid,DWORD dwCode);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL	_STDCALL tmcFeatCIDF(DWORD cid,PBYTE pi);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL	_STDCALL tmcFeatSB(DWORD cid,PBYTE pi,BYTE block,PBYTE data);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL	_STDCALL tmcSetRestraint(DWORD cid,BOOL fSet);
//
//
//***************************************************************



//***************************************************************	IMPLEMENTED
TMC_IMPEX PDWORD _STDCALL tmcGetUserList(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetUserInfo(DWORD cid,DWORD usid,TUserInfo* p_uinfo);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcPostUserDatagram(DWORD cid,DWORD usid,PVOID p_data,DWORD cb_data);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcComtradeEnumDays(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcComtradeEnumFiles(DWORD cid,LPSTR date);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcComtradeGetFile(DWORD cid,LPSTR fname,LPSTR locdir);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcBackupServerData ( DWORD cid, DWORD bflags, TServerBackupData* data );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcBackupServerProcedure(
	LPSTR machine,
	LPSTR pipe,
	LPSTR directory,
	PDWORD pbflags,
	HANDLE hCancel,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcRestoreServer(
	BOOL tms_not_rbs,
	LPSTR machine,
	LPSTR servname,
	LPSTR filename,
	PDWORD pbflags,
	HANDLE hCancel,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID _STDCALL tmcPreRestoreServer(
	BOOL tms_not_rbs,
	LPSTR machine,
	LPSTR servname,
	LPSTR filename,
	TPreRestoreServer* pprs
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetBlob(
	DWORD cid,
	LPSTR name,
	LPSTR local_filename,
	PDWORD pcount,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX TCommonPoint* _STDCALL tmcGetValuesByFlagMask(
	DWORD	cid,
	WORD	tm_type,
	DWORD	tm_flags,
	BYTE	q_flags,
	PDWORD	p_count
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX TCommonPoint* _STDCALL tmcTMValuesByListEx(
	DWORD	cid,
	WORD	tm_type,
	BYTE	q_flags,
	DWORD	a_count,
	TADRtm*	a
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetGrantedAccess(	DWORD cid ,PDWORD p_access);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcSetDgrmFlags(	DWORD cid, DWORD flags );
//
//		returns 0xffffffff on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcClrDgrmFlags(	DWORD cid, DWORD flags  );
//
//		returns 0xffffffff on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcClrFeedback(DWORD cid);
//
//		returns FAILURE on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetFeedbackItems(DWORD cid,WORD type,
	short Ch, short RTU, short Point,BYTE count,BYTE fbType,DWORD Id);
//
//		returns FAILURE on ERROR
#define  FBTYPE_SIMPLE		((BYTE)0)
#define  FBTYPE_CONTROL		((BYTE)2)
#define  FBTYPE_SEQ			((BYTE)3)
#define  FBTYPE_CTLADD		((BYTE)4)

#define	 FBFLAG_MANRTR		0x10
#define	 FBFLAG_MAINSRC		0x20


//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetFeedbackItemsEx(DWORD cid,WORD count/*max=128*/,
	TFeedbackInfo* items);
//
//		returns FAILURE on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetFeedbackItemsSrc(DWORD cid,PDWORD psrc,WORD count,TFeedbackInfo* items);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED, OBSOLETE!!
TMC_IMPEX void _STDCALL tmcGetTmSource(DWORD cid,WORD type,
	short Ch, short RTU, short Point,TTelemetrySource* src);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetRetransInfo(DWORD cid,WORD count,TRetransInfo* ri);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcUpdRetransInfo(DWORD cid,WORD count,TRetransInfo* ri);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcRemoveRetransInfo(DWORD cid,WORD count,TRetransInfo* ri);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetRetransInfoEx(DWORD cid,WORD count,TRetransInfo* ri,TRetransInfoReply* rir);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcClrRetransInfo(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSendMapboardCommand(DWORD cid,BYTE cmd,BYTE parm1,BYTE parm2);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSendMapboardCommandEx(DWORD cid,BYTE cmd,PBYTE parms,DWORD cb_parms);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcConnState( DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID _STDCALL tmcSetLastError(DWORD error);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcGetLastError();
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LONG _STDCALL tmcGetLastErrorText(DWORD cid,LPSTR* pp);
//
//	:            
//					    
//
//	:      pp    -  pp[0]    
//					      ,     
//					        tmcFreeMemory()
//
//	:         1  - 
//					 0  - 
//					-1 -   
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID _STDCALL tmcSetUser(LPSTR user,LPSTR pwd);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BYTE _STDCALL tmcEnumObjects( DWORD cid ,WORD object_type,BYTE count,PWORD buf,
		short Ch,short RTU,short Point);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcGetServerInfo(DWORD cid,TServerInfo* info);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcGetServerThreads(DWORD cid);
//
//
//***************************************************************	IMPLEMENTED

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcRetroInfoEx(DWORD cid,WORD idx,TRetroInfoEx* info);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcGetObjectName( DWORD cid ,WORD object_type,
		short Ch,short RTU,short Point,LPSTR buf,int buflen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcGetObjectNameEx(
	DWORD cid, short object_type,
	short Ch, short RTU, short Point, short SubObjectId,
	LPSTR buf,int buflen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcGetObjectProperties( DWORD cid ,WORD object_type,
		short Ch,short RTU,short Point,LPSTR buf,int buflen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcGetObjectPropertiesEx(
	DWORD cid ,WORD object_type,short Ch,short RTU,short Point);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcGetRetroFlags(DWORD cid); // return 0xffffffff on failure

#define RETROFLAG_COMMON	1
#define RETROFLAG_ARCHIVE	2
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSetRetroFlags(DWORD cid,DWORD rflags); // return FALSE on failure

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX PBYTE _STDCALL tmcGetNamedObject(DWORD cid,PDWORD paddr,LPSTR name,PDWORD pcb);

//		free result with tmcFreememory
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcEvaluateExpression(DWORD cid,LPSTR expr,LPSTR res,DWORD cbBytes);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcControlCmdResult(DWORD cid,DWORD Id,BOOL fSuccess);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD*	_STDCALL tmcPerspEnum(DWORD cid,PDWORD pCount);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL		_STDCALL tmcPerspDelete(DWORD cid,DWORD ut);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL		_STDCALL tmcPerspPutAnalogs(DWORD cid, DWORD ut, DWORD count, TADRtm* addr,float* pVal);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL		_STDCALL tmcPerspPutValue(DWORD cid, DWORD ut,LPSTR Prop,LPSTR Value);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR		_STDCALL tmcPerspGet(DWORD cid,DWORD ut,PDWORD pLen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX TBaseObjectInfo* _STDCALL tmcEnumBaseObjects(DWORD cid,PDWORD pCount);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR		_STDCALL tmcGetPerformanceData(DWORD cid);
//
//
//***************************************************************

//***************************************************************	OBSOLETE!!
TMC_IMPEX DWORD		_STDCALL tmcGetAnalogsFromQueueFirst(
	DWORD cid,ANALOG_QUEUE_FIND* aqf,TAnalogQueueRecord* records,
	DWORD count,DWORD start_time,DWORD stop_time,
	WORD chn,WORD rtu,WORD point);
//
//
//***************************************************************

//***************************************************************	OBSOLETE!!
TMC_IMPEX DWORD		_STDCALL tmcGetAnalogsFromQueueNext(
	DWORD cid,ANALOG_QUEUE_FIND* aqf,TAnalogQueueRecord* records,
	DWORD count);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short		_STDCALL tmcGetConfigInfo(DWORD cid, TServerConfig *pCfg, DWORD count);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcGetConfig(DWORD cid, PDWORD pConfig);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetConfig(DWORD cid, DWORD Config);
//
//
//***************************************************************

//****************************************************************		IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcGetReserveState(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetValues(DWORD cid,DWORD count,TValueAndFlags* values);
// returns SUCCESS if implemented in server
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetTimedValues(DWORD cid,DWORD count,TTimedValueAndFlags* values);
// returns SUCCESS if implemented in server
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetValuesEx(DWORD cid,DWORD svx_flags,DWORD count,DWORD itemlen,PVOID data);
// returns SUCCESS if implemented in server
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcDeliverMultipleValues(DWORD cid,PVOID data,DWORD cb_data);
// returns SUCCESS if implemented in server
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR* _STDCALL tmcGetStatusClassData(DWORD cid,DWORD count /* max 128*/,TADRtm* statuses);
// return NULL on error
// returned pointer should be freed by tmcFreeMemory()
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR* _STDCALL tmcGetAnalogClassData(DWORD cid,DWORD count /* max 128*/,TADRtm* statuses);
// return NULL on error
// returned pointer should be freed by tmcFreeMemory()
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcControl(DWORD cid, short Ch, short RTU, short Point,
										  short Cmd);
//
//	:         
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//					Cmd -   (0-, 1-)
//
//	:        SUCCESS - 
//					: FAILURE
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  INT _STDCALL  tmcExecuteControlScript(DWORD cid, short Ch, short RTU, short Point,
										  short Cmd);
//
//	:            
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//					Cmd -   (0-, 1-)
//
//	:        1  - ok
//					0  -  
//					-1 -  
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX	BOOL _STDCALL tmcOverrideControlScript(DWORD cid,BOOL fOverride);
//
//
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcControlByStatus(DWORD cid, short Ch, short RTU, short Point,
										  short Cmd);
//
//	:         
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//					Cmd -   (0-, 1-)
//
//	:        SUCCESS - 
//					:
#define TMCTLERR_INVALID_ADDRESS	0
#define TMCTLERR_NO_RESOURCES		-1
#define TMCTLERR_TMSOURCE_FAILED	-2
#define TMCTLERR_WAIT_TIMEOUT		-3
#define TMCTLERR_CANNOT_REDIRECT	-4
#define TMCTLERR_NO_TMSOURCE		-5
#define TMCTLERR_NO_KEYCODE			-6
#define TMCTLERR_WRONG_KEYCODE		-7
#define TMCTLERR_KEYCODE_TIMEOUT	-8
#define TMCTLERR_USER_NAME_UNKNOWN	-9
#define TMCTLERR_ACCESS_DENIED		-10
#define TMCTLERR_NOT_SUPPORTED		-11
#define TMCTLERR_NO_TM_SERVER		-12
#define TMCTLERR_WRONG_KEY			-13
#define TMCTLERR_SCRIPT_ERROR		-14
#define TMCTLERR_EXCEPT				-15
#define	TMCTLERR_BUSY				-16




//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSystemTime(DWORD cid, char *DateTime, struct tm *tm);
//
//	:          
//
//	:      DateTime -     
//                               ".. ::"  NULL
//					tm       -   tm (. TIME.H)  NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************


/*---------------    -----------------------*/

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcStatus(DWORD cid, short Ch, short RTU, short Point);
//
//	:          
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//
//	:        0 - ,  1 - 
//				   -1 - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcStatusFull(DWORD cid, short Ch, short RTU, short Point,
											 TStatusPoint *SP);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					SP             -     
//
//	:        SUCCESS - 
//					FAILURE - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcStatusFullEx(DWORD cid, short Ch, short RTU, short Point,
											TStatusPoint *SP, DWORD Time);
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  float _STDCALL tmcAnalog(DWORD cid, short Ch, short RTU, short Point,
										 const char  *DateTime, short RetroNum);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					DateTime, RetroNum -   
//									       .
//                                       DateTime   
//                                       ".. ::"
//									        ,
//									      DateTime == NULL
//
//	:            huge_flt   
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcAnalogFull(DWORD cid, short Ch, short RTU, short Point,
											 TAnalogPoint *AP,
											 const char *DateTime,
											 short RetroNum);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					AP             -    
//									  AP->asFloat == _huge_flt 
//									      
//									 .   
//									  .
//					DateTime, RetroNum -   
//									       .
//                                       DateTime   
//                                       ".. ::"
//									        ,
//									      DateTime == NULL
//
//	:        SUCCESS - 
//					FAILURE - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  float _STDCALL tmcAccumValue(DWORD cid, short Ch, short RTU, short Point,
											 const char *DateTime);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					DateTime -   
//							     .
//                             DateTime   
//                             ".. ::"
//							      ,
//							    DateTime == NULL
//
//	:            huge_flt  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  float _STDCALL tmcAccumLoad(DWORD cid, short Ch, short RTU, short Point,
											const char *DateTime);
//
//	:           
//
//	:      Ch, RTU, Point - . 
//					DateTime -   
//							     .
//                             DateTime   
//                             ".. ::"
//							      ,
//							    DateTime == NULL
//
//	:           huge_flt  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcAccumFull(DWORD cid, short Ch, short RTU, short Point,
											TAccumPoint *AP,
											const char *DateTime);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					AP       -    
//					DateTime -   
//							     .
//                             DateTime   
//                             ".. ::"
//							      ,
//							    DateTime == NULL
//
//	:        SUCCESS - 
//					FAILURE - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcAccumFullEx(
	DWORD cid,
	short Ch, short RTU, short Point,
	TAccumPoint *AcP,const char *DateTime,short RetroNum);

//***************************************************************

/*---------------    -----------------------*/
//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetStatusNormal(DWORD cid, short Ch, short RTU, short Point,
											WORD NValue);

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcGetStatusNormal(DWORD cid, short Ch, short RTU, short Point,
											PWORD pNValue); // return SUCCESS/FAILURE

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSetNamedObject(DWORD cid,PDWORD paddr,LPSTR name,PBYTE pobj,DWORD cb);

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcEnumNamedObjects(DWORD cid,PDWORD paddr);

//		double zero terminated list
//		free result with tmcFreememory
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcSetAccumValueSeries(DWORD cid,WORD chn,WORD rtu,WORD point,
	float val, DWORD ut,BOOL allow_reformat,LPSTR errs,DWORD cb_errs);

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetStatusUT (DWORD cid, short Ch, short RTU, short Point,
				   char Value,
				   DWORD ut,  BYTE hund,BYTE FlgCmd,BYTE Flags);
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetStatusUT_MS (DWORD cid, short Ch, short RTU, short Point,
				   char Value,
				   DWORD ut,  WORD ms, BYTE FlgCmd,BYTE Flags);
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetStatus(DWORD cid, short Ch, short RTU, short Point,
											char Value,
											const char *DateTime, short Hund);
//
//	:          
//
//	:      Ch    		   - ,
//					RTU            -   ( 1),
//					Point          -   ( 1)
//					Value          -   
//					DateTime       -   
//									   .
//									 : ".. ::."
//									  -   
//									    , 
//									   Time = NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************
TMC_IMPEX  short _STDCALL tmcFillStatusGroup(DWORD cid, short Ch, short RTU, short Point,
												  short Quan, char *SGroup);
//
//	:          
//
//	:      Ch, RTU        - . 
//					Point          -   
//					Quan           -    
//					SGroup         -     ( ,
//									     -  
//									 )
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetStatusFlags(DWORD cid, short Ch, short RTU, short Point,
												 short Flags);
TMC_IMPEX  short _STDCALL tmcClrStatusFlags(DWORD cid, short Ch, short RTU, short Point,
													 short Flags);
//
//	:       /   
//					tmSetStatusFlags - 
//					tmClrStatusFlags - 
//
//	:      Ch, RTU        - . 
//					Point          - N  ( 1),  == 0 
//									    
//									   
//					Flags          -   
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAnalogUT(DWORD cid, short Ch, short RTU, short Point,
											float Value,DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAnalogFloatCodeUT(
	DWORD cid,
	short Ch,
	short RTU,
	short Point,
	float FCode,
	DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAnalog(DWORD cid, short Ch, short RTU, short Point,
											float Value,
											const char *DateTime);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					Value          -    ( )
//					DateTime       -    
//									     ".. ::"
//									    , 
//									   DateTime = NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAnalogByCodeUT(DWORD cid, short Ch, short RTU, short Point,
												  short Value,DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAnalogByCode(DWORD cid, short Ch, short RTU, short Point,
												  short Value);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					Value          -  .  
//									    
//									 (-1 == 0FFFFh)
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcFillAnalogGroup(DWORD cid, short Ch, short RTU, short Point,
											short Quan, short *AGroup);
//
//	:          
//
//	:      Ch, RTU        - . 
//					Point          -   
//					Quan           -    
//					AGroup         -     ()
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAnalogFlags(DWORD cid, short Ch, short RTU, short Point,
												 short Flags);
TMC_IMPEX  short _STDCALL tmcClrAnalogFlags(DWORD cid, short Ch, short RTU, short Point,
												 short Flags);
//
//	:       /   
//					tmcSetAnalogFlags - 
//					tmcClrAnalogFlags - 
//
//	:      Ch, RTU        - . 
//					Point          - N  ( 1),  == 0 
//									    
//									   
//					Flags          -   
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcIncAccumPoints(DWORD cid, short Ch, short RTU, short Point,
												 short DataType, short Quan,
												 void *AGroup);
//
//	:            
//
//	:      Ch, RTU        - . 
//					Point          -   
//                  DataType       -   
//                                    (DataType&0x8000) != 0 
//							 		   - 
//                                    
#define ACCUM_TYPE_EXT_FLOAT (32*1+1)
#define ACCUM_TYPE_EXT_LD	(32*1+2)
//					Quan           -    
//					AGroup         -    
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcDeliverTimedAccum(DWORD cid, DWORD count,TTimedAccum* accums);

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcDeliverTimedAccumEx(DWORD cid, DWORD count,TTimedAccumEx* accums);

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcDeliverAccumData(DWORD cid, DWORD count,TAccumData* accums);


//***************************************************************	IMPLEMENTED
TMC_IMPEX short _STDCALL tmcSetAccumValueUT(DWORD cid, short Ch, short RTU, short Point,
												float Value, DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAccumValue(DWORD cid, short Ch, short RTU, short Point,
												float Value,
												const char *DateTime);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					Value          -    ( )
//					DateTime       -    
//									     ".. ::"
//									    , 
//									   DateTime = NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcSetAccumFlags(DWORD cid, short Ch, short RTU, short Point,
												short Flags);
TMC_IMPEX  short _STDCALL tmcClrAccumFlags(DWORD cid, short Ch, short RTU, short Point,
												short Flags);
//
//	:       /   
//					tmcSetAccumFlags - 
//					tmcClrAccumFlags - 
//
//	:      Ch, RTU        - . 
//					Point          - N  ( 1),  == 0 
//									    
//									   
//					Flags          -   
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************


/*---------------    ---------------------*/

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcRegEvent(DWORD cid, TEvent *tmEvent);
//
//	:          
//
//	:      tmEvent -     
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short  _STDCALL tmcRegEventRaw(DWORD cid, TTMSEvent *tmsEvent);
//
//	:          
//
//	:      tmsEvent -     
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  BOOL _STDCALL tmcEvlogPutStrBin(DWORD cid,
		DWORD unix_time,BYTE unix_hund,
		BYTE importance,DWORD SourceTag,
		LPSTR str,PVOID bin,DWORD cb_bin);
//
//					FALSE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcEventLogUT(DWORD cid, DWORD Start, DWORD End,
				           short EvMask, TTMSEvent *Events,
				           short Cpct, DWORD *Cursor);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short _STDCALL tmcEventLog(DWORD cid,
										   const char *StartTime,
										   const char *EndTime,
										   short EvMask, TEvent *EvLog,
										   short Cpct, DWORD *Cursor);
//
//	:            
//
//	:      StartTime   -   
//					EndTime     -   
//					EvMask      -  ,   
//					EvLog       -     
//								    
//					Cpct        -    
//					Cursor      -    
//								     . 
//								      .
//								     *Cursor   0L
//								        
//								   *Cursor    
//								      
//								       
//
//	:          

//****************************************************************		IMPLEMENTED
TMC_IMPEX TTMSEvent* _STDCALL tmcEventLogByIndex(DWORD cid,DWORD index,DWORD ut,PDWORD pSize);

//****************************************************************		IMPLEMENTED
TMC_IMPEX TEventEx* _STDCALL tmcEventLogEx(DWORD cid,WORD ev_mask,DWORD ux_start,
								  DWORD ux_stop,TEventExCriteria* pCrit);


//****************************************************************		IMPLEMENTED
TMC_IMPEX TEventElix* _STDCALL tmcEventLogByElix(
	DWORD cid,
	TTMSElix* pElix,
	WORD ev_mask,
	DWORD ux_start,
	DWORD ux_stop
);

//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcGetCurrentElix(
	DWORD cid,
	TTMSElix* pElix);

//****************************************************************		IMPLEMENTED

//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSendTaggedData(
	DWORD cid,
	DWORD uid,
	PBYTE p_data,
	DWORD cb_data);

//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcRequestTaggedData(
	DWORD cid,
	DWORD id,
	DWORD inf_type,	//0 -all
	DWORD tma,
	DWORD reserved,
	LPSTR tagname);

//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcReturnTaggedData(
	DWORD			cid,
	TAGGED_DATA_DG*	p_tagd
);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSetTracer(
	DWORD			cid,
	WORD			ch,
	WORD			rtu,
	WORD			pt,
	WORD			tm_type,
	WORD			msgf

);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void _STDCALL tmcTakeRetroTit(DWORD cid, short Ch, short RTU, short Point,
								DWORD utime,WORD RetroNum, WORD count,WORD step,TAnalogPointShort* aps);
//****************************************************************		IMPLEMENTED
TMC_IMPEX TADRtm* _STDCALL tmcTakeAPS(DWORD cid);	// should free result with tmcFreeMemory
//****************************************************************		IMPLEMENTED
TMC_IMPEX void _STDCALL tmcReadRetroTimes(DWORD cid, WORD idx,
								PDWORD* ppdata,	//    . tmcFreeMemory()
								DWORD* pcount,LPSTR pError);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void _STDCALL tmcReadRetroSlice(DWORD cid,WORD idx,DWORD utime,
								 WORD* ptype,
								 PVOID* ppdata, //    . tmcFreeMemory()
								 DWORD* pcount);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short _STDCALL tmcRetroInfo(DWORD cid, TRetroInfo *RetroInfo);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short _STDCALL tmcPeekAlarm(DWORD cid, short Ch, short RTU, short Point,
                  short AlarmID, TAlarm *Alarm);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short _STDCALL tmcPokeAlarm(DWORD cid, short Ch, short RTU, short Point,
                  short AlarmID, TAlarm *Alarm);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short _STDCALL tmcEnumAlarms(DWORD cid, short Ch, short RTU, short Point,
                  TAlarm *Alarm, short MaxQuan, short ActiveOnly);


//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcGetAlarm(
	DWORD		cid,
	short		Ch,
	short		RTU,
	short		Point,
	BYTE		AlarmID,
	TAlarmNew	*Alarm,
	DWORD		cbAlarm,
	LPSTR		*ppStrings
);
// 0     
//pStrings  
//pStrings = "Expr=xxx""Name=xx""P1=xx""P2=xx"

//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmsGetAlarmParams(
	DWORD		cid,
	short		Ch,
	short		RTU,
	short		Point,
	BYTE		AlarmID,
	DWORD		count,
	TAlarmParam* params
 );
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmsSetAlarmParams(
	DWORD		cid,
	short		Ch,
	short		RTU,
	short		Point,
	BYTE		AlarmID,
	DWORD		count,
	float*		pvalues
 );
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDeleteAlarm(
	DWORD		cid,
	short		Ch,
	short		RTU,
	short		Point,
	BYTE		AlarmID
);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcReadAlarmState(
	DWORD		cid,
	short		Ch,
	short		RTU,
	short		Point,
	BYTE		AlarmID,
	TAlarmState	*ast,
	DWORD		cb_ast
);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSetAlarm(
	DWORD		cid,
	TAlarmNew	*Alarm,
	DWORD		cbAlarm,
	LPSTR		pStrings
);
// FALSE  
//****************************************************************		IMPLEMENTED
TMC_IMPEX short _STDCALL tmcDriverCall(DWORD cid, unsigned ADR, short Q_Code, short Command );
//****************************************************************		IMPLEMENTED
TMC_IMPEX void  _STDCALL tmcStatusByList(DWORD cid, short Quan, TADRtm *List, TStatusPoint *SPs);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void _STDCALL tmcStatusByListEx(DWORD cid, short Quan, TADRtm *ADRs, TStatusPoint *SPs,DWORD Time);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void  _STDCALL tmcAnalogByList(DWORD cid, short Quan, TADRtm *List, TAnalogPoint *APs,
                               DWORD Time, short RetroNum);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void  _STDCALL tmcAccumByList (DWORD cid, short Quan, TADRtm *List, TAccumPoint *AcPs,
                               DWORD Time);
//****************************************************************		IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcGetTextualInfo(DWORD cid,WORD info,PBYTE data,DWORD cbdata);
//****************************************************************		IMPLEMENTED
TMC_IMPEX TADRtm* _STDCALL tmcTextSearch(DWORD cid,WORD type,LPSTR txt,PDWORD p_count);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSetDapName(DWORD cid,WORD driver,WORD adapter,WORD port,LPSTR name);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcSpTreeChangeCount(DWORD cid,PDWORD p_chgcnt);

//****************************************************************		IMPLEMENTED

TMC_IMPEX BOOL _STDCALL tmcAanGetStats(	DWORD cid,TM_AAN_STATS* stats, DWORD cb_stats);

TMC_IMPEX TMAAN_MIN_DATA* _STDCALL tmcAanGetValues(
	DWORD			cid,
	DWORD			tma,
	DWORD			ut,
	BYTE			b_ser ,
	PWORD			pcnt,
	LPSTR			p_errs,		//only if fails
	DWORD			cb_errs
);

TMC_IMPEX TMAAN_ARCH_VALUE* _STDCALL tmcAanReadArchive(
	DWORD cid,
	DWORD tma,
	DWORD start_ut,
	DWORD stop_ut,
	DWORD intv,
	DWORD aarf,
	PDWORD p_cnt,
	tmcProgressFn prog_fn,
	PVOID prog_parm
);


TMC_IMPEX BOOL _STDCALL tmcTechObjBeginUpdate(DWORD	cid);

TMC_IMPEX BOOL _STDCALL tmcTechObjEndUpdate(DWORD	cid);

TMC_IMPEX INT	_STDCALL tmcTechObjWriteValues(DWORD	cid,TTechObjProps* objp, DWORD count);	//1-full success, 0 -partial success, -1 -failure

TMC_IMPEX TTechObjProps* _STDCALL tmcTechObjReadValues(
	DWORD cid,
	TTechObj* pobj,
	DWORD count);	// zero on connection error, free result with tmcFreeMemory()

TMC_IMPEX TTechObjProps* _STDCALL tmcTechObjEnumValues(
	DWORD cid,
	DWORD tob_s,			//	0xffffffff if any
	DWORD tob_t,			//	0xffffffff if any
	LPSTR props,			//  "Prop1=aa\0Prop1=bbbb\0Prop2=ccc\0Prop3\0\0"
	PDWORD p_count);		// free result with tmcFreeMemory()

//****************************************************************

TMC_IMPEX DWORD _STDCALL tmcAggrXact(DWORD cid,PVOID p_out,DWORD cb_out,PVOID p_in,DWORD cb_in);

//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD _STDCALL String2Utime(const char *DateTime);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL Utime2Str(DWORD t,char* buffer);

///////////////////////////////////////////////////////////////////////////////////
/////////////	K E Y   F U N C T I O N S
//////////////////////////////////////////////////////////////////////
TMC_IMPEX DWORD  _STDCALL tmcKeyGetTypeFlags(
	DWORD Type
);

#define TMC_KEY_TYPE_VALID		1
#define TMC_KEY_TYPE_WRITABLE	2
#define TMC_KEY_TYPE_DALLAS		4

TMC_IMPEX BOOL _STDCALL tmcKeyReadId(
	DWORD	type,
	DWORD	port,
	PBYTE	key_id			// OUT 8 BYTES
);

TMC_IMPEX BOOL  _STDCALL tmcKeyReadSubkey(
	DWORD	type,
	DWORD	port,
	PBYTE	key_id,			// OUT 8 BYTES
	PBYTE	password,		// IN 8 BYTES
	PBYTE	signature,		// IN 8 BYTES
	BYTE	sub_key_num,	// 0,1,2
	PBYTE	sub_key			// OUT 48 BYTES
);

TMC_IMPEX BOOL  _STDCALL tmcKeyWriteSubkey(
	DWORD	type,
	DWORD	port,
	PBYTE	password,		// IN 8 BYTES
	PBYTE	signature,		// IN 8 BYTES
	BYTE	sub_key_num,	// IN 0,1,2
	PBYTE	sub_key			// IN 48 BYTES
);

TMC_IMPEX BOOL  _STDCALL tmcKeyReadScratchPad(
	DWORD type,
	DWORD port,
	PBYTE key_id,			// OUT 8 BYTES
	PBYTE scratch_pad		// OUT 64 BYTES
);

TMC_IMPEX BOOL  _STDCALL tmcKeyWriteScratchPad(
	DWORD type,
	DWORD port,
	PBYTE scratch_pad		// IN 64 BYTES
);
//////////////////////////////////////////////////////////////////////
/////////////	D E L T A   F U N C T I O N S
//////////////////////////////////////////////////////////////////////
#pragma pack (1)

typedef struct {
	BYTE cmd[2];  //'D','P'
	BYTE prot;
	BYTE res;
	DWORD D;
	DWORD A;
	DWORD P;
	DWORD err;
}DELTA_USER_POST;

typedef struct {
	DWORD ft12_addr;
	DWORD typid;
	DWORD vsc;
	DWORD cot;
	DWORD asdu_addr;
}DELTA_GEN103_PAKHDR;

#pragma pack()
#define DNT_USERBUF_CMD_ATTACH		0
#define DNT_USERBUF_CMD_DETACH		1
#define DNT_USERBUF_ATTACH_GEN103	0x81

//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntGetConfig(DWORD cid,LPSTR fname);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntRegisterUser(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntUnRegisterUser(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntBeginTrace(DWORD cid,DWORD count,PDWORD pmask);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntStopTrace(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcDntTreeChange(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX LPSTR _STDCALL tmcDntGetReserveState(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX LPVOID _STDCALL tmcDntOpenItem(DWORD cid,DWORD count,PDWORD pmask);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DeltaCommon* _STDCALL tmcDntGetNextItem(LPVOID itid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX VOID  _STDCALL tmcDntCloseItem(LPVOID itid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntBeginDebug(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntStopDebug(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntTeleControl(DWORD cid,DWORD count,PDWORD pmask,DWORD idx,DWORD cmd);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntReqValue(DWORD cid,DWORD count,PDWORD pmask,DWORD idx);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntWriteValue(DWORD cid,DWORD count,PDWORD pmask,DWORD idx,LPSTR value);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntPassPortBuffer(DWORD cid,DWORD masklen,PDWORD pmask,PBYTE pData,DWORD cbData);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntGetObjectName( DWORD cid ,WORD object_type,
		short Ch,short RTU,short Point,LPSTR buf,int buflen);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntSetPortCapture(DWORD cid,BYTE driver,BYTE adapter,BYTE port);
//****************************************************************		IMPLEMENTED
TMC_IMPEX INT _STDCALL tmcDntGetPortCapture(DWORD cid,BYTE driver,BYTE adapter,BYTE port);
// returns 0 if not captured, 1 if captured by us, -1 if not by us or on error
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntReleasePortCapture(DWORD cid,BYTE driver,BYTE adapter,BYTE port);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD _STDCALL tmcDntGetLiveInfo(DWORD cid,DWORD count,PDWORD pmask,PVOID p_data,DWORD cb_data);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL _STDCALL tmcDntSendPortPacket(
	DWORD cid,
	BYTE driver,
	BYTE adapter,
	BYTE port,
	BYTE proto,
	BYTE timeout,
	PBYTE pPacket,
	DWORD cbPacket
);
//****************************************************************		


//////////////////////////////////////////////////////////////////

TMC_IMPEX DWORD	_STDCALL tcapConnectDelta(LPSTR machine,LPSTR pipe,tcapRecvFunc rcv, LPSTR* perr);
TMC_IMPEX VOID	_STDCALL tcapDisconnectDelta(DWORD cid);
TMC_IMPEX LPSTR	_STDCALL tcapAttachNode(DWORD cid,DWORD masklen,PDWORD pmask,BYTE prot);
TMC_IMPEX LPSTR	_STDCALL tcapAttachNodeEx(DWORD cid,DWORD masklen,PDWORD pmask,BYTE prot,BYTE kind);
TMC_IMPEX LPSTR	_STDCALL tcapDetachNode(DWORD cid,DWORD masklen,PDWORD pmask,BYTE prot);
TMC_IMPEX LPSTR	_STDCALL tcapSendPacket(DWORD cid,PBYTE pData,DWORD cbData,DWORD masklen,PDWORD pmask,BYTE prot);
TMC_IMPEX VOID	_STDCALL tcapFreeMemory(PVOID p);



//////////////////////////////////////////////////////////////////
///////////////////// RBASE CONSTANTS AND FUNCTIONS

/*------------------    -----------------------*/
#define GL_OK         0
#define GL_BLOK       1
#define GL_ERROR_DISK 2
#define GL_ERROR_LINE 3
#define GL_FAULT      4

/*---------------     ------------------*/
#define rbSYSTEM_DATE        1
#define rbINIT_BASE          9
#define rbUNBLOK_BASE       12

#define rbDELETE_STR        30
#define rbCALC_TABLE        40
#define rbADD_STR           50
#define rbREAD_STR          60
#define rbRESET_TABLE       70
#define rbUNBLOK_TABLE      80
#define rbFIND_STR          90

#define rbWRITE_STR        100
#define rbCALC_WHERE       101
#define rbDEL_WHERE        102
#define rbADD_PLUS         103
#define rbADD_MINUS        104
#define rbTEST_WHERE       105

#define rbTEST_TABLE       130
#define rbSET_WHERE        140
#define rbFIND_MIN_MAX     150
#define rbFIND_COL         170
#define rbWRITE_COL        180
#define rbDELETE_ALL       190

#define rbADD_GR_STR       200
#define rbREAD_COL         210
#define rbREAD_ADR_COL     220
#define rbREAD_ADR_STR     230
#define rbTABLE_INFO       250
#define rbSET_BLOK_TABLE   260
#define rbGET_USURPER_NAME 270

#define TEST              1000

#define STRUCT_GLOBAS   unsigned RecAdr

#define MAXBASE 16
#define MAX_BASES MAXBASE
#define MAXTAB  30

/*----------------------   ------------------------*/
#define GBLOK     0x1000    //   
#define GUNBLOK   0x1000
#define ADD_MAX   0x1000    //  FindMinMax -  
#define ADD_MIN   0x2000    //  FindMinMax -  
#define REVERSE   0x4000    //    

/*-------------------   -----------------------*/
#define _LIKE_     1        //  
#define _LE_       2        //   
#define _LT_       3        // 
#define _GE_       4        //   
#define _GT_       5        // 
#define _EQ_       6        // 
#define _BETWEEN_  8        //  
#define _NULL_     7        //  

TMC_IMPEX int	_CDECL rbcOpenBases		(DWORD cid,char *BaseName, ...);
TMC_IMPEX void	_CDECL rbcCloseBases	(DWORD cid);
TMC_IMPEX int	_CDECL rbcOpenTable		(DWORD cid, char *Base, char *Table);
TMC_IMPEX int	_CDECL rbcRecSize		(DWORD cid, int hTable );
TMC_IMPEX int	_CDECL rbcColSize		(DWORD cid, int hTable, int Column);
TMC_IMPEX int	_CDECL rbcResetTable	(DWORD cid, int hTable);
TMC_IMPEX int	_CDECL rbcReadStr		(DWORD cid, int hTable, int RecCount, void *Record);
TMC_IMPEX int	_CDECL rbcReadCol		(DWORD cid, int hTable, int RecCount, void *Record, int Column1, ...);
TMC_IMPEX int	_CDECL rbcReadAdrStr	(DWORD cid, int hTable, int RecAdr, void *Record);
TMC_IMPEX int	_CDECL rbcReadAdrCol	(DWORD cid, int hTable, unsigned RecAdr, void *Record, int Column1, ...);
TMC_IMPEX int	_CDECL rbcSetWhere		(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int	_CDECL rbcTestWhere		(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int	_CDECL rbcCalcWhere		(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int	_CDECL rbcFindStr		(DWORD cid, int hTable, int RecCount, void *Record);
TMC_IMPEX int	_CDECL rbcFindCol		(DWORD cid, int hTable, int RecCount, void *Record, int Column1, ...);
TMC_IMPEX int	_CDECL rbcFindMinMax	(DWORD cid,int hTable, int Column, int *MinVal, int *MaxVal);
TMC_IMPEX int	_CDECL rbcCalcTable		(DWORD cid,int hTable);
TMC_IMPEX int	_CDECL rbcTestTable		(DWORD cid,int hTable);
TMC_IMPEX int	_CDECL rbcWriteStr		(DWORD cid,int hTable, void *Record);
TMC_IMPEX int	_CDECL rbcWriteCol		(DWORD cid,int hTable, void *Record, int Column1, ...);
TMC_IMPEX int	_CDECL rbcAddStr		(DWORD cid,int hTable, void *Record);
TMC_IMPEX int	_CDECL rbcAddStrEx		(DWORD cid,int hTable, int RecCount, void *Records);
TMC_IMPEX int	_CDECL rbcAddStrInc		(DWORD cid, int hTable, int Column, void *Record);
TMC_IMPEX int	_CDECL rbcAddStrDec		(DWORD cid,int hTable, int Column, void *Record);
TMC_IMPEX int	_CDECL rbcDeleteStr		(DWORD cid,int hTable, void *Record);
TMC_IMPEX int	_CDECL rbcDeleteAll		(DWORD cid,int hTable);
TMC_IMPEX int	_CDECL rbcDeleteWhere	(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int	_CDECL rbcLockStr		(DWORD cid, int hTable, unsigned RecNum);
TMC_IMPEX int	_CDECL rbcGetUsurperName	(DWORD cid, int hBase, unsigned RecNum,LPSTR pName,DWORD cbName);

TMC_IMPEX int	_CDECL rbcUnlockStr		(DWORD cid, int hTable, unsigned RecNum);
TMC_IMPEX int	_CDECL rbcUnlockBases	(DWORD cid);
TMC_IMPEX unsigned _CDECL rbcRecCount	(DWORD cid,int hTable);
TMC_IMPEX int	_CDECL rbcGetSecurity	(DWORD cid,PBOOL pAdmin,PDWORD pAccessMask);
TMC_IMPEX int	_CDECL rbcGetUserId		(DWORD cid,PCHAR UserId /* max 16 */,PCHAR UserPwd /*max 32*/);
TMC_IMPEX int	_CDECL rbcReadUserId	(DWORD cid,DWORD index,PBOOL pDone,PBYTE UserSid /*max 128*/,
											PCHAR UserId /* max 16 */,PCHAR UserPwd /*max 32*/);
TMC_IMPEX int	_CDECL rbcWriteUserId	(DWORD cid,DWORD index,PBYTE UserSid /*max 128*/,
											PCHAR UserId /* max 16 */,PCHAR UserPwd /*max 32*/);
TMC_IMPEX LPSTR _CDECL rbcWsEnumDomains	(DWORD cid);
TMC_IMPEX LPSTR _CDECL rbcWsEnumDomainUsers(DWORD cid,LPSTR domain);
TMC_IMPEX PVOID _CDECL rbcWsGetUserSid	(DWORD cid,LPSTR domain,LPSTR user);
TMC_IMPEX BOOL	_CDECL rbcWsGetUserName	(DWORD cid,PVOID pSid,LPSTR domain /*max=128*/,LPSTR user/*max=128*/);
TMC_IMPEX LPSTR _STDCALL rbcGetReserveState(DWORD cid);

TMC_IMPEX BOOL _CDECL rbcBackupServerProcedure(
	LPSTR machine,
	LPSTR pipe,
	LPSTR directory,
	PDWORD pbflags,
	HANDLE hCancel,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);

///////////////////////// INTERNAL
TMC_IMPEX DWORD _STDCALL tmcGetCurrentXaction(DWORD cid);

#ifdef __cplusplus
}
#endif

#endif //_TMCONN_H
