unit tmconn;
interface
uses
    Sysutils,Windows, tma_defs;
const
    ERROR_TM_NOT_CONNECTED: Dword = $c0001;


    RETRO_STATUS_ELEMENT = $3153;
    RETRO_ANALOG_ELEMENT = $314e;
    RETRO_ACCUM_ELEMENT  = $3143;

    RETROFLAG_COMMON	=       1;
    RETROFLAG_ARCHIVE	=       2;




    TM_S_UNK:            string = '<?>';
    TM_S_ERR:            string = '<ERR>';
    DELTA_ITEM_DESCRIPTION =           0;
    DELTA_ITEM_TIME =                  1;
    DELTA_ITEM_STATUS =                2;
    DELTA_ITEM_ANALOG =                3;
    DELTA_ITEM_ACCUM =                 4;
    DELTA_ITEM_CONTROL =               5;
    DELTA_ITEM_ANALOGF =               6;
    DELTA_ITEM_ACCUMF =                7;
    DELTA_ITEM_STRVAL =                8;

    DELTA_ITEMF_RELIABLE =             1;
    DELTA_ITEMF_ZEROENUM =             2;
    DELTA_ITEMF_DESTRELI =             4;
    DELTA_ITEMF_DESTVAL =              8;
    DELTA_ITEMF_HEX =                  $10;
    DELTA_ITEMF_GROUP8 =               $20;
    DELTA_ITEMF_N_PRSNT =              $40;
    DELTA_ITEMF_WRITABLE =             $100;
    DELTA_ITEMF_S2_BREAK =	       $400;
    DELTA_ITEMF_S2_MALFN =	       $800;
    DELTA_ITEMF_ANALONG =              $1000;



    DNT_TRACE_ERROR =    	       0;
    DNT_TRACE_MSG =		       1;
    DNT_TRACE_DEBUG =		       2;
    DNT_TRACE_TM_IN =		       3;
    DNT_TRACE_TM_OUT =	               4;
    DNT_TRACE_S_IN =		       5;
    DNT_TRACE_S_OUT =		       6;

    TMS_TR_ERROR =		       $0001;
    TMS_TR_MSG =                       $0002;
    TMS_TR_DEBUG =                     $0004;
    TMS_TR_TM_IN =                     $0008;
    TMS_TR_TM_OUT =                    $0010;


    DNT_NODE_DRIVER =		       0;
    DNT_NODE_ADAPTER =	               1;
    DNT_NODE_PORT =		       2;
    DNT_NODE_RTU =		       3;
    DNT_NODE_ARRAY =		       4;
    DNT_NODE_BLOCK =		       5;
    DNT_NODE_INFO =		       7;

    TMS_ACCESS_TM_READ		       = $00000001;
    TMS_ACCESS_STATUS_CHANGE	       = $00000002;
    TMS_ACCESS_ANALOG_CHANGE	       = $00000004;
    TMS_ACCESS_ACCUM_CHANGE	       = $00000008;
    TMS_ACCESS_TELECONTROL	       = $00000010;
    TMS_ACCESS_RETRO_VIEW	       = $00000020;
    TMS_ACCESS_LOG_VIEW		       = $00000040;
    TMS_ACCESS_ALARM_CHANGE	       = $00000080;
    TMS_ACCESS_TM_SOURCE	       = $00000100;
    TMS_ACCESS_TMSRC_DIALOG	       = $00000200;

    TMC_KEY_TYPE_VALID	       =	   1;
    TMC_KEY_TYPE_WRITABLE      =           2;
    TMC_KEY_TYPE_DALLAS	       =	   4;

    SIPF_UNIQ_USERS_COUNT	       = 1;
    SIPF_TM_VALUE_COUNT		       = 2;
    SIPF_RB_FILL		       = 4;
    SIPF_RB_MAX_FILL		       = 8;
    SIPF_TM_TOTVALCNT		       = $10;
    SIPF_R_ASYNCB                      = $20;
    SIPF_EXT_VAL_CNT		       = $40;


    MAP_COMMAND_SUPPORTED		=0;
    MAP_COMMAND_ACKNOWLEDGE		=1;
    MAP_COMMAND_SET_BRIGHTNESS	        =2;
    MAP_COMMAND_ON_MODE			=3;
    MAP_COMMAND_OFF_MODE		=4;
    MAP_COMMAND_NORMAL_MODE		=5;
    MAP_COMMAND_DARK_MODE               =8;
    MAP_COMMAND_STNORM_MODE		=9;
    MAP_COMMAND_IND_ADDRESS             =10;

    TMS_BACKUP_CONFIG                   =1;
    TMS_BACKUP_ARRAY                    =2;
    TMS_BACKUP_EVLOG                    =4;
    TMS_BACKUP_ALARMS                   =8;
    TMS_BACKUP_RETRO                    =$10;
    TMS_BACKUP_SECURITY                 =$20;

    _TMSVX_TIMED                        =1;
    _TMSVX_S2                           =2;

    
    RBS_BACKUP_BASES	                =1;
    RBS_BACKUP_SECURITY                 =2;

    DNT_TRACE_FLAGS_DRV		        =1;
    DNT_TRACE_FLAGS_USR		        =2;


    _LIKE_:        Word = 1;
    _LE_:          Word = 2;
    _LT_:          Word = 3;
    _GE_:          Word = 4;
    _GT_:          Word = 5;
    _EQ_:          Word = 6;
    _BETWEEN_:     Word = 8;
    _NULL_:        Word = 9;

     TMDRV_STATE_OK			 =0;
     TMDRV_STATE_NO_DIAGS		 =1;
     TMDRV_STATE_ERROR			 =2;
     TMDRV_STATE_NOT_FOUND		 =3;
     TMDRV_STATE_NOT_SUPPORTED		 =4;
     TMDRV_STATE_UNKNOWN		 =5;

     NO_TRACE                            =$ffffffff;
     TRACE_SENT                          =$fffffffe;

     CPRT_FIRM			=0;
     CPRT_C_FIRM		=1;
     CPRT_CPRT			=2;
     CPRT_FIRM_E		=3;
     CPRT_MAIN_SWNAME	        =4;
     CPRT_PHONE_FAX		=5;

     CPRT_NATIVE		=1000;
     TMS_CAPS_SEQST		=0;
     TMS_CAPS_ALRNEW		=1;
     TMS_CAPS_COMTRADE          =2;
     TMS_CAPS_EVLARCH           =3;

     CFSSELD_DRIVE_UNKNOWN	=$01;
     CFSSELD_DRIVE_UNFORM	=$02;
     CFSSELD_DRIVE_REMOVABLE	=$04;
     CFSSELD_DRIVE_FIXED	=$08;
     CFSSELD_DRIVE_NETWORK	=$10;
     CFSSELD_DRIVE_CDROM	=$20;
     CFSSELD_DRIVE_RAM		=$40;

     AANSR_LAST	                =$ffff;

     AAMDF_OVF                  =1;
     AAMDF_CALC			=2;
     AAMDF_SER			=4;


     AAMDL_NO_DATA		=$00;
     AAMDL_OK			=$01;
     AAMDL_NOT_WR		=$ff;

     AAV_MOM			=$00;
     AAV_AVG                    =$01;
     AAV_MIN                    =$02;
     AAV_MAX			=$03;

     AAVR_MOM                   =(1 shl AAV_MOM);
     AAVR_AVG			=(1 shl AAV_AVG);
     AAVR_MIN			=(1 shl AAV_MIN);
     AAVR_MAX			=(1 shl AAV_MAX);

     AAVF_OVF			=1;




{$ALIGN OFF}
type
    TUnitedAddr = record
        Point: Word;
        RTU:   Byte;
        Ch:    Byte;
    end;

    TAnalogPointShort = record
        Value:   Single;
        Flags:   Word;
    end;

    TAnalogQueueRecord = record
	    fix_time:   Dword;
	    tm_time:    Dword;
	    chn:        Word;
	    rtu:        Word;
	    point:      Word;
	    asCode:     Word;
	    asFloat:    Single;
	    flags:      Word;
    end;

   ANALOG_QUEUE_FIND = record
       Storage: array [0..255] of char;
   end;
   TBaseObjectInfo = record
	level:  Word;
	a: array[0..3] of Word;
	name: PChar;
   end;

   TRetroStatusElement = record
        Flags: Word;
        Status:Word;
   end;

   TRetroAnalogElement = record
        Flags: Word;
        asFloat:Single;
        asCode:SmallInt;
   end;

    TRetroAccumElement = record
        Flags: Word;
        Value: Single;
        Load:  Single;
    end;

    TTelemetrySource =record
            Id:      Dword;
            Name:    array[0..63] of Char;
    end;

    TServerInfo = record
	Description:    array[0..63] of Char;
	dwType:         Dword;
	dwHeapUsage:    Dword;
    	dwWSMin:        Dword;
	dwWSMax:        Dword;

	HandleCount:    Dword;
	StartTime:      Dword;
        ConfChangeTime: Dword;
	ThreadCount:    Dword;

        UserCount:      Dword;
	LogonCount:     Dword;

        PresenceFlags:  Dword;
        UniqUserCount:  Dword;
        TmValueCount:   Dword;
	ReserveBufFill: DWORD;
	ReserveBufMaxFill:DWORD;

        TmTotalValCnt:  Dword;
        ReserveSentAsyncBytes:  DWORD;
        TmExtValueCnt:  Dword;
        DtmxLastCommit: Dword;
	DtmxBufFill:    Dword;
        AnRW:           Dword;
	reserverd:      array [0..75] of BYTE;
    end;

    TTMSUserInfo = record
	valid:                  LongBool;

	UserName:               array[0..15] of CHAR;
	UserComment:            array[0..63] of CHAR;
        NtUserName:             array[0..31] of CHAR;
        NtUserDomain:           array[0..31] of CHAR;

	DatagramMask:           Dword;
        AccessMask:             Dword;
        ConnectTime:            Dword;

	reserved:               array[0..95] of BYTE;

    end;

    TPreRestoreServer = record
            dwFreeSpace: Dword;
            dwErr:       Dword;
            reserved:    array [0..13] of Dword;
	    ErrorString: array [0..511] of Char;
    end;

    DeltaStatus = record
    	item_type:      Byte;
	    length:         Byte;
	    number:         Word;
	    lastUpdate:     Integer;
	    flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;
    	value:          Byte;
    end;
    DeltaAnalog = record
    	item_type:      Byte;
	    length:         Byte;
	    number:         Word;
	    lastUpdate:     Integer;
	    flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;
    	value:          Integer;
    end;

    DeltaAnalogF = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	value:          Single;
    end;
    DeltaAccum = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	value:          Integer;
    end;
    DeltaAccumF = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	value:          Single;
    end;
    DeltaControl = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;
	ctrlBlock:      Word;
	ctrlGroup:      Word;
	ctrlPoint:      Word;
    end;

    DeltaTime = record
	item_type:      Byte;
	length:         Byte;
        curtime:        Integer;
    end;
    DeltaDescription = record
	item_type:      Byte;
	length:         Byte;
	text:           Char;
    end;

    DeltaStrVal = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	s:              Char;
    end;


    TCprtText = function(id:Dword):PChar; cdecl;
    TCallBackEvent = procedure(count:Dword;buf:PByte;param:Pointer); stdcall;
    TTcCallback = function(cid:Dword;Param:Pointer;estr:PChar):Integer; stdcall;
    TTmcProgressEvent = procedure(count:Dword;errs:PChar;param:Pointer); stdcall;
    TEventExCriteria = record
    	ItemsLimit:     Dword;
    	MemoryLimit:    Dword;
    	hStop:          Dword; //handle
      Interrupted:    LongBool;
        EvlArch:        LongBool;
    end;
    TCfsInitData = record
	signature:      DWORD; // (DWORD)'CFSH'
	version:        DWORD;
        reserved:    array [0..31] of DWORD;
    end;

    TDGTaggedData = record
	sig:                    array [0..1] of Char;	//'T','D'
	id:                     Dword;
	delta_addr:             array [0..15] of Dword;
	value_idx:              Dword;
	name:                   array [0..295] of Char;
	value:                  array [0..127] of Char;
    end;

    TAanSrData = record
        ms:                     Word;
	value:                  Single;
	tmflg:                  Dword;
    end;

    pAanSrData  = ^TAanSrData;


    TAanMinData = record
	legend:                 Byte;
	mdflg:                  Byte;
        v_min:                  Single;
	v_max:                  Single;
	v_last:                 Single;
	v_avg:                  Word;
	v_tmflg:                Dword;
	series:                 pAanSrData;
    end;

    pAanMinData  = ^TAanMinData;

    TAanStats = record
	ok:                     Dword;
	last_mc_ms:             Dword;
	last_hc_ms:             Dword;
	last_dc_ms:             Dword;
	megabytes:              Dword;
    end;

    pAanStats  = ^TAanStats;

    TAanArchValue = record
        tag:                    Byte;
        aav_flg:                Byte;
	ut:                     Dword;
	ms:                     Word;
        tm_flg:                 Dword;
	value:                  Single;
    end;				//16 bytes

    TTechObj = record
	tob_flg:                Byte;
	scheme:                 Dword;
	tob_type:               Word;
	tob_object:             Dword;
    end;

    TTechObjProps = record
	tob_flg:                Byte;
	scheme:                 Dword;
	tob_type:               Word;
	tob_object:             Dword;
	props:                  PChar;
    end;




{$ALIGN ON}

    pAanArchValue= ^TAanArchValue;
    pUnitedAddr  = ^TUnitedAddr;
    pServerInfo  = ^TServerInfo;
    pAPShort     = ^TAnalogPointShort;
    pAQRecord    = ^TAnalogQueueRecord;
    pRetroStatusElement = ^TRetroStatusElement;
    pRetroAnalogElement = ^TRetroAnalogElement;
    pRetroAccumElement = ^TRetroAccumElement;
    pBaseObjectInfo = ^TBaseObjectInfo;
    pEventExCriteria = ^TEventExCriteria;
    pCfsInitData = ^TCfsInitData;
    pDGTaggedData =^TDGTaggedData;
    pTMSUserInfo =^TTMSUserInfo;
    pTechObjProps = ^TTechObjProps;
    pTechObj = ^TTechObj;
var
    hf_l:     LongInt = $7f7fffff;
    huge_flt: Single absolute hf_l;
    _cprtText: TCprtText;
    fGotCprtText:Boolean;


function cprtText(id:DWORD ):PChar;

function cfsInitApp:pCfsInitData;
          stdcall; external 'cfshare.dll' name 'cfsInitApp'

function cfsIfLang:DWord;
          stdcall; external 'cfshare.dll' name 'cfsIfLang'

procedure cfsSetUser(name,pwd:PChar);
          stdcall; external 'cfshare.dll' name 'cfsSetUser'
procedure cfsGetUser(name:PChar;namelen:DWORD;pwd:PChar; pwdlen:DWORD);
          stdcall; external 'cfshare.dll' name 'cfsGetUser'

function  cfsAllocMemory(bytes:DWORD ):Pointer;
          stdcall; external 'cfshare.dll' name 'cfsAllocMemory'
procedure cfsFreeMemory(p:Pointer);
          stdcall; external 'cfshare.dll' name 'cfsFreeMemory'
function  cfsEnumDomains:PChar;	// should be freed
          stdcall; external 'cfshare.dll' name 'cfsEnumDomains'
function  cfsGetUserSid(Domain:PChar;User:PChar):Pointer; // should be freed
          stdcall; external 'cfshare.dll' name 'cfsGetUserSid'
function  cfsGetUserNameFromSid(Sid:Pointer;Domain:Pchar):Pchar; // should be freed
          stdcall; external 'cfshare.dll' name 'cfsGetUserNameFromSid'
function  cfsPrintUserSid(Sid:Pointer):Pchar;	// should be freed
          stdcall; external 'cfshare.dll' name 'cfsPrintUserSid'
function  cfsEnumDomainUsers(Domain:PChar):PChar;	// should be freed
          stdcall; external 'cfshare.dll' name 'cfsEnumDomainUsers'
function  pkfEnumPackedFiles(Pkfname:PChar;Errs:PChar;Errlen:Dword):Pchar; //should be freed
          stdcall; external 'cfshare.dll' name 'pkfEnumPackedFiles'

function  cfsGetBasePath(connid:DWORD;path:PChar;cbPath:DWORD;
          var err:DWORD;errs:PChar;maxerrs:DWORD):LongBool;
          stdcall; external 'cfshare.dll' name 'cfsGetBasePath'

function  cfsSelectDirectory(hParent:HWND; flags:Dword; dir,caption,explanation:Pchar):LongBool;
          stdcall; external 'cfshare.dll' name 'cfsSelectDirectory'


procedure ndD(b:PByte;cnt:Dword;k:PByte);
          cdecl; external 'cfshare.dll' name 'ndD'

function  parse_uxtime(ut:DWORD; var Year:Integer; var Month:Integer; var Day:Integer; var Hour:Integer; var Minute:Integer; var Second:Integer):LongBool;
          cdecl; external 'cfshare.dll' name 'parse_uxtime'
function  mk_uxtime(Year,Month,Day,Hour,Minute,Second:Integer):DWORD;
          cdecl; external 'cfshare.dll' name 'mk_uxtime'
function  uxtime():DWORD;
          cdecl; external 'cfshare.dll' name 'uxtime'
function  uxtime_h(var Hund:BYTE):DWORD;
          cdecl; external 'cfshare.dll' name 'uxtime_h'

function MemComp (p1,p2:Pointer;len:Longint):Integer;

function  GetFlagName(connid:DWORD;tm_type:WORD;flag:DWORD;var name:string):Boolean;

function  GetImportanceName(connid:DWORD; Imp:Integer; var name:String):Boolean;

function GetTmTypeName(tmType:WORD):string;

procedure ConditionUTStr(c:Pchar);

function GetServerCaps(cid,cap:Dword):LongBool;

function UtimeToString(ut:DWord):string;

function L_S_PC(e,r:PChar):PChar;

function Attention:PChar;

function tmcGetConfigType(cid:Dword):Dword;
         stdcall; external 'tmconn.dll' name '_tmcGetConfigType@4'

function String2Utime( s:PChar ):Dword;
         stdcall; external 'tmconn.dll' name '_String2Utime@4'

procedure PrintFloat( var pf:single; buf:PChar;cb_buf:Dword);
         stdcall; external 'tmconn.dll' name '_PrintFloat@12'

procedure Utime2Str(t:Dword; s:PChar );
        stdcall; external 'tmconn.dll' name '_Utime2Str@8'

procedure Utime2StrMs(ut:DWord; ms:Word; s:PChar);

function tmcGetLastError:Dword;
         stdcall; external 'tmconn.dll' name '_tmcGetLastError@0'

function tmcGetLastErrorText(cid:Dword; var ptext:PChar):LongInt;
         stdcall; external 'tmconn.dll' name '_tmcGetLastErrorText@8'

function tmcConnect(ServerName,PipeName,UserName:PAnsiChar;
                    cback:TCallBackEvent;cback_param:Pointer):Dword;
         stdcall; external 'tmconn.dll' name '_tmcConnect@20'

function tmcGetServerCaps(cid:DWord;pCaps:PByte):Dword;
         stdcall; external 'tmconn.dll' name '_tmcGetServerCaps@8'

procedure tmcSetTelecontrolCallback( cid:Dword ;tccb:TTcCallback; Param:Pointer);
         stdcall; external 'tmconn.dll' name '_tmcSetTelecontrolCallback@12'

procedure tmcDisconnect( cid:Dword );
         stdcall; external 'tmconn.dll' name '_tmcDisconnect@4'

function tmcConnState( cid:Dword ):DWord;
         stdcall; external 'tmconn.dll' name '_tmcConnState@4'

function tmcGetCfsHandle( cid:Dword ):DWord;
         stdcall; external 'tmconn.dll' name '_tmcGetCfsHandle@4'

function tmcGetConfigPath( cid:Dword; path:Pchar; cb_path:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcGetConfigPath@12'

function tmcGetCurrentServer(cid:Dword;machine:Pchar;cbMachine:Dword;pipe:Pchar;cbPipe:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcGetCurrentServer@20'

function tmcGetUrgentMessage(cid:DWORD):PChar;
        stdcall; external 'tmconn.dll' name '_tmcGetUrgentMessage@4'
        
function tmcGetGrantedAccess(cid:Dword; var Access:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcGetGrantedAccess@8'

function tmcEnumObjects(cid:Dword; ObjType:Word; Count:Byte;
                     Buf:Pointer; Ch, RTU, Point: SmallInt):Byte;
         stdcall; external 'tmconn.dll' name '_tmcEnumObjects@28'

function tmcGetObjectName(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt; Buf:Pchar; cbBuf:LongInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectName@28'

function tmcGetObjectProperties(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt; Buf:Pchar; cbBuf:LongInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectProperties@28'

function tmcGetObjectPropertiesEx(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt ):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectPropertiesEx@20'

function tmcEnumBaseObjects(cid:DWORD;var Count:DWORD):PBaseObjectInfo;
         stdcall; external 'tmconn.dll' name '_tmcEnumBaseObjects@8'

function tmcGetAnalogsFromQueueFirst(
           cid:Dword; var aqf:ANALOG_QUEUE_FIND;
           var records:TAnalogQueueRecord;
           count,start_time,stop_time:Dword;
	        chn,rtu,point:WORD):Dword;
         stdcall ; external 'tmconn.dll' name '_tmcGetAnalogsFromQueueFirst@36'

function tmcGetAnalogsFromQueueNext(
           cid:Dword; var aqf:ANALOG_QUEUE_FIND;
           var records:TAnalogQueueRecord;
           count:Dword):Dword;
         stdcall ; external 'tmconn.dll' name '_tmcGetAnalogsFromQueueNext@16'

function tmcEvaluateExpression(cid:Dword;expr,res:PChar;cbBytes:Dword):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcEvaluateExpression@16'

function tmcGetServerInfo(cid:Dword; var info:TServerInfo):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetServerInfo@8'

function tmcGetServerThreads(cid:Dword):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetServerThreads@4'

function tmcBackupServerProcedure( machine,pipe,directory:PChar;
        var bflags:DWORD;hCancel:DWORD;
        prog_fn:TTmcProgressEvent;prog_parm:Pointer):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcBackupServerProcedure@28'

function tmcRestoreServer(tms_not_rbs:LongBool;machine,pipe,filename:PChar;
	var bflags:DWORD;hCancel:DWORD;
	prog_fn:TTmcProgressEvent;prog_parm:Pointer):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcRestoreServer@32'
procedure tmcPreRestoreServer(tms_not_rbs:LongBool;
        machine,pipe,filename:PChar;var prs:TPreRestoreServer);
         stdcall; external 'tmconn.dll' name '_tmcPreRestoreServer@20'


procedure tmcGetTmSource(cid:Dword; ObjectType:WORD; Ch, RTU, Point: SmallInt; var src:TTelemetrySource);
         stdcall; external 'tmconn.dll' name '_tmcGetTmSource@24'

function tmcRetroInfoEx(cid:Dword; idx:Word;var rinfo:TRetroInfoEX):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcRetroInfoEx@12'

function tmcSystemTime( cid:Dword; DateTime:PAnsiChar; Dummy: LongInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSystemTime@12'

function tmcRetroInfo( cid:Dword; var RetroInfo: TRetroInfo): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcRetroInfo@8'

function tmcStatus( cid:Dword; Ch, RTU, Point: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcStatus@16'

function tmcStatusFull(cid:Dword; Ch, RTU, Point: SmallInt; SP: pSP):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcStatusFull@20'

function tmcStatusFullEx(cid:Dword; Ch, RTU, Point: SmallInt; SP: pSP; Time:DWORD):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcStatusFullEx@24'

function tmcAnalog( cid:Dword; Ch, RTU, Point: SmallInt;
                  Time: PChar; RetroNum: SmallInt): Single;
         stdcall; external 'tmconn.dll' name '_tmcAnalog@24'

function tmcAnalogFull( cid:Dword; Ch, RTU, Point: SmallInt; AP: pAP;
                  Time: PChar; RetroNum: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcAnalogFull@28'

function tmcAccumValue( cid:Dword; Ch, RTU, Point: SmallInt;
                  Time: PChar): Single;
         stdcall; external 'tmconn.dll' name '_tmcAccumValue@20'

function tmcAccumLoad( cid:Dword; Ch, RTU, Point: SmallInt;
                  Time: PChar): Single;
         stdcall; external 'tmconn.dll' name '_tmcAccumLoad@20'

function tmcAccumFull( cid:Dword; Ch, RTU, Point: SmallInt; AcP: pAcP;
                  Time: PChar):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcAccumFull@24'

function tmcAccumFullEx( cid:Dword; Ch, RTU, Point: SmallInt; AcP: pAcP;
                  Time: PChar; RetroNum:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcAccumFullEx@28'

function tmcEventLog( cid:Dword; StartTime, EndTime: PChar;
                     EvMask: Word; EvLog: pEV;
                     Cpct:Word; var Cursor: LongInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcEventLog@28'

function tmcEventLogEx(cid:Dword; EvMask:Word;
         UTStart,UTStop:Dword;var Criteria: TEventExCriteria):pEventEx;
         stdcall; external 'tmconn.dll' name '_tmcEventLogEx@20'

function tmcEventLogByElix(cid:DWord; var elix:TElix; EvMask:Word;
        UTStart,UTStop:Dword):pEventElix;
        stdcall; external 'tmconn.dll' name '_tmcEventLogByElix@20'

function tmcGetCurrentElix(cid:DWord; var elix:TElix):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcGetCurrentElix@8'

function tmcRequestTaggedData( cid:DWORD; id, inf_type{0-all},tma,reserved:DWORD; tagname:Pchar):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcRequestTaggedData@24'

function tmcReturnTaggedData( cid:DWORD;p_tagd:	pDGTaggedData):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcReturnTaggedData@8'

function tmcSetTracer(cid:DWord; ch,rtu,point,tm_type,msgf:Word):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcSetTracer@24'

function tmcPeekAlarm( cid:Dword; Ch, RTU, Point, AlarmID: SmallInt; Alarm: pAL):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcPeekAlarm@24'

function tmcPeekAlarmEx( cid:Dword; Ch, RTU, Point, AlarmID: SmallInt; Alarm: pAL; var addit:Pchar):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcPeekAlarmEx@28'

function tmcPokeAlarm( cid:Dword; Ch, RTU, Point, AlarmID: SmallInt; Alarm: pAL):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcPokeAlarm@24'

function tmcEnumAlarms( cid:Dword; Ch, RTU, Point: SmallInt; Alarm: pAL;
                      MaxQuan, ActiveOnly: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcEnumAlarms@28'

function tmcGetAlarm(cid:Dword; Ch, RTU, Point, AlarmID: SmallInt;
         Alarm: pALNew;cbAlarm:Dword;var pStrings:PChar):Dword;
         stdcall; external 'tmconn.dll' name '_tmcGetAlarm@32'
// 0     
//pStrings  
//pStrings = 'Name=xx''Expr=xxx''P1=xx''P2=xx'\x0

function tmcReadAlarmState(cid:Dword; Ch, RTU, Point, AlarmID: SmallInt;
         ast: pAlarmState;cb_ast:Dword):Dword;
         stdcall; external 'tmconn.dll' name '_tmcReadAlarmState@28'

function tmcDeleteAlarm(cid:Dword; Ch, RTU, Point, AlarmID: SmallInt):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDeleteAlarm@20'

function tmcSetAlarm(cid:Dword;	Alarm:pALNew;cbAlarm:Dword;pStrings:PChar):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcSetAlarm@16'

function tmsGetAlarmParams(cid:Dword; Ch, RTU, Point, AlarmID: SmallInt;
        count:Dword; params:pAlarmParam):Dword;
         stdcall; external 'tmconn.dll' name '_tmsGetAlarmParams@28'
function tmsSetAlarmParams(
        cid:Dword; Ch, RTU, Point, AlarmID: SmallInt;
        count:Dword; params:pFloat):LongBool;
         stdcall; external 'tmconn.dll' name '_tmsSetAlarmParams@28'


function tmcDriverCall( cid:Dword; ADR: Integer; Q_Code, Command: SmallInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcDriverCall@16'

procedure tmcStatusByList( cid:Dword; Quan: SmallInt; List: pADRtm; SPs:   pSP);
         stdcall; external 'tmconn.dll' name '_tmcStatusByList@16'

procedure tmcStatusByListEx( cid:Dword; Quan: SmallInt; List: pADRtm; SPs:   pSP; UT:DWORD);
         stdcall; external 'tmconn.dll' name '_tmcStatusByListEx@20'

procedure tmcAnalogByList( cid:Dword; Quan: SmallInt; List: pADRtm; APs:   pAP;
                         UT: DWORD; RetroNum: SmallInt);
         stdcall; external 'tmconn.dll' name '_tmcAnalogByList@24'

procedure tmcAccumByList( cid:Dword; Quan: SmallInt;  List: pADRtm; AcPs: pAcP;
                          UT: DWORD);
         stdcall; external 'tmconn.dll' name '_tmcAccumByList@20'

function tmcTakeAPS( cid:Dword ): pADRtm;
         stdcall; external 'tmconn.dll' name '_tmcTakeAPS@4'

function tmcSetAnalog( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single; Time: PChar): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalog@24'

function tmcSetAnalogUT( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single;
                ut:DWORD; flgcmd, flags:BYTE):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogUT@32'

function tmcSetAccumValue( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single; Time: PChar): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAccumValue@24'

function tmcSetAccumValueUT( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single; ut: DWORD; flgcmd, flags:BYTE): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAccumValueUT@32'

function tmcIncAccumPoints(     cid:Dword; Ch, RTU, Point: SmallInt;
                                DataType,Quan:SmallInt; AGroup:Pointer): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcIncAccumPoints@28'

function tmcSetAnalogByCode  ( cid:Dword; Ch, RTU, Point: SmallInt; Value: SmallInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogByCode@20'

function tmcSetAnalogByCodeUT( cid:Dword; Ch, RTU, Point: SmallInt; Value: SmallInt;
         ut:DWORD; flgcmd, flags:BYTE):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogByCodeUT@32'

function tmcSetAnalogFloatCodeUT( cid:Dword; Ch, RTU, Point: SmallInt; Value:Single;
         ut:DWORD; flgcmd, flags:BYTE):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogFloatCodeUT@32'

function tmcSetStatus( cid:Dword; Ch, RTU, Point: SmallInt;
                            Value:Char;DateTime:PChar;Hund: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetStatus@28'

function tmcSetStatusUT (cid:Dword; Ch, RTU, Point: SmallInt;
			    Value:Char;ut:DWORD;hund:BYTE;FlgCmd,Flags:BYTE):SmallInt;
        stdcall; external 'tmconn.dll' name '_tmcSetStatusUT@36'

function tmcSetStatusNormal( cid:Dword; Ch, RTU, Point: SmallInt;NValue:WORD):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetStatusNormal@20'

function tmcSetValues( cid:Dword; count:DWORD; vf: pValueAndFlags):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetValues@12'

function tmcSetValuesEx( cid:Dword; tmsvx_flg,cnt,itemlen:DWORD;tvx:Pointer):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetValuesEx@20'

function tmcSetTimedValues( cid:Dword; cnt:Dword; values:pTimedValueAndFlags ):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetTimedValues@12'

function tmcSetStatusFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetStatusFlags@20'

function tmcClrStatusFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcClrStatusFlags@20'

function tmcSetAnalogFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogFlags@20'

function tmcClrAnalogFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcClrAnalogFlags@20'

function tmcSetAccumFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAccumFlags@20'

function tmcClrAccumFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcClrAccumFlags@20'

function tmcControl ( cid:Dword; Ch, RTU, Point: SmallInt; Cmd:SmallInt ):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcControl@20'

function tmcControlByStatus ( cid:Dword; Ch, RTU, Point: SmallInt; Cmd:SmallInt ):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcControlByStatus@20'

function tmcExecuteControlScript(cid:Dword; Ch, RTU, Point: SmallInt; Cmd:SmallInt):LongInt;
         stdcall; external 'tmconn.dll' name '_tmcExecuteControlScript@20'

function tmcOverrideControlScript(cid:Dword; fOverride:LongBool): LongBool;
         stdcall; external 'tmconn.dll' name '_tmcOverrideControlScript@8'

function tmcGetStatusClassData(cid:Dword;count:Dword;statuses:pADRtm):pPchar;
         stdcall; external 'tmconn.dll' name '_tmcGetStatusClassData@12'

function tmcGetAnalogClassData(cid:Dword;count:Dword;statuses:pADRtm):pPchar;
         stdcall; external 'tmconn.dll' name '_tmcGetAnalogClassData@12'

function tmcGetRetroFlags(cid:DWORD):DWORD; // return 0xffffffff on failure
         stdcall; external 'tmconn.dll' name '_tmcGetRetroFlags@4'

function tmcSetRetroFlags(cid,rflags:DWORD):LongBool; // return FALSE on failure
         stdcall; external 'tmconn.dll' name '_tmcSetRetroFlags@8'

function tmcDecodeTcError ( error_code:WORD ):PChar;
         stdcall; external 'tmconn.dll' name '_tmcDecodeTcError@4'

procedure tmcTakeRetroTit( cid:Dword; Ch,RTU,Point:SmallInt;
          utime:Dword;RetroNum,count,step:Word;aps:pAPShort);
         stdcall; external 'tmconn.dll' name '_tmcTakeRetroTit@36'

function  tmcPerspEnum(cid:Dword;var count:DWORD):PDWORD;
         stdcall; external 'tmconn.dll' name '_tmcPerspEnum@8'

function  tmcPerspDelete(cid:DWORD;ut:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcPerspDelete@8'

function  tmcPerspPutAnalogs(cid:DWORD;ut:DWORD;count:DWORD;addr:pADRTm;var Val:single):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcPerspPutAnalogs@20'

function  tmcPerspPutValue(cid:DWORD;ut:DWORD;Prop:PChar;Value:PChar):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcPerspPutValue@16'

function  tmcPerspGet(cid:DWORD;ut:DWORD;var len:DWORD):PChar;
         stdcall; external 'tmconn.dll' name '_tmcPerspGet@12'

function  tmcGetPerformanceData(cid:DWORD):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetPerformanceData@4'
         
function tmcGetReserveState(cid:Dword):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetReserveState@4'

function tmcGetValuesByFlagMask(cid:Dword; tm_type:Word; tm_flags:Dword;
        q_flags:byte; var Count:Dword):pCommonPoint;
        stdcall; external 'tmconn.dll' name '_tmcGetValuesByFlagMask@20'

function tmcTMValuesByListEx(cid:Dword; tm_type:Word; q_flags:byte; count:Dword;
	a:pAdrtm):pCommonPoint;
        stdcall; external 'tmconn.dll' name '_tmcTMValuesByListEx@20'

function tmcGetServerFeature(cid:Dword;feat:DWord):Integer;
        stdcall; external 'tmconn.dll' name '_tmcGetServerFeature@8'

function tmcIsPrivMID(cid:Dword; var midstate:LongInt):Boolean;
        stdcall; external 'tmconn.dll' name '_tmcIsPrivMID@8'

function tmcSetPrivMID(cid:Dword):Boolean;
        stdcall; external 'tmconn.dll' name '_tmcSetPrivMID@4'

function tmcGetNamedObject(cid:Dword;paddr:PDword;name:PChar;var cb:Dword):PByte;
        stdcall; external 'tmconn.dll' name '_tmcGetNamedObject@16'

function tmcSetNamedObject(cid:Dword;paddr:PDword;name:PChar;pobj:PByte; cb:Dword):LongBool
        stdcall; external 'tmconn.dll' name '_tmcSetNamedObject@20'

function tmcEnumNamedObjects(cid:Dword;paddr:PDword):PChar;
        stdcall; external 'tmconn.dll' name '_tmcEnumNamedObjects@8'

function tmcTextSearch(cid:Dword;tmType:Word;Txt:PChar;var count:Dword):pADRtm;
        stdcall; external 'tmconn.dll' name '_tmcTextSearch@16'

function tmcSetRetransInfo(cid:Dword; count:Word; ri:PRetransInfo):ShortInt;
        stdcall; external 'tmconn.dll' name '_tmcSetRetransInfo@12'

function tmcRemoveRetransInfo(cid:Dword; count:Word; ri:PRetransInfo):ShortInt;
        stdcall; external 'tmconn.dll' name '_tmcRemoveRetransInfo@12'

function tmcClrRetransInfo(cid:Dword):ShortInt;
        stdcall; external 'tmconn.dll' name '_tmcClrRetransInfo@4'

function tmcSetDgrmFlags(cid,dgf:Dword ):Dword; //returns $ffffffff on error
        stdcall; external 'tmconn.dll' name '_tmcSetDgrmFlags@8'

function tmcClrDgrmFlags(cid,dgf:Dword ):Dword; //returns $ffffffff on error
        stdcall; external 'tmconn.dll' name '_tmcClrDgrmFlags@8'

function tmcServEval(cid:Dword;fSet:LongBool;Eight:PByte):LongInt;
        stdcall; external 'tmconn.dll' name '_tmcServEval@12'

function tmcGetUserList(cid:Dword):PDword;
        stdcall; external 'tmconn.dll' name '_tmcGetUserList@4'

function tmcGetUserInfo(cid,usid:DWORD; var uinfo:TTMSUserInfo):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcGetUserInfo@12'

function tmcPostUserDatagram(cid,usid:DWORD; p_data:Pointer; cb_data:Dword):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcPostUserDatagram@16'

function tmcComtradeEnumDays(cid:Dword):PChar;
        stdcall; external 'tmconn.dll' name '_tmcComtradeEnumDays@4'

function tmcComtradeEnumFiles(cid:Dword; date:PChar):PChar;
        stdcall; external 'tmconn.dll' name '_tmcComtradeEnumFiles@8'

function tmcComtradeGetFile(cid:Dword; fname,locdir:Pchar):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcComtradeGetFile@12'
        
{-------------------------------------------------------------------}

function tmcDntGetConfig (cid:Dword; fname:PChar):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntGetConfig@8'

function tmcGetMapMode (cid:DWord; ModeType:DWord; var Mode:DWord): Boolean
        stdcall; external 'tmconn.dll' name '_tmcGetMapMode@12'

function tmcDntTreeChange (cid:Dword):Dword;
         stdcall; external 'tmconn.dll' name '_tmcDntTreeChange@4'

function tmcDntOpenItem(cid:Dword;count:Dword;var mask:Dword):Pointer;
         stdcall; external 'tmconn.dll' name '_tmcDntOpenItem@12'

function tmcDntGetNextItem(itid:Pointer):PByte;
         stdcall; external 'tmconn.dll' name '_tmcDntGetNextItem@4'

procedure tmcDntCloseItem(itid:Pointer);
         stdcall; external 'tmconn.dll' name '_tmcDntCloseItem@4'

function tmcDntRegisterUser(cid:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntRegisterUser@4'

procedure tmcDntUnRegisterUser(cid:Dword);
         stdcall; external 'tmconn.dll' name '_tmcDntUnRegisterUser@4'

function tmcDntBeginDebug(cid:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntBeginDebug@4'

procedure tmcDntStopDebug(cid:Dword);
         stdcall; external 'tmconn.dll' name '_tmcDntStopDebug@4'

function tmcDntBeginTrace(cid:Dword;count:Dword;var pmask:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntBeginTrace@12'

function tmcDntBeginTraceEx(cid:Dword;count:Dword;var pmask:Dword;
                trace_flags,res1,res2:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntBeginTraceEx@24'

procedure tmcDntStopTrace(cid:Dword);
         stdcall; external 'tmconn.dll' name '_tmcDntStopTrace@4'

function tmcDntTeleControl(cid,count:Dword;var pmask:Dword;idx,cmd:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntTeleControl@20'

function tmcDntGetReserveState(cid:Dword):PChar;
         stdcall; external 'tmconn.dll' name '_tmcDntGetReserveState@4'

function tmcDntReqValue(cid,count:Dword;var pmask:Dword;idx:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntReqValue@16'

function tmcDntWriteValue(cid,count:Dword;var pmask:Dword;idx:Dword;value:Pchar):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntWriteValue@20'

function tmcDntGetObjectName(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt; Buf:Pchar; cbBuf:LongInt):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntGetObjectName@28'

function tmcDntGetLiveInfo(cid:Dword;count:Dword;var pmask:Dword;
            p_data:Pointer;cb_data:Dword):Dword;
         stdcall; external 'tmconn.dll' name '_tmcDntGetLiveInfo@20'

function tmcDntSetPortCapture(cid:DWORD;driver,adapter,port:BYTE):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntSetPortCapture@16'

function tmcDntGetPortCapture(cid:DWORD;driver,adapter,port:BYTE):Integer;
         stdcall; external 'tmconn.dll' name '_tmcDntGetPortCapture@16'

function tmcDntReleasePortCapture(cid:DWORD;driver,adapter,port:BYTE):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntReleasePortCapture@16'

function tmcDntSendPortPacket(cid:DWORD;driver,adapter,port,proto,timeout:BYTE;
                                pPacket:Pointer;cbPacket:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntSendPortPacket@32'

function tmcDntPassPortBuffer(cid:DWORD; someint: DWORD; paddr:PDword;
                                pPacket:Pointer; cbPacket:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntPassPortBuffer@20'

function tmcDntChildInstMask(cid:Dword):Dword;
         stdcall; external 'tmconn.dll' name '_tmcDntChildInstMask@4'

procedure tmcReadRetroTimes(cid:Dword;idx:Word;var pdata:Pointer;
          var count:Dword;pError:PChar);
         stdcall; external 'tmconn.dll' name '_tmcReadRetroTimes@20'

procedure tmcReadRetroSlice(cid:Dword;idx:Word;utime:Dword;
          var rtype:Word;var pdata:Pointer;var count:Dword);
         stdcall; external 'tmconn.dll' name '_tmcReadRetroSlice@24'


function tmcAanGetValues( cid:Dword; tma,ut:Dword; b_ser:Byte; var cnt:Word; p_errs:Pchar; cb_errs:Dword ): pAanMinData;
        stdcall; external 'tmconn.dll' name '_tmcAanGetValues@28'

function tmcAanGetStats( cid:Dword; stats: pAanStats; cb_stats:Dword):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcAanGetStats@12'

function tmcAanReadArchive(
	cid,tma,start_ut,stop_ut,intv, aarf:DWord;
	var cnt:DWord;
	prog_fn:TTmcProgressEvent;prog_parm:Pointer):pAanArchValue;
         stdcall; external 'tmconn.dll' name '_tmcAanReadArchive@36'


function tmcRegEvent(cid:Dword; Event:  pEV): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcRegEvent@8'

function tmcEvlogPutStrBin(
                cid:Dword;unix_time:Dword;unix_hund:Byte;importance:Byte;
                SourceTag:Dword;str:Pchar;bin:Pointer;cb_bin:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcEvlogPutStrBin@32'

function tmcFillAnalogGroup(cid:Dword; Ch, RTU, Point: SmallInt; Quan: SmallInt; AGroup: Pointer): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcFillAnalogGroup@24'
procedure tmcSendMapboardCommand(cid, cmd, par1, par2: DWORD);
         stdcall; external 'tmconn.dll' name '_tmcSendMapboardCommand@16'
function tmcReconnectCount(cid: DWORD):DWORD;
         stdcall; external 'tmconn.dll' name '_tmcReconnectCount@4'
function tmcIsConnected(cid:Dword): Dword;
         stdcall; external 'tmconn.dll' name '_tmcIsConnected@4'

function tmcIsOperator(cid: DWORD):DWORD;
         stdcall; external 'tmconn.dll' name '_tmcIsOperator@4'
function tmcGetObjectNameEx(cid:Dword; ObjectType: Word;
            Ch, RTU, Point, SubObjectId: SmallInt;
            Buffer: PChar; MaxBufLen: Integer): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectNameEx@32'
function tmcGetStatusNormal(cid:Dword; Ch, RTU, Point: SmallInt; NValue: PSmallInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetStatusNormal@20'

function tmcEventLogByIndex(cid:Dword; index: DWORD; ut: DWORD; pSize: PDWORD): pTMSEV;
         stdcall; external 'tmconn.dll' name '_tmcEventLogByIndex@16'

function tmcSetAccumValueSeries(
        cid:DWORD;chn,rtu,point:WORD;
        val:Single;ut:DWORD;allow_reformat:LongBool;
        errs:PChar;cb_errs:DWORD ):DWORD;
        stdcall; external 'tmconn.dll' name '_tmcSetAccumValueSeries@36'

function tmcGetTextualInfo(cid:DWORD;info:WORD;data:Pointer;cbdata:DWORD):PChar;
        stdcall; external 'tmconn.dll' name '_tmcGetTextualInfo@16'

procedure tmcFreeMemory(p:Pointer);
         stdcall; external 'tmconn.dll' name '_tmcFreeMemory@4'

function tmcKeyGetTypeFlags(kind:Dword):Dword;
        stdcall; external 'tmconn.dll' name '_tmcKeyGetTypeFlags@4'

function tmcKeyReadId( key_type,port:Dword;key_id:Pbyte):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcKeyReadId@12'

function tmcKeyReadSubkey(key_type,port:Dword;key_id,password,signature:Pbyte;
                sub_key_num:Byte;sub_key:PByte):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcKeyReadSubkey@28'

function tmcKeyWriteSubkey(key_type,port:Dword;password,signature:Pbyte;
                sub_key_num:Byte;sub_key:PByte):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcKeyWriteSubkey@24'

function tmcKeyReadScratchPad(key_type,port:Dword;key_id,scratch_pad:Pbyte):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcKeyReadScratchPad@16'

function tmcKeyWriteScratchPad(key_type,port:Dword;scratch_pad:Pbyte):LongBool;
        stdcall; external 'tmconn.dll' name '_tmcKeyWriteScratchPad@12'

function tmcTechObjEnumValues(cid,tob_s,tob_t:Dword; props_flt:PChar; var count:DWord): pTechObjProps;
        stdcall; external 'tmconn.dll' name '_tmcTechObjEnumValues@20'

function tmcTechObjReadValues(cid:DWord; pobj:pTechObj; count:Dword): pTechObjProps;
        stdcall; external 'tmconn.dll' name '_tmcTechObjReadValues@12'


function rbcOpenBases(cid:Dword; Base1, Base2, Base3, Base4, Base5: PChar): Integer;
         cdecl; external 'tmconn.dll'
function rbcCloseBases(cid:Dword): Integer;
         cdecl; external 'tmconn.dll'
function rbcOpenTable(cid:Dword; Base, Table: PChar): Integer;
         cdecl; external 'tmconn.dll'
function rbcRecSize(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcResetTable(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcReadStr(cid:Dword; hTable, RecCount: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcReadAdrStr( cid:Dword; hTable, RecAdr: Integer; Rec: Pointer):Integer;
         cdecl; external 'tmconn.dll'
function rbcSetWhere(cid:Dword; hTable: Integer;
                    Column,  whType: Integer;
                    P1, P2, P3, P4, P5, P6, P7, P8, P9, P10: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcFindStr(cid:Dword; hTable, RecCount: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcFindCol(cid:Dword; hTable, RecCount: Integer; Rec: Pointer;
                   P1, P2, P3, P4, P5, P6, P7, P8: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcCalcTable(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcTestTable(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcWriteStr(cid:Dword; hTable: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcWriteCol(cid:Dword; hTable: Integer; Rec: Pointer;
                   P1, P2, P3, P4, P5, P6, P7, P8: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcAddStr(cid:Dword; hTable: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcAddStrInc(cid:Dword; hTable, Column: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcAddStrDec(cid:Dword; hTable, Column: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcFindMinMax(cid:Dword; hTable, Column: Integer; Rec1, Rec2: Pointer): Integer;
         cdecl; external 'tmconn.dll'

function rbcDeleteStr(cid:Dword; hTable: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcDeleteAll(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcLockStr(cid:Dword; hTable, RecNum: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcGetUsurperName(cid:Dword; hTable, RecNum: Integer; pName:PChar; cbName:Dword): Integer;
         cdecl; external 'tmconn.dll'
function rbcUnlockStr(cid:Dword; hTable, RecNum: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcGetSecurity(cid:Dword;var Admin:LongBool;var AccessMask:DWORD):Integer;
         cdecl; external 'tmconn.dll'
function rbcGetUserId(cid:Dword;UserId,UserPwd:PChar):Integer;
         cdecl; external 'tmconn.dll'
function rbcReadUserId(cid:Dword;index:DWORD ;var Done:LongBool;UserSid:PBYTE;
						UserId,UserPwd:PChar):Integer;
         cdecl; external 'tmconn.dll'
function rbcWriteUserId(cid:Dword;index:DWORD;UserSid:PBYTE;
						UserId,UserPwd:PChar):Integer;
         cdecl; external 'tmconn.dll'
function rbcWsEnumDomains(cid:Dword):PChar;
         cdecl; external 'tmconn.dll'
function rbcWsEnumDomainUsers(cid:Dword;domain:PChar):PChar;
         cdecl; external 'tmconn.dll'
function rbcWsGetUserSid(cid:Dword;domain:PChar;user:PChar):Pointer;
         cdecl; external 'tmconn.dll'
function rbcWsGetUserName(cid:Dword;pSid:Pointer;domain,user:PChar):LongBool;
         cdecl; external 'tmconn.dll'
function rbcBackupServerProcedure( machine,pipe,directory:PChar;
         var bflags:DWORD;hCancel:DWORD;
         prog_fn:TTmcProgressEvent;prog_parm:Pointer):LongBool;
         cdecl; external 'tmconn.dll'

implementation

function cprtText(id:DWORD ):PChar;
var
        idata:pCfsInitData;
        p:PDWORD;
begin
Result:='';
if fGotCprtText=false then
        begin
        idata:=cfsInitApp;
        if idata=nil then Exit;
        p:=PDWORD(idata.reserved[31]);
        if p=nil then Exit;
        Inc(p,10);
        if p^=0 then Exit;
        fGotCprtText:=true;
        _cprtText:=TCprtText(p^);
        end;
Result:=_cprtText(id);
end;

function GetTmTypeName(tmType:WORD):string;
begin

case tmType of
        TM_STATUS:      Result:=L_S_PC('Status','');
        TM_ANALOG:      Result:=L_S_PC('Analog','');
        TM_ACCUM:       Result:=L_S_PC('Counter','');
        TM_RTU:         Result:=L_S_PC('Rtu','');
        TM_CHANNEL:     Result:=L_S_PC('Channel','');
else
        Result:='???';
end;

end;
function MemComp (p1,p2:Pointer;len:Longint):Integer;
var
    pb1,pb2:PChar;
    i:Longint;
begin
Result:=0;
pb1:=PChar(p1);
pb2:=PChar(p2);
for i:=0 to len-1 do
    begin
    if pb1[i]<>pb2[i] then
        begin
        Result:=1;
        Break;
        end;
    end;
end;

function  CommonGetFlagName(connid:DWORD;flag:DWORD;var name:string):Boolean;
begin
        Result:=false;
        if flag=DWORD(UNRELIABLE_HDW) then
                begin
                name:=L_S_PC('Unreliable',' ');
                Result:=true;
                end
        else if flag=DWORD(UNRELIABLE_MANU) then
                begin
                if tmcGetConfigType(connid)=1 then name:=L_S_PC('Blocked',' ')
                else  name:=L_S_PC('Unreliable (user)',' ');
                Result:=true;
                end
        else if flag=DWORD(REQUESTED) then
                begin
                name:=L_S_PC('Requested',' ');
                Result:=true;
                end
        else if flag=DWORD(MANUALLY_SET) then
                begin
                name:=L_S_PC('Manual',' ');
                Result:=true;
                end
        else if flag=DWORD(FROM_BACKUP) then
                begin
                name:=L_S_PC('Substituted','/');
                Result:=true;
                end
        else if flag=DWORD(F_STREAMING) then
                begin
                name:=L_S_PC('Time tag retransmission','  ');
                Result:=true;
                end
        else if flag=DWORD(F_UNACKED) then
                begin
                name:=L_S_PC('Not acknowledged','');
                Result:=true;
                end
        else if flag=DWORD(F_IV) then
                begin
                name:=L_S_PC('Invalid (IEC101)','Invalid (101)');
                Result:=true;
                end
        else if flag=DWORD(F_HAVERES) then
                begin
                name:=L_S_PC('Has reserve',' ');
                Result:=true;
                end
        else if flag=DWORD(F_EXTERNAL) then
                begin
                name:=L_S_PC('From exernal server','  ');
                Result:=true;
                end
        else if flag=DWORD(F_EXPRESSION) then
                begin
                name:=L_S_PC('Calculated by expression','  ');
                Result:=true;
                end
        else if flag=DWORD(F_DTMX) then
                begin
                name:=L_S_PC('Data export','Data log');
                Result:=true;
                end
        else if flag=DWORD(F_CAN_OUTDATE) then
                begin
                name:=L_S_PC('Can outdate','');
                Result:=true;
                end;

end;

function  StatusGetFlagName(connid:DWORD;flag:DWORD;var name:string):Boolean;
begin
        Result:=false;
        if flag=DWORD(LEVEL_A) then
                begin
                name:=L_S_PC('Flag 1',' 1');
                Result:=true;
                end
        else if flag=DWORD(LEVEL_B) then
                begin
                name:=L_S_PC('Flag 2',' 2');
                Result:=true;
                end
        else if flag=DWORD(LEVEL_C) then
                begin
                name:=L_S_PC('Flag 3',' 3');
                Result:=true;
                end
        else if flag=DWORD(LEVEL_D) then
                begin
                name:=L_S_PC('Flag 4',' 4');
                Result:=true;
                end
        else if flag=DWORD(INVERTED) then
                begin
                name:=L_S_PC('Inverted','');
                Result:=true;
                end
        else if flag=DWORD(UNDER_CONTROL) then
                begin
                name:=L_S_PC('Has telectrl',' ');
                Result:=true;
                end
        else if flag=DWORD(IS_APS) then
                begin
                name:=L_S_PC('Fault warning','');
                Result:=true;
                end
        else if flag=DWORD(F_ABNORMAL) then
                begin
                name:=L_S_PC('Abnormal','  ');
                Result:=true;
                end
        else if flag=DWORD(F_HAVE_NORMAL) then
                begin
                name:=L_S_PC('has normal value','  ');
                Result:=true;
                end
        else if flag=DWORD(F_NO_RETRO) then
                begin
                name:=L_S_PC('Do not log','   ');
                Result:=true;
                end
        else if flag=DWORD(F_INTERIM) then
                begin
                name:=L_S_PC('Interim state',' ');
                Result:=true;
                end;

end;

function  AnalogGetFlagName(connid:DWORD;flag:DWORD;var name:string):Boolean;
begin
        Result:=false;
        if flag=DWORD(LEVEL_A) then
                begin
                name:=L_S_PC('Alarm level 1','  1 ');
                Result:=true;
                end
        else if flag=DWORD(LEVEL_B) then
                begin
                name:=L_S_PC('Alarm level 2','  2 ');
                Result:=true;
                end
        else if flag=DWORD(LEVEL_C) then
                begin
                name:=L_S_PC('Alarm level 3','  3 ');
                Result:=true;
                end
        else if flag=DWORD(LEVEL_D) then
                begin
                name:=L_S_PC('Alarm level 4','  4 ');
                Result:=true;
                end
        else if flag=DWORD(HAS_ALARMS) then
                begin
                name:=L_S_PC('Has alarms',' ');
                Result:=true;
                end
        else if flag=DWORD(INVERTED) then
                begin
                name:=L_S_PC('Goes to avg. retro','  ');
                Result:=true;
                end
        else if flag=DWORD(F_AN_UNSIGNED) then
                begin
                name:=L_S_PC('Unsigned','');
                Result:=true;
                end
        else if flag=DWORD(F_NO_ZERO) then
                begin
                name:=L_S_PC('No special 0',' ');
                Result:=true;
                end
        else if flag=DWORD(F_FORMAT) then
                begin
                name:=L_S_PC('Do formatting','  ');
                Result:=true;
                end
        else if flag=DWORD(F_NO_RETRO) then
                begin
                name:=L_S_PC('Do not log','   ');
                Result:=true;
                end;

end;

function  AccumGetFlagName(connid:DWORD;flag:DWORD;var name:string):Boolean;
begin
        Result:=false;
end;

function  GetFlagName(connid:DWORD;tm_type:WORD;flag:DWORD;var name:string):Boolean;
begin
        Result:=false;
        if tm_type=TM_STATUS then
                begin
                Result:=StatusGetFlagName(connid,flag,name);
                end
        else if tm_type=TM_ANALOG then
                begin
                Result:=AnalogGetFlagName(connid,flag,name);
                end
        else if tm_type=TM_ACCUM then
                begin
                Result:=AccumGetFlagName(connid,flag,name);
                end;
        if not Result then
                Result:=CommonGetFlagName(connid,flag,name);
end;

function GetImportanceName(connid:DWORD; Imp:Integer; var name:String):Boolean;
begin

        Result:=false;
        name:='???';
        if Imp>3 then Exit;
        if tmcGetConfigType(connid)=1 then
                begin

                case Imp of
                        0: name:= L_S_PC('low',' ');
                        1: name:= L_S_PC('medium 1',' 2');
                        2: name:= L_S_PC('medium 2',' 1');
                        3: name:= L_S_PC('alert','');
                end;
                Result:=true;
                end
        else
                begin

                case Imp of
                        0: name:= L_S_PC('low','');
                        1: name:= L_S_PC('log',' ');
                        2: name:= L_S_PC('sound',' ');
                        3: name:= L_S_PC('alarm','');
                end;
                Result:=true;
                end;
end;

procedure ConditionUTStr(c:Pchar);
begin
        while c^<>CHR(0) do
                begin
                case c^ of
                   '.', ':', ';', '*', '?': c^:='_';
                end;

                Inc(c,1);
                end;
end;

function GetServerCaps(cid,cap:Dword):LongBool;
var
        cbuf:array[0..15] of byte;
begin
Result:=false;

if cap>255 then Exit;

ZeroMemory(@cbuf[0],16);
if tmcGetServerCaps(cid,@cbuf[0])=0 then Exit;
if  ((cbuf[cap div 8] shr (cap mod 8)) and 1)=0 then Exit;
Result:=true;
end;

function UtimeToString(ut:DWord):string;
var
        sb: array [0..99] of Char;
begin
Result:='';
ZeroMemory(@sb[0],100);
Utime2Str(ut, @sb[0] );
Result:= StrPas(@sb[0]);
end;

procedure Utime2StrMs(ut:DWord; ms:Word; s:PChar);
var
        len: integer;
begin
s[0]:=CHR(0);
Utime2Str(ut,s);
len:=StrLen(s);
StrCopy(@s[len],PChar(Format('.%03u',[ms]))) ;
while true do
        begin
        if s[len]=CHR(0) then Break;
        if s[len]=' ' then s[len]:='0';
        Inc(len);
        end;
end;

function L_S_PC(e,r:PChar):PChar;
begin
        Result:=e;
        if cfsIfLang()=0 then
                begin
                Result:=r;
                end;
end;

function Attention:PChar;
begin
        Result:=L_S_PC('Attention!','!');
end;
end.
