﻿using System;

namespace SSH.CP.TmsClient.Misc
{
	[Serializable]
  public class ConnectException : Exception
	{
		#region Fields
		private readonly bool mAutoConnectionPossible;
		#endregion

		#region Ctor
		public ConnectException(string pMessage, bool pAutoConnectionPossible)
			: this(pMessage, null, pAutoConnectionPossible) { }

		public ConnectException(string pMessage, Exception pInnerException, bool pAutoConnectionPossible)
			: base(pMessage, pInnerException)
		{
			mAutoConnectionPossible = pAutoConnectionPossible;
		}
		#endregion

		#region Props
		public bool AutoConnectionPossible { get { return mAutoConnectionPossible; } }
		#endregion
	}
}