﻿using System;

namespace SSH.CP.TmsClient.Misc
{
	public struct UnixDateTime
	{
		#region Fields
		private readonly UInt32 mTotalTicks;
		#endregion

		#region Ctor
		public UnixDateTime(UInt32 pTotalTicks)
		{
			mTotalTicks = pTotalTicks;
		}
		#endregion

		#region Props
		public UInt32 TotalTicks { get { return mTotalTicks; } }
		public UInt32 TotalSeconds { get { return mTotalTicks; } }
		#endregion

		public static UnixDateTime ToUnixDateTime(DateTime pDt)
		{
			TimeSpan ts = pDt.Subtract(new DateTime(1970, 1, 1));
			long sec = ts.Ticks/10000000;
			UnixDateTime udt = new UnixDateTime((UInt32)sec);
			return udt;
		}

		public static DateTime ToDateTime(UnixDateTime pUdt)
		{
			DateTime dt = new DateTime(1970,1,1);
			dt = dt.AddSeconds(pUdt.TotalSeconds);
			return dt;
		}
	}
}