﻿using System;
using SSH.CP.TmsClient.Wraps;

namespace SSH.CP.TmsClient
{
	public class ServerTimeService
	{
		private readonly TmsConnectionBase mConnection;
		private TimeSpan mServer_Sub_Local;

		public ServerTimeService(TmsConnectionBase pConnection)
		{
			pConnection.EnsureConnected();
			//----
			mConnection = pConnection;
			RefreshTimeDiff();
		}

    public void RefreshTimeDiff()
		{
			DateTime serverTime = RequestServerTime();
			DateTime localTime = DateTime.Now;
			mServer_Sub_Local = serverTime.Subtract(localTime);
		}

    public void RefreshTimeDiff(out DateTime serverTime)
    {
      serverTime = RequestServerTime();
      DateTime localTime = DateTime.Now;
      mServer_Sub_Local = serverTime.Subtract(localTime);
    }

    public DateTime RequestServerTime()
		{
			//mConnection.EnsureConnected();
			return Tmconn.GetSystemTime(mConnection.Cid);
		}

    public DateTime GetServerTime() // CalculateServerTime()
		{
			return ToServerTime(DateTime.Now);
		}

		public DateTime ToLocalTime(DateTime pServerTime)
		{
			return pServerTime.Subtract(mServer_Sub_Local);
		}

		public DateTime ToServerTime(DateTime pLocalTime)
		{
			return pLocalTime.Add(mServer_Sub_Local);
		}
	}
}