﻿using System;
using System.Collections.Generic;

namespace SSH.CP.TmsClient
{
	public enum TagType
	{
		TS = 1,
		TIT = 2,
		TII = 3
	}

	public struct ShortTagId : IComparable
	{
		#region Static
		public static ShortTagId Null { get { return new ShortTagId(-1, -1, -1); } }
		#endregion

		#region Fields
		private int mPart1;
		private int mPart2;
		private int mPart3;
		#endregion

		#region Ctor
		public ShortTagId(int pPart1, int pPart2, int pPart3) : this()
		{
			mPart1 = pPart1;
			mPart2 = pPart2;
			mPart3 = pPart3;
		}
		#endregion

		#region Props
		public int Part1 { get { return mPart1; } set { mPart1 = value; } }
		public int Part2 { get { return mPart2; } set { mPart2 = value; } }
		public int Part3 { get { return mPart3; } set { mPart3 = value; } }
		#endregion

		public bool IsNull() { return mPart1 < 0; }

		public int CompareTo(object pOther)
		{
			ShortTagId other = (ShortTagId)pOther;
			int result;
			result = Part1.CompareTo(other.Part1);
			if (result != 0) return result;
			result = Part2.CompareTo(other.Part2);
			if (result != 0) return result;
			result = Part3.CompareTo(other.Part3);
			return result;
		}

		public override string ToString()
		{
			return mPart1 + " : " + mPart2 + " : " + mPart3;
		}

		#region Static Service

		public static ShortTagId Parse(string pContent)
		{
			ShortTagId tagId;
			TryParse(pContent, out tagId);
			return tagId;
		}

		public static bool TryParse(string pContent, out ShortTagId pTagId)
		{
			string[] sssArr = pContent.Trim().Split(new char[] { ',', ' ', ':' });
			if (sssArr.Length.Equals(3))
			{
				pTagId = new ShortTagId(Convert.ToInt32(sssArr[0]), Convert.ToInt32(sssArr[1]), Convert.ToInt32(sssArr[2]));
				return true;
			}
			pTagId = Null;
			return false;
		}

		public static void GetDiff(ShortTagId[] pArr1, ShortTagId[] pArr2, out ShortTagId[] pArr1Uniq, out ShortTagId[] pArr2Uniq)
		{
			List<ShortTagId> list1 = new List<ShortTagId>(pArr1);
			List<ShortTagId> list2 = new List<ShortTagId>(pArr2);

			List<ShortTagId> list1Uniq = new List<ShortTagId>();
			List<ShortTagId> list2Uniq = new List<ShortTagId>();

			for (int i = 0; i < pArr1.Length; i++)
			{
				ShortTagId tagId = pArr1[i];
				if (!list2.Exists(delegate(ShortTagId match) { return match.Equals(tagId); }))
					if (!list1Uniq.Exists(delegate(ShortTagId match) { return match.Equals(tagId); }))
						list1Uniq.Add(tagId);
			}

			for (int i = 0; i < pArr2.Length; i++)
			{
				ShortTagId tagId = pArr2[i];
				if (!list1.Exists(delegate(ShortTagId match) { return match.Equals(tagId); }))
					if (!list2Uniq.Exists(delegate(ShortTagId match) { return match.Equals(tagId); }))
						list2Uniq.Add(tagId);
			}

			list1Uniq.Sort();
			list2Uniq.Sort();

			pArr1Uniq = list1Uniq.ToArray();
			pArr2Uniq = list2Uniq.ToArray();
		}

		#endregion Static Service

	}


	public struct FullTagId
	{
		#region Fields
		private TagType mTagType;
		private int mPart1;
		private int mPart2;
		private int mPart3;
		#endregion

		public FullTagId(TagType pTagType, int pPart1, int pPart2, int pPart3) : this()
		{
			mTagType = pTagType;
			mPart1 = pPart1;
			mPart2 = pPart2;
			mPart3 = pPart3;
		}

		#region Props
		public TagType TagType { get { return mTagType; } set { mTagType = value; } }
		public int Part1 { get { return mPart1; } set { mPart1 = value; } }
		public int Part2 { get { return mPart2; } set { mPart2 = value; } }
		public int Part3 { get { return mPart3; } set { mPart3 = value; } }
		#endregion

		public override string ToString()
		{
			return mTagType + " : " + mPart1 + " : " + mPart2 + " : " + mPart3;
		}

	}
}