﻿using System;
using System.Collections.Generic;
using SSH.CP.TmsClient.Misc;
using SSH.CP.TmsClient.Wraps;

namespace SSH.CP.TmsClient
{
	public static class TmUtils
	{
    public static string GetTagName(Int32 cid, FullTagId pTagId)
    { return GetTagName(cid, pTagId.TagType, pTagId.Part1, pTagId.Part2, pTagId.Part3); }

    public static string GetTagName(Int32 cid, TagType tagType, int part1, int part2, int part3)
    {
      switch (tagType)
      {
        case TagType.TS:
          return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_STATUS, (Int16)part1, (Int16)part2, (Int16)part3);

        case TagType.TIT:
          return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_ANALOG, (Int16)part1, (Int16)part2, (Int16)part3);

        case TagType.TII:
          return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_ACCUM, (Int16)part1, (Int16)part2, (Int16)part3);

        default:
          return null;
      }
    }

    public static string GetChName(Int32 cid, int part1)
    { return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_CHANNEL, (Int16)part1, 0, 0); }

    public static string GetRtuName(Int32 cid, int part1, int part2)
    { return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_RTU, (Int16)part1, (Int16)part2, 0); }

    public static string GetTsName(Int32 cid, ShortTagId pTagId)
		{ return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_STATUS, (Int16)pTagId.Part1, (Int16)pTagId.Part2, (Int16)pTagId.Part3); }

    public static string GetTitName(Int32 cid, ShortTagId pTagId)
    { return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_ANALOG, (Int16)pTagId.Part1, (Int16)pTagId.Part2, (Int16)pTagId.Part3); }

    public static string GetTiiName(Int32 cid, ShortTagId pTagId)
    { return Tmconn.GetObjectName(cid, (UInt16)TmObjectType.TM_ACCUM, (Int16)pTagId.Part1, (Int16)pTagId.Part2, (Int16)pTagId.Part3); }

    public static void GetTagIds(Int32 cid, out FullTagId[] pIds)
		{
			List<FullTagId> list;
			GetTagIds(cid, out list);

			if(list!= null && list.Count > 0)
				pIds = list.ToArray();
			else
				pIds = null;
		}

		public static void GetTagIds(Int32 cid, out List<FullTagId> pList)
		{
      /*
      using (var helper = new MarshalHelper(2 * 255))
        GetTagIds(helper, cid, out pList);
      */

      pList = null;
      //-------------------
      var tree = GetTagTree(cid);
      //-------------------
      if (tree == null) return;

      var list = new List<FullTagId>();
      foreach (var node1Pair in tree)
        foreach (var node2Pair in node1Pair.Value)
          foreach (var node3Pair in node2Pair.Value)
            foreach (var node4Value in node3Pair.Value)
              list.Add(new FullTagId(node3Pair.Key, node1Pair.Key, node2Pair.Key, node4Value));

      if (list.Count > 0)
        pList = list;
    }

    public static Dictionary<int, Dictionary<int, Dictionary<TagType, List<int>>>> GetTagTree(Int32 cid)
    {
      using (var helper = new MarshalHelper(2 * 255))
        return GetTagTree(helper, cid);
    }

    private static Dictionary<int, Dictionary<int, Dictionary<TagType, List<int>>>> GetTagTree(MarshalHelper pHelper, Int32 cid)
    {
      var tree = new Dictionary<int, Dictionary<int, Dictionary<TagType, List<int>>>>(); // Channel

      Int16[] ids1;
      //-------------------------------------------------
      //EnumTags_Patched?
      Tmconn.EnumTags(pHelper, cid, TmObjectType.TM_CHANNEL, out ids1, 0, 0, 0);
      //-------------------------------------------------

      if (ids1 != null)
      {
        foreach (int id1 in ids1)
        {
          var node2 = new Dictionary<int, Dictionary<TagType, List<int>>>(); // RTU
          Int16[] ids2;
          //-------------------------------------------------
          //EnumTags_Patched?
          Tmconn.EnumTags(pHelper, cid, TmObjectType.TM_RTU, out ids2, (Int16)id1, 1, 0);
          //-------------------------------------------------

          if (ids2 != null)
          {
            foreach (int id2 in ids2)
            {
              var node3 = new Dictionary<TagType, List<int>>();
              Int16[] ids3;

              //-------------------------------------------------
              //EnumTags_Patched?
              Tmconn.EnumTags(pHelper, cid, TmObjectType.TM_STATUS, out ids3, (Int16)id1, (Int16)id2, 1);
              //-------------------------------------------------

              if (ids3 != null)
              {
                var node4 = new List<int>();

                foreach (int id3 in ids3)
                  node4.Add(id3);

                node3.Add(TagType.TS, node4);
              }

              //-------------------------------------------------
              //EnumTags_Patched?
              Tmconn.EnumTags(pHelper, cid, TmObjectType.TM_ANALOG, out ids3, (Int16)id1, (Int16)id2, 1);
              //-------------------------------------------------

              if (ids3 != null)
              {
                var node4 = new List<int>();

                foreach (int id3 in ids3)
                  node4.Add(id3);

                node3.Add(TagType.TIT, node4);
              }

              //-------------------------------------------------
              //EnumTags_Patched?
              Tmconn.EnumTags(pHelper, cid, TmObjectType.TM_ACCUM, out ids3, (Int16)id1, (Int16)id2, 1);
              //-------------------------------------------------

              if (ids3 != null)
              {
                var node4 = new List<int>();

                foreach (int id3 in ids3)
                  node4.Add(id3);

                node3.Add(TagType.TII, node4);
              }

              //----------
              node2.Add(id2, node3);
            }
          }
          tree.Add(id1, node2);
        }
      }
      //--------
      return tree.Count == 0 ? null : tree;
    }
    
    public static string GetTitMeasure(Int32 cid, ShortTagId tagId)
		{
			string measure;
			double tagValue;

			if (QueryTIT(cid, tagId, null, out tagValue, out measure))
				return measure;

			return null;
		}

		public static bool QueryTIT(Int32 cid, ShortTagId tagId, DateTime? dt, out double tagValue, out string measure)
		{
			tagValue = 0;
			measure = null;

			UInt32 unixTime;
			if (dt.HasValue)
				unixTime = UnixDateTime.ToUnixDateTime(dt.Value).TotalTicks;
			else
				unixTime = 0;

			TAdrTm[] adrArr = new TAdrTm[1];
			adrArr[0].Ch = (Int16)tagId.Part1;
			adrArr[0].RTU = (Int16)tagId.Part2;
			adrArr[0].Point = (Int16)tagId.Part3;

			TAnalogPoint[] resultArray = TAnalogPoint.CreateArray(1);
			TAnalogPoint.Reset(resultArray);

			//-------------------------
			Tmconn.tmcAnalogByList(cid, 1, adrArr, resultArray, unixTime, 0);
			//-------------------------
			TAnalogPoint data = resultArray[0];
			tagValue = data.asFloat;
			measure = (new string(data.Unit, 0, 6)).Trim();

			if (data.Flags == -1)
				return false;

			return true;
		}

    public static string GetTiiMeasure(Int32 cid, ShortTagId tagId)
    {
      string measure;
      double tagValue;

      if (QueryTII(cid, tagId, null, out tagValue, out measure))
        return measure;

      return null;
    }

    public static bool QueryTII(Int32 cid, ShortTagId tagId, DateTime? dt, out double tagValue, out string measure)
    {
      tagValue = 0;
      measure = null;

      UInt32 unixTime;
      if (dt.HasValue)
        unixTime = UnixDateTime.ToUnixDateTime(dt.Value).TotalTicks;
      else
        unixTime = 0;

      TAdrTm[] adrArr = new TAdrTm[1];
      adrArr[0].Ch = (Int16)tagId.Part1;
      adrArr[0].RTU = (Int16)tagId.Part2;
      adrArr[0].Point = (Int16)tagId.Part3;

      TAccumPoint[] resultArray = TAccumPoint.CreateArray(1);
      TAccumPoint.Reset(resultArray);

      //-------------------------
      Tmconn.tmcAccumByList(cid, 1, adrArr, resultArray, unixTime);
      //-------------------------
      TAccumPoint data = resultArray[0];
      tagValue = data.Value;
      measure = (new string(data.Unit, 0, 6)).Trim();

      if (data.Flags == -1)
        return false;

      return true;
    }

  }
}
