﻿using System;
using System.Runtime.InteropServices;

namespace SSH.CP.TmsClient.Wraps
{
	public static class CfShare
	{
		public const int TRS_SRV_STARTING = 0;
		public const int TRS_SRV_RUNNING = 1;
		public const int TRS_SRV_STOPPING = 2;

		//=====================================================
		// DWORD mk_uxtime(Year,Month,Day,Hour,Minute,Second:Integer); cdecl
		//=====================================================
		[DllImport("cfshare.dll", EntryPoint = "mk_uxtime", CallingConvention = CallingConvention.Cdecl)]
		public static extern UInt32 mk_uxtime(Int32 Year, Int32 Month, Int32 Day, Int32 Hour, Int32 Minute, Int32 Second);

		//=====================================================
		/* 
		VOID	__stdcall strac_SetConsoleDebug(BOOL fDebug);
		 */
		//=====================================================
		[DllImport("cfshare.dll", EntryPoint = "strac_SetConsoleDebug", CallingConvention = CallingConvention.StdCall)]
		public static extern void strac_SetConsoleDebug(bool fDebug);

		//=====================================================
		/* 
		VOID __cdecl d_printf(LPCSTR format, ...);
		VOID __cdecl m_printf(LPCSTR format, ...);
		VOID __cdecl e_printf(LPCSTR format, ...);
		*/
		//=====================================================
		[DllImport("cfshare.dll", EntryPoint = "d_printf", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
		public static extern void d_printf([MarshalAs(UnmanagedType.LPStr)] string format);

		[DllImport("cfshare.dll", EntryPoint = "e_printf", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
		public static extern void e_printf(string format);

		[DllImport("cfshare.dll", EntryPoint = "m_printf", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
		public static extern void m_printf(string format); //{...?}


		[DllImport("cfshare.dll", EntryPoint = "d_printf", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
		public static extern void d_printf(string format, UInt32 pArg1, UInt32 pArg2);
		
		//=====================================================
		/* 
		VOID _calltype_ cfsPmonLocalRegisterProcess(int argc,char** argv,	PHANDLE phStartEvt,PHANDLE phStopEvt);
		*/
		//=====================================================

		[DllImport("cfshare.dll", EntryPoint = "cfsPmonLocalRegisterProcess", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Ansi)]
		//public static extern bool cfsPmonLocalRegisterProcess(Int32 argc, [In, Out] String[] argv, out IntPtr phStartEvt, out IntPtr phStopEvt);
		public static extern bool cfsPmonLocalRegisterProcess(Int32 argc, [In, Out] String[] argv, ref UInt32 phStartEvt, ref UInt32 phStopEvt);
		//{... remove: Out}
		
		//=====================================================
		/* 
		BOOL 	__stdcall strac_AllocServer(TRACE_ITEM_STORAGE* tis,DWORD pid,DWORD ppid,LPSTR name,LPSTR comment);
		*/
		//=====================================================

		[DllImport("cfshare.dll", EntryPoint = "strac_AllocServer", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Ansi)]
		//public static extern bool strac_AllocServer(ref TRACE_ITEM_STORAGE tis, UInt32 pid, UInt32 ppid, string name, string comment);
		public static extern bool strac_AllocServer(ref TRACE_ITEM_STORAGE tis, UInt32 pid, UInt32 ppid, IntPtr name, IntPtr comment);

		//=====================================================
		/* 
		VOID	__stdcall strac_SetServerState(TRACE_ITEM_STORAGE* tis,DWORD state);
		*/
		//=====================================================

		[DllImport("cfshare.dll", EntryPoint = "strac_SetServerState", CallingConvention = CallingConvention.StdCall)]
		public static extern void strac_SetServerState(ref TRACE_ITEM_STORAGE tis, UInt32 state);

	}
}