﻿using System;

namespace SSH.CP.TmsClient.Wraps
{
	public class Constants
	{
		// Tag Flags
		public const Int16 UNRELIABLE_HDW = 0x0001;
		public const Int16 UNRELIABLE_MANU = 0x0002;

		/*------------------------ Типы событий ---------------------------*/
		public const UInt16 evSTATUS_CHANGE = 0x0001;   // Телесигна
		public const UInt16 evALARM = 0x0002;   // Уставка ТИТ
		public const UInt16 evCONTROL = 0x0004;   // Телеуправление
		public const UInt16 evMANUAL_CONTROL = 0x0008;   // ТУ со щита
		public const UInt16 evMANUAL_STATUS_SET = 0x0010;   // Обозначение положения ТС

		public const UInt16 TM_STATUS = 0x8000;
		public const UInt16 TM_ANALOG = 0x8001;
		public const UInt16 TM_ACCUM = 0x8002;

		public const Int16 tmCONTROL = 601;
		public const Int16 tmSTATUS = 602;
		public const Int16 tmSTATUS_FULL = 603;
		public const Int16 tmANALOG = 604;
		public const Int16 tmANALOG_FULL = 605;

	}

	/*------------- Определения флагов телепараметров -----------------*/
	/*
	#define UNRELIABLE_HDW     0x0001   // Недостоверность аппаратная
	#define UNRELIABLE_MANU    0x0002   // Недостоверность от пользователя
	#define REQUESTED          0x0004   // Идет опрос
	#define MANUALLY_SET       0x0008   // Установлено вручную
	#define NO_ALARMS          0x0000   // ТИТ в норме
	#define LEVEL_A            0x0010   // Сработала уставка первого уровня
	#define LEVEL_B            0x0020   // ------- " ------- второго уровня
	#define LEVEL_C            0x0040   // ------- " ------- третьего уровня
	#define LEVEL_D            0x0080   // ------- " ------- четвертого уровня
	#define INVERTED           0x0100   // ТС инвертируется при занесен
	#define RESCHANNEL         0x0200	// Данные взяты с резервного канала
	#define TMCTRL_PRESENT     0x0400	// Есть команда ТС - volatile
	#define STATUS_CLASS_APS   0x0800	// АПС
	#define TMSTREAMING        0x1000	// Передавать со временем
	*/

	[Flags]
	public enum TagFlags
	{
		NODATA = -1,   
		UNRELIABLE_HDW = 0x0001,   // Недостоверность аппаратная
		UNRELIABLE_MANU = 0x0002,   // Недостоверность от пользователя
		REQUESTED = 0x0004,   // Идет опрос
		MANUALLY_SET = 0x0008,   // Установлено вручную
		LEVEL_A = 0x0010,   // Сработала уставка первого уровня
		LEVEL_B = 0x0020,   // ------- " ------- второго уровня
		LEVEL_C = 0x0040,   // ------- " ------- третьего уровня
		LEVEL_D = 0x0080,   // ------- " ------- четвертого уровня
		INVERTED = 0x0100,   // ТС инвертируется при занесен
		RESCHANNEL = 0x0200,	// Данные взяты с резервного канала
		TMCTRL_PRESENT = 0x0400,	// Есть команда ТС - volatile
		STATUS_CLASS_APS = 0x0800,	// АПС
		TMSTREAMING = 0x1000,	// Передавать со временем

    UNACKED = 0x4000,	// john: не квитирован
  }

	public enum TmCommandReturnCode
	{
		Success = 1,
		Error_INVALID_ADDRESS = 0,
		Error_NO_RESOURCES = -1,
		Error_TMSOURCE_FAILED = -2,
		Error_WAIT_TIMEOUT = -3,
		Error_CANNOT_REDIRECT = -4,
		Error_NO_TMSOURCE = -5,
		Error_UNKNOWN = -100
	}

	internal enum TmObjectType
	{
		TM_CHANNEL = 0x9000,
		TM_RTU = 0x9001,
		TM_STATUS = 0x8000,
		TM_ANALOG = 0x8001,
		TM_ACCUM = 0x8002,
	}
}