﻿using System;
using System.Runtime.InteropServices;

namespace SSH.CP.TmsClient.Wraps
{

	//=====================================================
	/* 
	typedef struct {HANDLE	hMap; PVOID	pData;} TRACE_ITEM_STORAGE;
	*/
	//=====================================================

	[StructLayout(LayoutKind.Sequential, Pack = 1)]
	public struct TRACE_ITEM_STORAGE
	{
		public IntPtr hMap;
		public IntPtr pData;
	}

	[StructLayout(LayoutKind.Sequential, Pack = 1)]
	public struct TAdrTm
	{
		public Int16 Ch;
		public Int16 RTU;
		public Int16 Point;

    public static void Set(ref TAdrTm pItem, Int16 pCh, Int16 pRTU, Int16 pPoint)
    {
      pItem.Ch = pCh;
      pItem.RTU = pRTU;
      pItem.Point = pPoint;
    }
  }

	[StructLayout(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
	public struct TAnalogPoint
	{
		public Single asFloat;           // реальное значение ТИТ
		public Int16 asCode;            // код ТИТ, поступивший с ТМ
		public Int16 Flags;             // фла

		//{...to do} НЕ Правильно!
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)] // UnmanagedType.LPArray?
		public char[] Unit;           // единицы измерения // OEM!!!! // !последний байт: (precision = & 0xF0, width = & 0x0F)

		//{...to do} Правильно так:
		/*
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)] // UnmanagedType.LPArray?
		public char[] Unit;           // единицы измерения // OEM!!!! 
		public byte UnitFormat; // precision = & 0xF0, width = & 0x0F
		*/

    public void GetFormat(out string unit, out int precision, out int width)
    {
      unit = null;
      precision = 0;
      width = 0;
      if (Unit == null) return;
      unit = new String(Unit, 0, 7).Trim();
      if (Unit.Length < 8) return;
      var b = Convert.ToByte(Unit[7]);
      precision = b >> 4;
      width = b & 0x0f;
    }

    #region Static service

    private static readonly TAnalogPoint EmptyInstance = Create();
    public static TAnalogPoint Empty { get { return EmptyInstance; } }

    public static TAnalogPoint Create()
    {
      TAnalogPoint result = new TAnalogPoint();
      result.Unit = new char[8];
      return result;
    }

    public static TAnalogPoint[] CreateArray(int pSize)
    {
      TAnalogPoint[] array = new TAnalogPoint[pSize];
      for (int I = 0; I < pSize; I++)
      {
        //array[I] = TAnalogPoint.Create();
        array[I].Unit = new char[8];
      }
      return array;
    }

    public static void Reset(ref TAnalogPoint pItem)
    {
      pItem.asFloat = 0;
      pItem.asCode = 0;
      pItem.Flags = 0;
    }

    public static void Reset(TAnalogPoint[] pArr)
    {
      if (pArr != null)
        for (int I = 0; I < pArr.Length; I++)
          Reset(ref pArr[I]);
    }
    #endregion
	}

	[StructLayout(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
	public struct TAccumPoint
	{
		public Single Value;           // значение счетчика
		public Single Load;           // нагрузка
		public Int16 Flags;             // фла

    //{...to do} НЕ Правильно!
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)] // UnmanagedType.LPArray?
    public char[] Unit;           // единицы измерения // OEM!!!! // !последний байт: (precision = & 0xF0, width = & 0x0F)

    //{...to do} Правильно так:
    /*
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)] // UnmanagedType.LPArray?
    public char[] Unit;           // единицы измерения // OEM!!!! 
    public byte UnitFormat; // precision = & 0xF0, width = & 0x0F
    */

    public void GetFormat(out string unit, out int precision, out int width)
    {
      unit = null;
      precision = 0;
      width = 0;
      if (Unit == null) return;
      unit = new String(Unit, 0, 7).Trim();
      if (Unit.Length < 8) return;
      var b = Convert.ToByte(Unit[7]);
      precision = b >> 4;
      width = b & 0x0f;
    }

    #region Static Service

    private static readonly TAccumPoint EmptyInstance = Create();
    public static TAccumPoint Empty { get { return EmptyInstance; } }

    public static TAccumPoint Create()
    {
      TAccumPoint result = new TAccumPoint();
      result.Unit = new char[8];
      return result;
    }

    public static TAccumPoint[] CreateArray(int pSize)
    {
      TAccumPoint[] array = new TAccumPoint[pSize];
      for (int I = 0; I < pSize; I++)
      {
        //array[I] = TAccumPoint.Create();
        array[I].Unit = new char[8];
      }
      return array;
    }

    public static void Reset(ref TAccumPoint pItem)
    {
      pItem.Value = 0;
      pItem.Load = 0;
      pItem.Flags = 0;
    }

    public static void Reset(TAccumPoint[] pArr)
    {
      if (pArr != null)
        for (int I = 0; I < pArr.Length; I++)
          Reset(ref pArr[I]);
    }
    #endregion
  }

	[StructLayout(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
	public struct TStatusPoint
	{
    private static readonly TStatusPoint EmptyInstance = new TStatusPoint() { Status = 0, Flags = 0 };
    public static TStatusPoint Empty { get { return EmptyInstance; } }

    public Int16 Status;            // состояние объекта
		public Int16 Flags;             // фла

		public static void Reset(ref TStatusPoint pItem)
		{
			pItem.Status = 0;
			pItem.Flags = 0;
		}

		public static void Reset(TStatusPoint[] pArr)
		{
			if (pArr != null)
				for (int I = 0; I < pArr.Length; I++)
					Reset(ref pArr[I]);
		}
	}

	[StructLayout(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
	public struct TEvent
	{
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)] // UnmanagedType.LPArray?
		public char[] DateTime; // время события в формате ДД.ММ.ГГГГ ЧЧ:ММ:СС.cc

		public UInt16 Imp;      // уровень важнос

		public UInt16 ID;       // тип события
		/*------------------------ Типы событий ---------------------------*/
		//#define evSTATUS_CHANGE      0x0001   // Телесигна
		//#define evALARM              0x0002   // Уставка ТИТ
		//#define evCONTROL            0x0004   // Телеуправление
		//#define evMANUAL_CONTROL     0x0008   // ТУ со щита
		//#define evMANUAL_STATUS_SET  0x0010   // Обозначение положения ТС

		public UInt16 Ch;       // кана
		public UInt16 RTU;      // номер КП  (c 1)
		public UInt16 Point;    // объект    (c 1)

		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 22)] // UnmanagedType.LPArray?
		public byte[] Data;  // ТУ: struct ControlData         

		private static TEvent Create(DateTime pTime)
		{
			TEvent result = new TEvent();
		
			//------
			string time = pTime.ToString("dd.MM.yyyy HH:mm:ss.ff"); //ДД.ММ.ГГГГ ЧЧ:ММ:СС.cc
			char[] arr = time.ToCharArray();
			result.DateTime = new char[24];
			for (int I = 0; (I < arr.Length) && (I < result.DateTime.Length); I++) result.DateTime[I] = arr[I];
			//------

			result.Data = new byte[22];
			return result;
		}

		public static TEvent Create(DateTime pTime, ControlData pControlData, UInt16 pImpotance)
		{
      TEvent result = Create(pTime);
      //------
      result.Imp = pImpotance;
      result.ID = Constants.evCONTROL;

      #region Added 29 feb 2012
      result.Ch = pControlData.Ch;
      result.RTU = pControlData.RTU;
      result.Point = (UInt16)pControlData.Point;
      #endregion

      //------
      IntPtr ptr = Marshal.AllocCoTaskMem(22);
      Marshal.StructureToPtr(pControlData, ptr, false);
      Marshal.Copy(ptr, result.Data, 0, 22);
      Marshal.FreeCoTaskMem(ptr);
      //------
      return result;
    }
	}

	[StructLayout(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
	public struct ControlData // параметры выданного телеуправления
	{
		public byte Ch;
		public byte RTU;
		public Int16 Point;
		public byte Cmd;     // выданная команда
		public byte Result;  // == SUCCESS если ТУ успешно, иначе FAILURE

		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)] // UnmanagedType.LPArray?
		public char[] UserName;  // пользователь, выдавший ТУ  // OEM!!!!

		public static ControlData Create()
		{
			ControlData result = new ControlData();
			result.UserName = new char[16];
			return result;
		}

		public static ControlData Create(string pUserName, int pTagPart1, int pTagPart2, int pTagPart3, byte pCommand, TmCommandReturnCode pReturnCode)
		{
			ControlData result = new ControlData();

			string userName = Win32.CharToOem(pUserName);
			char[] arr = userName.ToCharArray();
			result.UserName = new char[16];
			for (int I = 0; (I < arr.Length) && (I < result.UserName.Length); I++) result.UserName[I] = arr[I];

			result.Ch = (byte)pTagPart1;
			result.RTU = (byte)pTagPart2;
			result.Point = (Int16)pTagPart3;
			result.Cmd = pCommand;
			result.Result = (byte)pReturnCode;
			return result;
		}

	}

}