﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace SSH.CP.TmsClient.Wraps
{
	/*
	typedef VOID (* tmcDatagamFn)(DWORD count,LPBYTE buf,LPVOID param);
	*/
	public delegate void CallBackDelegate(Int32 sizeInBytes, IntPtr buffer, IntPtr param);


	//=====================================================
	public static class Tmconn
	{
		//public const int DSBI_ENTIREDIRECTORY = 0x00090000;

		//=====================================================
		// tmcGetServerFeature(cid:Dword;feat:DWord):Integer;
		//=====================================================
		[DllImport("tmconn.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "tmcGetServerFeature")]
		public static extern Int32 tmcGetServerFeature(UInt32 cid, UInt32 feat);

		public static bool DetectLicenseViolation(int cid, int feat)
		{
			int code = tmcGetServerFeature((UInt32)cid, (UInt32)feat);
			return code == 0;
		}

		//=====================================================
		// void Utime2Str(long t,char* buffer);
		//=====================================================
		[DllImport("tmconn.dll" // , SSH.Eula.TmsClient
			, CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto
			, EntryPoint = "Utime2Str" //, EntryPoint = "_Utime2Str@8"
			)]
		public static extern void Utime2Str(Int32 utime, [MarshalAs(UnmanagedType.LPStr)] StringBuilder utimeSb);

		public static string Utime2Str(Int32 pUtime)
		{
			StringBuilder sb = new StringBuilder(100);
			Utime2Str(pUtime, sb);
			return sb.ToString();
		}

		//=====================================================
		/* 
		DWORD __stdcall tmcConnect(
					LPSTR server,
					LPSTR pipe,
					LPSTR user,
					tmcDatagamFn cback,
					LPVOID cback_param);
		*/
		//=====================================================
    [DllImport("tmconn.dll", EntryPoint = "tmcConnect", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Ansi)]
    public static extern Int32 tmcConnectCore(string server, string pipe, string user
      , [MarshalAs(UnmanagedType.FunctionPtr)]CallBackDelegate cbackDelegate
      , IntPtr cbackParam
      );

    public static Int32 tmcConnect(string server, string pipe, string user, CallBackDelegate cbackDelegate, IntPtr cbackParam)
    {
      if (server == "")
        server = null;

      return tmcConnectCore(server, pipe, user, cbackDelegate, cbackParam);
    }
    //=====================================================
		// void tmcDisconnect( DWORD cid );
		//=====================================================
		[DllImport("tmconn.dll", EntryPoint = "tmcDisconnect", CallingConvention = CallingConvention.StdCall)]
		public static extern void tmcDisconnect(Int32 cid);

		//=====================================================
		// DWORD tmcConnState( DWORD cid );
		//=====================================================
		[DllImport("tmconn.dll", EntryPoint = "tmcConnState", CallingConvention = CallingConvention.StdCall)]
		public static extern Int32 tmcConnState(Int32 cid);

		//=====================================================
		// DWORD tmcReconnectCount( DWORD cid );
		//=====================================================
		[DllImport("tmconn.dll", EntryPoint = "tmcReconnectCount", CallingConvention = CallingConvention.StdCall)]
		public static extern Int32 tmcReconnectCount(Int32 cid);

		//=====================================================
		// short tmcSystemTime(DWORD cid, char *DateTime, struct tm *tm);
		//=====================================================
		//
		//	ОПИСАНИЕ:       Запрос времени на ТМ-сервере
		//
		//	ПАРАМЕТРЫ:      DateTime - адрес строки для выдачи времен в формате "ДД.ММ.ГГГГ ЧЧ:ММ:СС" или NULL
		//					tm       - адрес структуры tm (см. TIME.H) или NULL
		//
		//	ВОЗВРАТ:        SUCCESS - успех, FAILURE - ошибка
		//=====================================================
		[DllImport("tmconn.dll", EntryPoint = "tmcSystemTime", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		public static extern Int16 tmcSystemTime(Int32 cid, [MarshalAs(UnmanagedType.LPStr)] StringBuilder timeSB, [In] IntPtr timeStru);

		public static void GetSystemTime(Int32 cid, out string pTimeString)
		{
			StringBuilder sb = new StringBuilder(80);
			tmcSystemTime(cid, sb, IntPtr.Zero);
			pTimeString = sb.ToString();
		}

		public static DateTime GetSystemTime(Int32 cid)
		{
			string timeString;
			GetSystemTime(cid, out timeString);

			string[] parts = timeString.Split(new Char[] { ' ', ',', '.', ':' });
			int dd = Convert.ToInt32(parts[0]);
			int mm = Convert.ToInt32(parts[1]);
			int yy = Convert.ToInt32(parts[2]);
			int hh = Convert.ToInt32(parts[3]);
			int min = Convert.ToInt32(parts[4]);
			int sec = Convert.ToInt32(parts[5]);
			DateTime dt = new DateTime(yy,mm,dd,hh,min,sec);
			return dt;
		}

		//=====================================================
		// function tmcStatusFullEx(cid:Dword; Ch, RTU, Point: SmallInt; SP: pSP; Time:DWORD):SmallInt;
		//=====================================================
		
		[DllImport("tmconn.dll", EntryPoint = "tmcStatusFullEx", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		public static extern Int16 tmcStatusFullEx(Int32 cid, Int16 Ch, Int16 RTU, Int16 Point
			, [In, Out] ref TStatusPoint result
			, UInt32 unixTime
			);

		//=====================================================
		// TakeRetroTIT
		//=====================================================
		//{...}

		//=====================================================
		// void tmcAnalogByList(DWORD cid, short Quan, TADRtm *List, TAnalogPoint *APs, unsigned long Time, short RetroNum);
		// Max = ? // Непроверено
		//=====================================================

    public const int ANALOG_BY_LIST_MAX = 125; // 2000 / 16
		
		[DllImport("tmconn.dll", EntryPoint = "tmcAnalogByList", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		public static extern void tmcAnalogByList(Int32 cid, Int16 arraySize
			, [In] TAdrTm[] adrArray
			, [In, Out] TAnalogPoint[] resultArray
			, UInt32 unixTime
			, Int16 RetroNum
			);

    [DllImport("tmconn.dll", EntryPoint = "tmcAnalogByList", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
    public static extern void tmcAnalogByList(Int32 cid, Int16 arraySize
      , IntPtr adrArray
      , IntPtr resultArray
      , UInt32 unixTime
      , Int16 retroNum
      );

	  //=====================================================
		// void tmcAccumByList(DWORD cid, short Quan, TADRtm *List, TAccumPoint *AcPs, unsigned long Time);
		// Max = ? // Непроверено
		//=====================================================

    public const int ACCUM_BY_LIST_MAX = 200; // 2000 / 10

		[DllImport("tmconn.dll", EntryPoint = "tmcAccumByList", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		public static extern void tmcAccumByList(Int32 cid, Int16 arraySize
			, [In] TAdrTm[] adrArray
			, [In, Out] TAccumPoint[] resultArray
			, UInt32 unixTime
			);

    [DllImport("tmconn.dll", EntryPoint = "tmcAccumByList", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
    public static extern void tmcAccumByList(Int32 cid, Int16 arraySize
      , IntPtr adrArray
      , IntPtr resultArray
      , UInt32 unixTime
      );

    //=====================================================
		// void tmcStatusByListEx(DWORD cid, short Quan, TADRtm *List, TStatusPoint *SPs, unsigned long Time);
		// Max = 333 !!!!!!!
		//=====================================================

    public const int STATUS_BY_LIST_MAX = 333; // 2000 / 6

		[DllImport("tmconn.dll", EntryPoint = "tmcStatusByListEx", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		private static extern void tmcStatusByListEx(Int32 cid, Int16 arraySize
			, [In] TAdrTm[] adrArray
			, [In, Out] TStatusPoint[] resultArray
			, UInt32 unixTime
			);

		[DllImport("tmconn.dll", EntryPoint = "tmcStatusByListEx", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		private static extern void tmcStatusByListEx(Int32 cid, Int16 arraySize
			, [In] TAdrTm[] adrArray
			, IntPtr resultArray
			, UInt32 unixTime
			);

    [DllImport("tmconn.dll", EntryPoint = "tmcStatusByListEx", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
    public static extern void tmcStatusByListEx(Int32 cid, Int16 arraySize
      , IntPtr adrArray
      , IntPtr resultArray
      , UInt32 unixTime
      );

    #region Bonus

		public static void StatusByList(Int32 cid
			, TAdrTm[] adrArray
			, TStatusPoint[] resultArray
			, UInt32 unixTime
			)
		{
			if (adrArray.Length == 0) throw new Exception("Error");
      if (adrArray.Length != resultArray.Length) throw new Exception("Error");

			int count = adrArray.Length;

			if (count <= STATUS_BY_LIST_MAX)
				tmcStatusByListEx(cid, (Int16)count, adrArray, resultArray, unixTime);
			else
			{
				int startIndex = 0;
				while(startIndex < count)
				{
					int endIndex = Math.Min(startIndex + STATUS_BY_LIST_MAX - 1, count - 1);
					//---------
					StatusByList(cid, adrArray, resultArray, unixTime, startIndex, endIndex);
					//---------
					startIndex = endIndex + 1;
				}
			}
		}

		private static void StatusByList(Int32 cid
			, TAdrTm[] adrArray
			, TStatusPoint[] resultArray
			, UInt32 unixTime
			, int startIndex, int endIndex
			)
		{
			int count = endIndex - startIndex + 1;
			TAdrTm[] adrArray2 = new TAdrTm[count];
			Array.Copy(adrArray, startIndex, adrArray2, 0, count);

			IntPtr ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(TStatusPoint)) * count);

			try
			{
				IntPtr itemPtr = ptr;
				for (int I = 0; I < count; I++)
				{
					Marshal.StructureToPtr(resultArray[startIndex + I], itemPtr, false);
					itemPtr = (IntPtr)((long)itemPtr + Marshal.SizeOf(typeof(TStatusPoint)));
				}

				//-------------------------
				tmcStatusByListEx(cid, (Int16)count, adrArray2, ptr, unixTime);
				//-------------------------

				itemPtr = ptr;
				for (int I = 0; I < count; I++)
				{
					resultArray[startIndex + I] = (TStatusPoint)Marshal.PtrToStructure(itemPtr, typeof(TStatusPoint));
					Marshal.DestroyStructure(itemPtr, typeof(TStatusPoint));
					itemPtr = (IntPtr)((long)itemPtr + Marshal.SizeOf(typeof(TStatusPoint)));
				}
			}
			finally
			{
				Marshal.FreeCoTaskMem(ptr);
			}
		}

		#endregion

		//=====================================================
		// short __stdcall tmcControlByStatus(DWORD cid, short Ch, short RTU, short Point, short Cmd);
		//=====================================================
		// выдача команды телеуправления
		//	ПАРАМЕТРЫ:      Ch    - канал,
		//					RTU   - номер КП (с 1),
		//					Point - номер объекта (с 1)
		//					Cmd - команда ТУ (0-ОТКЛ, 1-ВКЛ)
		//
		//	ВОЗВРАТ:        1 - успех, иначе:
		//#define TMCTLERR_INVALID_ADDRESS	0
		//#define TMCTLERR_NO_RESOURCES		-1
		//#define TMCTLERR_TMSOURCE_FAILED	-2
		//#define TMCTLERR_WAIT_TIMEOUT		-3
		//#define TMCTLERR_CANNOT_REDIRECT	-4
		//#define TMCTLERR_NO_TMSOURCE		-5
		//=====================================================
		[DllImport("tmconn.dll", EntryPoint = "tmcControlByStatus", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Ansi)]
		public static extern Int16 tmcControlByStatus(Int32 cid, Int16 Ch, Int16 RTU, Int16 Point, Int16 Cmd);

		public static TmCommandReturnCode ControlByStatus(Int32 cid, Int16 Ch, Int16 RTU, Int16 Point, Int16 Cmd)
		{
			Int16 kz = tmcControlByStatus(cid, Ch, RTU, Point, Cmd);
			TmCommandReturnCode kz2;
			try 
			{ kz2 = (TmCommandReturnCode)Enum.Parse(typeof(TmCommandReturnCode), kz.ToString(), true); }
			catch 
			{ kz2 = TmCommandReturnCode.Error_UNKNOWN; }
			return kz2;
		}

		//=====================================================
		// short __stdcall tmcGetObjectName( DWORD cid ,WORD object_type, short Ch,short RTU, short Point
		//												,LPSTR buf, int buflen);
		//=====================================================
		[DllImport("tmconn.dll", EntryPoint = "tmcGetObjectName", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		public static extern Int16 tmcGetObjectName(Int32 cid, UInt16 object_type, Int16 Ch, Int16 RTU, Int16 Point
			, [MarshalAs(UnmanagedType.LPStr)] StringBuilder bufSb, Int32 buflen);

    // object_type >> TmObjectType
    public static string GetObjectName(Int32 cid, UInt16 object_type, Int16 Ch, Int16 RTU, Int16 Point)
		{
			StringBuilder sb = new StringBuilder(100);
			tmcGetObjectName(cid, object_type, Ch, RTU, Point, sb, 100);
			return sb.ToString();
		}

		//=====================================================
		//  short __stdcall tmcRegEvent(DWORD cid, TEvent *tmEvent);
		//=====================================================
		//	ОПИСАНИЕ:       регистрация события в ретроспективе
		//
		//	ПАРАМЕТРЫ:      tmEvent - указатель на структуру с событие
		//
		//	ВОЗВРАТ:        (1)SUCCESS - успех
		//					FAILURE - ошибка
		[DllImport("tmconn.dll", EntryPoint = "tmcRegEvent", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Auto)]
		public static extern void tmcRegEvent(Int32 cid, [In] ref TEvent tmEvent);
		public static void RegEvent(Int32 cid, TEvent tmEvent) { tmcRegEvent(cid, ref tmEvent); }

		//public static extern void tmcRegEvent(Int32 cid, [In] TEvent[] tmEvent);
		//public static void RegEvent(Int32 cid, TEvent tmEvent) { tmcRegEvent(cid, new TEvent[] { tmEvent }); }

		/*
		public static extern void tmcRegEvent(Int32 cid, [In] IntPtr tmEvent);
		public static void RegEvent(Int32 cid, TEvent tmEvent)
		{
			IntPtr ptr = Marshal.AllocCoTaskMem(100);
			Marshal.StructureToPtr(tmEvent, ptr, false);
			tmcRegEvent(cid, ptr);
			Marshal.FreeCoTaskMem(ptr);
		}
		*/

		//=====================================================
		// function tmcKeyReadScratchPad(key_type,port:Dword;key_id,scratch_pad:Pbyte):LongBool; 
		//=====================================================
		// key_id: // IN: byte[8] of zero // OUT:
		// scratch_pad: // IN: byte[64] of zero // OUT: sequence of 8-bit Windows (ANSI) character till zero or end
		[DllImport("tmconn.dll", EntryPoint = "tmcKeyReadScratchPad", CallingConvention = CallingConvention.StdCall)]
		public static extern bool tmcKeyReadScratchPad(UInt32 key_type, UInt32 port, IntPtr key_id, IntPtr scratch_pad);

		public static bool KeyReadScratchPad(UInt32 key_type, UInt32 port, out Int32 key_id, out byte[] scratch_pad)
		{
			string sss;
			return KeyReadScratchPad(key_type, port, out key_id, out scratch_pad, out sss);
		}

		public static bool KeyReadScratchPad(UInt32 key_type, UInt32 port, out Int32 key_id, out string scratch_pad)
		{
			byte[] sss;
			return KeyReadScratchPad(key_type, port, out key_id, out sss, out scratch_pad);
		}

		private static bool KeyReadScratchPad(UInt32 key_type, UInt32 port, out Int32 key_id, out byte[] scratch_pad1, out string scratch_pad2)
		{
			IntPtr ptr1 = Marshal.AllocCoTaskMem(8);
			IntPtr ptr2 = Marshal.AllocCoTaskMem(64);
			
			Marshal.WriteInt32(ptr1,0);
			Utils.WriteZero(ptr2, 64);

			//---------------------
			bool kz = tmcKeyReadScratchPad(key_type, port, ptr1, ptr2);
			//---------------------

			if(kz)
			{
				key_id = Marshal.ReadInt32(ptr1);

				scratch_pad1 = new byte[64];
				Marshal.Copy(ptr2, scratch_pad1, 0, 64);

				scratch_pad2 = Marshal.PtrToStringAnsi(ptr2, 64);
			}
			else
			{
				key_id = 0;
				scratch_pad1 = null;
				scratch_pad2 = null;
			}

			Marshal.FreeCoTaskMem(ptr1);
			Marshal.FreeCoTaskMem(ptr2);

			return kz;
		}

		//=====================================================
		// function tmcKeyReadSubkey(key_type,port:Dword;key_id,password,signature:Pbyte; sub_key_num:Byte;sub_key:PByte):LongBool;
		//=====================================================
		// key_id: // IN: byte[8]
		// password: // IN: null-terminated string of 8-bit Windows (ANSI) characters
		// signature: // IN: null-terminated string of 8-bit Windows (ANSI) characters
		// sub_key_num: [0..2]
		// sub_key: // IN: byte[48] of zero // OUT: sequence of 8-bit Windows (ANSI) character till zero or end
		[DllImport("tmconn.dll", EntryPoint = "tmcKeyReadSubkey", CallingConvention = CallingConvention.StdCall)]
		public static extern bool tmcKeyReadSubkey(UInt32 key_type, UInt32 port, IntPtr key_id, IntPtr password, IntPtr signature, Byte sub_key_num, IntPtr sub_key);

		public static bool KeyReadSubkey(UInt32 key_type, UInt32 port, Int32 key_id, string password, string signature, Byte sub_key_num, out byte[] sub_key)
		{
			IntPtr ptrKeyId = Marshal.AllocCoTaskMem(8);
			IntPtr ptrPassword = Marshal.StringToCoTaskMemAnsi(password);
			IntPtr ptrSignature = Marshal.StringToCoTaskMemAnsi(signature);
			IntPtr ptrSubKey = Marshal.AllocCoTaskMem(48);

			Marshal.WriteInt32(ptrKeyId, key_id);
			Utils.WriteZero(ptrSubKey, 48);

			//---------------------
			bool kz = tmcKeyReadSubkey(key_type, port, ptrKeyId, ptrPassword, ptrSignature, sub_key_num, ptrSubKey);
			//---------------------

			if(kz)
			{
				sub_key = new byte[48];
				Marshal.Copy(ptrSubKey, sub_key, 0, 48);
			}
			else
			{
				sub_key = null;
			}

			Marshal.FreeCoTaskMem(ptrKeyId);
			Marshal.FreeCoTaskMem(ptrPassword);
			Marshal.FreeCoTaskMem(ptrSignature);
			Marshal.FreeCoTaskMem(ptrSubKey);

			return kz;
		}

		//=====================================================
		// BYTE __stdcall tmcEnumObjects( DWORD cid ,WORD object_type,BYTE count,PWORD buf, short Ch,short RTU,short Point);
		//=====================================================
		// buf: // IN/OUT: WORD[] 
		[DllImport("tmconn.dll", EntryPoint = "tmcEnumObjects", CallingConvention = CallingConvention.StdCall)]
		public static extern Byte tmcEnumObjects(Int32 cid, UInt16 object_type, Byte count, IntPtr buf, Int16 Ch, Int16 RTU, Int16 Point);

		internal static void EnumRootObjects(Int32 cid, TmObjectType pObjectType, out Int16[] pIds)
		{
			switch(pObjectType)
			{
				case TmObjectType.TM_CHANNEL:
					EnumTags(cid, pObjectType, out pIds, 0, 0, 0);
					return;

				default:
          throw new Exception("Not implemented");
			}
		}

		internal static void EnumTags(Int32 cid, TmObjectType pObjectType, out Int16[] pIds, Int16 pTagPart1, Int16 pTagPart2, Int16 pTagPart3)
		{
			using (MarshalHelper helper = new MarshalHelper(2*255))
				EnumTags(helper, cid, pObjectType, out pIds, pTagPart1, pTagPart2, pTagPart3);
		}

		internal static void EnumTags(MarshalHelper pHelper, Int32 cid, TmObjectType pObjectType, out Int16[] pIds, Int16 pTagPart1, Int16 pTagPart2, Int16 pTagPart3)
		{
			pIds = null;

			IntPtr ptr1 = pHelper.Ptr1;

			List<Int16[]> iterList = new List<Int16[]>();
			int count;
			//---------------------
			while (true)
			{
				count = tmcEnumObjects(cid, (UInt16)pObjectType, 255, ptr1, pTagPart1, pTagPart2, pTagPart3);
				//---------------------
				if (count <= 0)
					break;
				//---------------------
				Int16[] ids = new Int16[count];
				Marshal.Copy(ptr1, ids, 0, count);
				iterList.Add(ids);

				int idNext = 1 + ids[ids.Length - 1];

				switch (pObjectType)
				{
          /*
          case TmObjectType.TM_CHANNEL: pTagPart1 += (Int16)count; break;
          case TmObjectType.TM_RTU: pTagPart2 += (Int16)count; break;

          case TmObjectType.TM_STATUS: pTagPart3 += (Int16)count; break;
          case TmObjectType.TM_ANALOG: pTagPart3 += (Int16)count; break;
          case TmObjectType.TM_ACCUM: pTagPart3 += (Int16)count; break;

          default:
            throw new Exception("Not implemented");
          */

          case TmObjectType.TM_CHANNEL:
						pTagPart1 = (Int16)idNext; 
						break;

					case TmObjectType.TM_RTU:
						pTagPart2 = (Int16)idNext;
						break;

					case TmObjectType.TM_STATUS:
					case TmObjectType.TM_ANALOG:
					case TmObjectType.TM_ACCUM:
						pTagPart3 = (Int16)idNext; 
						break;

					default:
            throw new Exception("Not implemented");
				}
			}
			//---------------------
			count = 0;
			for (int I = 0; I < iterList.Count; I++)
				count += iterList[I].Length;

			if (count > 0)
			{
				pIds = new Int16[count];

				int ix = 0;
				for (int I = 0; I < iterList.Count; I++)
				{
					iterList[I].CopyTo(pIds, ix);
					ix += iterList[I].Length;
				}
			}
		}

		internal static void EnumTags_Patched(MarshalHelper pHelper, Int32 cid, TmObjectType pObjectType, out Int16[] pIds, Int16 pTagPart1, Int16 pTagPart2, Int16 pTagPart3)
		{
			EnumTags(pHelper, cid, pObjectType, out pIds, pTagPart1, pTagPart2, pTagPart3);

			//patch
			if(pIds != null)
			{
				List<Int16> list = new List<Int16>(pIds.Length);
				foreach (Int16 id in pIds)
				{
					if(!list.Contains(id))
						list.Add(id);
				}
				pIds = list.ToArray();
			}
		}


    //=====================================================
    // short __stdcall tmcSetAnalog(DWORD cid, short Ch, short RTU, short Point, float Value, const char *DateTime);
    //=====================================================
    //	ОПИСАНИЕ:       задает значение объекта ТИТ
    //
    //	ПАРАМЕТРЫ:      Ch, RTU, Point - см. выше
    //					Value          - новое значение ТИТ (реальное число)
    //					DateTime       - опциональный параметр записи ТИТ
    //									 в ретроспективу в формате "ДД.ММ.ГГ ЧЧ:ММ:СС"
    //									 Если задается мгновенное значение, то
    //									 следует передать DateTime = NULL
    //
    //	ВОЗВРАТ:        SUCCESS - успех // 1
    //					FAILURE - ошибка // 0
    //=====================================================
    [DllImport("tmconn.dll", EntryPoint = "tmcSetAnalog", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Ansi)]
    public static extern Int16 tmcSetAnalog(Int32 cid, Int16 Ch, Int16 RTU, Int16 Point, Single Value, [MarshalAs(UnmanagedType.LPStr)] string DateTime);


	}

}