﻿using System;
using System.Runtime.InteropServices;
using System.Text;

namespace SSH.CP.TmsClient.Wraps
{
	public class Win32
	{
		public const UInt32 WAIT_OBJECT_0 = 0;
		public const UInt32 WAIT_TIMEOUT = 0x00000102;
		public const UInt32 WAIT_ABANDONED = 0x00000080;
		public const UInt32 WAIT_FAILED = 0xFFFFFFFF;

		//=====================================================
		// BOOL CharToOem(LPCTSTR lpszSrc,LPSTR lpszDst)
		//=====================================================
		[DllImport("user32")]
		public static extern bool CharToOem(string src, StringBuilder dst);

		public static string CharToOem(string pContent)
		{
			StringBuilder sb = new StringBuilder(pContent.Length + 10);
			if(CharToOem(pContent, sb))
			{
				return sb.ToString();
			}
			return null;
		}

		[DllImport("Kernel32.dll", EntryPoint = "GetCurrentProcessId", CallingConvention = CallingConvention.StdCall)]
		public static extern UInt32 GetCurrentProcessId();

		//=====================================================
		// DWORD WINAPI WaitForSingleObject(__in  HANDLE hHandle,__in  DWORD dwMilliseconds);
		//=====================================================
		[DllImport("Kernel32.dll", EntryPoint = "WaitForSingleObject", CallingConvention = CallingConvention.StdCall)]
		//public static extern UInt32 WaitForSingleObject(IntPtr hHandle, UInt32 dwMilliseconds);
		public static extern UInt32 WaitForSingleObject(UInt32 hHandle, UInt32 dwMilliseconds);

		//=====================================================
		// BOOL WINAPI SetEvent( __in  HANDLE hEvent);
		//=====================================================
		[DllImport("Kernel32.dll", EntryPoint = "SetEvent", CallingConvention = CallingConvention.StdCall)]
		//public static extern bool SetEvent(IntPtr hEvent);
		public static extern bool SetEvent(UInt32 hEvent);

		//=====================================================
		// HANDLE WINAPI CreateEvent( 
		//		__in_opt  LPSECURITY_ATTRIBUTES lpEventAttributes,
		//		__in      BOOL bManualReset,
		//		__in      BOOL bInitialState,
		//		__in_opt  LPCTSTR lpName
		// );
		//=====================================================
		[DllImport("Kernel32.dll", EntryPoint = "CreateEvent", CallingConvention = CallingConvention.StdCall)]
		//public static extern bool SetEvent(IntPtr hEvent);
		public static extern UInt32 CreateEvent(IntPtr lpEventAttributes, bool bManualReset, bool bInitialState, string lpName);
	}
}