﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace SSH.CP.Utils.ComponentModel
{
	public class PropComparer<TObject> : IComparer<TObject>
	{
		private readonly PropertyDescriptor mProp;
		private readonly ListSortDirection mDirection;

		public PropComparer(PropertyDescriptor pProp, ListSortDirection pDirection)
		{
			mProp = pProp;
			mDirection = pDirection;
		}

		public int Compare(TObject obj1, TObject obj2)
		{
			object value1 = mProp.GetValue(obj1);
			object value2 = mProp.GetValue(obj2);

			if(value1 == null)
				return value2 == null ? 0 : (mDirection.Equals(ListSortDirection.Descending) ? 1 : -1);

			if (value2 == null)
				return value1 == null ? 0 : (mDirection.Equals(ListSortDirection.Descending) ? -1 : 1);

			IComparable comparable1 = value1 as IComparable;
			if (comparable1 == null) return 0;

			if (mDirection == ListSortDirection.Ascending)
				return comparable1.CompareTo(value2);
			else
				return -comparable1.CompareTo(value2);
		}
	}
}
