﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Text;

namespace SSH.CP.Utils
{
	public static class DbValueConvert
	{
		public static int ToInt(object pValue) { return ToInt(pValue, 0); }
		public static int ToInt(object pValue, int pDefaultValue)
		{
			try
			{
				if ((pValue == null) || (pValue == DBNull.Value))
					return pDefaultValue;
				return Convert.ToInt32(pValue);
			}
			catch (Exception)
			{
				return pDefaultValue;
			}
		}

		public static double ToDouble(object pValue, double pDefaultValue)
		{
			try
			{
				if ((pValue == null) || (pValue == DBNull.Value))
					return pDefaultValue;

				try
				{
					return Double.Parse(pValue.ToString(), NumberStyles.Float, NumberFormatInfo.CurrentInfo);
				}
				catch (Exception)
				{
					return Double.Parse(pValue.ToString(), NumberStyles.Float, NumberFormatInfo.InvariantInfo);
				}
			}
			catch (Exception)
			{
				return pDefaultValue;
			}
		}

		public static string ToString(object pValue) { return ToString(pValue, null); }
		public static string ToString(object pValue, string pDefaultValue)
		{
			try
			{
				if ((pValue == null) || (pValue == DBNull.Value))
					return pDefaultValue;
				return Convert.ToString(pValue);
			}
			catch (Exception)
			{
				return pDefaultValue;
			}
		}
	
		public static bool ToBool(object pValue) { return ToBool(pValue, false); }
		public static bool ToBool(object pValue, bool pDefaultValue)
		{
			try
			{
				if ((pValue == null) || (pValue == DBNull.Value))
					return pDefaultValue;

				if(pValue.GetType() == typeof(string))
				{
					string s = (string)pValue;
					return (s.Length > 0) && ((s[0] == 't') || (s[0] == 'T') || (s[0] == '1'));
				}

				return Convert.ToBoolean(pValue);
			}
			catch (Exception)
			{
				return pDefaultValue;
			}
		}

		public static DateTime? ToNullableDateTime(object pValue)
		{
			try
			{
				if ((pValue == null) || (pValue == DBNull.Value))
					return null;
				return Convert.ToDateTime(pValue);
			}
			catch (Exception)
			{
				return null;
			}
		}

		public static Nullable<TEnumType> ToNullableEnum<TEnumType>(object pValue) where TEnumType : struct
		{
			try
			{
				if ((pValue == DBNull.Value) || (pValue == null))
					return null;
				return (TEnumType)Enum.Parse(typeof(TEnumType), pValue.ToString());
			}
			catch (Exception)
			{
				return null;
			}
		}

		public static TEnumType ToEnum<TEnumType>(object pValue) where TEnumType : struct { return ToEnum<TEnumType>(pValue, default(TEnumType)); }
		public static TEnumType ToEnum<TEnumType>(object pValue, TEnumType pDefaultValue) where TEnumType : struct
		{
			try
			{
				if ((pValue == DBNull.Value) || (pValue == null))
					return pDefaultValue;
				return (TEnumType)Enum.Parse(typeof(TEnumType), pValue.ToString());
			}
			catch (Exception)
			{
				return pDefaultValue;
			}
		}
		public static object ToEnum(Type pEnumType, object pValue, object pDefaultValue)
		{
			try
			{
				if ((pValue == DBNull.Value) || (pValue == null))
					return pDefaultValue;
				return Enum.Parse(pEnumType, pValue.ToString());
			}
			catch (Exception)
			{
				return pDefaultValue;
			}
		}

	}
}
