﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;

namespace SSH.CP.Utils
{
	public delegate string EnumTitleGetter(Enum pValue);

	public static class EnumFns
	{
		public static DataTable CreateEnumTable<TEnumType>() where TEnumType : struct
		{ return CreateEnumTable<TEnumType>(Enum.GetUnderlyingType(typeof(TEnumType)), null, false); }

		public static DataTable CreateEnumTable<TEnumType>(EnumTitleGetter pGetter) where TEnumType : struct
		{ return CreateEnumTable<TEnumType>(Enum.GetUnderlyingType(typeof(TEnumType)), pGetter, false); }

		public static DataTable CreateEnumTable<TEnumType>(EnumTitleGetter pGetter, bool pWithNull) where TEnumType : struct
		{ return CreateEnumTable<TEnumType>(Enum.GetUnderlyingType(typeof(TEnumType)), pGetter, pWithNull); }

		public static DataTable CreateEnumTable<TEnumType>(Type pIdColumnType, EnumTitleGetter pGetter, bool pWithNull) where TEnumType : struct
		{
			Type enumType = typeof(TEnumType);
			//------
			DataTable table = new DataTable();
			DataColumn idColumn = table.Columns.Add("Id", pIdColumnType);
			table.Columns.Add("Name", typeof(System.String));
			//------
			if (pWithNull)
				table.Rows.Add(DBNull.Value, " "); // "" = Error!
			else
				table.PrimaryKey = new DataColumn[] { idColumn };
			//------
			foreach (int i in Enum.GetValues(enumType))
			{
				string title = null;
				if(pGetter != null)
				{
					Enum value = (Enum)Enum.ToObject(enumType, i);
					title = pGetter(value);
				}
				if(title == null)
					title = Enum.GetName(enumType, i);
				table.Rows.Add(i, title);
			}
			//------
			return table;
		}
	}
}
