﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SSH.CP.Utils
{
	public class EnumTranslator
	{
		#region

		private static EnumTranslator msInstance;
		public static EnumTranslator Instance
		{
			get
			{
				if(msInstance == null)		
					msInstance = new EnumTranslator();
				return msInstance;
			}
		}
		#endregion

		private readonly Dictionary<Type, Dictionary<Enum, string>> _types = new Dictionary<Type, Dictionary<Enum, string>>();

		public void Register(Enum value, string name)
		{
			Type type = value.GetType();

			Dictionary<Enum, string> values;
			if (!_types.TryGetValue(type, out values))
			{
				values = new Dictionary<Enum, string>();
				_types.Add(type, values);
			}

			if(!values.ContainsKey(value))
				values.Add(value, name);
		}

		public string GetName(Enum value)
		{
			Type type = value.GetType();

			Dictionary<Enum, string> values;
			if (_types.TryGetValue(type, out values))
			{
				string name;
				if (values.TryGetValue(value, out name))
					return name;
			}
			return Enum.GetName(type, value);
		}

		public object NameToValue(Type enumType, string name)
		{
			Dictionary<Enum, string> values;
			if (_types.TryGetValue(enumType, out values))
				foreach (KeyValuePair<Enum, string> pair in values)
					if (String.Equals(pair.Value, name, StringComparison.OrdinalIgnoreCase))
						return pair.Key;

			return Enum.Parse(enumType, name);
		}
	}
}
