﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SSH.CP.Utils
{
	public static class ExceptionFns
	{
		public static string ParseException(Exception pException)
		{
			string s;
			ParseException(pException, out s);
			return s;
		}


		public static void ParseException(Exception pException, out string pMessage)
		{
			StringBuilder sb = new StringBuilder();
			sb.AppendLine(pException.Message);

			// 22 july 2010
			sb.AppendLine("----- StackTrace (BEG) ---------");
			sb.AppendLine(pException.StackTrace);
			sb.AppendLine("----- StackTrace (END) ---------");

			Exception exc = pException.InnerException;
			while (exc != null)
			{
				sb.AppendLine(exc.Message);
				exc = exc.InnerException;
			}
			pMessage = sb.ToString();
		}
	}
}