﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SSH.CP.Utils
{
	public enum GeneralExceptionCode
	{
		Undefined,
		DialogCancel
	}

	[Serializable]
	public class GeneralException : Exception
	{
		#region Fields
		private readonly GeneralExceptionCode mCode;
		#endregion

		#region Ctor
		public GeneralException(string pMessage) 
			: this(GeneralExceptionCode.Undefined, pMessage, null) { }
		
		public GeneralException(string pMessage, Exception pInnerException) 
			: this(GeneralExceptionCode.Undefined, pMessage, pInnerException) { }

		public GeneralException(GeneralExceptionCode pCode, string pMessage, Exception pInnerException)
			: base(pMessage, pInnerException)
		{
			mCode = pCode;
		}
		#endregion

		#region Props
		public GeneralExceptionCode Code { get { return mCode; } }
		#endregion
	}

	[Serializable]
	public class AbortException : GeneralException
	{
		#region Ctor
		public AbortException(string pMessage)
			: this(GeneralExceptionCode.DialogCancel, pMessage) { }

		public AbortException(GeneralExceptionCode pCode, string pMessage)
			: base(pCode, pMessage, null) { }
		#endregion
	}

	[Serializable]
	public class ConnectException : GeneralException
	{
		#region Fields
		private readonly bool mAutoConnectionPossible;
		#endregion

		#region Ctor
		public ConnectException(string pMessage, bool pAutoConnectionPossible)
			: this(GeneralExceptionCode.Undefined, pMessage, null, pAutoConnectionPossible) { }

		public ConnectException(GeneralExceptionCode pCode, string pMessage, Exception pInnerException, bool pAutoConnectionPossible)
			: base(pCode, pMessage, pInnerException)
		{
			mAutoConnectionPossible = pAutoConnectionPossible;
		}
		#endregion

		#region Props
		public bool AutoConnectionPossible { get { return mAutoConnectionPossible; } }
		#endregion
	}
}