using System;
using System.Collections.Generic;
using System.Text;

namespace SSH.CP.Utils
{
	public class WeakReference<T> where T : class
	{
		public WeakReference(T pObject)
		{
			mRefObject = new WeakReference(pObject);
		}
		public T Value
		{
			get
			{
				return (T)mRefObject.Target;
			}
			set
			{
				mRefObject.Target = value;
			}
		}
		public bool IsAlive
		{
			get
			{
				return mRefObject.IsAlive;
			}
		}
		private WeakReference mRefObject;
	}
}
