﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Security.Permissions;
using System.Text;

namespace SSH.CP.Utils.Win32
{
	[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
	public struct InterDataTest
	{
		public int size;
		public Int32 d1;
		public Int32 d2;
		public Int32 d3;
	}

	[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
	public struct InterDataStruct
	{
		public int DataSizeInBytes;

		[MarshalAs(UnmanagedType.LPStr)]
		public string Message;
	}

	public static class WinApi
	{
		[DllImport("user32")]
		public static extern int RegisterWindowMessage(string message);

		public static int RegisterWindowMessage(string format, params object[] args)
		{
			string message = String.Format(format, args);
			return RegisterWindowMessage(message);
		}

		public const int HWND_BROADCAST = 0xffff;
		//Example: WinApi.SendMessage((IntPtr)WinApi.HWND_BROADCAST, ...

		public const int SW_SHOWNORMAL = 1;
		public const int SW_SHOW = 5;
		public const int SW_SHOWNA = 8;

		[DllImport("user32")]
		public static extern bool SendMessage(IntPtr hwnd, int msg, IntPtr wparam, IntPtr lparam);

		[DllImport("user32", CharSet = CharSet.Ansi)]
		public static extern bool SendMessage(IntPtr hwnd, int msg, IntPtr wparam, [In()] ref InterDataStruct lparam);

		[DllImport("user32", CharSet = CharSet.Ansi)]
		public static extern bool SendMessage(IntPtr hwnd, int msg, IntPtr wparam, ref InterDataTest lparam);

		[DllImport("user32", CharSet = CharSet.Ansi)]
		public static extern bool SendMessage(IntPtr hwnd, int msg, IntPtr wparam, [MarshalAs(UnmanagedType.LPStr)] string lparam);

		[SecurityPermission(SecurityAction.Demand, UnmanagedCode = true)]
		public static bool SendMessage(IntPtr hwnd, int msg, string lparam)
		{
			string ss = "123qwe";
			IntPtr ptr = Marshal.StringToCoTaskMemAnsi(ss);
			//IntPtr ptr = Marshal.StringToHGlobalAnsi("123qwe");
			//IntPtr ptr = Marshal.StringToBSTR(lparam);

/*
			string data = "123qwe";

			GCHandle gch = GCHandle.Alloc(data, GCHandleType.Pinned);
			IntPtr ptr = GCHandle.ToIntPtr(gch);
*/

			try
			{
				//return SendMessage(hwnd, msg, IntPtr.Zero, ptr);
				SendMessage(hwnd, msg, IntPtr.Zero, ptr);
				string sss = ss;
				return true;
			}
			finally
			{
				//gch.Free();
				//Marshal.FreeCoTaskMem(ptr);
				//Marshal.FreeBSTR(ptr);
			}
		}

		[DllImportAttribute("user32.dll")]
		public static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);

		[DllImportAttribute("user32.dll")]
		public static extern bool SetForegroundWindow(IntPtr hWnd);

		public static void ShowToFront(IntPtr window)
		{
			ShowWindow(window, SW_SHOWNORMAL);
			SetForegroundWindow(window);
		}
	}
}
