﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace SSH.CP.WinForms
{
	public static class ControlFns
	{
		public static void BeginInvoke(Control pDispatcher, Delegate pAction, params object[] pParams)
		{
			if (pDispatcher.InvokeRequired)
			{
				if (pParams != null)
					pDispatcher.BeginInvoke(pAction, pParams);
				else
					pDispatcher.BeginInvoke(pAction);
			}
			else
			{
				if (pParams != null)
					pAction.DynamicInvoke(pParams);
				else
					pAction.DynamicInvoke();
			}
		}
		public static void Invoke(Control pDispatcher, Delegate pAction, params object[] pParams)
		{
			if (pDispatcher.InvokeRequired)
			{
				if (pParams != null)
					pDispatcher.Invoke(pAction, pParams);
				else
					pDispatcher.Invoke(pAction);
			}
			else
			{
				if (pParams != null)
					pAction.DynamicInvoke(pParams);
				else
					pAction.DynamicInvoke();
			}
		}
	}
}
