using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SSH.CP.Utils;

namespace SSH.CP.WinForms
{
	public partial class ExceptionForm : Form
	{
		#region Static Methods

		public static void ProcessException(Exception pException)
		{ ProcessException(pException, false, true); }

		public static void ProcessException(Exception pException, bool pExitEnabled, bool pContinueEnabled)
		{
			GeneralException generalException = pException as GeneralException;
			if ((generalException != null) && (generalException.Code == GeneralExceptionCode.DialogCancel))
				return;

			//if (pException is AbortException) return;

			ExceptionForm frm = new ExceptionForm(pException, pExitEnabled, pContinueEnabled);
			frm.ShowDialog();
		}
		#endregion

		#region Fields
		private bool mDetailMode;
		private int mHeightMax;
		#endregion

		#region Ctor
		private ExceptionForm(Exception pException, bool pExitEnabled, bool pContinueEnabled)
		{
			InitializeComponent();

			string str = pException.Message;
			string sDetails = pException.StackTrace;

			Exception exc = pException.InnerException;
			while (exc != null)
			{
				str = String.Concat(str, "\r\n", exc.Message);
				sDetails = String.Concat(sDetails, "\r\n\r\n", exc.StackTrace);

				exc = exc.InnerException;
			}
			_MessageTextBox.Text = str;
			_DetailsTextBox.Text = sDetails;

			_ExitButton.Enabled = pExitEnabled;
			_ContinueButton.Enabled = pContinueEnabled;

			mHeightMax = Height;
			mDetailMode = false;

			UpdateForm();
		}
		#endregion

		private void UpdateForm()
		{
			if (mDetailMode)
				Height = Math.Max(mHeightMax, _SplitContainer.SplitterDistance + 32 + 150);
			else
				Height = _SplitContainer.SplitterDistance + 32;
		}

		private void Form_Shown(object sender, EventArgs e)
		{
			if (_ContinueButton.Enabled)
				_ContinueButton.Focus();
			else if (_ExitButton.Enabled)
				_ExitButton.Focus();
		}

		private void _DetailsButton_Click(object sender, EventArgs e)
		{
			if (WindowState == FormWindowState.Normal)
			{
				if (mDetailMode)
					mHeightMax = Height;
				//---
				mDetailMode = !mDetailMode;
				UpdateForm();
			}
		}

		private void _ContinueButton_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}

		private void _ExitButton_Click(object sender, EventArgs e)
		{
			Application.Exit();
		}
	}
}