﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace SSH.CP.WinForms
{
	public static class GridFns
	{
		public static void StyleGridToAlternatingRows(DataGridView pGridView)
		{
			if (pGridView == null) return; // Can't style it; perhaps should blow?
			pGridView.AlternatingRowsDefaultCellStyle = AltRowsDefaultCellStyle;
		}

		public static void StyleGridToStandard(DataGridView pGridView)
		{
			if (pGridView == null) return; // Can't style it; perhaps should blow?
			pGridView.AllowUserToOrderColumns = true;
			//pGridView.RowHeadersVisible = false; // Turn off the leftmost column with row selected indicator //new
			pGridView.BackgroundColor = BackgroundColor; //new

			pGridView.AlternatingRowsDefaultCellStyle = AltRowsDefaultCellStyle; //new

			pGridView.EnableHeadersVisualStyles = false; // essential or the following don't work //new
			pGridView.BorderStyle = BorderStyle.None; //new
			pGridView.ColumnHeadersBorderStyle = DataGridViewHeaderBorderStyle.Single; //new
			pGridView.ColumnHeadersDefaultCellStyle = ColumnHeadersDefaultCellStyle; //new

		}

		#region Application Style Elements
		// ToDo: Acquire these styles through a service

		/// <summary>Get a new, configured ColumnHeadersDefaultCellStyle.</summary>
		public static DataGridViewCellStyle ColumnHeadersDefaultCellStyle
		{
			get
			{
				DataGridViewCellStyle style = new DataGridViewCellStyle();
				style.Alignment = DataGridViewContentAlignment.TopCenter; //MiddleLeft;
				style.BackColor = HeaderBackColor;
				style.ForeColor = HeaderForeColor;
				style.SelectionBackColor = HeaderSelectionBackColor;
				style.SelectionForeColor = HeaderSelectionForeColor;
				style.Font = StandardFont;
				style.WrapMode = DataGridViewTriState.True;
				return style;
			}
		}

		private static DataGridViewCellStyle AltRowsDefaultCellStyle
		{
			get
			{
				DataGridViewCellStyle style = new DataGridViewCellStyle();
				style.BackColor = AltBackColor;
				style.ForeColor = AltForeColor;
				return style;
			}
		}

		// ToDo: Put the following constants in separate Constants class

		// Colors
		/// <summary>Standard grid background color.</summary>
		public static Color BackgroundColor { get { return Color.White; } }
		/// <summary>Standard cell  background color.</summary>
		public static Color BackColor { get { return Color.White; } }
		/// <summary>Standard cell  text color.</summary>
		public static Color ForeColor { get { return SystemColors.WindowText; } }
		/// <summary>Standard alternate row cell  background color.</summary>
		public static Color AltBackColor { get { return Color.Beige; } }
		/// <summary>Standard alternate row cell  text color.</summary>
		public static Color AltForeColor { get { return SystemColors.WindowText; } }
		/// <summary>Standard selected cell background color.</summary>
		public static Color SelectionBackColor { get { return SystemColors.Highlight; } }
		/// <summary>Standard selected cell text color.</summary>
		public static Color SelectionForeColor { get { return SystemColors.HighlightText; } }
		/// <summary>Standard grid header cell background color.</summary>
		public static Color HeaderBackColor { get { return SystemColors.InactiveCaptionText; } }
		/// <summary>Standard grid cell text color.</summary>
		public static Color HeaderForeColor { get { return SystemColors.WindowText; } }
		/// <summary>Standard grid selected header cell color.</summary>
		public static Color HeaderSelectionBackColor { get { return SystemColors.Highlight; } }
		/// <summary>Standard grid selected header text color.</summary>
		public static Color HeaderSelectionForeColor { get { return SystemColors.HighlightText; } }

		// Text
		/// <summary>Standard grid font.</summary>
		public static Font StandardFont
		{
			get
			{
				return new Font(
				"Microsoft Sans Serif", 8.25F, FontStyle.Regular,
				GraphicsUnit.Point, (0));
			}
		}
		#endregion

		// CodeGround Note: The Following is taked from  DotNetGridBuilderBase
		// todo: remove

		/// <summary>Get the pixel size of this text if it were in a ColumnHeader.</summary>
		public static int MeasureColumnHeaderTextLength(DataGridView pGridView, string pText)
		{
			int result;
			using (Graphics g = pGridView.CreateGraphics())
			{
				SizeF w = g.MeasureString(pText, pGridView.ColumnHeadersDefaultCellStyle.Font);
				result = Convert.ToInt32(w.Width);
			}
			return result;
		}
	}
}
