program SampleET;

{$APPTYPE CONSOLE}
uses
  SysUtils,
  Types,
  Windows,
  tmconn in 'tmconn.pas',
  tma_defs in 'tma_defs.pas',
  cfsShare in 'cfsShare.pas',
  MainUnit in 'MainUnit.pas';

var
lpszServerTypeString: array[0..200] of Char;
lpszServerTraceName: array[0..200] of Char;
hStartEvent, hStopEvent: DWORD;
TraceServer: TRACE_ITEM_STORAGE;
argc, i: Integer;
argv: array[0..9] of PChar;
s_argv: array[0..9] of string;
Cnt1, tmCid, cfsConn: Integer;
ServerTime: array[0..80] of Char;
errs: array[0..512] of Char;
pipeName, machineName, cfgFileName, localCfgFileName: string;
err: Cardinal;
ft: FILETIME;

exports
lpszServerTypeString, lpszServerTraceName;

label Stop;
begin
StrCopy(lpszServerTypeString, oikFullTaskName);
StrCopy(lpszServerTraceName,  oikShortTaskName);
strac_AllocServer(TraceServer, GetCurrentProcessId(), 0,
                  lpszServerTraceName, lpszServerTypeString);
strac_SetServerState(TraceServer, TRS_SRV_STARTING);

argc := ParamCount+1; if argc > 10 then argc := 10;
for i := 0 to Pred(argc) do
    begin
    s_argv[i] := ParamStr(i);
    argv[i]   := PChar(s_argv[i]);
    end;

cfsPmonLocalRegisterProcess(argc, @argv[0], hStartEvent, hStopEvent);

if hStopEvent = 0 then
   begin
   e_printf('Cannot create stop event!\n', 0,0,0,0,0);
   goto Stop;
   end;
if hStartEvent <> 0 then
    begin
    if SetEvent(hStartEvent) then
        m_printf(' '#10, 0,0,0,0,0)
      else
        begin
        e_printf('Couldn''t fire start event!\n', 0,0,0,0,0);
        goto Stop;
        end;
    end
  else
    begin
    e_printf('Cannot create start event!\n', 0,0,0,0,0);
    goto Stop;
    end;
//--------------  ------------------
//   : SampleET TMS \\OIK
//    TMS -  
//    \\OIK -  
//
//      -   
//  
//
tmCid := INVALID_HANDLE_VALUE;
if argc > 1 then
    begin
    pipeName := StrPas(argv[1]);
    if (argc > 2) then
        machineName := StrPas(argv[2])
      else
        machineName := '.';
    if Copy(machineName, 0, 2) <> '\\' then
        machineName := '.';
    end
  else
    begin
    e_printf('     '#10, 0,0,0,0,0);
    exit;
    end;
ServerTime[0] := #0;
tmCid := tmcConnect(PChar(machineName), PChar(pipeName), nil, nil, nil);
if (tmCid > 0) then tmcSystemTime(tmCid, ServerTime, 0);
if (tmCid <= 0) or (tmcIsConnected(tmCid) = 0) then
    begin
    e_printf('     %s   %s'#10,
        Cardinal(PChar(pipeName)), Cardinal(PChar(machineName)),0,0,0);
    exit;
    end;
//----------------     ----------------------------
cfgFileName := '';
for Cnt1 := 1 to Pred(argc) do
    begin
    if StrLIComp(argv[Cnt1], '/f', 2) = 0 then
        begin
        cfgFileName := StrPas(argv[Cnt1]+2);
        break;
        end;
    end;
if cfgFileName = '' then
    begin
    cfgFileName := '_'+ChangeFileExt(ExtractFileName(argv[0]), '.cfg')
    end;
cfsConn := cfsConnect(PChar(machineName), err, errs, 512);
if cfsConn > 0 then
    begin
    localCfgFileName := '.\SampleETcfg.tmp';
    if(cfsFileGet(cfsConn,
                  PChar('TM_SERVER'+'\'+pipeName+'\'+cfgFileName),
                  PChar(localCfgFileName),
                  60000,ft,err,errs,512) = 0) then
        begin
        e_printf('    %s   %s (%s)!'#10,
            Cardinal(PChar(cfgFileName)),
            Cardinal(PChar(machineName)),
            Cardinal(@errs[0]),
            0,0);
        cfsDisconnect(cfsConn);
        localCfgFileName := '';
        end;
    cfsDisconnect(cfsConn);
    end
  else
    begin
    e_printf('        %s',
        Cardinal(PChar(machineName)),
        0,0,0,0);
    localCfgFileName := '';
    end;
//------------------------------------------------------------------------------

strac_SetServerState(TraceServer, TRS_SRV_RUNNING);
RunTask(hStartEvent, hStopEvent, tmCid, localCfgFileName);
m_printf(' '#10, 0,0,0,0,0);
strac_SetServerState(TraceServer, TRS_SRV_STOPPING);
if tmCid <> INVALID_HANDLE_VALUE then
    begin
    tmcDisconnect(tmCid);
    end;
Stop:
  ;
end.
