unit tmconn;
interface
uses
    Windows, tma_defs;
const
    ERROR_TM_NOT_CONNECTED: Dword = $c0001;

    RETRO_STATUS_ELEMENT = $3153;
    RETRO_ANALOG_ELEMENT = $314e;
    RETRO_ACCUM_ELEMENT  = $3143;

    RETROFLAG_COMMON	=       1;
    RETROFLAG_ARCHIVE	=       2;

    BAlarmSignMask             =           $0001;
    BAlarmSignShift            =           0;
    BAlarmSensibilityMask      =           $00fe;
    BAlarmSensibilityShift     =           1;
    BAlarmActiveMask           =           $0300;
    BAlarmActiveShift          =           8;
    BAlarmInUseMask            =           $0c00;
    BAlarmInUseShift           =           10;
    BAlarmImportanceMask       =           $f000;
    BAlarmImportanceShift      =           12;
    MaxAlarms                  =           40;

    TM_S_UNK:            string = '<?>';
    TM_S_ERR:            string = '<ERR>';
    DELTA_ITEM_DESCRIPTION =           0;
    DELTA_ITEM_TIME =                  1;
    DELTA_ITEM_STATUS =                2;
    DELTA_ITEM_ANALOG =                3;
    DELTA_ITEM_ACCUM =                 4;
    DELTA_ITEM_CONTROL =               5;
    DELTA_ITEM_ANALOGF =               6;
    DELTA_ITEM_ACCUMF =                7;

    DELTA_ITEMF_RELIABLE =             1;
    DELTA_ITEMF_ZEROENUM =             2;
    DELTA_ITEMF_DESTRELI =             4;
    DELTA_ITEMF_DESTVAL =              8;
    DELTA_ITEMF_HEX =                  $10;
    DELTA_ITEMF_GROUP8 =               $20;
    DELTA_ITEMF_N_PRSNT =              $40;

    DNT_TRACE_ERROR =    	       0;
    DNT_TRACE_MSG =		       1;
    DNT_TRACE_DEBUG =		       2;
    DNT_TRACE_TM_IN =		       3;
    DNT_TRACE_TM_OUT =	               4;
    DNT_TRACE_S_IN =		       5;
    DNT_TRACE_S_OUT =		       6;

    DNT_NODE_DRIVER =		       0;
    DNT_NODE_ADAPTER =	               1;
    DNT_NODE_PORT =		       2;
    DNT_NODE_RTU =		       3;
    DNT_NODE_ARRAY =		       4;
    DNT_NODE_BLOCK =		       5;

    TMS_ACCESS_TM_READ		       = $00000001;
    TMS_ACCESS_STATUS_CHANGE	       = $00000002;
    TMS_ACCESS_ANALOG_CHANGE	       = $00000004;
    TMS_ACCESS_ACCUM_CHANGE	       = $00000008;
    TMS_ACCESS_TELECONTROL	       = $00000010;
    TMS_ACCESS_RETRO_VIEW	       = $00000020;
    TMS_ACCESS_LOG_VIEW		   = $00000040;
    TMS_ACCESS_ALARM_CHANGE	   = $00000080;
    TMS_ACCESS_TM_SOURCE	       = $00000100;
    TMS_ACCESS_TMSRC_DIALOG	   = $00000200;
    MAX_TMS_CONFIG                = 33;
    SIPF_UNIQ_USERS_COUNT	       = 1;
    SIPF_TM_VALUE_COUNT		   = 2;

    MAP_COMMAND_SUPPORTED		=0;
    MAP_COMMAND_ACKNOWLEDGE		=1;
    MAP_COMMAND_SET_BRIGHTNESS	        =2;
    MAP_COMMAND_ON_MODE			=3;
    MAP_COMMAND_OFF_MODE		=4;
    MAP_COMMAND_NORMAL_MODE		=5;
    MAP_COMMAND_DARK_MODE               =8;
    MAP_COMMAND_STNORM_MODE		=9;

    TMS_BACKUP_CONFIG                   =1;
    TMS_BACKUP_ARRAY                    =2;
    TMS_BACKUP_EVLOG                    =4;
    TMS_BACKUP_ALARMS                   =8;
    TMS_BACKUP_RETRO                    =$10;
    TMS_BACKUP_SECURITY                 =$20;
    RBS_BACKUP_BASES	                =1;
    RBS_BACKUP_SECURITY                 =2;

    _LIKE_:        Word = 1;
    _LE_:          Word = 2;
    _LT_:          Word = 3;
    _GE_:          Word = 4;
    _GT_:          Word = 5;
    _EQ_:          Word = 6;
    _BETWEEN_:     Word = 8;
    _NULL_:        Word = 9;

{$ALIGN OFF}
type
    TUnitedAddr = record
        Point: Word;
        RTU:   Byte;
        Ch:    Byte;
    end;

    TAnalogPointShort = record
        Value:   Single;
        Flags:   Word;
    end;

    TAnalogQueueRecord = record
	    fix_time:   Dword;
	    tm_time:    Dword;
	    chn:        Word;
	    rtu:        Word;
	    point:      Word;
	    asCode:     Word;
	    asFloat:    Single;
	    flags:      Word;
    end;

   ANALOG_QUEUE_FIND = record
       Storage: array [0..255] of char;
   end;
   TBaseObjectInfo = record
	level:  Word;
	a: array[0..3] of Word;
	name: PChar;
   end;

   TRetroStatusElement = record
        Flags: Word;
        Status:Word;
   end;

   TRetroAnalogElement = record
        Flags: Word;
        asFloat:Single;
        asCode:SmallInt;
   end;

    TRetroAccumElement = record
        Flags: Word;
        Value: Single;
        Load:  Single;
    end;

    TTelemetrySource =record
            Id:      Dword;
            Name:    array[0..63] of Char;
    end;

    TServerInfo = record
	    Description:    array[0..63] of Char;
	    dwType:         Dword;
	    dwHeapUsage:    Dword;
    	dwWSMin:        Dword;
	    dwWSMax:        Dword;

	    HandleCount:    Dword;
	    StartTime:      Dword;
        ConfChangeTime: Dword;
	    ThreadCount:    Dword;

        UserCount:      Dword;
	    LogonCount:     Dword;

        PresenceFlags:  Dword;
        UniqUserCount:  Dword;
        TmValueCount:   Dword;
	    reserverd:      array [0..26] of Dword;
    end;

    TServerConfig = record
	    dwNumber:   Dword;
	    szName:     array[0..31] of Char;
    end;
    TPreRestoreServer = record
            dwFreeSpace: Dword;
            dwErr:       Dword;
            reserved:    array [0..13] of Dword;
	    ErrorString: array [0..511] of Char;
    end;

    DeltaStatus = record
    	item_type:      Byte;
	    length:         Byte;
	    number:         Word;
	    lastUpdate:     Integer;
	    flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;
    	value:          Byte;
    end;
    DeltaAnalog = record
    	item_type:      Byte;
	    length:         Byte;
	    number:         Word;
	    lastUpdate:     Integer;
	    flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;
    	value:          Integer;
    end;

    DeltaAnalogF = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	value:          Single;
    end;
    DeltaAccum = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	value:          Integer;
    end;
    DeltaAccumF = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;

	value:          Single;
    end;
    DeltaControl = record
	item_type:      Byte;
	length:         Byte;
	number:         Word;
	lastUpdate:     Integer;
	flags:          Word;
        tmsChn:         Word;
        tmsRtu:         Word;
        tmsPoint:       Word;
	ctrlBlock:      Word;
	ctrlGroup:      Word;
	ctrlPoint:      Word;
    end;

    DeltaTime = record
	item_type:      Byte;
	length:         Byte;
        curtime:        Integer;
    end;
    DeltaDescription = record
	item_type:      Byte;
	length:         Byte;
	text:           Char;
    end;
    TCallBackEvent = procedure(count:Dword;buf:PByte;param:Pointer); stdcall;
    TTcCallback = function(cid:Dword;Param:Pointer;estr:PChar):Integer; stdcall;
    TTmcProgressEvent = procedure(count:Dword;str:PChar;param:Pointer); stdcall;
    TEventExCriteria = record
    	ItemsLimit:     Dword;
	MemoryLimit:    Dword;
	hStop:          Dword; //handle
	Interrupted:    LongBool;
    end;
{$ALIGN ON}

    pUnitedAddr  = ^TUnitedAddr;
    pServerInfo  = ^TServerInfo;
    pAPShort     = ^TAnalogPointShort;
    pAQRecord    = ^TAnalogQueueRecord;
    pRetroStatusElement = ^TRetroStatusElement;
    pRetroAnalogElement = ^TRetroAnalogElement;
    pRetroAccumElement = ^TRetroAccumElement;
    pBaseObjectInfo = ^TBaseObjectInfo;
    pEventExCriteria = ^TEventExCriteria;
var
    hf_l:     LongInt = $7f7fffff;
    huge_flt: Single absolute hf_l;

procedure cfsSetUser(name,pwd:PChar);
          stdcall; external 'cfshare.dll' name 'cfsSetUser'
procedure cfsGetUser(name:PChar;namelen:DWORD;pwd:PChar; pwdlen:DWORD);
          stdcall; external 'cfshare.dll' name 'cfsGetUser'

function  cfsAllocMemory(bytes:DWORD ):Pointer;
          stdcall; external 'cfshare.dll' name 'cfsAllocMemory'
procedure cfsFreeMemory(p:Pointer);
          stdcall; external 'cfshare.dll' name 'cfsFreeMemory'
function  cfsEnumDomains:PChar;	// should be freed
          stdcall; external 'cfshare.dll' name 'cfsEnumDomains'
function  cfsGetUserSid(Domain:PChar;User:PChar):Pointer; // should be freed
          stdcall; external 'cfshare.dll' name 'cfsGetUserSid'
function  cfsGetUserNameFromSid(Sid:Pointer;Domain:Pchar):Pchar; // should be freed
          stdcall; external 'cfshare.dll' name 'cfsGetUserNameFromSid'
function  cfsPrintUserSid(Sid:Pointer):Pchar;	// should be freed
          stdcall; external 'cfshare.dll' name 'cfsPrintUserSid'
function  cfsEnumDomainUsers(Domain:PChar):PChar;	// should be freed
          stdcall; external 'cfshare.dll' name 'cfsEnumDomainUsers'
function  pkfEnumPackedFiles(Pkfname:PChar;Errs:PChar;Errlen:Dword):Pchar; //should be freed
          stdcall; external 'cfshare.dll' name 'pkfEnumPackedFiles'

function  cfsGetBasePath(connid:DWORD;path:PChar;cbPath:DWORD;
          var err:DWORD;errs:PChar;maxerrs:DWORD):LongBool;
          stdcall; external 'cfshare.dll' name 'cfsGetBasePath'

function  parse_uxtime(ut:DWORD; var Year:Integer; var Month:Integer; var Day:Integer; var Hour:Integer; var Minute:Integer; var Second:Integer):LongBool;
          cdecl; external 'cfshare.dll' name 'parse_uxtime'
function  mk_uxtime(Year,Month,Day,Hour,Minute,Second:Integer):DWORD;
          cdecl; external 'cfshare.dll' name 'mk_uxtime'
function  uxtime():DWORD;
          cdecl; external 'cfshare.dll' name 'uxtime'
function  uxtime_h(var Hund:BYTE):DWORD;
          cdecl; external 'cfshare.dll' name 'uxtime_h'

function MemComp (p1,p2:Pointer;len:Longint):Integer;

function String2Utime( s:PChar ):Dword;
         stdcall; external 'tmconn.dll' name '_String2Utime@4'

procedure Utime2Str(t:Dword; s:PChar );
        stdcall; external 'tmconn.dll' name '_Utime2Str@8'

function tmcGetLastError:Dword;
         stdcall; external 'tmconn.dll' name '_tmcGetLastError@0'

function tmcGetLastErrorText(cid:Dword; var ptext:PChar):LongInt;
         stdcall; external 'tmconn.dll' name '_tmcGetLastErrorText@8'

function tmcConnect(ServerName,PipeName,UserName:PAnsiChar;
                    cback:TCallBackEvent;cback_param:Pointer):Dword;
         stdcall; external 'tmconn.dll' name '_tmcConnect@20'

procedure tmcSetTelecontrolCallback( cid:Dword ;tccb:TTcCallback; Param:Pointer);
         stdcall; external 'tmconn.dll' name '_tmcSetTelecontrolCallback@12'

procedure tmcDisconnect( cid:Dword );
         stdcall; external 'tmconn.dll' name '_tmcDisconnect@4'

function tmcConnState( cid:Dword ):DWord;
         stdcall; external 'tmconn.dll' name '_tmcConnState@4'

function tmcGetCurrentServer(cid:Dword;machine:Pchar;cbMachine:Dword;pipe:Pchar;cbPipe:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcGetCurrentServer@20'

function tmcGetUrgentMessage(cid:DWORD):PChar;
        stdcall; external 'tmconn.dll' name '_tmcGetUrgentMessage@4'
        
function tmcGetGrantedAccess(cid:Dword; var Access:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcGetGrantedAccess@8'

function tmcEnumObjects(cid:Dword; ObjType:Word; Count:Byte;
                     Buf:Pointer; Ch, RTU, Point: SmallInt):Byte;
         stdcall; external 'tmconn.dll' name '_tmcEnumObjects@28'

function tmcGetObjectName(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt; Buf:Pchar; cbBuf:LongInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectName@28'

function tmcGetObjectProperties(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt; Buf:Pchar; cbBuf:LongInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectProperties@28'

function tmcEnumBaseObjects(cid:DWORD;var Count:DWORD):PBaseObjectInfo;
         stdcall; external 'tmconn.dll' name '_tmcEnumBaseObjects@8'

function tmcGetAnalogsFromQueueFirst(
           cid:Dword; var aqf:ANALOG_QUEUE_FIND;
           var records:TAnalogQueueRecord;
           count,start_time,stop_time:Dword;
	        chn,rtu,point:WORD):Dword;
         stdcall ; external 'tmconn.dll' name '_tmcGetAnalogsFromQueueFirst@36'

function tmcGetAnalogsFromQueueNext(
           cid:Dword; var aqf:ANALOG_QUEUE_FIND;
           var records:TAnalogQueueRecord;
           count:Dword):Dword;
         stdcall ; external 'tmconn.dll' name '_tmcGetAnalogsFromQueueNext@16'

function tmcEvaluateExpression(cid:Dword;expr,res:PChar;cbBytes:Dword):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcEvaluateExpression@16'

function tmcGetServerInfo(cid:Dword; var info:TServerInfo):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetServerInfo@8'

function tmcGetServerThreads(cid:Dword):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetServerThreads@4'

function tmcBackupServerProcedure( machine,pipe,directory:PChar;
        var bflags:DWORD;hCancel:DWORD;
        prog_fn:TTmcProgressEvent;prog_parm:Pointer):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcBackupServerProcedure@28'

function tmcRestoreServer(tms_not_rbs:LongBool;machine,pipe,filename:PChar;
	var bflags:DWORD;hCancel:DWORD;
	prog_fn:TTmcProgressEvent;prog_parm:Pointer):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcRestoreServer@32'
procedure tmcPreRestoreServer(tms_not_rbs:LongBool;
        machine,pipe,filename:PChar;var prs:TPreRestoreServer);
         stdcall; external 'tmconn.dll' name '_tmcPreRestoreServer@20'


procedure tmcGetTmSource(cid:Dword; ObjectType:WORD; Ch, RTU, Point: SmallInt; var src:TTelemetrySource);
         stdcall; external 'tmconn.dll' name '_tmcGetTmSource@24'

function tmcRetroInfoEx(cid:Dword; idx:Word;var rinfo:TRetroInfoEX):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcRetroInfoEx@12'

function tmcSystemTime( cid:Dword; DateTime:PAnsiChar; Dummy: LongInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSystemTime@12'

function tmcRetroInfo( cid:Dword; var RetroInfo: TRetroInfo): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcRetroInfo@8'

function tmcStatus( cid:Dword; Ch, RTU, Point: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcStatus@16'

function tmcStatusFull(cid:Dword; Ch, RTU, Point: SmallInt; SP: pSP):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcStatusFull@20'

function tmcStatusFullEx(cid:Dword; Ch, RTU, Point: SmallInt; SP: pSP; Time:DWORD):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcStatusFullEx@24'

function tmcAnalog( cid:Dword; Ch, RTU, Point: SmallInt;
                  Time: PChar; RetroNum: SmallInt): Single;
         stdcall; external 'tmconn.dll' name '_tmcAnalog@24'

function tmcAnalogFull( cid:Dword; Ch, RTU, Point: SmallInt; AP: pAP;
                  Time: PChar; RetroNum: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcAnalogFull@28'

function tmcAccumValue( cid:Dword; Ch, RTU, Point: SmallInt;
                  Time: PChar): Single;
         stdcall; external 'tmconn.dll' name '_tmcAccumValue@20'

function tmcAccumLoad( cid:Dword; Ch, RTU, Point: SmallInt;
                  Time: PChar): Single;
         stdcall; external 'tmconn.dll' name '_tmcAccumLoad@20'

function tmcAccumFull( cid:Dword; Ch, RTU, Point: SmallInt; AcP: pAcP;
                  Time: PChar):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcAccumFull@24'

function tmcAccumFullEx( cid:Dword; Ch, RTU, Point: SmallInt; AcP: pAcP;
                  Time: PChar; RetroNum:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcAccumFullEx@28'

function tmcEventLog( cid:Dword; StartTime, EndTime: PChar;
                     EvMask: Word; EvLog: pEV;
                     Cpct:Word; var Cursor: LongInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcEventLog@28'
         
function tmcEventLogEx(cid:Dword; EvMask:Word;
         UTStart,UTStop:Dword;var Criteria: TEventExCriteria):pEventEx;
         stdcall; external 'tmconn.dll' name '_tmcEventLogEx@20'

function tmcPeekAlarm( cid:Dword; Ch, RTU, Point, AlarmID: SmallInt; Alarm: pAL):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcPeekAlarm@24'

function tmcPokeAlarm( cid:Dword; Ch, RTU, Point, AlarmID: SmallInt; Alarm: pAL):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcPokeAlarm@24'

function tmcEnumAlarms( cid:Dword; Ch, RTU, Point: SmallInt; Alarm: pAL;
                      MaxQuan, ActiveOnly: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcEnumAlarms@28'

function tmcDriverCall( cid:Dword; ADR: Integer; Q_Code, Command: SmallInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcDriverCall@16'

procedure tmcStatusByList( cid:Dword; Quan: SmallInt; List: pADRtm; SPs:   pSP);
         stdcall; external 'tmconn.dll' name '_tmcStatusByList@16'

procedure tmcStatusByListEx( cid:Dword; Quan: SmallInt; List: pADRtm; SPs:   pSP; UT:DWORD);
         stdcall; external 'tmconn.dll' name '_tmcStatusByListEx@20'

procedure tmcAnalogByList( cid:Dword; Quan: SmallInt; List: pADRtm; APs:   pAP;
                         UT: DWORD; RetroNum: SmallInt);
         stdcall; external 'tmconn.dll' name '_tmcAnalogByList@24'

procedure tmcAccumByList( cid:Dword; Quan: SmallInt;  List: pADRtm; AcPs: pAcP;
                          UT: DWORD);
         stdcall; external 'tmconn.dll' name '_tmcAccumByList@20'

function tmcTakeAPS( cid:Dword ): pADRtm;
         stdcall; external 'tmconn.dll' name '_tmcTakeAPS@4'

function tmcSetAnalog( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single; Time: PChar): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalog@24'

function tmcSetAnalogUT( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single;
                ut:DWORD; flgcmd, flags:BYTE):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogUT@32'

function tmcSetAccumValue( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single; Time: PChar): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAccumValue@24'

function tmcSetAccumValueUT( cid:Dword; Ch, RTU, Point: SmallInt; Value: Single; ut: DWORD; flgcmd, flags:BYTE): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAccumValueUT@32'

function tmcSetAnalogByCode  ( cid:Dword; Ch, RTU, Point: SmallInt; Value: SmallInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogByCode@20'

function tmcSetAnalogByCodeUT( cid:Dword; Ch, RTU, Point: SmallInt; Value: SmallInt;
         ut:DWORD; flgcmd, flags:BYTE):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogByCodeUT@32'

function tmcSetStatus( cid:Dword; Ch, RTU, Point: SmallInt;
                            Value:Char;DateTime:PChar;Hund: SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetStatus@28'

function tmcSetStatusUT (cid:Dword; Ch, RTU, Point: SmallInt;
			    Value:Char;ut:DWORD;hund:BYTE;FlgCmd,Flags:BYTE):SmallInt;
        stdcall; external 'tmconn.dll' name '_tmcSetStatusUT@36'

function tmcSetStatusNormal( cid:Dword; Ch, RTU, Point: SmallInt;NValue:WORD):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetStatusNormal@20'

function tmcSetStatusFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetStatusFlags@20'

function tmcClrStatusFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcClrStatusFlags@20'

function tmcSetAnalogFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAnalogFlags@20'

function tmcClrAnalogFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcClrAnalogFlags@20'

function tmcSetAccumFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetAccumFlags@20'

function tmcClrAccumFlags( cid:Dword; Ch, RTU, Point: SmallInt;Flags:SmallInt):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcClrAccumFlags@20'

function tmcControl ( cid:Dword; Ch, RTU, Point: SmallInt; Cmd:SmallInt ):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcControl@20'

function tmcControlByStatus ( cid:Dword; Ch, RTU, Point: SmallInt; Cmd:SmallInt ):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcControlByStatus@20'

function tmcExecuteControlScript(cid:Dword; Ch, RTU, Point: SmallInt; Cmd:SmallInt):LongInt;
         stdcall; external 'tmconn.dll' name '_tmcExecuteControlScript@20'

function tmcOverrideControlScript(cid:Dword; fOverride:LongBool): LongBool;
         stdcall; external 'tmconn.dll' name '_tmcOverrideControlScript@8'

function tmcGetStatusClassData(cid:Dword;count:Dword;statuses:pADRtm):pPchar;
         stdcall; external 'tmconn.dll' name '_tmcGetStatusClassData@12'

function tmcGetRetroFlags(cid:DWORD):DWORD; // return 0xffffffff on failure
         stdcall; external 'tmconn.dll' name '_tmcGetRetroFlags@4'

function tmcSetRetroFlags(cid,rflags:DWORD):LongBool; // return FALSE on failure
         stdcall; external 'tmconn.dll' name '_tmcSetRetroFlags@8'

function tmcDecodeTcError ( error_code:WORD ):PChar;
         stdcall; external 'tmconn.dll' name '_tmcDecodeTcError@4'

procedure tmcTakeRetroTit( cid:Dword; Ch,RTU,Point:SmallInt;
          utime:Dword;RetroNum,count,step:Word;aps:pAPShort);
         stdcall; external 'tmconn.dll' name '_tmcTakeRetroTit@36'

function  tmcPerspEnum(cid:Dword;var count:DWORD):PDWORD;
         stdcall; external 'tmconn.dll' name '_tmcPerspEnum@8'

function  tmcPerspDelete(cid:DWORD;ut:DWORD):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcPerspDelete@8'

function  tmcPerspPutAnalogs(cid:DWORD;ut:DWORD;count:DWORD;addr:pADRTm;var Val:single):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcPerspPutAnalogs@20'

function  tmcPerspPutValue(cid:DWORD;ut:DWORD;Prop:PChar;Value:PChar):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcPerspPutValue@16'

function  tmcPerspGet(cid:DWORD;ut:DWORD;var len:DWORD):PChar;
         stdcall; external 'tmconn.dll' name '_tmcPerspGet@12'

function  tmcGetPerformanceData(cid:DWORD):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetPerformanceData@4'
         
function tmcGetReserveState(cid:Dword):PChar;
         stdcall; external 'tmconn.dll' name '_tmcGetReserveState@4'

function tmcGetValuesByFlagMask(cid:Dword; tm_type:Word; tm_flags:Dword;
        q_flags:byte; var Count:Dword):pCommonPoint;
        stdcall; external 'tmconn.dll' name '_tmcGetValuesByFlagMask@20'
        
function tmcGetServerFeature(cid:Dword;feat:DWord):Integer;
        stdcall; external 'tmconn.dll' name '_tmcGetServerFeature@8'

function tmcDntGetConfig (cid:Dword; fname:PChar):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntGetConfig@8'

function tmcDntTreeChange (cid:Dword):Dword;
         stdcall; external 'tmconn.dll' name '_tmcDntTreeChange@4'

function tmcDntOpenItem(cid:Dword;count:Dword;var mask:Dword):Pointer;
         stdcall; external 'tmconn.dll' name '_tmcDntOpenItem@12'

function tmcDntGetNextItem(itid:Pointer):PByte;
         stdcall; external 'tmconn.dll' name '_tmcDntGetNextItem@4'

procedure tmcDntCloseItem(itid:Pointer);
         stdcall; external 'tmconn.dll' name '_tmcDntCloseItem@4'

function tmcDntRegisterUser(cid:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntRegisterUser@4'

procedure tmcDntUnRegisterUser(cid:Dword);
         stdcall; external 'tmconn.dll' name '_tmcDntUnRegisterUser@4'

function tmcDntBeginDebug(cid:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntBeginDebug@4'

procedure tmcDntStopDebug(cid:Dword);
         stdcall; external 'tmconn.dll' name '_tmcDntStopDebug@4'

function tmcDntBeginTrace(cid:Dword;count:Dword;var pmask:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntBeginTrace@12'

procedure tmcDntStopTrace(cid:Dword);
         stdcall; external 'tmconn.dll' name '_tmcDntStopTrace@4'

function tmcDntTeleControl(cid,count:Dword;var pmask:Dword;idx,cmd:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntTeleControl@20'

function tmcDntGetReserveState(cid:Dword):PChar;
         stdcall; external 'tmconn.dll' name '_tmcDntGetReserveState@4'

function tmcDntReqValue(cid,count:Dword;var pmask:Dword;idx:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntReqValue@16'

function tmcDntGetObjectName(cid:Dword; ObjType:Word;
            Ch, RTU, Point: SmallInt; Buf:Pchar; cbBuf:LongInt):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntGetObjectName@28'

function tmcDntSetPortCapture(cid:DWORD;driver,adapter,port:BYTE):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntSetPortCapture@16'

function tmcDntGetPortCapture(cid:DWORD;driver,adapter,port:BYTE):Integer;
         stdcall; external 'tmconn.dll' name '_tmcDntGetPortCapture@16'

function tmcDntReleasePortCapture(cid:DWORD;driver,adapter,port:BYTE):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntReleasePortCapture@16'
         
function tmcDntSendPortPacket(cid:DWORD;driver,adapter,port,proto,timeout:BYTE;
                                pPacket:Pointer;cbPacket:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcDntSendPortPacket@32'

procedure tmcReadRetroTimes(cid:Dword;idx:Word;var pdata:Pointer;
          var count:Dword;pError:PChar);
         stdcall; external 'tmconn.dll' name '_tmcReadRetroTimes@20'

procedure tmcReadRetroSlice(cid:Dword;idx:Word;utime:Dword;
          var rtype:Word;var pdata:Pointer;var count:Dword);
         stdcall; external 'tmconn.dll' name '_tmcReadRetroSlice@24'

function  tmcGetConfig (cid:Dword; var Config:Dword):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetConfig@8'

function  tmcSetConfig (cid:Dword; Config:Dword):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcSetConfig@8'

function  tmcGetConfigInfo(cid:Dword; var pCfg:TServerConfig;count:Dword):SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetConfigInfo@12'

function tmcRegEvent(cid:Dword; Event:  pEV): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcRegEvent@8'

function tmcEvlogPutStrBin(
                cid:Dword;unix_time:Dword;unix_hund:Byte;importance:Byte;
                SourceTag:Dword;str:Pchar;bin:Pointer;cb_bin:Dword):LongBool;
         stdcall; external 'tmconn.dll' name '_tmcEvlogPutStrBin@32'

function tmcFillAnalogGroup(cid:Dword; Ch, RTU, Point: SmallInt; Quan: SmallInt; AGroup: Pointer): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcFillAnalogGroup@24'
procedure tmcSendMapboardCommand(cid, cmd, par1, par2: DWORD);
         stdcall; external 'tmconn.dll' name '_tmcSendMapboardCommand@16'
function tmcReconnectCount(cid: DWORD):DWORD;
         stdcall; external 'tmconn.dll' name '_tmcReconnectCount@4'
function tmcIsConnected(cid:Dword): Dword;
         stdcall; external 'tmconn.dll' name '_tmcIsConnected@4'

function tmcIsOperator(cid: DWORD):DWORD;
         stdcall; external 'tmconn.dll' name '_tmcIsOperator@4'
function tmcGetObjectNameEx(cid:Dword; ObjectType: Word;
            Ch, RTU, Point, SubObjectId: SmallInt;
            Buffer: PChar; MaxBufLen: Integer): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetObjectNameEx@32'
function tmcGetStatusNormal(cid:Dword; Ch, RTU, Point: SmallInt; NValue: PSmallInt): SmallInt;
         stdcall; external 'tmconn.dll' name '_tmcGetStatusNormal@20'

function tmcEventLogByIndex(cid:Dword; index: DWORD; ut: DWORD; pSize: PDWORD): pTMSEV;
         stdcall; external 'tmconn.dll' name '_tmcEventLogByIndex@16'

function tmcSetAccumValueSeries(
        cid:DWORD;chn,rtu,point:WORD;
        val:Single;ut:DWORD;allow_reformat:LongBool;
        errs:PChar;cb_errs:DWORD ):DWORD;
        stdcall; external 'tmconn.dll' name '_tmcSetAccumValueSeries@36'

procedure tmcFreeMemory(p:Pointer);
         stdcall; external 'tmconn.dll' name '_tmcFreeMemory@4'

function rbcOpenBases(cid:Dword; Base1, Base2, Base3, Base4, Base5: PChar): Integer;
         cdecl; external 'tmconn.dll'
function rbcCloseBases(cid:Dword): Integer;
         cdecl; external 'tmconn.dll'
function rbcOpenTable(cid:Dword; Base, Table: PChar): Integer;
         cdecl; external 'tmconn.dll'
function rbcRecSize(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcResetTable(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcReadStr(cid:Dword; hTable, RecCount: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcSetWhere(cid:Dword; hTable: Integer;
                    Column,  whType: Integer;
                    P1, P2, P3, P4, P5, P6, P7, P8, P9, P10: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcFindStr(cid:Dword; hTable, RecCount: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcFindCol(cid:Dword; hTable, RecCount: Integer; Rec: Pointer;
                   P1, P2, P3, P4, P5, P6, P7, P8: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcCalcTable(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcTestTable(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcWriteStr(cid:Dword; hTable: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcWriteCol(cid:Dword; hTable: Integer; Rec: Pointer;
                   P1, P2, P3, P4, P5, P6, P7, P8: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcAddStr(cid:Dword; hTable: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcAddStrInc(cid:Dword; hTable, Column: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcAddStrDec(cid:Dword; hTable, Column: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcFindMinMax(cid:Dword; hTable, Column: Integer; Rec1, Rec2: Pointer): Integer;
         cdecl; external 'tmconn.dll'

function rbcDeleteStr(cid:Dword; hTable: Integer; Rec: Pointer): Integer;
         cdecl; external 'tmconn.dll'
function rbcDeleteAll(cid:Dword; hTable: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcLockStr(cid:Dword; hTable, RecNum: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcUnlockStr(cid:Dword; hTable, RecNum: Integer): Integer;
         cdecl; external 'tmconn.dll'
function rbcGetSecurity(cid:Dword;var Admin:LongBool;var AccessMask:DWORD):Integer;
         cdecl; external 'tmconn.dll'
function rbcGetUserId(cid:Dword;UserId,UserPwd:PChar):Integer;
         cdecl; external 'tmconn.dll'
function rbcReadUserId(cid:Dword;index:DWORD ;var Done:LongBool;UserSid:PBYTE;
						UserId,UserPwd:PChar):Integer;
         cdecl; external 'tmconn.dll'
function rbcWriteUserId(cid:Dword;index:DWORD;UserSid:PBYTE;
						UserId,UserPwd:PChar):Integer;
         cdecl; external 'tmconn.dll'
function rbcWsEnumDomains(cid:Dword):PChar;
         cdecl; external 'tmconn.dll'
function rbcWsEnumDomainUsers(cid:Dword;domain:PChar):PChar;
         cdecl; external 'tmconn.dll'
function rbcWsGetUserSid(cid:Dword;domain:PChar;user:PChar):Pointer;
         cdecl; external 'tmconn.dll'
function rbcWsGetUserName(cid:Dword;pSid:Pointer;domain,user:PChar):LongBool;
         cdecl; external 'tmconn.dll'
function rbcBackupServerProcedure( machine,pipe,directory:PChar;
         var bflags:DWORD;hCancel:DWORD;
         prog_fn:TTmcProgressEvent;prog_parm:Pointer):LongBool;
         cdecl; external 'tmconn.dll'

implementation


function MemComp (p1,p2:Pointer;len:Longint):Integer;
var
    pb1,pb2:PChar;
    i:Longint;
begin
Result:=0;
pb1:=PChar(p1);
pb2:=PChar(p2);
for i:=0 to len-1 do
    begin
    if pb1[i]<>pb2[i] then
        begin
        Result:=1;
        Break;
        end;
    end;
end;

end.
