#include <windows.h>
#include <stdio.h>
#include "..\cfshare\cfshare.h"
#include "..\tmconn\tmconn.h"

//   
// '  ' 
//    -  WindowsNT (c)


//  Microsoft Visual C++ 4.0  


//     
// cfshare.lib  tmconn.lib

#define MAX_TMVRTU	128		//      -  
#define MAX_RETRANS	1000	//      -  
#define MAX_RTUS	256		// . -  -  

//////////////////// DATAGRAM DEFINITIONS -  !

#pragma pack(1)		//   
typedef struct {
	BYTE tag[2];
	DWORD Id;
	WORD type;
	WORD Chn;
	WORD Rtu;
	WORD Point;
	DWORD op1;
	DWORD op2;
} TSrcCommand;
#pragma pack()

//	    -    
#define TMFB_STATUS		0x0100		
#define TMFB_ANALOG		0x0200
#define TMFB_ACCUM		0x0300
#define TMFB_CONTROL	0x0400
#define TMFB_SET		0x8000	
///////////////////

TRetransInfo RetransInfo[MAX_RETRANS];
DWORD		 RetransCount=0;

////////////////////////////
//      -      
typedef struct {
	WORD chn;
	WORD rtu;
	WORD point;
}TM_ADDRESS;

typedef struct {
	BOOL Present;
	BOOL Retrans;
	TM_ADDRESS ts_start;
	TM_ADDRESS tit_start;
	WORD ts_count;
	WORD tit_count;
}RTU;

////////////////////////////
//   .        
//   
RTU Rtus[MAX_RTUS];
///////////////////////////

DWORD rec_count=0xffffffff;
HANDLE hStop;
DWORD connid;
VOID ReinitConnection();
VOID Work();
VOID InitRetransArray();

BOOL GetCurrentTs(WORD numRtu,BYTE* values,PBOOL pDataChanged);
BOOL GetCurrentTit(WORD numRtu,WORD* values,PBOOL pDataChanged);
VOID RetransStatusChanged(WORD rtunum,WORD idx,DWORD val /*0;1*/,WORD flags);
VOID RetransAnalogChanged(WORD rtunum,WORD idx,float fval,WORD code,WORD flags);
VOID StatusQueried(WORD rtunum,WORD idx);
VOID AnalogQueried(WORD rtunum,WORD idx);

BOOL WINAPI HandlerRoutine( DWORD dwCtrlType );
VOID __stdcall tmcDatagram(DWORD count,LPBYTE buf,LPVOID parm);
CHAR Machine[MAX_PATH]=".";
CHAR Pipe[MAX_PATH]="MyTms";


void main(int argc,char** argv)
{
	DWORD new_rec_count;
	///       
	strac_SetConsoleDebug(FALSE);

	//
	//     Rtus
	//    Retrans  ,   
	//
	InitRetransArray();
	hStop=CreateEvent(NULL,TRUE,FALSE,NULL);
	if(!hStop){
		printf("Cannot create stop event (error=%u)!\n",GetLastError());
		return;
	}
	//   Ctrl-Break
	SetConsoleCtrlHandler(
		HandlerRoutine,
		TRUE
	);
	//   
	connid=tmcConnect(
		Machine,	//  NT-  ALIAS
		Pipe,		//    
		"testapp$",	//    
		tmcDatagram,	// Callback   
		NULL			//   (  )
	);
	if(!connid){
		//    
		printf(
			"Fatal error connecting to server %s\\%s!",
			Machine,
			Pipe
		);
		return;
	}

	while(1){
		DWORD err;
		if(WaitForSingleObject(hStop,2000)==WAIT_OBJECT_0){
			printf("Stopping..");
			Sleep(1000);
			break;
		} ///   2     
		//   ,    ,   
		//  ,       ..
		err=tmcConnState(connid);
		if(err!=ERROR_SUCCESS){
			printf("\nNo connection to server %s\\%s (error=%u)\n",Machine,Pipe,err);
		}
		new_rec_count=tmcReconnectCount(connid);
		if(new_rec_count!=rec_count){
			//  ?
			rec_count=new_rec_count;
			if(rec_count==0){
				// ,    
				continue;
			}
			// ,  -    
			ReinitConnection();
		}
		if(rec_count==0){
			//  ,  
			//        
			continue;
		}
		//   -       
		Work();
	}	
	tmcDisconnect(connid);
}
VOID ReinitConnection()
{
	DWORD cnt1,cnt2,i=0;
	tmcSetDgrmFlags(connid,DGM_DATASOURCE);	//    
	//   ,   
	tmcClrDgrmFlags(connid,DGM_TMNOTIFY); //     
	//   ,  

	cnt1=RetransCount;
	while(1){
		if(WaitForSingleObject(hStop,0)==WAIT_OBJECT_0){
			//   - 
			break;
		}
		if(cnt1>128){
			cnt2=128;
			cnt1-=128;
		}
		else {
			cnt2=cnt1;
			cnt1=0;
		}
		tmcSetRetransInfo(connid,(WORD)cnt2,&RetransInfo[i]);
		//  ,   
		if(!cnt1)break;
		i+=128;
	}
	for(i=0;i<MAX_RTUS;i++){
		if(WaitForSingleObject(hStop,0)==WAIT_OBJECT_0)break;
		if(!Rtus[i].Present || Rtus[i].Retrans)continue;
		if(Rtus[i].ts_count){
			//    ()
			// (       )
			tmcSetFeedbackItems(connid,TM_STATUS,
				Rtus[i].ts_start.chn,
				Rtus[i].ts_start.rtu,
				Rtus[i].ts_start.point,
				(BYTE)Rtus[i].ts_count,
				FBTYPE_SIMPLE,
				i	// Id== 
			);
		}
		if(Rtus[i].tit_count){
			//    ()
			tmcSetFeedbackItems(connid,TM_ANALOG,
				Rtus[i].tit_start.chn,
				Rtus[i].tit_start.rtu,
				Rtus[i].tit_start.point,
				(BYTE)Rtus[i].tit_count,
				FBTYPE_SIMPLE,
				i
			);
		}
	}
}

VOID Work()
{
	BOOL Reliable,DataChanged;
	DWORD i,j;
	BYTE ts[(MAX_TMVRTU+7)/8]; //  ,      
	WORD tit[MAX_TMVRTU];
	//      -
	for(i=0;i<MAX_RTUS;i++){
		if(!Rtus[i].Present || Rtus[i].Retrans)continue;
		Reliable=GetCurrentTs((WORD)i,ts,&DataChanged);
		if(DataChanged){	//   
			if(Reliable){ //  
				//    
				tmcFillStatusGroup(connid,
					(short)Rtus[i].ts_start.chn,
					(short)Rtus[i].ts_start.rtu,
					(short)Rtus[i].ts_start.point,
					(short)Rtus[i].ts_count,
					ts
				);
			}
			else {
				//  ,   
				for(j=0;j<Rtus[i].ts_count;j++){
					tmcSetStatusFlags(
						connid,
						(short)Rtus[i].ts_start.chn,
						(short)Rtus[i].ts_start.rtu,
						(short)(Rtus[i].ts_start.point+j),
						UNRELIABLE_HDW
					);
				}
			}
		}
		Reliable=GetCurrentTit((WORD)i,tit,&DataChanged);
		if(DataChanged){
			if(Reliable){
				//   () 
				tmcFillAnalogGroup(connid,
					(short)Rtus[i].tit_start.chn,
					(short)Rtus[i].tit_start.rtu,
					(short)Rtus[i].tit_start.point,
					(short)Rtus[i].tit_count,
					(short*)tit
				);
			}
			else {
				for(j=0;j<Rtus[i].tit_count;j++){
					tmcSetAnalogFlags(
						connid,
						(short)Rtus[i].tit_start.chn,
						(short)Rtus[i].tit_start.rtu,
						(short)(Rtus[i].tit_start.point+j),
						UNRELIABLE_HDW
					);
				}
			}
		}
	}
}


VOID __stdcall tmcDatagram(DWORD count,LPBYTE buf,LPVOID parm)
{
//      ,   -
	TSrcCommand* srccmd=(TSrcCommand*)buf;
	if(srccmd->tag[0]=='C'){
		if(srccmd->tag[1]=='F' && count>=2){
			// conf change -  "CF"
			printf("TM-server configuration change!\n");
			tmcUpdateConnection(connid);
			return;
		}
		else if(srccmd->tag[1]!='M' || count>=sizeof(TSrcCommand)){ //     >=
			//  -  "CM"
			WORD tmsFlags=(WORD)srccmd->op2;
			WORD rtunum=(WORD)srccmd->Id;
			WORD idx;
			switch(srccmd->type){
				case (TMFB_STATUS|TMFB_SET):
					//      (srccmd->Id),
					//    ,  ,   . 
					if(rtunum>MAX_RTUS || !Rtus[rtunum].Present 
						||!Rtus[rtunum].Retrans || !Rtus[rtunum].ts_count)break;
					if(Rtus[rtunum].ts_start.chn!=srccmd->Chn)return;
					if(Rtus[rtunum].ts_start.rtu!=srccmd->Rtu)return;
					//     ,   .  
					//     -
					//
					idx=srccmd->Point-Rtus[rtunum].ts_start.point;
					if(idx>=Rtus[rtunum].ts_count)return;
					RetransStatusChanged(rtunum,idx,srccmd->op1,tmsFlags);
				break;
				case TMFB_STATUS:
					//   ,      
					if(rtunum>MAX_RTUS || !Rtus[rtunum].Present 
						||Rtus[rtunum].Retrans || !Rtus[rtunum].ts_count)break;
					if(Rtus[rtunum].ts_start.chn!=srccmd->Chn)return;
					if(Rtus[rtunum].ts_start.rtu!=srccmd->Rtu)return;
					idx=srccmd->Point-Rtus[rtunum].ts_start.point;
					if(idx>=Rtus[rtunum].ts_count)return;
					StatusQueried(rtunum,idx);
					break;
				case (TMFB_ANALOG|TMFB_SET):
					{
					WORD ancode;
					if(rtunum>MAX_RTUS || !Rtus[rtunum].Present 
						||!Rtus[rtunum].Retrans || !Rtus[rtunum].tit_count)break;
					if(Rtus[rtunum].tit_start.chn!=srccmd->Chn)return;
					if(Rtus[rtunum].tit_start.rtu!=srccmd->Rtu)return;
					idx=srccmd->Point-Rtus[rtunum].tit_start.point;
					if(idx>=Rtus[rtunum].tit_count)return;
					ancode=(WORD)(srccmd->op2>>16);
					RetransAnalogChanged(rtunum,idx,*((float*)&srccmd->op1),ancode,tmsFlags);
					}
					break;
				case TMFB_ANALOG:
					if(rtunum>MAX_RTUS || !Rtus[rtunum].Present 
						|| Rtus[rtunum].Retrans || !Rtus[rtunum].tit_count)break;
					if(Rtus[rtunum].tit_start.chn!=srccmd->Chn)return;
					if(Rtus[rtunum].tit_start.rtu!=srccmd->Rtu)return;
					idx=srccmd->Point-Rtus[rtunum].tit_start.point;
					if(idx>=Rtus[rtunum].tit_count)return;
					AnalogQueried(rtunum,idx);
					break;
				case (TMFB_ACCUM|TMFB_SET):
					break;
				case TMFB_ACCUM:
					break;
				case (TMFB_CONTROL|TMFB_SET):
				case TMFB_CONTROL:
					break;
			default:
					break;
			}
		}
	}
}
BOOL WINAPI HandlerRoutine( DWORD dwCtrlType )
{
	//  Ctrl-Break
	SetEvent(hStop);
	return TRUE;
}
VOID InitRetransArray()
{
	DWORD i,j;
	//    
	for(i=0;i<MAX_RTUS;i++){
		if(Rtus[i].Retrans){
			for(j=0;j<(DWORD)Rtus[i].ts_count;j++){
				// 
				RetransInfo[RetransCount].Id=i;	// Id== 
				RetransInfo[RetransCount].type=TM_STATUS;
				RetransInfo[RetransCount].a.Ch=(short)Rtus[i].ts_start.chn;
				RetransInfo[RetransCount].a.RTU=(short)Rtus[i].ts_start.rtu;
				RetransInfo[RetransCount].a.Point=(short)((WORD)j+Rtus[i].ts_start.point);
				RetransCount++;
				if(RetransCount>=MAX_RETRANS)return;
			}
			for(j=0;j<(DWORD)Rtus[i].tit_count;j++){
				// 
				RetransInfo[RetransCount].Id=i;
				RetransInfo[RetransCount].type=TM_ANALOG;
				RetransInfo[RetransCount].a.Ch=(short)Rtus[i].tit_start.chn;
				RetransInfo[RetransCount].a.RTU=(short)Rtus[i].tit_start.rtu;
				RetransInfo[RetransCount].a.Point=(short)((WORD)j+Rtus[i].tit_start.point);
				RetransCount++;
				if(RetransCount>=MAX_RETRANS)return;
			}
		}
	}
}
////////////////////////////////// 
// ,  ,      
//////////////////////////////////
BOOL GetCurrentTs(WORD numRtu,BYTE* values,PBOOL pDataChanged)
//      
//  FALSE,       
{
	pDataChanged[0]=FALSE;
	return FALSE;		//      
}
BOOL GetCurrentTit(WORD numRtu,WORD* values,PBOOL pDataChanged)
//      
//  FALSE,       
{
	pDataChanged[0]=FALSE; //      
	return FALSE;
}
VOID RetransStatusChanged(WORD rtunum,WORD idx,DWORD val /*0;1*/,WORD flags)
//   (idx)     rtunum,   
// idx=0,1, ... Rtus[rtunum].ts_count-1
{
	if(flags&UNRELIABLE_HDW){
		// 
	}
	else {
		if(val==0){
			//
		}
		else {
			//
		}
	}
}

VOID RetransAnalogChanged(WORD rtunum,WORD idx,float fval,WORD code,WORD flags)
//   (idx)     rtunum,   
// idx=0,1, ... Rtus[rtunum].tit_count-1
// fval -    -
// code -    -
//      ,  
//   . 
{
	if(flags&UNRELIABLE_HDW){
		// 
	}
	else {
	}
}

VOID StatusQueried(WORD rtunum,WORD idx)
{
	//       
}

VOID AnalogQueried(WORD rtunum,WORD idx)
{
	//    
}

