#ifndef _TMCONN_H
#define _TMCONN_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __TIME_H
#include <time.h>
#endif

#define ERROR_TM_NOT_CONNECTED 0xc0001
#define TM_KERNEL_SIGNATURE 0x0830

#ifdef INVALID
#undef INVALID
#endif

#define INVALID 0xffffffff

#define SUCCESS 1                 //   
#define FAILURE 0                 //    

/*-------------    -----------------*/

#define TMS_ACCESS_TM_READ			0x00000001
#define TMS_ACCESS_STATUS_CHANGE	0x00000002
#define TMS_ACCESS_ANALOG_CHANGE	0x00000004
#define TMS_ACCESS_ACCUM_CHANGE		0x00000008
#define TMS_ACCESS_TELECONTROL		0x00000010
#define TMS_ACCESS_RETRO_VIEW		0x00000020
#define TMS_ACCESS_LOG_VIEW			0x00000040
#define TMS_ACCESS_ALARM_CHANGE		0x00000080
#define TMS_ACCESS_TM_SOURCE		0x00000100
#define TMS_ACCESS_TMSRC_DIALOG		0x00000200

#define DNT_ACCESS_READ				0x00000001
#define DNT_ACCESS_TRACE			0x00000002
#define DNT_ACCESS_CMD				0x00000004

#define	DNT_GENERIC_READ	DNT_ACCESS_READ
#define	DNT_GENERIC_WRITE   DNT_ACCESS_READ
#define	DNT_GENERIC_EXECUTE DNT_GENERIC_READ
#define	DNT_GENERIC_ALL (DNT_ACCESS_READ|DNT_ACCESS_TRACE|DNT_ACCESS_CMD)

/*-------------    -----------------*/
#define UNRELIABLE_HDW     0x0001   //  
#define UNRELIABLE_MANU    0x0002   //   
#define REQUESTED          0x0004   //  
#define MANUALLY_SET       0x0008   //  
#define NO_ALARMS          0x0000   //   
#define LEVEL_A            0x0010   //    
#define LEVEL_B            0x0020   // ------- " -------  
#define LEVEL_C            0x0040   // ------- " -------  
#define LEVEL_D            0x0080   // ------- " -------  
#define INVERTED           0x0100   //    
#define RESCHANNEL         0x0200	//     
#define TMCTRL_PRESENT     0x0400	//    - volatile
#define STATUS_CLASS_APS   0x0800	// 
#define TMSTREAMING        0x1000	//   
#define F_ABNORMAL         0x2000   //   
#define F_UNACKED          0x4000   //  


#define F_VRES             0x10000000   //      

// S2	STATUS		15 -
#define S2_BREAK			 0x0001
#define	S2_MALFUNCTION		 0x0002   //  

// S2	ANALOG-ACCUM 15 .

// S2	 
#define S2_FLAGSONLY		 0x8000




/*------------------------   ---------------------------*/
#define evSTATUS_CHANGE      0x0001   // 
#define evALARM              0x0002   //  
#define evCONTROL            0x0004   // 
#define evMANUAL_CONTROL     0x0008   //   
#define evMANUAL_STATUS_SET  0x0010   //   
#define evMANUAL_ANALOG_SET  0x0020   //   
#define evRES1               0x0040
#define evRES2               0x0080

#define evEXT_LNK			 0x2000	  //   -  !
#define evEXT_FILE_LNK		 0x4000	  //   -  !
#define evEXTENDED			 0x8000	  //  
	
#define EXTEVL_KIND_STRBIN		0x100

#define EXTEVL_SOURCE_IEC101_MESSAGE	101
#define EXTEVL_SOURCE_AURA_FILE			102
#define EXTEVL_SOURCE_IEC103_MESSAGE	103
#define EXTEVL_SOURCE_SPA_MESSAGE		105
#define EXTEVL_SOURCE_MODBUS			106


#define FLAGS_IGNORE			0x00
#define FLAGS_SET				0x01
#define FLAGS_CLEAR				0x02
#define FLAGS_COPY				0x03
#define FLAGS_RESET				0x10


#define TM_STATUS	((WORD)0x8000)
#define TM_ANALOG	((WORD)0x8001)
#define TM_ACCUM	((WORD)0x8002)
#define TM_CONTROL  ((WORD)0x8003)

#define TM_CHANNEL 	((WORD)0x9000)
#define TM_RTU 		((WORD)0x9001)

#define TM_RETRO_STATUS	((WORD)0x9010)
#define TM_RETRO_ANALOG ((WORD)0x9011)
#define TM_RETRO_ACCUM 	((WORD)0x9012)

#define MAP_COMMAND_SUPPORTED		0
#define MAP_COMMAND_ACKNOWLEDGE		1
#define MAP_COMMAND_SET_BRIGHTNESS	2
#define MAP_COMMAND_ON_MODE			3
#define MAP_COMMAND_OFF_MODE		4
#define MAP_COMMAND_NORMAL_MODE		5
#define MAP_COMMAND_SET_BLINK_RATE	6
#define MAP_COMMAND_SHOW_UNDEFINED  7
#define MAP_COMMAND_DARK_MODE		8
#define MAP_COMMAND_STNORM_MODE		9

#define DGM_DATASOURCE 	0x00000001
#define DGM_TRACEALL	0x00000002
#define DGM_TRACEDEF	0x00000004
#define DGM_TMNOTIFY	0x00000008

#define DNTT_DRIVER		'0'
#define DNTT_ADAPTER	'1'
#define DNTT_PORT		'2'
#define DNTT_RTU		'3'
#define DNTT_ARRAY		'4'
#define DNTT_BLOCK		'5'

#define DNTERR_OK			0
#define DNTERR_THREAD		1
#define DNTERR_RESOURCE		2
#define DNTERR_MEMORY		3
#define DNTERR_UNKNOWN		100

#define DNT_TRACE_ERROR		0
#define DNT_TRACE_MSG		1
#define DNT_TRACE_DEBUG		2
#define DNT_TRACE_TM_IN		3
#define DNT_TRACE_TM_OUT	4
#define DNT_TRACE_S_IN		5
#define DNT_TRACE_S_OUT		6

#define DNT_DRIVER_ETHERNET	1
#define DNT_DRIVER_COM		2

#ifndef TMS_BACKUP_
#define TMS_BACKUP_
#define TMS_BACKUP_CONFIG	1
#define TMS_BACKUP_ARRAY	2
#define TMS_BACKUP_EVLOG	4
#define TMS_BACKUP_ALARMS	8
#define TMS_BACKUP_RETRO	0x10
#define TMS_BACKUP_SECURITY	0x20
#endif

#define TMV_MAX_CLASSES		256

#ifndef RBS_BACKUP_
#define RBS_BACKUP_
#define RBS_BACKUP_BASES	1
#define RBS_BACKUP_SECURITY 2
#endif

/*-------------------------------- * ------------------------------*/
#pragma pack(1)
typedef struct
	{
    short Ch;
    short RTU;
    short Point;
    } TADRtm;

typedef struct
	{
	short Status;            //  
	short Flags;             // 
	} TStatusPoint;  //  

typedef struct
	{
	float asFloat;           //   
	short asCode;            //  ,   
	short Flags;             // 
	char  Unit[8];           //  
	} TAnalogPoint;  //  

typedef struct {
	float Value;
	short Flags;
}TAnalogPointShort;

typedef struct {
	DWORD fix_time;
	DWORD tm_time;
	WORD  chn;
	WORD  rtu;
	WORD  point;
	WORD  asCode;
	float asFloat;
	WORD  flags;
}TAnalogQueueRecord;

typedef struct {
	WORD level;
	WORD a[4];
	LPSTR name;
}TBaseObjectInfo;

typedef struct {
	TADRtm	a;
	unsigned char type;
#define VF_TYPE_STATUS				0x10
#define VF_TYPE_ANALOG_CODE			0x20
#define VF_TYPE_ANALOG_FLOAT		0x30
#define VF_TYPE_ACCUM_VALUE			0x40
#define VF_TYPE_ACCUM_CODE			0x50
#define VF_TYPE_ACCUM_INCREMENT		0x60
#define VF_TYPE_TELECTRL			0x70
#define VF_TYPE_ACCUM_FLOAT			0x80
#define VF_TYPE_ACCUM_DIRECT		0x90
#define VF_TYPE_ACCUM_FLT_DIRECT	0xa0
#define VF_TYPE_TC_ACK				0xb0
#define VF_TYPE_ANALOG_FLOATCODE	0xc0



#define VF_FLG_IGNORE			0x00
#define VF_FLG_SET				0x01
#define VF_FLG_CLEAR			0x02
#define VF_FLG_COPY				0x03

#define VF_SIGNED				0x04
#define VF_ALWAYS_SET_VALUE		0x08
	unsigned char flags;
	unsigned char bits;

	union {
		unsigned	char	uchar;
		signed		char	schar;
		unsigned	short	ushort;
		signed		short	sshort;
		unsigned	long	ulong;
		signed		long	slong;
		float				flt;
	};
}TValueAndFlags;

typedef struct {
	DWORD	sec;
	WORD	ms;
	BYTE	flags;
#define TMXT_FLAG_GRINWICH		1
#define TMXT_FLAG_NORETRO		2
	BYTE	reserved;
}TMXTime;

typedef struct {
	TValueAndFlags	vf;
	TMXTime			xt;
}TTimedValueAndFlags;

typedef struct {
	unsigned short Ch; 
	unsigned short RTU;
	unsigned short Point;		//6
	unsigned long  Value;		//10
	unsigned long  sec;			//14
	unsigned char  hund;		//15
    unsigned char  DataType;	//16
}TTimedAccum;
typedef struct {
	unsigned short Ch; 
	unsigned short RTU;
	unsigned short Point;		//6
	unsigned long  sec;			//10
	unsigned char  hund;		//11
	unsigned char  flags_type;	//12
    unsigned short DataType;	//14
	unsigned char  Data[16];	//30
}TTimedAccumEx;
typedef struct {
	unsigned short Ch; 
	unsigned short RTU;
	unsigned short Point;		//6
	unsigned long  sec;			//10
	unsigned char  hund;		//11
	unsigned char  flags_type;	//12
    unsigned short DataType;	//14
#define ACCFLG_INC		1
#define ACCFLG_DIRECT	2
	unsigned short AccFlags;	//16
	unsigned char  Data[16];	//32
}TAccumData;

typedef struct
    {
    short           Point;
    char            RTU;
    char            Ch;
	char 			GroupId;
	char 			AlarmId;
	float 			Value;
	unsigned short	Sign		:1;
	unsigned short	Sensibility	:7;
	unsigned short	Active		:2;
	unsigned short	InUse		:2;
	unsigned short	Importance	:4;
	unsigned short 	Period;
	char 			DayMap[6];
	char 			WeekMap;
	char 			YearMap[6];
	char 			InDirect;
	unsigned short 	CountDown;
	double 			Sum;
    } TAlarm;

typedef struct
	{
	float Value;             //  
	float Load;              // 
	short Flags;             // 
	char Unit[8];            //  
	} TAccumPoint;   //  

typedef struct {
	LPSTR	name;
	BYTE	cp_flags;
#define TMCPF_NAME		1
#define TMCPF_ALLFLAGS	2
	BYTE	res1;

	WORD	Type;
	WORD	Ch;
	WORD	RTU;
	WORD	Point;
	DWORD	TM_Flags;

	DWORD	res2[4];
	union {
		TStatusPoint st;
		TAnalogPoint an;
		TAccumPoint	 ac;
		BYTE		 padding[32];
	};
}TCommonPoint;
typedef struct	{
	char DateTime[24];       //     .. ::.cc

	unsigned short Imp;      //  
	unsigned short ID;       //  
	
	union {
		struct {
			unsigned short Ch;       // 
			unsigned short RTU;      //    (c 1)
			unsigned short Point;    //     (c 1)
		}Common;
		struct {
			WORD Kind;
			WORD DataLen;
			WORD Reserved;
		}Extended;
	};

	char Data[22];
} TEvent;      // 

typedef struct _TEventEx{
	struct _TEventEx* next;
	DWORD size;
	TEvent evt;
}TEventEx;

typedef struct {
	DWORD	ItemsLimit;
	DWORD	MemoryLimit;
	HANDLE	hStop;
	BOOL	Interrupted;
}TEventExCriteria;

typedef struct
	{
	unsigned long  Time;     //   .  01.01.1970
	unsigned char  Hund;     //   .

	unsigned char  Imp;      //  
	unsigned short ID;       //  
	union {
		struct {
			unsigned char  Ch;       // 
			unsigned char  RTU;      //    (c 1)
			unsigned short Point;    //     (c 1)
		}Common;
		struct {
			unsigned short Kind;
			unsigned short DataLen;
		}Extended;
	};

	union
		{
		char EndOfHeader;
		struct
			{
			char State;     //   
			char Class;     //   (.. - 0   - 1)
			} Status;  //   
		struct
			{
			float Val;      //   
			short AlarmID;  //  
			char  State;    // 0 -  , 1 -  
			} Alarm;   //   
		struct
			{
			char  Ch;
			char  RTU;
			short Point;
			char  Cmd;     //  
			char  Result;  // == SUCCESS   ,  FAILURE
			char  UserName[16];  // ,  
			} Control; //   
		struct 
			{
			DWORD index;
			} ExtendedLink;
		} Data;
	} TTMSEvent;        //   

typedef struct {
	WORD Source;
	BYTE Rtu;
	BYTE Chn;
	BYTE Str_And_Bin;
}EXTEVL_STRBIN;

struct StatusData  //   
	{
	char State;    //   
	char Class;    //   (.. - 0   - 1)
	};
struct AlarmData   //   
	{
	float Val;     //   
	short AlarmID; //  
	char  State;   // 0 -  , 1 -  
	};
struct ControlData //   
	{
	char  Ch;
	char  RTU;
	short Point;
	char  Cmd;     //  
	char  Result;  // == SUCCESS   ,  FAILURE
	char  UserName[16];  // ,  
	};
typedef struct
    {
    unsigned short TII_RETRO_PERIOD;
    unsigned short TII_RETRO_DEPTH;
    unsigned short TIT_RETRO_PERIOD[3];
    unsigned short TIT_RETRO_DEPTH[3];
    char           TIT_RETRO_NAME[3][30];
    } TRetroInfo;

typedef struct {
	WORD	type;
	CHAR	name[128];
	CHAR	descr[30];
	DWORD	period;
	DWORD	capacity;
	DWORD	start;
	DWORD	stop;
	DWORD	rec_count;
	DWORD	reserved[16];
}TRetroInfoEx;
typedef struct {
	DWORD Id;
	CHAR  Name[64];
}TTelemetrySource;
#ifndef TServerInfo_DEEFINED
#define TServerInfo_DEEFINED
typedef struct {
	CHAR  Description[64];

	DWORD dwType;
	DWORD dwHeapUsage;
	DWORD dwWSMin;
	DWORD dwWSMax;

	DWORD HandleCount;
	DWORD StartTime;
	DWORD ConfChangeTime;
	DWORD ThreadCount;

	DWORD UserCount;
	DWORD LogonCount;

	DWORD PresenceFlags;
#define SIPF_UNIQ_USERS_COUNT	1
#define SIPF_TM_VALUE_COUNT		2
#define SIPF_RB_FILL			4
#define SIPF_RB_MAX_FILL		8

	DWORD UniqUserCount;
	DWORD TmValueCount;

	DWORD ReserveBufFill;
	DWORD ReserveBufMaxFill;
	DWORD TmTotValCnt;
	DWORD ReserveSentAsyncBytes;

	BYTE  reserverd[92];

} TServerInfo;
#endif //TServerInfo_DEEFINED
typedef struct {
	DWORD	Id;
	WORD	type;
	TADRtm	a;
} TRetransInfo;

typedef struct {
	BYTE Ok;
#define TRIR_GROUP 1
#define TRIR_CLASS 2
	BYTE flags;
	WORD Group;
	WORD Class;
	WORD reserved2[3];
}TRetransInfoReply;

typedef struct {
	DWORD Id;
	WORD type;
	BYTE count;
	BYTE fbType;
	TADRtm a;
} TFeedbackInfo;
typedef struct {
	WORD Ch;
	WORD RTU;
	WORD Point;
	short Flags;
	short Status;
}TRetroStatusElement;
typedef struct {
	WORD Ch;
	WORD RTU;
	WORD Point;
	short Flags;
	float asFloat;
	short asCode;
}TRetroAnalogElement;
typedef struct {
	WORD Ch;
	WORD RTU;
	WORD Point;
	short Flags;
	float Value;
	float Load;
}TRetroAccumElement;

typedef struct {
	DWORD dwNumber;
	CHAR szName[32];
}TServerConfig;


typedef struct {
	BOOL	success;
	DWORD	bflags;
	CHAR	fname_or_error[1024];
}TServerBackupData;

typedef struct {
	DWORD	dwFreeSpace;
	DWORD	dwErr;
	DWORD	reserved[14];
	CHAR	errs[512];
}TPreRestoreServer;

//////////////////////
typedef struct {
	BYTE type;
	BYTE length;
	WORD number;
	LONG lastUpdate;
	WORD flags;
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	BYTE value;
}DeltaStatus;
typedef struct {
	BYTE type;
	BYTE length;	
	WORD number;	
	LONG lastUpdate;
	WORD flags;		
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	LONG value;		
}DeltaAnalog;
typedef struct {
	BYTE type;
	BYTE length;	
	WORD number;	
	LONG lastUpdate;
	WORD flags;		
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	float value;		
}DeltaAnalogF;
typedef struct {
	BYTE type;		
	BYTE length;	
	WORD number;	
	LONG lastUpdate;
	WORD flags;		
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	LONG value;		
}DeltaAccum;
typedef struct {
	BYTE type;
	BYTE length;	
	WORD number;	
	LONG lastUpdate;
	WORD flags;		
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;

	float value;		
}DeltaAccumF;
typedef struct {
	BYTE type;		
	BYTE length;	
	WORD number;	
	LONG lastUpdate;
	WORD flags;		
	WORD tmsChn;
	WORD tmsRtu;
	WORD tmsPoint;
	
	WORD ctrlBlock;
	WORD ctrlGroup;
	WORD ctrlPoint; 
}DeltaControl;
typedef struct {
	BYTE type;	
	BYTE length;
	LONG current;
}DeltaSliceTime;

typedef struct {
	BYTE type;	
	BYTE length;
	CHAR text[1];
}DeltaDescription;

typedef struct {
	BYTE type;	
	BYTE length;
}DeltaCommon;


#define DELTA_ITEM_DESCRIPTION	0
#define DELTA_ITEM_TIME			1
#define	DELTA_ITEM_STATUS		2
#define DELTA_ITEM_ANALOG		3
#define DELTA_ITEM_ACCUM		4
#define DELTA_ITEM_CONTROL		5
#define DELTA_ITEM_ANALOGF		6
#define DELTA_ITEM_ACCUMF		7

#define DELTA_ITEMF_RELIABLE	1
#define DELTA_ITEMF_ZEROENUM    2
#define DELTA_ITEMF_DESTRELI	4
#define DELTA_ITEMF_DESTVAL		8
#define DELTA_ITEMF_HEX			0x10
#define DELTA_ITEMF_GROUP8		0x20
#define DELTA_ITEMF_N_PRSNT		0x40

#pragma pack()
typedef struct {
	BYTE storage[0x100];
}ANALOG_QUEUE_FIND;
#ifdef _TMCONN_DLL
__declspec(dllexport) extern
#else
__declspec(dllimport)
#endif
float huge_flt;

typedef VOID (__stdcall * tmcDatagramFn)(DWORD count,LPBYTE buf,LPVOID param);
typedef VOID (__stdcall * tmcProgressFn)(DWORD count,LPVOID str,LPVOID param);
typedef LONG (__stdcall * tmcTelecontrolCallback)(DWORD cid,PVOID parm,LPSTR estr);
typedef VOID (__cdecl   * tcapRecvFunc)(DWORD count,LPBYTE buf,DWORD cid,BYTE proto);

#define TMTCCB_OK		1
#define TMTCCB_CANCEL	0
#define TMTCCB_NOKEY	-1
#ifdef _TMCONN_DLL
#define TMC_IMPEX	_declspec(dllexport)
#else
#define TMC_IMPEX	_declspec(dllimport)
#endif

#ifdef __cplusplus
#endif
/*-----------------------   --------------------------*/
//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID __stdcall tmcFreeMemory(PVOID p);

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcConnect(
					LPSTR server,
					LPSTR pipe,
					LPSTR user,
					tmcDatagramFn cback,
					LPVOID cback_param);
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcConnectEx(
					LPSTR server,
					LPSTR pipe,
					LPSTR user,
					tmcDatagramFn cback,
					LPVOID cback_param,
					DWORD	cbProps,
					PDWORD	pProps,
					PDWORD	pPropValues	);
#define				TMC_MAX_CPROPS			8
#define				TMCCPROP_DGTYPE			1
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID __stdcall tmcSetTelecontrolCallback(
				DWORD cid,
				tmcTelecontrolCallback cb,
				PVOID parm);
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR  __stdcall tmcDecodeTcError(WORD status);
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID  __stdcall tmcDisconnect( DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID  __stdcall tmcUpdateConnection( DWORD cid );
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcIsConnected(	DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcGetCurrentServer(DWORD cid,LPSTR machine,DWORD cbMachine,LPSTR pipe,DWORD cbPipe);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR __stdcall tmcGetUrgentMessage(DWORD cid);
// returned pointer should be freed by tmcFreeMemory()
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcGetMapMode(DWORD cid, DWORD ModeType,PDWORD pMapMode);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcReconnectCount(	DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID  __stdcall tmcReactError( DWORD cid, BOOL fReact );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX INT	__stdcall tmcGetServerFeature(DWORD cid,DWORD dwCode);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL	__stdcall tmcSetRestraint(DWORD cid,BOOL fSet);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcBackupServerData ( DWORD cid, DWORD bflags, TServerBackupData* data );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcBackupServerProcedure(
	LPSTR machine,
	LPSTR pipe,
	LPSTR directory,
	PDWORD pbflags,
	HANDLE hCancel,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcRestoreServer(
	BOOL tms_not_rbs,
	LPSTR machine,
	LPSTR servname,
	LPSTR filename,
	PDWORD pbflags,
	HANDLE hCancel,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID __stdcall tmcPreRestoreServer(
	BOOL tms_not_rbs,
	LPSTR machine,
	LPSTR servname,
	LPSTR filename,
	TPreRestoreServer* pprs
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcGetBlob(
	DWORD cid,
	LPSTR name,
	LPSTR local_filename,
	PDWORD pcount,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX TCommonPoint* __stdcall tmcGetValuesByFlagMask(
	DWORD	cid,
	WORD	tm_type,
	DWORD	tm_flags,
	BYTE	q_flags,
	PDWORD	p_count
);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcGetGrantedAccess(	DWORD cid ,PDWORD p_access);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcSetDgrmFlags(	DWORD cid, DWORD flags );
//
//		returns 0xffffffff on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcClrDgrmFlags(	DWORD cid, DWORD flags  );
//
//		returns 0xffffffff on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcClrFeedback(DWORD cid);
//
//		returns FAILURE on ERROR
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetFeedbackItems(DWORD cid,WORD type,
	short Ch, short RTU, short Point,BYTE count,BYTE fbType,DWORD Id);
//
//		returns FAILURE on ERROR
#define  FBTYPE_SIMPLE ((BYTE)0)
#define  FBTYPE_CONTROL ((BYTE)2)
//***************************************************************	IMPLEMENTED
TMC_IMPEX short _stdcall tmcSetFeedbackItemsEx(DWORD cid,WORD count/*max=128*/,
	TFeedbackInfo* items);
//
//		returns FAILURE on ERROR

//***************************************************************	IMPLEMENTED
TMC_IMPEX void __stdcall tmcGetTmSource(DWORD cid,WORD type,
	short Ch, short RTU, short Point,TTelemetrySource* src);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetRetransInfo(DWORD cid,WORD count,TRetransInfo* ri);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcUpdRetransInfo(DWORD cid,WORD count,TRetransInfo* ri);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetRetransInfoEx(DWORD cid,WORD count,TRetransInfo* ri,TRetransInfoReply* rir);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcClrRetransInfo(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcSendMapboardCommand(DWORD cid,BYTE cmd,BYTE parm1,BYTE parm2);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcConnState( DWORD cid );
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID __stdcall tmcSetLastError(DWORD error);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcGetLastError();
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LONG __stdcall tmcGetLastErrorText(DWORD cid,LPSTR* pp);
//
//	:            
//					    
//
//	:      pp    -  pp[0]    
//					      ,     
//					        tmcFreeMemory()
//
//	:         1  - 
//					 0  - 
//					-1 -   
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX VOID __stdcall tmcSetUser(LPSTR user,LPSTR pwd);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BYTE __stdcall tmcEnumObjects( DWORD cid ,WORD object_type,BYTE count,PWORD buf,
		short Ch,short RTU,short Point);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcGetServerInfo(DWORD cid,TServerInfo* info);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR __stdcall tmcGetServerThreads(DWORD cid);
//
//
//***************************************************************	IMPLEMENTED

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcRetroInfoEx(DWORD cid,WORD idx,TRetroInfoEx* info);
//
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcGetObjectName( DWORD cid ,WORD object_type,
		short Ch,short RTU,short Point,LPSTR buf,int buflen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcGetObjectNameEx(
	DWORD cid, short object_type, 
	short Ch, short RTU, short Point, short SubObjectId, 
	LPSTR buf,int buflen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcGetObjectProperties( DWORD cid ,WORD object_type,
		short Ch,short RTU,short Point,LPSTR buf,int buflen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcEvaluateExpression(DWORD cid,LPSTR expr,LPSTR res,DWORD cbBytes);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcControlCmdResult(DWORD cid,DWORD Id,BOOL fSuccess);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX time_t*	__stdcall tmcPerspEnum(DWORD cid,PDWORD pCount);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL		__stdcall tmcPerspDelete(DWORD cid,time_t ut);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL		__stdcall tmcPerspPutAnalogs(DWORD cid,time_t ut, DWORD count, TADRtm* addr,float* pVal);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL		__stdcall tmcPerspPutValue(DWORD cid,time_t ut,LPSTR Prop,LPSTR Value);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR		__stdcall tmcPerspGet(DWORD cid,time_t ut,PDWORD pLen);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX TBaseObjectInfo* __stdcall tmcEnumBaseObjects(DWORD cid,PDWORD pCount);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR		__stdcall tmcGetPerformanceData(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD		__stdcall tmcGetAnalogsFromQueueFirst(
	DWORD cid,ANALOG_QUEUE_FIND* aqf,TAnalogQueueRecord* records,
	DWORD count,DWORD start_time,DWORD stop_time,
	WORD chn,WORD rtu,WORD point);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD		__stdcall tmcGetAnalogsFromQueueNext(
	DWORD cid,ANALOG_QUEUE_FIND* aqf,TAnalogQueueRecord* records,
	DWORD count);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short		__stdcall tmcGetConfigInfo(DWORD cid, TServerConfig *pCfg, DWORD count);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcGetConfig(DWORD cid, PDWORD pConfig);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetConfig(DWORD cid, DWORD Config);
//
//
//***************************************************************

//****************************************************************		IMPLEMENTED
TMC_IMPEX LPSTR __stdcall tmcGetReserveState(DWORD cid);
//
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetValues(DWORD cid,DWORD count,TValueAndFlags* values);
// returns SUCCESS if implemented in server
//
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetTimedValues(DWORD cid,DWORD count,TTimedValueAndFlags* values);
// returns SUCCESS if implemented in server
//
//***************************************************************

#define _TMSVX_TIMED	1
#define _TMSVX_S2		2

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetValuesEx(DWORD cid,DWORD sv_flags,DWORD count,DWORD itemlen,PVOID data);
// returns SUCCESS if implemented in server
//
//***************************************************************


//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR* __stdcall tmcGetStatusClassData(DWORD cid,DWORD count /* max 128*/,TADRtm* statuses);
// return NULL on error
// returned pointer should be freed by tmcFreeMemory()
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcControl(DWORD cid, short Ch, short RTU, short Point,
										  short Cmd);
//
//	:         
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//					Cmd -   (0-, 1-)
//
//	:        SUCCESS - 
//					: FAILURE
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  long __stdcall  tmcExecuteControlScript(DWORD cid, short Ch, short RTU, short Point,
										  short Cmd);
//
//	:            
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//					Cmd -   (0-, 1-)
//
//	:        1  - ok
//					0  -  
//					-1 -  
//*************************************************************** 	

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX	BOOL __stdcall tmcOverrideControlScript(DWORD cid,BOOL fOverride);
//
//
//*************************************************************** 	

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcControlByStatus(DWORD cid, short Ch, short RTU, short Point,
										  short Cmd);
//
//	:         
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//					Cmd -   (0-, 1-)
//
//	:        SUCCESS - 
//					:
#define TMCTLERR_INVALID_ADDRESS	0
#define TMCTLERR_NO_RESOURCES		-1
#define TMCTLERR_TMSOURCE_FAILED	-2
#define TMCTLERR_WAIT_TIMEOUT		-3
#define TMCTLERR_CANNOT_REDIRECT	-4
#define TMCTLERR_NO_TMSOURCE		-5
#define TMCTLERR_NO_KEYCODE			-6
#define TMCTLERR_WRONG_KEYCODE		-7
#define TMCTLERR_KEYCODE_TIMEOUT	-8
#define TMCTLERR_USER_NAME_UNKNOWN	-9
#define TMCTLERR_ACCESS_DENIED		-10
#define TMCTLERR_NOT_SUPPORTED		-11
#define TMCTLERR_NO_TM_SERVER		-12
#define TMCTLERR_WRONG_KEY			-13
#define TMCTLERR_SCRIPT_ERROR		-14
#define TMCTLERR_EXCEPT				-15




//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSystemTime(DWORD cid, char *DateTime, struct tm *tm);
//
//	:          -
//
//	:      DateTime -     
//                               ".. ::"  NULL
//					tm       -   tm (. TIME.H)  NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************


/*---------------    -----------------------*/

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcStatus(DWORD cid, short Ch, short RTU, short Point);
//
//	:          
//
//	:      Ch    - ,
//					RTU   -   ( 1),
//					Point -   ( 1)
//
//	:        0 - ,  1 - 
//				   -1 - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcStatusFull(DWORD cid, short Ch, short RTU, short Point,
											 TStatusPoint *SP);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					SP             -     
//
//	:        SUCCESS - 
//					FAILURE - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcStatusFullEx(DWORD cid, short Ch, short RTU, short Point, 
											TStatusPoint *SP, unsigned long Time);
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  float __stdcall tmcAnalog(DWORD cid, short Ch, short RTU, short Point,
										 const char  *DateTime, short RetroNum);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					DateTime, RetroNum -   
//									       .
//                                       DateTime   
//                                       ".. ::"
//									        ,
//									      DateTime == NULL
//
//	:            huge_flt   
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcAnalogFull(DWORD cid, short Ch, short RTU, short Point,
											 TAnalogPoint *AP,
											 const char *DateTime,
											 short RetroNum);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					AP             -    
//									  AP->asFloat == _huge_flt 
//									      
//									 .   
//									  .
//					DateTime, RetroNum -   
//									       .
//                                       DateTime   
//                                       ".. ::"
//									        ,
//									      DateTime == NULL
//
//	:        SUCCESS - 
//					FAILURE - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  float __stdcall tmcAccumValue(DWORD cid, short Ch, short RTU, short Point,
											 const char *DateTime);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					DateTime -   
//							     .
//                             DateTime   
//                             ".. ::"
//							      ,
//							    DateTime == NULL
//
//	:            huge_flt  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  float __stdcall tmcAccumLoad(DWORD cid, short Ch, short RTU, short Point,
											const char *DateTime);
//
//	:           
//
//	:      Ch, RTU, Point - . 
//					DateTime -   
//							     .
//                             DateTime   
//                             ".. ::"
//							      ,
//							    DateTime == NULL
//
//	:           huge_flt  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcAccumFull(DWORD cid, short Ch, short RTU, short Point,
											TAccumPoint *AP,
											const char *DateTime);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					AP       -    
//					DateTime -   
//							     .
//                             DateTime   
//                             ".. ::"
//							      ,
//							    DateTime == NULL
//
//	:        SUCCESS - 
//					FAILURE - ,  
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcAccumFullEx(
	DWORD cid, 
	short Ch, short RTU, short Point, 
	TAccumPoint *AcP,const char *DateTime,short RetroNum);

//***************************************************************

/*---------------    -----------------------*/
//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetStatusNormal(DWORD cid, short Ch, short RTU, short Point,
											WORD NValue);

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcGetStatusNormal(DWORD cid, short Ch, short RTU, short Point,
											PWORD pNValue); // return SUCCESS/FAILURE

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcGetRetroFlags(DWORD cid); // return 0xffffffff on failure

#define RETROFLAG_COMMON	1
#define RETROFLAG_ARCHIVE	2
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcSetRetroFlags(DWORD cid,DWORD rflags); // return FALSE on failure

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX PBYTE __stdcall tmcGetNamedObject(DWORD cid,PDWORD paddr,LPSTR name,PDWORD pcb);

//		free result with tmcFreememory
//***************************************************************	

//***************************************************************	IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcSetNamedObject(DWORD cid,PDWORD paddr,LPSTR name,PBYTE pobj,DWORD cb);

//***************************************************************	

//***************************************************************	IMPLEMENTED
TMC_IMPEX LPSTR __stdcall tmcEnumNamedObjects(DWORD cid,PDWORD paddr);

//		double zero terminated list
//		free result with tmcFreememory
//***************************************************************	


//***************************************************************	IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcSetAccumValueSeries(DWORD cid,WORD chn,WORD rtu,WORD point,
	float val, DWORD ut,BOOL allow_reformat,LPSTR errs,DWORD cb_errs);

//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetStatusUT (DWORD cid, short Ch, short RTU, short Point,
				   char Value,
				   DWORD ut,  BYTE hund,BYTE FlgCmd,BYTE Flags);
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetStatusUT_MS (DWORD cid, short Ch, short RTU, short Point,
				   char Value,
				   DWORD ut,  WORD ms, BYTE FlgCmd,BYTE Flags);
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetStatus(DWORD cid, short Ch, short RTU, short Point,
											char Value,
											const char *DateTime, short Hund);
//
//	:          
//
//	:      Ch    		   - ,
//					RTU            -   ( 1),
//					Point          -   ( 1)
//					Value          -   
//					DateTime       -   
//									   .
//									 : ".. ::."
//									  -   
//									    , 
//									   Time = NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************
TMC_IMPEX  short __stdcall tmcFillStatusGroup(DWORD cid, short Ch, short RTU, short Point,
												  short Quan, char *SGroup);
//
//	:          
//
//	:      Ch, RTU        - . 
//					Point          -   
//					Quan           -    
//					SGroup         -     ( ,
//									     -  
//									 )
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetStatusFlags(DWORD cid, short Ch, short RTU, short Point,
												 short Flags);
TMC_IMPEX  short __stdcall tmcClrStatusFlags(DWORD cid, short Ch, short RTU, short Point,
													 short Flags);
//
//	:       /   
//					tmSetStatusFlags - 
//					tmClrStatusFlags - 
//
//	:      Ch, RTU        - . 
//					Point          - N  ( 1),  == 0 
//									    
//									   
//					Flags          -   
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAnalogUT(DWORD cid, short Ch, short RTU, short Point,
											float Value,DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAnalogFloatCodeUT(
	DWORD cid, 
	short Ch, 
	short RTU, 
	short Point,
	float FCode,
	DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAnalog(DWORD cid, short Ch, short RTU, short Point,
											float Value,
											const char *DateTime);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					Value          -    ( )
//					DateTime       -    
//									     ".. ::"
//									    , 
//									   DateTime = NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAnalogByCodeUT(DWORD cid, short Ch, short RTU, short Point,
												  short Value,DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAnalogByCode(DWORD cid, short Ch, short RTU, short Point,
												  short Value);
//
//	:            
//
//	:      Ch, RTU, Point - . 
//					Value          -  .  
//									    
//									 (-1 == 0FFFFh)
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcFillAnalogGroup(DWORD cid, short Ch, short RTU, short Point,
											short Quan, short *AGroup);
//
//	:          
//
//	:      Ch, RTU        - . 
//					Point          -   
//					Quan           -    
//					AGroup         -     ()
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAnalogFlags(DWORD cid, short Ch, short RTU, short Point,
												 short Flags);
TMC_IMPEX  short __stdcall tmcClrAnalogFlags(DWORD cid, short Ch, short RTU, short Point,
												 short Flags);
//
//	:       /   
//					tmcSetAnalogFlags - 
//					tmcClrAnalogFlags - 
//
//	:      Ch, RTU        - . 
//					Point          - N  ( 1),  == 0 
//									    
//									   
//					Flags          -   
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcIncAccumPoints(DWORD cid, short Ch, short RTU, short Point,
												 short DataType, short Quan,
												 void *AGroup);
//
//	:            
//
//	:      Ch, RTU        - . 
//					Point          -   
//                  DataType       -   
//                                    (DataType&0x8000) != 0 
//							 		   - 
//                                    
#define ACCUM_TYPE_EXT_FLOAT (32*1+1)
#define ACCUM_TYPE_EXT_LD	(32*1+2)
//					Quan           -    
//					AGroup         -    
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcDeliverTimedAccum(DWORD cid, DWORD count,TTimedAccum* accums);

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcDeliverTimedAccumEx(DWORD cid, DWORD count,TTimedAccumEx* accums);

//*************************************************************** 	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcDeliverAccumData(DWORD cid, DWORD count,TAccumData* accums);


//***************************************************************	IMPLEMENTED
TMC_IMPEX short __stdcall tmcSetAccumValueUT(DWORD cid, short Ch, short RTU, short Point,
												float Value, DWORD ut,BYTE FlgCmd,BYTE Flags);

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAccumValue(DWORD cid, short Ch, short RTU, short Point,
												float Value,
												const char *DateTime);
//
//	:          
//
//	:      Ch, RTU, Point - . 
//					Value          -    ( )
//					DateTime       -    
//									     ".. ::"
//									    , 
//									   DateTime = NULL
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcSetAccumFlags(DWORD cid, short Ch, short RTU, short Point,
												short Flags);
TMC_IMPEX  short __stdcall tmcClrAccumFlags(DWORD cid, short Ch, short RTU, short Point,
												short Flags);
//
//	:       /   
//					tmcSetAccumFlags - 
//					tmcClrAccumFlags - 
//
//	:      Ch, RTU        - . 
//					Point          - N  ( 1),  == 0 
//									    
//									   
//					Flags          -   
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************


/*---------------    ---------------------*/

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcRegEvent(DWORD cid, TEvent *tmEvent);
//
//	:          
//
//	:      tmEvent -     
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short  __stdcall tmcRegEventRaw(DWORD cid, TTMSEvent *tmsEvent);
//
//	:          
//
//	:      tmsEvent -     
//
//	:        SUCCESS - 
//					FAILURE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  BOOL __stdcall tmcEvlogPutStrBin(DWORD cid,
		DWORD unix_time,BYTE unix_hund,
		BYTE importance,DWORD SourceTag,
		LPSTR str,PVOID bin,DWORD cb_bin);
//
//					FALSE - 
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcEventLogUT(DWORD cid, unsigned long Start, unsigned long End,
				           short EvMask, TTMSEvent *Events,
				           short Cpct, unsigned long *Cursor);
//
//					
//***************************************************************

//***************************************************************	IMPLEMENTED
TMC_IMPEX  short __stdcall tmcEventLog(DWORD cid, 
										   const char *StartTime,
										   const char *EndTime,
										   short EvMask, TEvent *EvLog,
										   short Cpct, unsigned long *Cursor);
//
//	:            
//
//	:      StartTime   -   
//					EndTime     -   
//					EvMask      -  ,   
//					EvLog       -     
//								    
//					Cpct        -    
//					Cursor      -    
//								     . 
//								      .
//								     *Cursor   0L
//								        
//								   *Cursor    
//								      
//								       
//
//	:          

//****************************************************************		IMPLEMENTED
TMC_IMPEX TTMSEvent* __stdcall tmcEventLogByIndex(DWORD cid,DWORD index,DWORD ut,PDWORD pSize);

//****************************************************************		IMPLEMENTED
TMC_IMPEX TEventEx* __stdcall tmcEventLogEx(DWORD cid,WORD ev_mask,DWORD ux_start,
								  DWORD ux_stop,TEventExCriteria* pCrit);


//****************************************************************		IMPLEMENTED
TMC_IMPEX void __stdcall tmcTakeRetroTit(DWORD cid, short Ch, short RTU, short Point,
								time_t utime,WORD RetroNum, WORD count,WORD step,TAnalogPointShort* aps);
//****************************************************************		IMPLEMENTED
TMC_IMPEX TADRtm* __stdcall tmcTakeAPS(DWORD cid);	// should free result with tmcFreeMemory
//****************************************************************		IMPLEMENTED
TMC_IMPEX void __stdcall tmcReadRetroTimes(DWORD cid, WORD idx, 
								PDWORD* ppdata,	//    . tmcFreeMemory()
								DWORD* pcount,LPSTR pError);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void __stdcall tmcReadRetroSlice(DWORD cid,WORD idx,DWORD utime,
								 WORD* ptype, 
								 PVOID* ppdata, //    . tmcFreeMemory()
								 DWORD* pcount);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short __stdcall tmcRetroInfo(DWORD cid, TRetroInfo *RetroInfo);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short __stdcall tmcPeekAlarm(DWORD cid, short Ch, short RTU, short Point,
                  short AlarmID, TAlarm *Alarm);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short __stdcall tmcPokeAlarm(DWORD cid, short Ch, short RTU, short Point,
                  short AlarmID, TAlarm *Alarm);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short __stdcall tmcEnumAlarms(DWORD cid, short Ch, short RTU, short Point,
                  TAlarm *Alarm, short MaxQuan, short ActiveOnly);
//****************************************************************		IMPLEMENTED
TMC_IMPEX short __stdcall tmcDriverCall(DWORD cid, unsigned ADR, short Q_Code, short Command );
//****************************************************************		IMPLEMENTED
TMC_IMPEX void  __stdcall tmcStatusByList(DWORD cid, short Quan, TADRtm *List, TStatusPoint *SPs);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void __stdcall tmcStatusByListEx(DWORD cid, short Quan, TADRtm *ADRs, TStatusPoint *SPs,unsigned long Time);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void  __stdcall tmcAnalogByList(DWORD cid, short Quan, TADRtm *List, TAnalogPoint *APs,
                               unsigned long Time, short RetroNum);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void  __stdcall tmcAccumByList (DWORD cid, short Quan, TADRtm *List, TAccumPoint *AcPs,
                               unsigned long Time);
//****************************************************************		IMPLEMENTED
TMC_IMPEX LPSTR __stdcall tmcGetTextualInfo(DWORD cid,WORD info,PBYTE data,DWORD cbdata);
//****************************************************************		IMPLEMENTED
TMC_IMPEX TADRtm* __stdcall tmcTextSearch(DWORD cid,WORD type,LPSTR txt,PDWORD p_count);
//****************************************************************		IMPLEMENTED
TMC_IMPEX long __stdcall String2Utime(const char *DateTime);
//****************************************************************		IMPLEMENTED
TMC_IMPEX void __stdcall Utime2Str(long t,char* buffer);

///////////////////////////////////////////////////////////////////////////////////
/////////////	K E Y   F U N C T I O N S 
//////////////////////////////////////////////////////////////////////
TMC_IMPEX DWORD  __stdcall tmcKeyGetTypeFlags(
	DWORD Type
);

#define TMC_KEY_TYPE_VALID		1
#define TMC_KEY_TYPE_WRITABLE	2
#define TMC_KEY_TYPE_DALLAS		4

TMC_IMPEX BOOL __stdcall tmcKeyReadId(
	DWORD	type,
	DWORD	port,
	PBYTE	key_id			// OUT 8 BYTES
);

TMC_IMPEX BOOL  __stdcall tmcKeyReadSubkey(
	DWORD	type,
	DWORD	port,
	PBYTE	key_id,			// OUT 8 BYTES
	PBYTE	password,		// IN 8 BYTES
	PBYTE	signature,		// IN 8 BYTES
	BYTE	sub_key_num,	// 0,1,2
	PBYTE	sub_key			// OUT 48 BYTES
);

TMC_IMPEX BOOL  __stdcall tmcKeyWriteSubkey(
	DWORD	type,
	DWORD	port,
	PBYTE	password,		// IN 8 BYTES
	PBYTE	signature,		// IN 8 BYTES
	BYTE	sub_key_num,	// IN 0,1,2
	PBYTE	sub_key			// IN 48 BYTES
);

TMC_IMPEX BOOL  __stdcall tmcKeyReadScratchPad(
	DWORD type,
	DWORD port,
	PBYTE key_id,			// OUT 8 BYTES
	PBYTE scratch_pad		// OUT 64 BYTES
);

TMC_IMPEX BOOL  __stdcall tmcKeyWriteScratchPad(
	DWORD type,
	DWORD port,
	PBYTE scratch_pad		// IN 64 BYTES
);
//////////////////////////////////////////////////////////////////////
/////////////	D E L T A   F U N C T I O N S 
//////////////////////////////////////////////////////////////////////
#pragma pack (1)
typedef struct {
	BYTE cmd[2];  //'D','P'
	BYTE prot;
	BYTE res;
	DWORD D;
	DWORD A;
	DWORD P;
	DWORD err;
}DELTA_USER_POST;
#pragma pack()
#define DNT_USERBUF_CMD_ATTACH 0
#define DNT_USERBUF_CMD_DETACH 1

//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntGetConfig(DWORD cid,LPSTR fname);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntRegisterUser(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntUnRegisterUser(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntBeginTrace(DWORD cid,DWORD count,PDWORD pmask);
//****************************************************************		IMPLEMENTED		
TMC_IMPEX BOOL __stdcall tmcDntStopTrace(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcDntTreeChange(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX LPSTR __stdcall tmcDntGetReserveState(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX LPVOID __stdcall tmcDntOpenItem(DWORD cid,DWORD count,PDWORD pmask);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DeltaCommon* __stdcall tmcDntGetNextItem(LPVOID itid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX VOID  __stdcall tmcDntCloseItem(LPVOID itid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntBeginDebug(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntStopDebug(DWORD cid);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntTeleControl(DWORD cid,DWORD count,PDWORD pmask,DWORD idx,DWORD cmd);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntReqValue(DWORD cid,DWORD count,PDWORD pmask,DWORD idx);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntPassPortBuffer(DWORD cid,DWORD masklen,PDWORD pmask,PBYTE pData,DWORD cbData);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntGetObjectName( DWORD cid ,WORD object_type,
		short Ch,short RTU,short Point,LPSTR buf,int buflen);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntSetPortCapture(DWORD cid,BYTE driver,BYTE adapter,BYTE port);
//****************************************************************		IMPLEMENTED
TMC_IMPEX INT __stdcall tmcDntGetPortCapture(DWORD cid,BYTE driver,BYTE adapter,BYTE port);
// returns 0 if not captured, 1 if captured by us, -1 if not by us or on error
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntReleasePortCapture(DWORD cid,BYTE driver,BYTE adapter,BYTE port);
//****************************************************************		IMPLEMENTED
TMC_IMPEX DWORD __stdcall tmcDntGetLiveInfo(DWORD cid,DWORD count,PDWORD pmask,PVOID p_data,DWORD cb_data);
//****************************************************************		IMPLEMENTED
TMC_IMPEX BOOL __stdcall tmcDntSendPortPacket(
	DWORD cid,
	BYTE driver,
	BYTE adapter,
	BYTE port,
	BYTE proto,
	BYTE timeout,
	PBYTE pPacket,
	DWORD cbPacket
);

TMC_IMPEX DWORD	__stdcall tcapConnectDelta(LPSTR machine,LPSTR pipe,tcapRecvFunc rcv, LPSTR* perr);
TMC_IMPEX VOID	__stdcall tcapDisconnectDelta(DWORD cid);
TMC_IMPEX LPSTR	__stdcall tcapAttachNode(DWORD cid,DWORD masklen,PDWORD pmask,BYTE prot);
TMC_IMPEX LPSTR	__stdcall tcapDetachNode(DWORD cid,DWORD masklen,PDWORD pmask,BYTE prot);
TMC_IMPEX LPSTR	__stdcall tcapSendPacket(DWORD cid,PBYTE pData,DWORD cbData,DWORD masklen,PDWORD pmask,BYTE prot);
TMC_IMPEX VOID	__stdcall tcapFreeMemory(PVOID p);



//////////////////////////////////////////////////////////////////
///////////////////// RBASE CONSTANTS AND FUNCTIONS

/*------------------    -----------------------*/
#define GL_OK         0
#define GL_BLOK       1
#define GL_ERROR_DISK 2
#define GL_ERROR_LINE 3
#define GL_FAULT      4

/*---------------     ------------------*/
#define rbINIT_BASE          9

#define rbRESET_TABLE       70
#define rbREAD_STR          60
#define rbREAD_COL         210
#define rbREAD_ADR_STR     230
#define rbREAD_ADR_COL     220

#define rbSET_WHERE        140
#define rbFIND_STR          90
#define rbFIND_COL         170
#define rbCALC_WHERE       101
#define rbTEST_WHERE       105
#define rbCALC_TABLE        40
#define rbTEST_TABLE       130
#define rbFIND_MIN_MAX     150

#define rbADD_STR           50
#define rbADD_GR_STR       200
#define rbADD_PLUS         103
#define rbADD_MINUS        104

#define rbWRITE_STR        100
#define rbWRITE_COL        180

#define rbDELETE_STR        30
#define rbDELETE_ALL       190
#define rbDEL_WHERE        102

#define rbSYSTEM_DATE        1
#define rbTABLE_INFO       250
#define rbUNBLOK_BASE       12
#define rbUNBLOK_TABLE      80
#define rbSET_BLOK_TABLE   260
#define rbGET_USURPER_NAME 270

#define TEST              1000

#define STRUCT_GLOBAS   unsigned RecAdr

#define MAXBASE 16
#define MAX_BASES MAXBASE
#define MAXTAB  30

/*----------------------   ------------------------*/
#define GBLOK     0x1000    //   
#define GUNBLOK   0x1000
#define ADD_MAX   0x1000    //  FindMinMax -  
#define ADD_MIN   0x2000    //  FindMinMax -  
#define REVERSE   0x4000    //    

/*-------------------   -----------------------*/
#define _LIKE_     1        //  
#define _LE_       2        //   
#define _LT_       3        // 
#define _GE_       4        //   
#define _GT_       5        // 
#define _EQ_       6        // 
#define _BETWEEN_  8        //  
#define _NULL_     7        //  

TMC_IMPEX int __cdecl rbcOpenBases		(DWORD cid,char *BaseName, ...);
TMC_IMPEX void __cdecl rbcCloseBases	(DWORD cid);
TMC_IMPEX int __cdecl rbcOpenTable		(DWORD cid, char *Base, char *Table);
TMC_IMPEX int __cdecl rbcRecSize		(DWORD cid, int hTable );
TMC_IMPEX int  __cdecl rbcColSize		(DWORD cid, int hTable, int Column);
TMC_IMPEX int __cdecl rbcResetTable		(DWORD cid, int hTable);
TMC_IMPEX int __cdecl rbcReadStr		(DWORD cid, int hTable, int RecCount, void *Record);
TMC_IMPEX int __cdecl rbcReadCol		(DWORD cid, int hTable, int RecCount, void *Record, int Column1, ...);
TMC_IMPEX int __cdecl rbcReadAdrStr		(DWORD cid, int hTable, int RecAdr, void *Record);
TMC_IMPEX int __cdecl rbcReadAdrCol		(DWORD cid, int hTable, unsigned RecAdr, void *Record, int Column1, ...);
TMC_IMPEX int __cdecl rbcSetWhere		(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int __cdecl rbcTestWhere		(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int __cdecl rbcCalcWhere		(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int __cdecl rbcFindStr		(DWORD cid, int hTable, int RecCount, void *Record);
TMC_IMPEX int __cdecl rbcFindCol		(DWORD cid, int hTable, int RecCount, void *Record, int Column1, ...);
TMC_IMPEX int __cdecl rbcFindMinMax		(DWORD cid,int hTable, int Column, int *MinVal, int *MaxVal);
TMC_IMPEX int __cdecl rbcCalcTable		(DWORD cid,int hTable);
TMC_IMPEX int __cdecl rbcTestTable		(DWORD cid,int hTable);
TMC_IMPEX int __cdecl rbcWriteStr		(DWORD cid,int hTable, void *Record);
TMC_IMPEX int __cdecl rbcWriteCol		(DWORD cid,int hTable, void *Record, int Column1, ...);
TMC_IMPEX int __cdecl rbcAddStr			(DWORD cid,int hTable, void *Record);
TMC_IMPEX int __cdecl rbcAddStrEx		(DWORD cid,int hTable, int RecCount, void *Records);
TMC_IMPEX int __cdecl rbcAddStrInc		(DWORD cid, int hTable, int Column, void *Record);
TMC_IMPEX int __cdecl rbcAddStrDec		(DWORD cid,int hTable, int Column, void *Record);
TMC_IMPEX int __cdecl rbcDeleteStr		(DWORD cid,int hTable, void *Record);
TMC_IMPEX int __cdecl rbcDeleteAll		(DWORD cid,int hTable);
TMC_IMPEX int __cdecl rbcDeleteWhere	(DWORD cid, int hTable, unsigned Column, ...);
TMC_IMPEX int __cdecl rbcLockStr		(DWORD cid, int hTable, unsigned RecNum);
TMC_IMPEX int __cdecl rbcUnlockStr		(DWORD cid, int hTable, unsigned RecNum);
TMC_IMPEX int __cdecl rbcUnlockBases	(DWORD cid);
TMC_IMPEX unsigned __cdecl rbcRecCount	(DWORD cid,int hTable);
TMC_IMPEX int __cdecl rbcGetSecurity	(DWORD cid,PBOOL pAdmin,PDWORD pAccessMask);
TMC_IMPEX int __cdecl rbcGetUserId		(DWORD cid,PCHAR UserId /* max 16 */,PCHAR UserPwd /*max 32*/);
TMC_IMPEX int __cdecl rbcReadUserId		(DWORD cid,DWORD index,PBOOL pDone,PBYTE UserSid /*max 128*/,
											PCHAR UserId /* max 16 */,PCHAR UserPwd /*max 32*/);
TMC_IMPEX int __cdecl rbcWriteUserId	(DWORD cid,DWORD index,PBYTE UserSid /*max 128*/,
											PCHAR UserId /* max 16 */,PCHAR UserPwd /*max 32*/);
TMC_IMPEX LPSTR __cdecl rbcWsEnumDomains(DWORD cid);
TMC_IMPEX LPSTR __cdecl rbcWsEnumDomainUsers(DWORD cid,LPSTR domain);
TMC_IMPEX PVOID __cdecl rbcWsGetUserSid(DWORD cid,LPSTR domain,LPSTR user);
TMC_IMPEX BOOL __cdecl rbcWsGetUserName(DWORD cid,PVOID pSid,LPSTR domain /*max=128*/,LPSTR user/*max=128*/);
TMC_IMPEX LPSTR __stdcall rbcGetReserveState(DWORD cid);

TMC_IMPEX BOOL __cdecl rbcBackupServerProcedure(
	LPSTR machine,
	LPSTR pipe,
	LPSTR directory,
	PDWORD pbflags,
	HANDLE hCancel,
	tmcProgressFn prog_fn,
	LPVOID prog_parm
);

///////////////////////// INTERNAL
TMC_IMPEX DWORD __stdcall tmcTransact(
	DWORD cid,
	DWORD sl,
	PVOID sb,
	DWORD rl,
	PVOID rb
);
TMC_IMPEX DWORD __stdcall tmcGetCurrentXaction(DWORD cid);

#ifdef __cplusplus
}
#endif

#endif //_TMCONN_H
